/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.staff.validate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.service.ServiceFactory;
import kd.hr.haos.business.service.staff.bean.BaseDataNameCheckDto;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class StaffCommonNameValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length == 0) {
            return;
        }
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List enabledLangList = service.getEnabledLang();
        HashMap<String, Map<String, String>> langAndNameMap = new HashMap<String, Map<String, String>>(enabledLangList.size());
        HashMap<String, ExtendedDataEntity> numberDataEntityMap = new HashMap<String, ExtendedDataEntity>(dataEntities.length);
        ArrayList<Long> ids = new ArrayList<Long>(dataEntities.length);
        String metaName = null;
        for (ExtendedDataEntity dataEntity : dataEntities) {
            metaName = dataEntity.getDataEntity().getDataEntityType().getName();
            OrmLocaleValue nameOrm = (OrmLocaleValue)dataEntity.getDataEntity().get("name");
            String number = dataEntity.getDataEntity().getString("number");
            Long id = dataEntity.getDataEntity().getLong("id");
            if (id != 0L) {
                ids.add(id);
            }
            for (EnabledLang lang : enabledLangList) {
                Map<String, String> nameNumberMap;
                String name = nameOrm.getItem(lang.getNumber());
                if (name == null) continue;
                if (langAndNameMap.get(lang.getNumber()) == null) {
                    nameNumberMap = new HashMap(dataEntities.length);
                    nameNumberMap.put(name, number);
                    langAndNameMap.put(lang.getNumber(), nameNumberMap);
                    numberDataEntityMap.put(dataEntity.getDataEntity().getString("number"), dataEntity);
                    continue;
                }
                nameNumberMap = (Map)langAndNameMap.get(lang.getNumber());
                if (!nameNumberMap.containsKey(name)) {
                    nameNumberMap.put(name, number);
                    numberDataEntityMap.put(dataEntity.getDataEntity().getString("number"), dataEntity);
                    continue;
                }
                String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u8bed\u8a00\u73af\u5883\u4e0b\uff0c\u540d\u79f0\u201c%2$s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"StaffCommonNameValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), lang.getName(), name);
                this.addErrorMessage(dataEntity, message);
            }
        }
        for (EnabledLang lang : enabledLangList) {
            if (langAndNameMap.get(lang.getNumber()) == null) continue;
            List<BaseDataNameCheckDto> result = this.getBaseDataNameCheckDtos(langAndNameMap, metaName, lang, ids);
            for (BaseDataNameCheckDto checkDto : result) {
                Map nameNumberMap = (Map)langAndNameMap.get(lang.getNumber());
                if (nameNumberMap.containsKey(checkDto.getName()) && ((String)nameNumberMap.get(checkDto.getName())).equals(checkDto.getNumber())) continue;
                String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u8bed\u8a00\u73af\u5883\u4e0b\uff0c\u540d\u79f0\u201c%2$s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"StaffCommonNameValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), lang.getName(), checkDto.getName());
                this.addErrorMessage((ExtendedDataEntity)numberDataEntityMap.get(nameNumberMap.get(checkDto.getName())), message);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<BaseDataNameCheckDto> getBaseDataNameCheckDtos(Map<String, Map<String, String>> langAndNameMap, String metaName, EnabledLang lang, List<Long> ids) {
        String mainTable = "t_" + metaName;
        String mutilLangTable = "t_" + metaName + "_l";
        String querySQL = "select a.fid,a.fnumber,a.fname as fdefaultname,l.flocaleid,l.fname from " + mainTable + " a left join " + mutilLangTable + " l on a.fid = l.fid where a.fenable = '1' and l.flocaleid = '" + lang.getNumber() + "'";
        StringBuilder namesb = new StringBuilder(" and l.fname in (");
        for (String string : langAndNameMap.get(lang.getNumber()).keySet()) {
            void var10_10;
            if (string.contains("'")) {
                String string2 = string.replace("'", "''");
            }
            namesb.append("'");
            namesb.append((String)var10_10);
            namesb.append("',");
        }
        namesb.deleteCharAt(namesb.length() - 1);
        querySQL = querySQL + namesb + ")";
        if (!ids.isEmpty()) {
            StringBuilder idsb = new StringBuilder(" and a.fid not in (");
            for (Long id : ids) {
                idsb.append(id);
                idsb.append(",");
            }
            idsb.deleteCharAt(idsb.length() - 1);
            querySQL = querySQL + idsb + ")";
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        try (DataSet dataSet = HRDBUtil.queryDataSet((String)"queryHaosBaseDataLocaleNames", (DBRoute)new DBRoute("haos"), (String)querySQL, null);){
            for (Row data : dataSet) {
                BaseDataNameCheckDto checkDto = new BaseDataNameCheckDto();
                checkDto.setId(data.getLong("fid"));
                checkDto.setNumber(data.getString("fnumber"));
                checkDto.setDefaultname(data.getString("fdefaultname"));
                checkDto.setLocaleid(data.getString("flocaleid"));
                checkDto.setName(data.getString("fname"));
                result.add(checkDto);
            }
        }
        return result;
    }
}

