/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.staff.validate;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.haos.business.domain.repository.staff.StaffProjectRepository;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class StaffProjectSaveValidator
extends HRDataBaseValidator
implements OrgStaffConstants {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        List idList = Arrays.stream(extendedDataEntities).map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_staffproject");
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        checker.setDraftValidReference(true);
        DynamicObject staffProjectDyn = serviceHelper.generateEmptyDynamicObject();
        Map checkResult = checker.checkRef((BasedataEntityType)staffProjectDyn.getDataEntityType(), idList.toArray());
        DynamicObject[] staffProjectDynArr = StaffProjectRepository.getInstance().queryByPks("id, unitycontrolmode, unitystaffdimension", idList);
        Map<Long, DynamicObject> idVsDynMap = Arrays.stream(staffProjectDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        for (ExtendedDataEntity extendedDataEntity2 : extendedDataEntities) {
            BaseDataCheckRefrenceResult baseDataCheckRefrenceResult;
            DynamicObject dataEntity = extendedDataEntity2.getDataEntity();
            long id = dataEntity.getLong("id");
            if (!idVsDynMap.containsKey(id) || !Objects.nonNull(baseDataCheckRefrenceResult = (BaseDataCheckRefrenceResult)checkResult.get(id))) continue;
            DynamicObject dynFromDB = idVsDynMap.get(id);
            boolean unityControlMode = dataEntity.getBoolean("unitycontrolmode");
            boolean unityControlModeFromDB = dynFromDB.getBoolean("unitycontrolmode");
            if (!unityControlModeFromDB && unityControlMode) {
                String message = ResManager.loadKDString((String)"\u201c%1$s\u201d\u8bed\u8a00\u73af\u5883\u4e0b\uff0c\u540d\u79f0\u201c%2$s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"StaffCommonNameValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(extendedDataEntity2, message);
            }
            boolean unityStaffDimension = dataEntity.getBoolean("unitystaffdimension");
            boolean unityStaffDimensionFromDB = dynFromDB.getBoolean("unitystaffdimension");
            if (unityStaffDimensionFromDB || !unityStaffDimension) continue;
            String message = ResManager.loadKDString((String)"\u201c%1$s\u201d\u8bed\u8a00\u73af\u5883\u4e0b\uff0c\u540d\u79f0\u201c%2$s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"StaffCommonNameValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(extendedDataEntity2, message);
        }
    }
}

