/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.structproject.validator;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class OtherStructProjectOrgImportStartDateValidator
extends AbstractValidator {
    private DynamicObject structProjectDy;

    public OtherStructProjectOrgImportStartDateValidator(DynamicObject structProjectDy) {
        this.structProjectDy = structProjectDy;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Set orgSet = Stream.of(dataEntities).map(ExtendedDataEntity::getDataEntity).map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection col = AdminOrgStructRepository.getInstance().queryColByOrgAndStructProject("adminorg.id,firstbsed", orgSet, Long.valueOf(this.structProjectDy.getLong("id")));
        HashMap structDyMap = new HashMap();
        col.forEach(dy -> structDyMap.put(dy.getLong("adminorg.id"), dy));
        String enable = this.structProjectDy.getString("enable");
        Date effdt = this.structProjectDy.getDate("effdt");
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            Date firstDate;
            long orgId;
            DynamicObject structDy;
            String errorMsg;
            DynamicObject dataEntity2 = extendedDataEntity.getDataEntity();
            Date startDate = dataEntity2.getDate("bsed");
            if (Objects.isNull(startDate)) continue;
            Date today = HRDateTimeUtils.truncateDate((Date)new Date());
            if (HRDateTimeUtils.dayAfter((Date)startDate, (Date)today)) {
                errorMsg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"OtherStructProjectOrgImportStartDateValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(extendedDataEntity, errorMsg);
            }
            if (HRDateTimeUtils.dayBefore((Date)startDate, (Date)effdt)) {
                errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u77e9\u9635\u67b6\u6784\u7684\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"OtherStructProjectOrgImportStartDateValidator_2", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)effdt));
                this.addFatalErrorMessage(extendedDataEntity, errorMsg);
            }
            if (HRStringUtils.equals((String)enable, (String)"10") || Objects.isNull(structDy = (DynamicObject)structDyMap.get(orgId = dataEntity2.getLong("id"))) || !HRDateTimeUtils.dayBefore((Date)startDate, (Date)(firstDate = structDy.getDate("firstbsed")))) continue;
            String errorMsg2 = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u8be5\u7ec4\u7ec7\u9996\u6b21\u52a0\u5165\u8be5\u67b6\u6784\u7684\u65e5\u671f\u201c%s\u201d\u3002", (String)"OtherStructProjectOrgImportStartDateValidator_3", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), HRDateTimeUtils.formatDate((Date)structDy.getDate("firstbsed")));
            this.addFatalErrorMessage(extendedDataEntity, errorMsg2);
        }
    }
}

