/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.structproject.validator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.haos.business.servicehelper.SystemParamHelper;
import kd.hr.haos.business.util.HAOSPermUtils;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.haos.business.util.PatternUtil;
import kd.hr.haos.common.constants.MultiLangEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.QueryEntityServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class OtherStructProjectOrgImportValidator
extends AbstractValidator {
    private DynamicObject structProjectDy;

    public OtherStructProjectOrgImportValidator(DynamicObject structProjectDy) {
        this.structProjectDy = structProjectDy;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HasPermOrgResult permOrg = OrgPermHelper.getHRPermOrg();
        long structProjectId = this.structProjectDy.getLong("id");
        long rootOrgId = this.structProjectDy.getLong("rootorg.id");
        boolean isIncludeVirtualOrg = this.structProjectDy.getBoolean("isincludevirtualorg");
        Optional<List<Long>> structProjectPermOrgOpt = this.getPermOrgResultWithSub();
        Optional<List<Long>> adminOrgPermOrgOpt = this.getPermAdminOrg(1010L);
        HashSet pkIdSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashSet parentIdSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashSet numberSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            pkIdSet.add(dataEntity.getLong("id"));
            parentIdSet.add(dataEntity.getLong("parentorg.id"));
            if (!dataEntity.getBoolean("isvirtualorg")) continue;
            numberSet.add(dataEntity.getString("number"));
        }
        Map<String, String> inTransitBillMap = this.queryBillOrg(numberSet);
        DynamicObject[] orgDetailResult = this.queryExistOrgId("isvirtualorg,org.id", pkIdSet);
        DynamicObject[] parentIdsResult = this.queryExistOrgId("id", parentIdSet);
        HashMap virtualOrgDbMap = Maps.newHashMapWithExpectedSize((int)orgDetailResult.length);
        Stream.of(orgDetailResult).forEach(org -> virtualOrgDbMap.put(org.getLong("id"), org.getBoolean("isvirtualorg")));
        Set<Long> existDbIds = virtualOrgDbMap.keySet();
        Set<Long> existDbParentIds = Stream.of(parentIdsResult).map(org -> org.getLong("id")).collect(Collectors.toSet());
        Set<Long> existOrgTeamIds = this.queryExistOrgTeamId(structProjectId, existDbIds);
        Set<Long> existParentOrgTeamIds = this.queryExistOrgTeamId(structProjectId, existDbParentIds);
        Set orgIdSet = Stream.of(orgDetailResult).map(org -> org.getLong("org.id")).collect(Collectors.toSet());
        HRBaseServiceHelper orgHelper = new HRBaseServiceHelper("bos_org");
        DynamicObject[] orgEnableResult = orgHelper.queryOriginalArray("id,enable", new QFilter[]{new QFilter("id", "in", orgIdSet)});
        HashMap orgEnableMap = Maps.newHashMapWithExpectedSize((int)orgEnableResult.length);
        Stream.of(orgEnableResult).forEach(orgEnable -> orgEnableMap.put(orgEnable.getLong("id"), orgEnable.getString("enable")));
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            Boolean isVirtualOrgDb;
            String errorMsg;
            String errorMsg2;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            long orgId = dataEntity.getLong("id");
            boolean orgIdExist = existDbIds.contains(orgId);
            boolean orgTeamIdExist = existOrgTeamIds.contains(orgId);
            boolean isVirtualOrg = dataEntity.getBoolean("isvirtualorg");
            boolean isNewVirtualOrg = !orgIdExist && isVirtualOrg;
            DynamicObject parentOrgDy = dataEntity.getDynamicObject("parentorg");
            String inputNumber = dataEntity.getString("number");
            if (!isVirtualOrg) {
                if (HRStringUtils.isEmpty((String)inputNumber)) {
                    errorMsg2 = ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u9879\u672a\u586b\u5199\uff1a\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u3002", (String)"OtherStructOrgImportValidator_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                    this.addFatalErrorMessage(extendedDataEntity, errorMsg2);
                } else {
                    if (!existOrgTeamIds.contains(orgId) && HRObjectUtils.isEmpty((Object)parentOrgDy)) {
                        errorMsg2 = ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u9879\u672a\u586b\u5199\uff1a\u4e0a\u7ea7\u7ec4\u7ec7\u3002", (String)"OtherStructOrgImportValidator_18", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                        this.addFatalErrorMessage(extendedDataEntity, errorMsg2);
                    }
                    if (adminOrgPermOrgOpt.isPresent() && !adminOrgPermOrgOpt.get().contains(orgId)) {
                        errorMsg2 = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OtherStructOrgImportValidator_19", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), inputNumber);
                        this.addFatalErrorMessage(extendedDataEntity, errorMsg2);
                    }
                }
            }
            if (isIncludeVirtualOrg) {
                if (isNewVirtualOrg) {
                    String number;
                    if (HRStringUtils.isEmpty((String)inputNumber)) {
                        errorMsg2 = ResManager.loadKDString((String)"\u5982\u679c\u60a8\u9700\u8981\u65b0\u589e\u865a\u62df\u7ec4\u7ec7\uff0c\u8bf7\u586b\u5199\u201c\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u201d\u3002", (String)"OtherStructOrgImportValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                        this.addFatalErrorMessage(extendedDataEntity, errorMsg2);
                    }
                    if (HRStringUtils.isEmpty((String)(number = dataEntity.getString("name")))) {
                        errorMsg = ResManager.loadKDString((String)"\u5982\u679c\u60a8\u9700\u8981\u65b0\u589e\u865a\u62df\u7ec4\u7ec7\uff0c\u8bf7\u586b\u5199\u201c\u884c\u653f\u7ec4\u7ec7\u540d\u79f0\u201d\u3002", (String)"OtherStructOrgImportValidator_2", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                        this.addFatalErrorMessage(extendedDataEntity, errorMsg);
                    }
                    if (HRObjectUtils.isEmpty((Object)parentOrgDy)) {
                        errorMsg = ResManager.loadKDString((String)"\u5982\u679c\u60a8\u9700\u8981\u65b0\u589e\u865a\u62df\u7ec4\u7ec7\uff0c\u8bf7\u586b\u5199\u201c\u4e0a\u7ea7\u7ec4\u7ec7\u201d\u3002", (String)"OtherStructOrgImportValidator_17", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                        this.addFatalErrorMessage(extendedDataEntity, errorMsg);
                    }
                }
                if (!orgIdExist && !isVirtualOrg && HRStringUtils.isNotEmpty((String)inputNumber)) {
                    errorMsg2 = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u82e5\u60a8\u9700\u65b0\u589e\u865a\u62df\u7ec4\u7ec7\uff0c\u5219\u9700\u586b\u5199\u201c\u662f\u5426\u865a\u62df\u7ec4\u7ec7\u201d\u4e3a\u201c\u662f\u201d\u3002", (String)"OtherStructOrgImportValidator_4", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                    this.addFatalErrorMessage(extendedDataEntity, errorMsg2);
                }
                if (isVirtualOrg && orgIdExist && !orgTeamIdExist && HRStringUtils.isNotEmpty((String)inputNumber)) {
                    errorMsg2 = ResManager.loadKDString((String)"\u6709\u76f8\u540c\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OtherStructOrgImportValidator_5", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                    this.addFatalErrorMessage(extendedDataEntity, errorMsg2);
                }
                String inTransitBillNo = inTransitBillMap.get(inputNumber);
                if (isNewVirtualOrg && Objects.nonNull(inTransitBillNo) && HRStringUtils.isNotEmpty((String)inputNumber)) {
                    String errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\u5728\u9014\u7ec4\u7ec7\u8c03\u6574\u5355\u636e\u201c%s\u201d\u4e2d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OtherStructOrgImportValidator_6", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), inTransitBillNo);
                    this.addFatalErrorMessage(extendedDataEntity, errMsg);
                }
                if (isVirtualOrg) {
                    ILocaleString nameLocaleString = dataEntity.getLocaleString("name");
                    nameLocaleString.forEach((code, nameSet) -> {
                        if (PatternUtil.valideName((String)nameSet) && !HRStringUtils.equals((String)code, (String)"GLang")) {
                            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08!_\\\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OtherStructOrgImportValidator_7", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), MultiLangEnum.getName((String)code));
                            this.addFatalErrorMessage(extendedDataEntity, errorMsg);
                        }
                    });
                    DynamicObject orgDy = dataEntity.getDynamicObject("org");
                    if (Objects.nonNull(orgDy)) {
                        String errorMsg3;
                        if (!permOrg.hasAllOrgPerm() && !permOrg.getHasPermOrgs().contains(orgDy.getLong("id"))) {
                            errorMsg3 = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u9650\u5728\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201c%s\u201d\u4e0b\u65b0\u589e\u7ec4\u7ec7\u3002", (String)"OtherStructOrgImportValidator_8", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), orgDy.getString("name"));
                            this.addFatalErrorMessage(extendedDataEntity, errorMsg3);
                        } else if (HRStringUtils.equals((String)((String)orgEnableMap.get(orgDy.getLong("id"))), (String)"0")) {
                            errorMsg3 = ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u88ab\u7981\u7528\u3002", (String)"OtherStructOrgImportValidator_9", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                            this.addFatalErrorMessage(extendedDataEntity, errorMsg3);
                        }
                    }
                }
            } else if (!orgIdExist) {
                errorMsg2 = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OtherStructOrgImportValidator_10", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(extendedDataEntity, errorMsg2);
            }
            if (orgIdExist && Objects.nonNull(isVirtualOrgDb = (Boolean)virtualOrgDbMap.get(orgId))) {
                if (!isVirtualOrgDb.booleanValue() && isVirtualOrg) {
                    errorMsg = ResManager.loadKDString((String)"\u4e0d\u80fd\u5c06\u5df2\u6709\u884c\u653f\u7ec4\u7ec7\u8bbe\u7f6e\u4e3a\u865a\u62df\u7ec4\u7ec7\u3002", (String)"OtherStructOrgImportValidator_11", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                    this.addFatalErrorMessage(extendedDataEntity, errorMsg);
                } else {
                    dataEntity.set("isvirtualorg", (Object)isVirtualOrgDb);
                }
            }
            if (Objects.equals(rootOrgId, orgId) && Objects.nonNull(parentOrgDy)) {
                errorMsg2 = ResManager.loadKDString((String)"\u6839\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u8c03\u6574\u4e0a\u7ea7\u3002\u3002", (String)"OtherStructOrgImportValidator_12", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(extendedDataEntity, errorMsg2);
            }
            if (existOrgTeamIds.contains(orgId) && structProjectPermOrgOpt.isPresent() && !structProjectPermOrgOpt.get().contains(orgId)) {
                errorMsg2 = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u9650\u7ef4\u62a4\u201c%1$s\u201d\u67b6\u6784\u7684\u884c\u653f\u7ec4\u7ec7\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OtherStructOrgImportValidator_13", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), this.structProjectDy.getString("name"), inputNumber);
                this.addFatalErrorMessage(extendedDataEntity, errorMsg2);
            }
            if (Objects.nonNull(parentOrgDy) && !existParentOrgTeamIds.contains(parentOrgDy.getLong("id"))) {
                ArrayList fields = Lists.newArrayListWithCapacity((int)2);
                fields.add(parentOrgDy.getString("number"));
                fields.add(parentOrgDy.getString("name"));
                String joinFields = fields.stream().filter(HRStringUtils::isNotEmpty).collect(Collectors.joining("/"));
                String errorMsg4 = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OtherStructOrgImportValidator_14", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), joinFields);
                this.addFatalErrorMessage(extendedDataEntity, errorMsg4);
            }
            if (Objects.nonNull(parentOrgDy) && existDbParentIds.contains(parentOrgDy.getLong("id")) && structProjectPermOrgOpt.isPresent() && !structProjectPermOrgOpt.get().contains(parentOrgDy.getLong("id"))) {
                errorMsg2 = ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OtherStructOrgImportValidator_15", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(extendedDataEntity, errorMsg2);
            }
            if (!this.isCircle(dataEntity, parentOrgDy)) continue;
            errorMsg2 = ResManager.loadKDString((String)"\u4e0d\u80fd\u8bbe\u7f6e\u81ea\u5df1\u6216\u81ea\u5df1\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OtherStructOrgImportValidator_16", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(extendedDataEntity, errorMsg2);
        }
    }

    private Map<String, String> queryBillOrg(Set<String> numbers) {
        String sql = "select  o.fbillno,e.fnumber  from  t_homs_orgchgbill o join t_homs_orgchgbillentry e on o.fid = e.fid where o.fbillstatus in('B','D')  and e.fchangesceneid in(1010,1030) and e.fnumber in(?)";
        DataSet dataSet = DB.queryDataSet((String)"queryBillOrg", (DBRoute)DBRoute.of((String)"hr"), (String)sql, (Object[])new Object[]{String.join((CharSequence)",", numbers)});
        LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize((int)16);
        dataSet.forEach(row -> result.put(row.getString("fnumber"), row.getString("fbillno")));
        return result;
    }

    private Optional<List<Long>> getPermOrgResultWithSub() {
        long userId = RequestContext.get().getCurrUserId();
        long structProjectOrgId = this.structProjectDy.getLong("org.id");
        long structProjectId = this.structProjectDy.getLong("id");
        long structProjectCreatorId = this.structProjectDy.getLong("creator.id");
        boolean creatorHasPermission = SystemParamHelper.getCreatorHasPermission((Long)structProjectOrgId);
        if (creatorHasPermission && Objects.equals(userId, structProjectCreatorId)) {
            return Optional.empty();
        }
        String structProjectEnable = this.structProjectDy.getString("enable");
        if (HRStringUtils.equals((String)structProjectEnable, (String)"10")) {
            return Optional.of(new ArrayList());
        }
        return this.getPermAdminOrg(structProjectId);
    }

    private Optional<List<Long>> getPermAdminOrg(long structProjectId) {
        long userId = RequestContext.get().getCurrUserId();
        String permEntityId = "haos_structorgdetail";
        permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
        String propKey = "boid";
        Map map = HAOSPermUtils.getStructProjectCustomInParam((String)propKey, (long)structProjectId);
        AuthorizedOrgResult result = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserAdminOrgs", (Object[])new Object[]{userId, "217WYC/L9U7E", permEntityId, "47150e89000000ac", propKey, map});
        if (result.isHasAllOrgPerm()) {
            return Optional.empty();
        }
        return Optional.ofNullable(result.getHasPermOrgs());
    }

    private boolean isCircle(DynamicObject orgDy, DynamicObject parentOrgDy) {
        if (Objects.isNull(orgDy) || Objects.isNull(parentOrgDy)) {
            return false;
        }
        long orgId = orgDy.getLong("id");
        long parentOrgId = parentOrgDy.getLong("id");
        if (Objects.equals(orgId, parentOrgId)) {
            return true;
        }
        DynamicObject result = this.getParentOrgDy(orgId);
        if (Objects.isNull(result)) {
            return false;
        }
        if (result.getLong("parentorgteam.id") == parentOrgId) {
            return false;
        }
        do {
            DynamicObject circleResult;
            if (Objects.isNull(circleResult = this.getParentOrgDy(parentOrgId))) {
                return false;
            }
            parentOrgId = circleResult.getLong("parentorgteam.id");
            if (parentOrgId != 0L) continue;
            return false;
        } while (orgId != parentOrgId);
        return true;
    }

    private DynamicObject getParentOrgDy(long orgId) {
        HRBaseServiceHelper structHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        return structHelper.queryOne("parentorgteam.id", new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("structproject", "=", (Object)this.structProjectDy.getLong("id")), new QFilter("orgteam", "=", (Object)orgId)});
    }

    private Set<Long> queryExistOrgTeamId(long structProjectId, Set<Long> orgTeamIds) {
        HRBaseServiceHelper structHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        DynamicObject[] structOrgResult = structHelper.query("orgteam.id", new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("structproject", "=", (Object)structProjectId), new QFilter("orgteam", "in", orgTeamIds)});
        return Stream.of(structOrgResult).map(structDy -> structDy.getDynamicObject("orgteam")).filter(Objects::nonNull).map(structDy -> structDy.getLong("id")).collect(Collectors.toSet());
    }

    private DynamicObject[] queryExistOrgId(String selectProperties, Set<Long> pkIdSet) {
        HRBaseServiceHelper orgDetailHelper = new HRBaseServiceHelper("haos_structorgdetail");
        QFilter filter = new QFilter("id", "in", pkIdSet).and(new QFilter("datastatus", "=", (Object)"1").or(new QFilter("isvirtualorg", "=", (Object)Boolean.TRUE)));
        return orgDetailHelper.query(selectProperties, new QFilter[]{filter});
    }
}

