/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.structproject.validator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.haos.business.domain.service.impl.structproject.StructConfigServiceImpl;
import kd.hr.haos.business.domain.service.structproject.IStructConfigService;

public class StructProConfigValidator
extends AbstractValidator {
    private IStructConfigService structConfigService = new StructConfigServiceImpl();

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Set entityTypes = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getString("entitytype.id")).collect(Collectors.toSet());
        DynamicObject[] structConfigInfoArr = this.structConfigService.queryStructConfigByEntityType("id, entitytype", entityTypes);
        Map<String, DynamicObject> structConfigInfoMap = Arrays.stream(structConfigInfoArr).collect(Collectors.toMap(structConfigInfo -> structConfigInfo.getString("entitytype.id"), structConfigInfo -> structConfigInfo));
        for (ExtendedDataEntity dataEntity2 : dataEntities) {
            DynamicObject structConfigDyn = dataEntity2.getDataEntity();
            String entityType = structConfigDyn.getString("entitytype.id");
            DynamicObject structConfigDynFromDB = structConfigInfoMap.get(entityType);
            if (structConfigDynFromDB != null && structConfigDyn.getLong("id") != structConfigDynFromDB.getLong("id")) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u201c%s\u201d\u5df2\u5b58\u5728\u67b6\u6784\u914d\u7f6e\u4fe1\u606f,\u8bf7\u5728\u539f\u914d\u7f6e\u4fe1\u606f\u4e2d\u4fee\u6539\u914d\u7f6e\u3002", (String)"StructProConfigValidator_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), entityType);
                this.addFatalErrorMessage(dataEntity2, errorMsg);
            }
            DynamicObjectCollection entryEntity = structConfigDyn.getDynamicObjectCollection("entryentity");
            ArrayList propKeys = Lists.newArrayListWithExpectedSize((int)16);
            for (DynamicObject entry : entryEntity) {
                String propKey = entry.getString("propkey");
                if (propKeys.contains(propKey)) {
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u5b57\u6bb5\u201c%s\u201d,\u8bf7\u786e\u8ba4\u3002", (String)"StructProConfigValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), propKey);
                    this.addFatalErrorMessage(dataEntity2, errorMsg);
                    continue;
                }
                propKeys.add(propKey);
            }
        }
    }
}

