/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.structtype.validate;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.haos.business.util.PatternUtil;

public class StructTypeValidator
extends AbstractValidator {
    public void validate() {
        boolean isNew = "save".equals(this.getOperateKey());
        ExtendedDataEntity dataEntity = this.getDataEntities()[0];
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String structTypeName = dynamicObject.getString("name");
        if (PatternUtil.valideName((String)structTypeName)) {
            String errorMsg = ResManager.loadKDString((String)"\u67b6\u6784\u7c7b\u578b\u540d\u79f0\u4e0d\u5141\u8bb8\u5e26\u7279\u6b8a\u5206\u5272\u7b26\uff08!_\\\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"StructTypeValidator_4", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, errorMsg);
        }
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        boolean existEnable = false;
        HashMap<String, Integer> numberMap = new HashMap<String, Integer>(entryentity.size());
        HashMap<String, Integer> nameMap = new HashMap<String, Integer>(entryentity.size());
        for (DynamicObject entry : entryentity) {
            String structName;
            Integer nameCount;
            String structNumber = entry.getString("struct_number");
            Integer count = numberMap.compute(structNumber, (key, value) -> value == null ? 1 : value + 1);
            if (count == 2) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u67b6\u6784\u65b9\u6848\u7f16\u7801\u201c%s\u201d\u91cd\u590d\u3002", (String)"StructTypeValidator_2", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), structNumber));
            }
            if ((nameCount = nameMap.compute(structName = entry.getString("struct_name"), (key, value) -> value == null ? 1 : value + 1)) == 2) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u67b6\u6784\u65b9\u6848\u540d\u79f0\u201c%s\u201d\u91cd\u590d\u3002", (String)"StructTypeValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), structName));
            }
            if (!isNew || existEnable || !entry.getBoolean("struct_enable")) continue;
            existEnable = true;
        }
        if (isNew && !existEnable) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e00\u4e2a\u67b6\u6784\u7c7b\u578b\u4e0b\u9762\u81f3\u5c11\u6709\u4e00\u4e2a\u542f\u7528\u7684\u67b6\u6784\u65b9\u6848\u3002", (String)"StructTypeValidator_3", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
        }
    }
}

