/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.validate;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class ChangeSceneImportValidator
extends AbstractValidator {
    private static final String CREATE_ORG_ID = "createorg.id";
    private static final String ORG_CHANGE_TYPE_ID = "orgchangetype.id";

    public void validate() {
        if (!HRStringUtils.equals((String)"save", (String)this.getOperateKey())) {
            return;
        }
        String importType = (String)this.getOption().getVariables().get("importtype");
        if (HRStringUtils.isEmpty((String)importType) || "new".equals(importType)) {
            return;
        }
        Set idSet = Arrays.stream(this.getDataEntities()).map(item -> item.getDataEntity().getLong("id")).collect(Collectors.toSet());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.getEntityKey());
        QFilter filter = new QFilter("id", "in", idSet);
        DynamicObject[] dyArray = serviceHelper.query("id,number,orgchangetype,createorg,ctrlstrategy,issyspreset", new QFilter[]{filter});
        Map<Long, DynamicObject> map = Arrays.stream(dyArray).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        String ctrlStrategyMsg = ResManager.loadKDString((String)"\u63a7\u5236\u7b56\u7565\u4e0d\u53ef\u4fee\u6539\u3002", (String)"CtrlStrategyValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
        String errorMsg = ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6570\u636e\u53ea\u80fd\u4fee\u6539\u201c\u540d\u79f0\u201d\u3001\u201c\u53d8\u52a8\u539f\u56e0\u201d\u548c\u201c\u63cf\u8ff0\u201d\u3002", (String)"ChangeSceneValidator_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
        String reviseMsg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u4fee\u8ba2\u53ea\u80fd\u53d8\u52a8\u539f\u56e0\u3001\u63cf\u8ff0", (String)"ChangeSceneValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity entity : this.getDataEntities()) {
            DynamicObject dy2 = entity.getDataEntity();
            DynamicObject dbDy = map.get(dy2.getLong("id"));
            if (dbDy == null) continue;
            boolean issyspreset = dbDy.getBoolean("issyspreset");
            if (!issyspreset && !HRStringUtils.equals((String)dbDy.getString("ctrlstrategy"), (String)dy2.getString("ctrlstrategy"))) {
                this.addErrorMessage(entity, ctrlStrategyMsg);
            }
            if (dbDy.getLong("id") == 1110L && this.isReviseChange(dy2, dbDy)) {
                this.addErrorMessage(entity, reviseMsg);
                continue;
            }
            if (!issyspreset || !this.isChange(dy2, dbDy)) continue;
            this.addErrorMessage(entity, errorMsg);
        }
    }

    private boolean isReviseChange(DynamicObject dy, DynamicObject dbDy) {
        return this.isChange(dy, dbDy) || !HistoryEntityUtils.compareValues((Object)dy.get("name"), (Object)dbDy.get("name"));
    }

    private boolean isChange(DynamicObject dy, DynamicObject dbDy) {
        if (!HRStringUtils.equals((String)dy.getString("number"), (String)dbDy.getString("number"))) {
            return true;
        }
        if (dy.getLong(CREATE_ORG_ID) != dbDy.getLong(CREATE_ORG_ID)) {
            return true;
        }
        if (dy.getLong(ORG_CHANGE_TYPE_ID) != dbDy.getLong(ORG_CHANGE_TYPE_ID)) {
            return true;
        }
        return !HRStringUtils.equals((String)dy.getString("ctrlstrategy"), (String)dbDy.getString("ctrlstrategy"));
    }
}

