/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.validate;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.util.PatternUtil;
import kd.hr.haos.common.constants.MultiLangEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class StructProjectValidator
extends AbstractValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        if (HRStringUtils.equals((String)"save", (String)operateKey)) {
            this.saveValidate();
        } else if (HRStringUtils.equals((String)"enable", (String)operateKey)) {
            this.enableValidate();
        } else if (HRStringUtils.equals((String)"delete_project", (String)operateKey)) {
            this.deleteValidate();
        } else if (HRStringUtils.equals((String)"disable", (String)operateKey)) {
            this.disableValidate();
        }
    }

    private void disableValidate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject dataEntity = entity.getDataEntity();
            if (!HRStringUtils.equals((String)dataEntity.getString("enable"), (String)"10")) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u5f85\u542f\u7528\uff0c\u4e0d\u80fd\u7981\u7528\u3002", (String)"StructProjectValidator_5", (String)"hrmp-haos-opplugin", (Object[])new Object[]{entity.getValue("number")}));
        }
    }

    private void saveValidate() {
        Map<String, DynamicObject> structGroupMap = this.getStructGroupInfoMap();
        if (!CollectionUtils.isEmpty(structGroupMap)) {
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject dataEntity = entity.getDataEntity();
                String groupKey = this.fetchGroupKey(dataEntity);
                DynamicObject structProjectInfo = structGroupMap.get(groupKey);
                if (structProjectInfo == null || dataEntity.getLong("id") == structProjectInfo.getLong("id")) continue;
                this.addErrorMessage(entity, ResManager.loadKDString((String)"%s\uff1a\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"StructProjectValidator_0", (String)"hrmp-haos-opplugin", (Object[])new Object[]{entity.getValue("number")}));
            }
        }
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject[] dynamicObjects;
            if (!"2".equals(entity.getDataEntity().getString("roottype"))) continue;
            ILocaleString name = entity.getDataEntity().getLocaleString("rootname");
            name.forEach((localeId, localeValue) -> {
                if ("GLang".equals(localeId)) {
                    return;
                }
                if (PatternUtil.valideName((String)localeValue)) {
                    this.addErrorMessage(entity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7[%s]\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08!_\\\uff09\uff0c\u8bf7\u4fee\u6539; ", (String)"StructProjectValidator_6", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), MultiLangEnum.getName((String)localeId)));
                }
            });
            HRBaseServiceHelper helper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
            QFilter numberFilter = new QFilter("number", "=", entity.getValue("rootnumber"));
            long rootOrgId = entity.getDataEntity().getLong("rootorg.id");
            if (rootOrgId > 0L) {
                numberFilter.and(new QFilter("boid", "!=", (Object)rootOrgId));
            }
            if ((dynamicObjects = helper.queryOriginalArray("id, boid, number", QFilterHelper.createHisCurrentDataFilter().and(numberFilter).toArray())) != null && dynamicObjects.length >= 1) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6709\u76f8\u540c\u7ec4\u7ec7\u7f16\u7801\u5b58\u5728\uff0c\u8bf7\u4fee\u6539;", (String)"StructProjectValidator_7", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                return;
            }
            HRBaseServiceHelper billHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
            QFilter billStatusFilter = new QFilter("billstatus", "in", (Object)new String[]{"B", "D"});
            DynamicObject[] bills = billHelper.queryOriginalArray("id, billno, entryentity_all.number", billStatusFilter.and(new QFilter("entryentity_all.number", "=", entity.getValue("rootnumber"))).toArray());
            if (bills == null || bills.length < 1) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\u5728\u9014\u7ec4\u7ec7\u8c03\u6574\u5355\u636e\u201c%s\u201d\u4e2d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"StructProjectValidator_8", (String)"hrmp-haos-opplugin", (Object[])new Object[]{bills[0].getString("billno")}));
            return;
        }
    }

    private void enableValidate() {
        Map<String, DynamicObject> structGroupMapFromDB = this.getStructGroupInfoMap();
        HashMap structGroupMap = Maps.newHashMapWithExpectedSize((int)this.dataEntities.length);
        Arrays.stream(this.dataEntities).forEach(dataEntity -> {
            DynamicObject structGroupDyn = dataEntity.getDataEntity();
            String groupKey = this.fetchGroupKey(structGroupDyn);
            List structProjectList = structGroupMap.getOrDefault(groupKey, new ArrayList());
            structProjectList.add(structGroupDyn);
            structGroupMap.put(groupKey, structProjectList);
        });
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject dataEntity2 = entity.getDataEntity();
            String groupKey = this.fetchGroupKey(dataEntity2);
            DynamicObject structProjectFromDB = structGroupMapFromDB.get(groupKey);
            List structProjectList = ((List)structGroupMap.get(groupKey)).stream().filter(structProject -> structProject.getLong("id") != dataEntity2.getLong("id")).collect(Collectors.toList());
            if (structProjectFromDB == null || structProjectList.size() <= 0) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"%s\uff1a\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u542f\u7528\u3002", (String)"StructProjectValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[]{entity.getValue("number")}));
        }
    }

    private void deleteValidate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject structProject = entity.getDataEntity();
            if (!"1".equals(structProject.getString("enable"))) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u88ab\u542f\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"StructProjectValidator_2", (String)"hrmp-haos-opplugin", (Object[])new Object[]{entity.getValue("number")}));
        }
    }

    private Map<String, DynamicObject> getStructGroupInfoMap() {
        HashSet names = Sets.newHashSetWithExpectedSize((int)this.dataEntities.length);
        HashSet orgIds = Sets.newHashSetWithExpectedSize((int)this.dataEntities.length);
        Arrays.stream(this.dataEntities).forEach(dataEntity -> {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            names.add(dynamicObject.getString("name"));
            orgIds.add(dynamicObject.getLong("org.id"));
        });
        DynamicObject[] structProjects = StructProjectRepository.getInstance().queryOriginalByNameAndOrgId("id, name, org.id", (Collection)names, (Collection)orgIds);
        return Arrays.stream(structProjects).collect(Collectors.toMap(this::fetchGroupKey, dynamicObject -> dynamicObject, (v1, v2) -> v1));
    }

    private String fetchGroupKey(DynamicObject structProject) {
        return structProject.getString("name") + "_";
    }
}

