/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class AdminOrgHisMainPeopleShiftPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(AdminOrgHisMainPeopleShiftPlugin.class);
    private static final String CARD_BUTTON_KEY = "cardbutton";
    private static final String LIST_BUTTON_KEY = "listbutton";
    private static final String TARGET_FLEX_KEY = "mainflex";
    private static final String KEY_FOCUS_BUTTON = "focusButton";
    public static final String PERSON_RESULT_KEY = "person_result";
    public static final String BELONG_DEPT_NAME_KEY = "belong_dept_name";
    public static final String BELONG_COMP_NAME_KEY = "belong_comp_name";
    public static final String ORG_ID = "orgid";
    private static Map<String, Consumer<IFormView>> SHOW_FORM_MAP = new HashMap<String, Consumer<IFormView>>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CARD_BUTTON_KEY});
        this.addClickListeners(new String[]{LIST_BUTTON_KEY});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initData();
        this.createSwitchControlByInit().switchPageView();
    }

    public void click(EventObject evt) {
        String clickingButton;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (clickingButton = source.getKey()) {
            case "cardbutton": 
            case "listbutton": {
                this.createSwitchControlByClick(clickingButton).switchPageView();
                break;
            }
        }
    }

    private void initData() {
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam("currentObjectPKId");
        if (orgId != null) {
            this.getView().getFormShowParameter().setCustomParam("customvariables", this.getView().getFormShowParameter().getCustomParam("customvariables"));
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
            DynamicObject dynamicObject = hrBaseServiceHelper.queryOriginalOne("belongcompany.name, belongdept.name", new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(orgId))});
            this.getView().getFormShowParameter().setCustomParam(BELONG_COMP_NAME_KEY, (Object)dynamicObject.getString("belongcompany.name"));
            this.getView().getFormShowParameter().setCustomParam(BELONG_DEPT_NAME_KEY, (Object)dynamicObject.getString("belongdept.name"));
            this.getView().cacheFormShowParameter();
        }
    }

    private static void showListForm(IFormView formView) {
        ListShowParameter subFormShowParameter = new ListShowParameter();
        subFormShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        subFormShowParameter.getOpenStyle().setTargetKey(TARGET_FLEX_KEY);
        subFormShowParameter.setFormId("hr_list");
        subFormShowParameter.setBillFormId("haos_hismainpeoplelist");
        subFormShowParameter.setLookUp(false);
        subFormShowParameter.setCustomParam("type", (Object)"list");
        AdminOrgHisMainPeopleShiftPlugin.transferCustomParam2SubView((FormShowParameter)subFormShowParameter, formView);
        formView.showForm((FormShowParameter)subFormShowParameter);
    }

    private static void showCardForm(IFormView formView) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setFormId("haos_hismainpeoplecard");
        showParameter.getOpenStyle().setTargetKey(TARGET_FLEX_KEY);
        showParameter.setSendToClient(false);
        AdminOrgHisMainPeopleShiftPlugin.transferCustomParam2SubView(showParameter, formView);
        formView.showForm(showParameter);
    }

    private static void transferCustomParam2SubView(FormShowParameter subShowParameter, IFormView formView) {
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        subShowParameter.setCustomParam("customvariables", formShowParameter.getCustomParam("customvariables"));
        String orgId = (String)formShowParameter.getCustomParam("currentObjectPKId");
        subShowParameter.setCustomParam("currentObjectPKId", (Object)orgId);
        subShowParameter.setCustomParam(BELONG_DEPT_NAME_KEY, formShowParameter.getCustomParam(BELONG_DEPT_NAME_KEY));
        subShowParameter.setCustomParam(BELONG_COMP_NAME_KEY, formShowParameter.getCustomParam(BELONG_COMP_NAME_KEY));
    }

    private void setButtonColorLight(String button) {
        HashMap<String, String> action = new HashMap<String, String>();
        action.put("fc", "themeColor");
        this.getView().updateControlMetadata(button, action);
    }

    private void setButtonColorDark(String button) {
        HashMap<String, String> action = new HashMap<String, String>();
        action.put("fc", "#666666");
        this.getView().updateControlMetadata(button, action);
    }

    private void cacheFocusButton(String clickingButton) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        formShowParameter.setCustomParam(KEY_FOCUS_BUTTON, (Object)clickingButton);
        this.getView().cacheFormShowParameter();
    }

    private SwitchControl createSwitchControlByInit() {
        return new SwitchControl(LIST_BUTTON_KEY, CARD_BUTTON_KEY);
    }

    private SwitchControl createSwitchControlByClick(String clickingButton) {
        return new SwitchControl((String)this.getView().getFormShowParameter().getCustomParam(KEY_FOCUS_BUTTON), clickingButton);
    }

    static {
        SHOW_FORM_MAP.put(CARD_BUTTON_KEY, AdminOrgHisMainPeopleShiftPlugin::showCardForm);
        SHOW_FORM_MAP.put(LIST_BUTTON_KEY, AdminOrgHisMainPeopleShiftPlugin::showListForm);
    }

    class SwitchControl {
        String clickingButton;
        String focusButton;

        SwitchControl(String focusButton, String clickingButton) {
            this.focusButton = focusButton;
            this.clickingButton = clickingButton;
        }

        void switchPageView() {
            if (this.canSwitch()) {
                AdminOrgHisMainPeopleShiftPlugin.this.setButtonColorDark(this.focusButton);
                AdminOrgHisMainPeopleShiftPlugin.this.setButtonColorLight(this.clickingButton);
                this.showForm(this.clickingButton);
                AdminOrgHisMainPeopleShiftPlugin.this.cacheFocusButton(this.clickingButton);
            }
        }

        boolean canSwitch() {
            return !StringUtils.equals((CharSequence)this.clickingButton, (CharSequence)this.focusButton);
        }

        void showForm(String focusButton) {
            ((Consumer)SHOW_FORM_MAP.get(focusButton)).accept(AdminOrgHisMainPeopleShiftPlugin.this.getView());
        }
    }
}

