/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.haos.business.service.adminorg.util.AdminOrgCountSubHelper;
import kd.hr.haos.business.servicehelper.AdminOrgQueryServiceHelper;
import kd.hr.haos.business.util.HAOSPermUtils;
import kd.hr.haos.business.util.TabOperateUtils;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class AdminOrgTopInfoEditPlugin
extends HRDataBaseEdit {
    private static final String CURRENT_PROJECT = "hrmp-haos-formplugin";
    private static final String HAOS_ORG_DETAIL = "haos_adminorgdetail";
    private static final HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgdetail");
    private static final String MANAGER_NAME = "managername";
    private static final String PAGE_AP = "jianap";
    private static final String MORE_AP = "moreap";
    private static final String CHANGE = "change";
    private static final String WILL_STOP_LABEL_FLEX = "willstoplabelflex";
    private static final String CANCLE_LABEL_FLEX = "canclelabelflex";
    private static final String ENABLE_LABEL_FLEX = "enablelabelflex";
    private static final String DEPAERT_TYPE = "depaerttype";
    private static final String DEPT_VECTOR_AP = "deptvectorap";
    private static final String TOBE_DISABLE_FLAG = "tobedisableflag";
    private static final String ORGDETAIL_CLOSEPARENT = "orgdetail_closeparent";
    private static final String SYSTEM_TYPE = "hrmp-haos-formplugin";
    public static final String IS_RELATE_PAGE = "is_relate_page";
    public static final String HRPI_PERSON = "hrpi_person";
    public static final String VIEW_DESENSITIZE = "view_desensitize";
    private static final Log logger = LogFactory.getLog(AdminOrgTopInfoEditPlugin.class);
    private static final String PERSON = "person";
    private static final String POS_TYPE = "postype";
    private static final String POSITION = "position";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{MORE_AP, CHANGE, VIEW_DESENSITIZE});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (MORE_AP.equals(control.getKey().toLowerCase(Locale.ROOT))) {
            FormShowParameter formShowParameter = this.showMoreLeaders("haos_leaderlist");
            String morePerson = this.getPageCache().get(MORE_AP);
            if (HRStringUtils.isNotEmpty((String)morePerson)) {
                formShowParameter.setCustomParam(MORE_AP, (Object)morePerson);
                this.getView().showForm(formShowParameter);
            }
        } else if (CHANGE.equals(control.getKey().toLowerCase(Locale.ROOT))) {
            FormShowParameter formShowParameter = this.showOrgF7();
            this.getView().showForm(formShowParameter);
        } else if (VIEW_DESENSITIZE.equals(control.getKey())) {
            this.getView().getPageCache().put("privacy", "true");
            long id = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("currentObjectPKId"));
            QFilter qFilter = new QFilter("boid", "=", (Object)id);
            Date searchDate = this.getSearchdate();
            qFilter.and(new QFilter("bsed", "<=", (Object)searchDate)).and(new QFilter("bsled", ">=", (Object)searchDate));
            qFilter.and("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
            qFilter.and("iscurrentversion", "=", (Object)Character.valueOf('0'));
            DynamicObject dy = helper.loadDynamicObject(qFilter.toArray());
            this.showLeader(dy, searchDate);
        }
    }

    public FormShowParameter showOrgF7() {
        ListShowParameter formShowParameter = new ListShowParameter();
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("620px");
        styleCss.setWidth("960px");
        openStyle.setInlineStyleCss(styleCss);
        formShowParameter.setLookUp(true);
        formShowParameter.setShowTitle(false);
        formShowParameter.setMultiSelect(false);
        formShowParameter.setFormId("haos_orgtreelistf7");
        formShowParameter.setBillFormId("haos_adminorgf7");
        formShowParameter.setHasRight(true);
        String structProjectIdStr = (String)this.getView().getFormShowParameter().getCustomParam("structproject");
        Long structProjectId = AdminOrgConstants.ADMINORG_STRUCT;
        if (!StringUtils.isEmpty((CharSequence)structProjectIdStr)) {
            structProjectId = Long.valueOf(structProjectIdStr);
        }
        QFilter structNumberFilter = null;
        String permItemId = "47150e89000000ac";
        String appId = this.getView().getFormShowParameter().getAppId();
        Long userId = RequestContext.get().getCurrUserId();
        AuthorizedOrgResultWithSub permOrgResultWithSub = (AuthorizedOrgResultWithSub)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserAdminOrgsWithSub", (Object[])new Object[]{userId, appId, HAOS_ORG_DETAIL, permItemId, "boid", HAOSPermUtils.getStructProjectCustomInParam((String)"boid", (long)Long.parseLong(structProjectIdStr))});
        if (!permOrgResultWithSub.isHasAllOrgPerm() && !CollectionUtils.isEmpty((Collection)permOrgResultWithSub.getHasPermOrgsWithSub())) {
            List orgIds = permOrgResultWithSub.getHasPermOrgsWithSub().stream().map(orgSubInfo -> orgSubInfo.getOrgId()).collect(Collectors.toList());
            List structNumberList = permOrgResultWithSub.getHasPermOrgsWithSub().stream().filter(orgSubInfo -> orgSubInfo.isContainsSub()).map(orgSubInfo -> orgSubInfo.getLongStructNumber()).collect(Collectors.toList());
            for (String structNumber : structNumberList) {
                if (structNumberFilter == null) {
                    structNumberFilter = new QFilter("structlongnumber", "like", (Object)("%" + structNumber + "%"));
                    continue;
                }
                structNumberFilter.or(new QFilter("structlongnumber", "like", (Object)("%" + structNumber + "%")));
            }
            if (structNumberFilter == null) {
                structNumberFilter = new QFilter("boid", "in", orgIds);
            } else {
                structNumberFilter.or(new QFilter("boid", "in", orgIds));
            }
            formShowParameter.getListFilterParameter().getQFilters().add(structNumberFilter);
        }
        formShowParameter.setCustomParam("struct_project_ids", (Object)SerializationUtils.toJsonString(Collections.singletonList(structProjectId)));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"AdminOrgTopInfoEditPlugin_5", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ORGDETAIL_CLOSEPARENT));
        return formShowParameter;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (ORGDETAIL_CLOSEPARENT.equals(actionId)) {
            Object primaryKeyValue;
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (returnData == null || returnData.get(0) == null || (primaryKeyValue = returnData.get(0).getPrimaryKeyValue()) == null) {
                return;
            }
            if (this.isCurrentRelatePage() && this.getView().getParentView() != null) {
                this.setCustomParameter4Refresh(primaryKeyValue);
                String caption = ResManager.loadKDString((String)"\u5173\u8054\u4fe1\u606f", (String)"AdminOrgPageRightDynamicPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
                caption = caption + "-" + returnData.get(0).getName();
                TabOperateUtils.refreshTabName((IFormView)this.getView(), (String)caption);
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
            } else {
                BillShowParameter formShowParameter = new BillShowParameter();
                OpenStyle openStyle = formShowParameter.getOpenStyle();
                openStyle.setShowType(ShowType.InCurrentForm);
                formShowParameter.setFormId(HAOS_ORG_DETAIL);
                formShowParameter.setPkId(primaryKeyValue);
                this.getView().showForm((FormShowParameter)formShowParameter);
            }
        }
    }

    private void setCustomParameter4Refresh(Object primaryKeyValue) {
        String currentRelatePage;
        IFormView parentView = this.getView().getParentView();
        FormShowParameter formShowParameter = parentView.getFormShowParameter();
        formShowParameter.setCustomParam("currentObjectPKId", (Object)primaryKeyValue.toString());
        Map customParam = (Map)formShowParameter.getCustomParam("customPKFilter");
        if (customParam != null) {
            customParam.put("boid", primaryKeyValue.toString());
        }
        if ((currentRelatePage = parentView.getPageCache().get("currentRelatePage")) == null) {
            currentRelatePage = (String)parentView.getFormShowParameter().getCustomParam("currentRelatePage");
        }
        formShowParameter.setCustomParam("currentRelatePage", (Object)currentRelatePage);
        parentView.cacheFormShowParameter();
    }

    public FormShowParameter showMoreLeaders(String formId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        openStyle.setFloatingDirection(FloatingDirection.RightCenter);
        formShowParameter.setFormId(formId);
        return formShowParameter;
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.getView().getPageCache().put("privacy", "false");
        this.setTopInfo();
    }

    private void setTopInfo() {
        if ("false".equals(this.getView().getFormShowParameter().getCustomParam("visableChange"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CHANGE});
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"attachmeflex"});
        if (HAOS_ORG_DETAIL.equals(this.getView().getFormShowParameter().getFormId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CHANGE});
        }
        long id = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("currentObjectPKId"));
        QFilter qFilter = new QFilter("boid", "=", (Object)id);
        Date searchDate = this.getSearchdate();
        qFilter.and(new QFilter("bsed", "<=", (Object)searchDate)).and(new QFilter("bsled", ">=", (Object)searchDate));
        qFilter.and("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        qFilter.and("iscurrentversion", "=", (Object)Character.valueOf('0'));
        DynamicObject dy = helper.loadDynamicObject(qFilter.toArray());
        this.showLeader(dy, searchDate);
        this.showOrgInfo(dy, searchDate);
        Long adminOrgTypeId = (Long)dy.get("adminorgtype.adminorgtypestd.id");
        if (Objects.nonNull(adminOrgTypeId)) {
            this.handleOrgType(String.valueOf(adminOrgTypeId));
            Label lable = (Label)this.getView().getControl(DEPAERT_TYPE);
            lable.setText(dy.getString("adminorgtype.name"));
        }
        this.getModel().setDataChanged(false);
    }

    private boolean isCurrentRelatePage() {
        return "true".equals(this.getView().getFormShowParameter().getCustomParam(IS_RELATE_PAGE));
    }

    private void showOrgInfo(DynamicObject dy, Date searchDate) {
        boolean flag;
        String name = dy.getString("name");
        this.getView().getModel().setValue("orgname", (Object)name);
        this.getView().updateView("orgname");
        String enable = dy.getString("enable");
        Object tobedisableflag = dy.get(TOBE_DISABLE_FLAG);
        boolean bl = flag = tobedisableflag == null ? false : (Boolean)tobedisableflag;
        if (enable.equals("1")) {
            if (!flag) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{WILL_STOP_LABEL_FLEX, CANCLE_LABEL_FLEX});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ENABLE_LABEL_FLEX, CANCLE_LABEL_FLEX});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ENABLE_LABEL_FLEX, WILL_STOP_LABEL_FLEX});
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{DEPAERT_TYPE, DEPT_VECTOR_AP});
        String belongCompanyName = this.getBelongcompanyName(dy.getLong("belongcompany.boid"), searchDate);
        Date establishmentdate = dy.getDate("establishmentdate");
        Map preciseDuration = OrgDateTimeUtil.calculatePreciseDuration((Date)establishmentdate, (Date)searchDate);
        int years = (Integer)preciseDuration.get("years");
        int months = (Integer)preciseDuration.get("months");
        int day = (Integer)preciseDuration.get("days");
        String establishmentPeriodTip = ResManager.loadKDString((String)"\u5df2\u6210\u7acb%s", (String)"NewAdminorgDetailEditPlugin_4", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
        String ymd = OrgDateTimeUtil.setYmd((int)years, (int)months, (int)day);
        String structProjectIdStr = (String)this.getView().getFormShowParameter().getCustomParam("structproject");
        Long structProjectId = AdminOrgConstants.ADMINORG_STRUCT;
        if (!StringUtils.isEmpty((CharSequence)structProjectIdStr)) {
            structProjectId = Long.valueOf(structProjectIdStr);
        }
        int oneLevelSubCount = AdminOrgCountSubHelper.createWithOnlyOneLevel((boolean)true).countSubWithAuth(dy.getLong("boid"), AdminOrgCountSubHelper.DEFAULT_AUTHOR_FORM_VIEW, searchDate, structProjectId);
        int allSubCount = AdminOrgCountSubHelper.createWithOnlyOneLevel((boolean)false).countSubWithAuth(dy.getLong("boid"), AdminOrgCountSubHelper.DEFAULT_AUTHOR_FORM_VIEW, searchDate, structProjectId);
        Label label = (Label)this.getView().getControl("establishmentdate");
        label.setText(String.format(establishmentPeriodTip, ymd));
        Label orgLabel = (Label)this.getView().getControl("org");
        if (orgLabel != null) {
            orgLabel.setText(dy.getString("org.name"));
        }
        ((Label)this.getView().getControl("labelap02")).setText(belongCompanyName);
        ((Label)this.getView().getControl("labelap04")).setText(String.valueOf(oneLevelSubCount));
        ((Label)this.getView().getControl("labelap06")).setText(String.valueOf(allSubCount));
    }

    private String getBelongcompanyName(long id, Date searchDate) {
        QFilter qFilter = new QFilter("boid", "=", (Object)id);
        qFilter.and(new QFilter("bsed", "<=", (Object)searchDate)).and(new QFilter("bsled", ">=", (Object)searchDate));
        qFilter.and("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        qFilter.and("iscurrentversion", "=", (Object)Character.valueOf('0'));
        DynamicObject dy = helper.loadDynamicObject(qFilter.toArray());
        if (dy != null) {
            return dy.getString("name");
        }
        return "";
    }

    private void showLeader(DynamicObject dy, Date searchDate) {
        boolean privacy;
        ArrayList ids = Lists.newArrayListWithCapacity((int)1);
        ids.add(dy.getLong("boid"));
        this.getView().setVisible(Boolean.valueOf(false), new String[]{MORE_AP});
        Map personByOrgIdList = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIChargeService", (String)"queryChargePersonByOrgId", (Object[])new Object[]{ids, searchDate});
        List chargePersonInfoList = (List)personByOrgIdList.get(dy.getLong("boid"));
        logger.info(String.format("==showLeader:%s", chargePersonInfoList));
        if (CollectionUtils.isEmpty((Collection)chargePersonInfoList)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"managerap", "managerapempty"});
            return;
        }
        chargePersonInfoList.sort((map1, map2) -> {
            Object number1 = map1.get("number");
            Object number2 = map2.get("number");
            if (number1 == null) {
                if (number2 == null) {
                    return 0;
                }
                return 1;
            }
            if (number2 == null) {
                return -1;
            }
            return ((String)number1).compareTo((String)number2);
        });
        this.getPageCache().put(MORE_AP, JSON.toJSONString((Object)chargePersonInfoList));
        List<Object> merageList = this.mergePersonList(chargePersonInfoList);
        MainEntityType personEntityType = MetadataServiceHelper.getDataEntityType((String)HRPI_PERSON);
        DynamicObject personDy = new DynamicObject((DynamicObjectType)personEntityType);
        boolean personnamePrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)HRPI_PERSON, (String)"name", (String)Lang.get().toString(), (String)"LIST", null);
        boolean bl = privacy = !HRStringUtils.equals((String)"false", (String)this.getView().getPageCache().get("privacy"));
        if (chargePersonInfoList.size() > 0) {
            if (merageList.size() > 1) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{MORE_AP});
            }
            if (merageList.size() > 0) {
                Map info = (Map)chargePersonInfoList.get(merageList.size() - 1);
                String pic = info.getOrDefault("headsculpture", "");
                String imageFullUrl = HRImageUrlUtil.getImageFullUrl((String)pic);
                Image image = (Image)this.getView().getControl("imageap0");
                image.setUrl(imageFullUrl);
                String nameObj = info.getOrDefault("name", "");
                String postype = info.getOrDefault(POS_TYPE, "");
                Label lable = (Label)this.getView().getControl("managername0");
                boolean nameClickView = AdminOrgQueryServiceHelper.checkClickView((String)HRPI_PERSON, (String)"name");
                if ((!personnamePrivacy || privacy) && nameClickView) {
                    lable.setText(nameObj);
                } else {
                    Object nameDesensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((String)HRPI_PERSON, (String)"name", (String)Lang.get().toString(), (String)"LIST", (DynamicObject)personDy, (Object)nameObj);
                    lable.setText((String)nameDesensitizeValue);
                }
                this.setLeaderTipsConent(info);
                if (!personnamePrivacy || privacy || !nameClickView) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{VIEW_DESENSITIZE});
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"managername0", "imageap0"});
            }
        }
    }

    private List<Object> mergePersonList(List<Map<String, Object>> personList) {
        HashMap<String, Map<String, Object>> perListMap = new HashMap<String, Map<String, Object>>();
        for (Map<String, Object> map : personList) {
            String personId = String.valueOf(map.get(PERSON));
            if (perListMap.containsKey(personId)) {
                Map mergeMap = (Map)perListMap.get(personId);
                String postype = (String)mergeMap.get(POS_TYPE);
                String postype1 = (String)map.get(POS_TYPE);
                if (!HRStringUtils.equals((String)postype1, (String)postype)) {
                    mergeMap.put(POS_TYPE, "");
                }
                String position = (String)mergeMap.get(POSITION);
                String position1 = (String)map.get(POSITION);
                position = HRStringUtils.isNotEmpty((String)position) ? position + "\u3001" + position1 : position1;
                mergeMap.put(POSITION, position);
                continue;
            }
            perListMap.put(personId, map);
        }
        return perListMap.values().stream().collect(Collectors.toList());
    }

    private void handleOrgType(String orgTypeId) {
        switch (orgTypeId) {
            case "1010": {
                this.getView().setVisible(Boolean.TRUE, new String[]{DEPAERT_TYPE, DEPT_VECTOR_AP});
                break;
            }
            case "1020": {
                this.getView().setVisible(Boolean.TRUE, new String[]{DEPAERT_TYPE, DEPT_VECTOR_AP});
                break;
            }
            case "1030": {
                this.getView().setVisible(Boolean.TRUE, new String[]{DEPAERT_TYPE, DEPT_VECTOR_AP});
                break;
            }
            case "1040": {
                this.getView().setVisible(Boolean.TRUE, new String[]{DEPAERT_TYPE, DEPT_VECTOR_AP});
                break;
            }
        }
    }

    private Date getSearchdate() {
        String searchdateStr = (String)this.getView().getFormShowParameter().getCustomParam("searchdate");
        Date searchdate = new Date();
        try {
            if (!StringUtils.isEmpty((CharSequence)searchdateStr)) {
                searchdate = HRDateTimeUtils.parseDate((String)searchdateStr);
            }
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        return searchdate;
    }

    private void setLeaderTipsConent(Map<String, Object> info) {
        HRBaseServiceHelper hrBaseServiceHelper;
        DynamicObject adminorg;
        ImageAp imageAp = new ImageAp();
        imageAp.setKey("imageap0");
        Tips ctlTips = new Tips();
        ctlTips.setType("text");
        StringBuilder titleSb = new StringBuilder();
        if (info.get("name") != null) {
            titleSb.append(info.get("name").toString()).append("  ");
        }
        if (info.get("number") != null) {
            titleSb.append(info.get("number").toString());
        }
        if (titleSb.length() > 0) {
            ctlTips.setTitle(new LocaleString(titleSb.toString()));
        }
        StringBuilder contentSb = new StringBuilder();
        contentSb.append(ResManager.loadKDString((String)"\u90e8\u95e8\uff1a", (String)"AdminOrgTopInfoEditPlugin_4", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
        if (info.get("adminorg") != null && (adminorg = (hrBaseServiceHelper = new HRBaseServiceHelper(HAOS_ORG_DETAIL)).queryOne(info.get("adminorg"))) != null) {
            contentSb.append(adminorg.getString("name"));
        }
        if (info.get(POSITION) != null) {
            contentSb.append("\r\n").append(ResManager.loadKDString((String)"\u5c97\u4f4d\uff1a", (String)"AdminOrgTopInfoEditPlugin_7", (String)"hrmp-haos-formplugin", (Object[])new Object[0])).append(info.get(POSITION));
        }
        contentSb.append("\r\n").append(ResManager.loadKDString((String)"\u4efb\u804c\u7c7b\u578b\uff1a", (String)"AdminOrgTopInfoEditPlugin_6", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
        if (info.get(POS_TYPE) != null) {
            contentSb.append(info.get(POS_TYPE).toString());
        }
        ctlTips.setContent(new LocaleString(contentSb.toString()));
        ctlTips.setShowIcon(false);
        ctlTips.setTriggerType("hover");
        imageAp.setCtlTips(ctlTips);
        this.getView().updateControlMetadata("imageap0", imageAp.createControl());
    }
}

