/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg;

import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class OrgDetailCommonListPlugin
extends HRDataBaseList {
    protected static final Log LOGGER = LogFactory.getLog(OrgDetailCommonListPlugin.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            Map customParams = listShowParameter.getCustomParams();
            LOGGER.info("isFromSchemeFilterColumn:" + customParams.containsKey("isFromSchemeFilterColumn") + " searchDate:" + customParams.containsKey("searchdate"));
            if (listShowParameter.isLookUp()) {
                if (!customParams.containsKey("searchdate") && customParams.containsKey("isFromSchemeFilterColumn")) {
                    listShowParameter.getListFilterParameter().getQFilters().add(QFilterHelper.createHisCurrentDataFilter());
                } else if (customParams.containsKey("searchdate")) {
                    String searchDateStr = (String)customParams.get("searchdate");
                    try {
                        if (!HRDateTimeUtils.truncateDate((Date)new Date()).equals(HRDateTimeUtils.truncateDate((Date)HRDateTimeUtils.parseDate((String)searchDateStr)))) {
                            QFilter filter = QFilterHelper.createValidHisVersionFilterByOnePoint((Date)HRDateTimeUtils.parseDate((String)searchDateStr));
                            listShowParameter.getListFilterParameter().getQFilters().add(filter);
                        }
                    }
                    catch (ParseException parseException) {
                        LOGGER.info("OrgDetailCommonListPlugin date format error!");
                        throw new KDBizException("data format error!");
                    }
                }
            }
        }
    }

    public void setListColumnVisible(boolean orgParent, List<IListColumn> listColumns) {
        for (int i = 0; i < listColumns.size(); ++i) {
            if (!HRStringUtils.equals((String)"struct_parent_org.name", (String)listColumns.get(i).getListFieldKey()) || orgParent) continue;
            listColumns.remove(i);
            return;
        }
    }

    public void setIsVirtualOrgListColumnVisible(List<IListColumn> listColumns, boolean isVirtualOrg) {
        if (isVirtualOrg) {
            return;
        }
        for (int i = 0; i < listColumns.size(); ++i) {
            if (!HRStringUtils.equals((String)"isvirtualorg", (String)listColumns.get(i).getListFieldKey())) continue;
            listColumns.remove(i);
            return;
        }
    }
}

