/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.servicehelper.OrgBatchBillHelper;
import kd.hr.haos.business.servicehelper.VirtualOrgHelper;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.util.HaosOrgUnitServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.PermCustomParamUtil;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class VirtualOrgDetailPlugin
extends HRDataBaseEdit
implements AdminOrgConstants,
BeforeF7SelectListener {
    private static final String ORG_NAME = "orgname";
    private static final String BU_ORG = "bu_org";
    private static final String WILL_STOP_LABEL_FLEX = "willstoplabelflex";
    private static final String CANCLE_LABEL_FLEX = "canclelabelflex";
    private static final String ENABLE_LABEL_FLEX = "enablelabelflex";
    private static final String BAR_MODIFY = "bar_modify";
    private static final String BAR_SAVE = "bar_save";
    private static final String TOP_INFO = "topinfo";
    private static final String STRUCT_PARENT_ORG = "struct_parent_org";
    private static final String ROOT_STRUCT_PARENT_ORG = "root_struct_parent_org";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.getView().getFormShowParameter().isHasRight()) {
            PermCustomParamUtil.setHasAllPermParam((IFormView)this.getView(), (Boolean)true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String name = dataEntity.getString("name");
        ((Label)this.getView().getControl(ORG_NAME)).setText(name);
        this.setButtonVisible(dataEntity);
        this.setStatusLableVisible(dataEntity);
        ((Label)this.getView().getControl(ORG_NAME)).setText(name);
        this.setOrgInfo();
        String prefix = this.getView().getModel().getDataEntity().getString("structproject.name");
        this.getView().setFormTitle(new LocaleString(prefix + "-" + name));
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        if (HRStringUtils.isEmpty((String)((String)this.getView().getFormShowParameter().getCustomParam("edit"))) || !HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("edit")), (String)"true")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE, BAR_MODIFY});
        }
    }

    private void setOrgInfo() {
        String structProject = (String)this.getView().getFormShowParameter().getCustomParam("structproject");
        Long structId = Long.valueOf(structProject);
        this.getModel().setValue("structproject", (Object)structId);
        QFilter qFilter = new QFilter("adminorg", "=", (Object)this.getModel().getDataEntity().getLong("boid"));
        QFilter structprojectQf = new QFilter("structproject", "=", (Object)structId);
        QFilter currentQf = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] dynamicObjects = AdminOrgStructRepository.getInstance().queryArray("id,parentorg.id", new QFilter[]{qFilter, structprojectQf, currentQf});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            DynamicObject orgStructDy = dynamicObjects[0];
            Long parentOrgId = orgStructDy.getLong("parentorg.id");
            if (parentOrgId.equals(0L)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{STRUCT_PARENT_ORG});
                this.getView().setVisible(Boolean.TRUE, new String[]{ROOT_STRUCT_PARENT_ORG});
                this.getModel().setValue(STRUCT_PARENT_ORG, (Object)this.getModel().getDataEntity().getLong("boid"));
                this.getModel().setValue("struct_name", (Object)this.getModel().getDataEntity().getString("name"));
            } else {
                this.getModel().setValue(STRUCT_PARENT_ORG, (Object)parentOrgId);
                String parentOrgLongName = OrgBatchBillHelper.getOrgLongName((Long)this.getModel().getDataEntity().getLong("struct_parent_org.id"), (Date)new Date(), (String)String.valueOf(structId));
                this.getModel().setValue("parent_struct_name", (Object)parentOrgLongName);
                String orgLongName = StringUtils.isEmpty((CharSequence)parentOrgLongName) ? this.getModel().getDataEntity().getString("name") : parentOrgLongName + HaosOrgUnitServiceHelper.getFullNameSep() + this.getModel().getDataEntity().getString("name");
                this.getModel().setValue("struct_name", (Object)orgLongName);
                this.getView().setVisible(Boolean.TRUE, new String[]{STRUCT_PARENT_ORG});
                this.getView().setVisible(Boolean.FALSE, new String[]{ROOT_STRUCT_PARENT_ORG});
            }
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"parent_struct_name"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"struct_name"});
    }

    private void setButtonVisible(DynamicObject dynamicObject) {
        String soucce = (String)this.getView().getFormShowParameter().getCustomParam("soucce");
        if ("1".equals(soucce)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_MODIFY});
            return;
        }
        String enable = dynamicObject.getString("enable");
        if (HRStringUtils.equals((String)enable, (String)"1")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_MODIFY});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_MODIFY});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE});
    }

    private void setStatusLableVisible(DynamicObject dynamicObject) {
        boolean flag;
        String enable = dynamicObject.getString("enable");
        Object tobedisableflag = dynamicObject.get("tobedisableflag");
        boolean bl = flag = tobedisableflag == null ? false : (Boolean)tobedisableflag;
        if (enable.equals("1")) {
            if (!flag) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{WILL_STOP_LABEL_FLEX, CANCLE_LABEL_FLEX});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ENABLE_LABEL_FLEX, CANCLE_LABEL_FLEX});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ENABLE_LABEL_FLEX, WILL_STOP_LABEL_FLEX});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (!HRStringUtils.equals((String)operateKey, (String)"save")) {
            return;
        }
        DynamicObject currentDy = this.getModel().getDataEntity();
        DynamicObject parentDy = currentDy.getDynamicObject(STRUCT_PARENT_ORG);
        if (parentDy != null) {
            currentDy.set("org", parentDy.get("org"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        if (eventArgs.getOperationResult().isSuccess()) {
            String operateKey = eventArgs.getOperateKey();
            if (operateKey.equals("save")) {
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().setVisible(Boolean.TRUE, new String[]{BAR_MODIFY, TOP_INFO});
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE});
                this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
                if (this.getView().getParentView() != null) {
                    this.getView().getParentView().invokeOperation("refresh");
                    this.getView().sendFormAction(this.getView().getParentView());
                }
                String message = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ManageRelStratgyRpPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(message);
                this.getView().updateView();
            } else if (operateKey.equals("modify")) {
                this.getView().setStatus(OperationStatus.EDIT);
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_MODIFY, TOP_INFO});
                this.getView().setVisible(Boolean.TRUE, new String[]{BAR_SAVE});
                String enable = this.getView().getModel().getDataEntity().getString("structproject.enable");
                if (HRStringUtils.equals((String)enable, (String)"10")) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"establishmentdate"});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"establishmentdate"});
                }
                Long rootOrgId = this.getView().getModel().getDataEntity().getLong("structproject.rootorg.id");
                if (rootOrgId.equals(this.getModel().getDataEntity().getLong("id"))) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{STRUCT_PARENT_ORG});
                }
                String structProject = (String)this.getView().getFormShowParameter().getCustomParam("structproject");
                Long structId = Long.valueOf(structProject);
                if (this.getModel().getDataEntity().getDynamicObject(STRUCT_PARENT_ORG) != null) {
                    Long parentId;
                    Long orgId = this.getModel().getDataEntity().getLong("id");
                    if (!orgId.equals(parentId = Long.valueOf(this.getModel().getDataEntity().getLong("struct_parent_org.id")))) {
                        String parentOrgLongName = OrgBatchBillHelper.getOrgLongName((Long)this.getModel().getDataEntity().getLong("struct_parent_org.id"), (Date)new Date(), (String)String.valueOf(structId));
                        this.getModel().setValue("parent_struct_name", (Object)parentOrgLongName);
                        String orgLongName = StringUtils.isEmpty((CharSequence)parentOrgLongName) ? this.getModel().getDataEntity().getString("name") : parentOrgLongName + "_" + this.getModel().getDataEntity().getString("name");
                        this.getModel().setValue("struct_name", (Object)orgLongName);
                    }
                    this.getView().setVisible(Boolean.TRUE, new String[]{"parent_struct_name"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"struct_name"});
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit parent = (BasedataEdit)this.getView().getControl(STRUCT_PARENT_ORG);
        parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)STRUCT_PARENT_ORG)) {
            beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7", (String)"VirtualOrgDetailPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            String structProject = (String)this.getView().getFormShowParameter().getCustomParam("structproject");
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "not in", this.getSubOrgSet()));
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("struct_project_visible", (Object)String.valueOf(Boolean.FALSE));
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("struct_project_ids", (Object)SerializationUtils.toJsonString(Collections.singletonList(structProject)));
        }
    }

    private Set<Long> getSubOrgSet() {
        Long orgId = this.getModel().getDataEntity().getLong("boid");
        Date effectDate = HRDateTimeUtils.getNowDate();
        String structProjectIdStr = (String)this.getView().getFormShowParameter().getCustomParam("structproject");
        Long structProjectId = Long.valueOf(structProjectIdStr);
        return VirtualOrgHelper.getSubOrgSet((Long)orgId, (Long)structProjectId, (Date)effectDate);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (fieldKey.equals(STRUCT_PARENT_ORG)) {
            Long parentId;
            DynamicObject parentDy = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (parentDy == null) {
                return;
            }
            Long orgId = this.getModel().getDataEntity().getLong("id");
            if (!orgId.equals(parentId = Long.valueOf(this.getModel().getDataEntity().getLong("struct_parent_org.id")))) {
                String structProjectIdStr = (String)this.getView().getFormShowParameter().getCustomParam("structproject");
                String orgLongName = OrgBatchBillHelper.getOrgLongName((Long)parentDy.getLong("id"), (Date)new Date(), (String)String.valueOf(structProjectIdStr));
                this.getModel().setValue("parent_struct_name", (Object)orgLongName);
            }
        }
    }
}

