/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg.mob;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterBindDataEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.domain.repository.adorg.HRAdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.HRAdminOrgStructRepository;
import kd.hr.haos.business.service.adminorg.bean.Pair;
import kd.hr.haos.business.service.adminorg.util.AdminOrgFilterCreationHelper;
import kd.hr.haos.business.util.HAOSDynamicObjectUtil;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.haos.common.model.customap.AbstractCustomApVO;
import kd.hr.haos.common.model.customap.ResponseData;
import kd.hr.haos.common.model.customap.drilldownlist.OrgModel;
import kd.hr.haos.common.model.customap.drilldownlist.bo.ConfirmBO;
import kd.hr.haos.common.model.customap.drilldownlist.bo.NavigateBO;
import kd.hr.haos.common.model.customap.drilldownlist.bo.NavigationBar;
import kd.hr.haos.common.model.customap.drilldownlist.bo.NextPageBO;
import kd.hr.haos.common.model.customap.drilldownlist.bo.SearchBO;
import kd.hr.haos.common.model.customap.drilldownlist.vo.NavigateVO;
import kd.hr.haos.common.model.customap.drilldownlist.vo.NextPageVO;
import kd.hr.haos.common.model.customap.drilldownlist.vo.SearchVO;
import kd.hr.haos.common.model.customap.drilldownlist.vo.ShowListVO;
import kd.hr.haos.common.util.tree.FindSubTree;
import kd.hr.haos.formplugin.web.adminorg.mob.AdminOrgDDMobListProvider;
import kd.hr.hbp.business.servicehelper.org.TreeTemplateHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseMobList;

public class AdminOrgDrillDownMobListPlugin
extends HRDataBaseMobList {
    private static final String CONTROL_KEY_DRILL_DOWN_LIST = "kdorgdrildownmoblistap";
    private static final String CONTROL_KEY_BILL_LIST = "billlistap";
    private static final String CACHE_KEY_NAVIGATE_ORG = "nagivate_org";
    private static final String CACHE_KEY_NAVIGATE_ORG_LIST = "nagivate_org_list";
    private static final String CACHE_KEY_NAVIGATE_TYPE = "nagivate_type";
    private static final String CACHE_KEY_NAVIGATE_TYPE_COMMON_ROOT = "1";
    private static final String CACHE_KEY_NAVIGATE_TYPE_NO_COMMON_ROOT = "0";
    private static final String CACHE_KEY_NAVIGATION_BAR = "nagivation_bar";
    private static final String CACHE_KEY_INPUT_STRING = "input_string";
    private static final String CACHE_KEY_PAGING_DRILL_DOWN = "paging1";
    private static final String CACHE_KEY_PAGING_SEARCH = "paging2";
    private static final String CACHE_KEY_LIST_FILTER = "qfilter";
    private static final String CACHE_KEY_FIRST_IN = "is_first_in";
    private String eventStatus;
    private String eventName;

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(CONTROL_KEY_BILL_LIST);
        billList.addAfterBindDataListener(this::afterBindData4BillList);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl(CONTROL_KEY_BILL_LIST);
        billList.addAfterBindDataListener(this::afterBindData4BillList);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.isFirstIn()) {
            this.initNavigateBar();
            this.initPaging4DrillDown();
            this.eventStatus = "showlist";
            this.eventName = "init";
            this.getView().cacheFormShowParameter();
            this.markAlreadyIn();
        }
    }

    private void afterBindData4BillList(AfterBindDataEvent afterBindDataEvent) {
        this.initListData();
        this.getView().cacheFormShowParameter();
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new AdminOrgDDMobListProvider());
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(QFilterHelper.createValidHisCurrentDataFilter());
        e.getQFilters().add(QFilterHelper.createInitFinishedFilter());
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.addAll(e.getQFilters());
        qFilterList.addAll(e.getDataPermQFilters());
        qFilterList.removeIf(Objects::isNull);
        this.cacheListFilterList(qFilterList);
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        if (eventName == null) {
            return;
        }
        this.eventName = eventName;
        this.eventStatus = "update";
        switch (eventName) {
            case "navigate": {
                NavigateBO navigateBO = (NavigateBO)SerializationUtils.fromJsonString((String)e.getEventArgs(), NavigateBO.class);
                if (HRStringUtils.equals((String)navigateBO.getOrgId(), (String)String.valueOf(this.getDefaultNavigateOrg().getId()))) {
                    navigateBO.setInit(true);
                }
                this.navigate(navigateBO);
                break;
            }
            case "search": {
                SearchBO searchBO = (SearchBO)SerializationUtils.fromJsonString((String)e.getEventArgs(), SearchBO.class);
                this.search(searchBO);
                break;
            }
            case "nextPage": {
                NextPageBO nextPageBO = new NextPageBO();
                nextPageBO.setType("drillDown");
                this.nextPage(nextPageBO);
                break;
            }
            case "searchNextPage": {
                NextPageBO searchNextPage = new NextPageBO();
                searchNextPage.setType("search");
                this.nextPage(searchNextPage);
                break;
            }
            case "confirm": {
                List selectedIdList = SerializationUtils.fromJsonStringToList((String)e.getEventArgs(), String.class);
                Set selectedIdSet = selectedIdList.stream().map(obj -> Long.parseLong(obj.toString())).collect(Collectors.toSet());
                ConfirmBO confirmBO = new ConfirmBO();
                confirmBO.setSelectedOrg(selectedIdSet);
                this.confirm(confirmBO);
                break;
            }
        }
        this.getView().cacheFormShowParameter();
    }

    private void initListData() {
        List<OrgModel> org = this.getFirstInDrillDownData();
        DynamicObject[] selectedOrgDy = this.getSelectedOrg();
        List selectedOrg = Arrays.stream(selectedOrgDy).map(dy -> new OrgModel(dy.getString("name"), dy.getLong("id"))).collect(Collectors.toList());
        this.packageLongName(org);
        ShowListVO showListVO = new ShowListVO();
        showListVO.setMultiSelect(this.isMultiSelect());
        showListVO.setSelectedCount(selectedOrg.size());
        showListVO.setSelectedOrg(selectedOrg);
        showListVO.setOrg(org);
        showListVO.setNavigationBar(this.getNavigateBar().getOrg());
        this.setCustomControl((AbstractCustomApVO)showListVO);
    }

    private void nextPage(NextPageBO nextPageBO) {
        DynamicObject[] adminOrgs = null;
        switch (nextPageBO.getType()) {
            case "search": {
                this.updatePaging4Search();
                adminOrgs = this.querySearchNextPage();
                break;
            }
            case "drillDown": {
                this.updatePaging4DrillDown();
                adminOrgs = this.queryDrillDownNextPage();
                break;
            }
        }
        List<OrgModel> orgModelList = Arrays.stream(adminOrgs).map(dy -> {
            OrgModel orgModel = new OrgModel();
            orgModel.setId(dy.getLong("id"));
            orgModel.setName(dy.getString("name"));
            orgModel.setNumber(dy.getString("number"));
            return orgModel;
        }).collect(Collectors.toList());
        if ("drillDown".equals(nextPageBO.getType())) {
            Map<Long, Boolean> orgVsHasSub = this.queryHasSub(orgModelList.stream().map(OrgModel::getId).collect(Collectors.toList()));
            orgModelList.forEach(orgModel -> orgModel.setHasSub(orgVsHasSub.getOrDefault(orgModel.getId(), false).booleanValue()));
        }
        this.packageLongName(orgModelList);
        NextPageVO nextPageVO = new NextPageVO();
        nextPageVO.setOrg(orgModelList);
        this.setCustomControl((AbstractCustomApVO)nextPageVO);
    }

    private void navigate(NavigateBO navigateBO) {
        List<OrgModel> orgModelList;
        this.initPaging4DrillDown();
        if (navigateBO.isInit()) {
            orgModelList = this.getFirstInDrillDownData();
            this.initNavigateBar();
        } else {
            this.cacheNavigateOrg(navigateBO.getOrgId());
            DynamicObject[] nextPageData = this.queryDrillDownNextPage();
            orgModelList = this.packageDrillDownModel(nextPageData);
            NavigationBar navigateBar = this.getNavigateBar();
            this.updateNavigationBar(navigateBO, navigateBar);
        }
        this.packageLongName(orgModelList);
        NavigationBar navigateBar = this.getNavigateBar();
        NavigateVO navigateVO = new NavigateVO();
        navigateVO.setNavigationBar(navigateBar.getOrg());
        navigateVO.setOrg(orgModelList);
        this.setCustomControl((AbstractCustomApVO)navigateVO);
    }

    private void search(SearchBO searchBO) {
        this.initPaging4Search();
        this.cacheInputString(searchBO.getInputStr());
        DynamicObject[] adminOrgs = this.querySearchData();
        List<OrgModel> orgModelList = Arrays.stream(adminOrgs).map(dy -> {
            OrgModel orgModel = new OrgModel();
            orgModel.setId(dy.getLong("id"));
            orgModel.setName(dy.getString("name"));
            orgModel.setNumber(dy.getString("number"));
            return orgModel;
        }).collect(Collectors.toList());
        this.packageLongName(orgModelList);
        SearchVO searchVO = new SearchVO();
        searchVO.setOrg(orgModelList);
        searchVO.setRequestNumber(searchBO.getRequestNumber());
        this.setCustomControl((AbstractCustomApVO)searchVO);
    }

    private void confirm(ConfirmBO confirmBO) {
        ListSelectedRowCollection listSelectedRows = confirmBO.getSelectedOrg().stream().map(id -> new ListSelectedRow(id, Boolean.valueOf(true))).collect(Collectors.toCollection(ListSelectedRowCollection::new));
        if (listSelectedRows.size() == 0) {
            listSelectedRows.setClearFlag(true);
        }
        this.getView().returnDataToParent((Object)listSelectedRows);
        this.getView().close();
    }

    private List<OrgModel> getFirstInDrillDownData() {
        List<QFilter> structFilterList = this.createStructFilterList();
        structFilterList.add((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get());
        DynamicObject[] structDys = HRAdminOrgStructRepository.getInstance().queryOriginal("id, adminorg.id, parentorg.id, structlongnumber, isroot", QFilterHelper.convert2Array(structFilterList));
        Map<Long, Long> orgVsParentOrg = Arrays.stream(structDys).collect(Collectors.toMap(struct -> struct.getLong("adminorg.id"), struct -> struct.getLong("parentorg.id")));
        Map<Long, DynamicObject> orgVsStruct = Arrays.stream(structDys).collect(Collectors.toMap(struct -> struct.getLong("adminorg.id"), struct -> struct));
        FindSubTree dynamicObjectFindSubTree = new FindSubTree(orgVsParentOrg, orgVsStruct);
        List firstLevelStructList = dynamicObjectFindSubTree.levelFirstLevel();
        if (firstLevelStructList.size() == 1) {
            CommonRootResult commonRootResult = this.queryCommonRoot();
            DynamicObject commonRoot = commonRootResult.commonRoot;
            OrgModel rootOrgModel = new OrgModel(commonRoot.getString("name"), commonRoot.getLong("id"));
            this.cacheNavigateOrg(commonRoot.getString("id"));
            DynamicObject[] nextPageOrg = this.queryDrillDownNextPage();
            List<OrgModel> org = this.packageDrillDownModel(nextPageOrg);
            if (commonRootResult.permission) {
                org.add(0, rootOrgModel);
            }
            return org;
        }
        List<Long> adminOrgList = firstLevelStructList.stream().map(struct -> struct.getLong("adminorg.id")).collect(Collectors.toList());
        this.cacheNavigateOrgList(adminOrgList);
        DynamicObject[] nextPageOrg = this.queryDrillDownNextPage();
        return this.packageDrillDownModel(nextPageOrg);
    }

    private CommonRootResult queryCommonRoot() {
        List<QFilter> structFilterList = this.createStructFilterList();
        structFilterList.add((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get());
        DynamicObject[] structDys = HRAdminOrgStructRepository.getInstance().queryOriginal("id, adminorg.id, structlongnumber", QFilterHelper.convert2Array(structFilterList));
        String parentOrgStructLongNumber = TreeTemplateHelper.getParentOrgStructLongNumberByOrgArray((DynamicObject[])structDys);
        Optional<DynamicObject> rootStructOpt = Arrays.stream(structDys).filter(structDy -> HRStringUtils.equals((String)structDy.getString("structlongnumber"), (String)parentOrgStructLongNumber)).findAny();
        CommonRootResult commonRootResult = null;
        if (rootStructOpt.isPresent()) {
            DynamicObject commonRootStruct = rootStructOpt.get();
            DynamicObject commonRoot = HRAdOrgRepository.getInstance().queryOriginalOneByPk("id, name", (Object)commonRootStruct.getLong("adminorg.id"));
            commonRootResult = new CommonRootResult();
            commonRootResult.commonRoot = commonRoot;
            commonRootResult.permission = Arrays.stream(structDys).anyMatch(structDy -> structDy.getLong("adminorg.id") == commonRoot.getLong("id"));
        } else {
            commonRootResult = new CommonRootResult();
            DynamicObject adOrgDy = HRAdOrgRepository.getInstance().genEmptyDy(Arrays.asList("id", "name"));
            adOrgDy.set("id", (Object)-1);
            commonRootResult.commonRoot = adOrgDy;
            commonRootResult.permission = false;
        }
        return commonRootResult;
    }

    private void addLevelFilter4QueryStruct(List<QFilter> structFilterList) {
        Object levelCustomParam = this.getView().getFormShowParameter().getCustomParam("query_level");
        if (levelCustomParam != null) {
            int level = Integer.parseInt(levelCustomParam.toString());
            structFilterList.add(new QFilter("level", "<=", (Object)level));
        }
    }

    private List<OrgModel> packageDrillDownModel(DynamicObject[] nextPageData) {
        List<OrgModel> orgModelList = Arrays.stream(nextPageData).map(dy -> {
            OrgModel orgModel = new OrgModel(dy.getString("name"), dy.getLong("id"));
            orgModel.setNumber(dy.getString("number"));
            return orgModel;
        }).collect(Collectors.toList());
        Map<Long, Boolean> orgVsHasSub = this.queryHasSub(Arrays.stream(nextPageData).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        orgModelList.forEach(orgModel -> orgModel.setHasSub(orgVsHasSub.getOrDefault(orgModel.getId(), false).booleanValue()));
        return orgModelList;
    }

    private List<QFilter> createStructFilterList() {
        List<QFilter> listDataQFilterList = this.getListDataQFilterList();
        List<QFilter> qFilters = listDataQFilterList.stream().map(filter -> QFilterHelper.createConvertedFieldFilter((QFilter)filter, oldField -> "adminorg." + oldField)).collect(Collectors.toList());
        qFilters.add(QFilterHelper.createValidHisCurrentDataFilter());
        qFilters.add(QFilterHelper.createInitFinishedFilter());
        this.addLevelFilter4QueryStruct(qFilters);
        return qFilters;
    }

    private void initNavigateBar() {
        NavigationBar navigationBar = new NavigationBar();
        navigationBar.setOrg(new ArrayList());
        navigationBar.getOrg().add(this.getDefaultNavigateOrg());
        this.cacheNavigateBar(navigationBar);
    }

    private DynamicObject[] getSelectedOrg() {
        DynamicObject targetBaseData;
        DynamicObjectCollection targetMultiBaseData;
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return new DynamicObject[0];
        }
        DynamicObject parentDataEntity = parentView.getModel().getDataEntity();
        String controlKey = this.getView().getFormShowParameter().getCloseCallBack().getControlKey();
        if (parentDataEntity == null || controlKey == null) {
            return new DynamicObject[0];
        }
        if (!parentDataEntity.getDynamicObjectType().getProperties().containsKey((Object)controlKey)) {
            return new DynamicObject[0];
        }
        List<Object> selectedOrg = this.isMultiSelect() ? (CollectionUtils.isEmpty((Collection)(targetMultiBaseData = parentDataEntity.getDynamicObjectCollection(controlKey))) ? Collections.emptyList() : targetMultiBaseData.stream().map(dyn -> dyn.getLong("fbasedataid_id")).collect(Collectors.toList())) : ((targetBaseData = parentDataEntity.getDynamicObject(controlKey)) == null ? Collections.emptyList() : Collections.singletonList(HAOSDynamicObjectUtil.smartGetId((Object)targetBaseData)));
        return HRAdOrgRepository.getInstance().queryOriginalByPks("id, name", selectedOrg);
    }

    private OrgModel getDefaultNavigateOrg() {
        OrgModel orgModel = new OrgModel();
        orgModel.setId(-1L);
        orgModel.setName(ResManager.loadKDString((String)"\u9009\u62e9\u7ec4\u7ec7", (String)"AdminOrgDrillDownMobListPlugin_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
        return orgModel;
    }

    private void updateNavigationBar(NavigateBO navigateBO, NavigationBar navigateBar) {
        if (navigateBO.isInit()) {
            navigateBar.setOrg(Collections.singletonList(this.getDefaultNavigateOrg()));
        } else {
            long navigateOrgId = Long.parseLong(navigateBO.getOrgId());
            List navigateBarOrgList = navigateBar.getOrg();
            Optional<Long> barHasNavigateIdOpt = navigateBarOrgList.stream().map(OrgModel::getId).filter(id -> id == navigateOrgId).findAny();
            if (barHasNavigateIdOpt.isPresent()) {
                while (!navigateBarOrgList.isEmpty() && ((OrgModel)navigateBarOrgList.get(navigateBarOrgList.size() - 1)).getId() != navigateOrgId) {
                    navigateBarOrgList.remove(navigateBarOrgList.size() - 1);
                }
            } else {
                OrgModel navigateOrgModel = new OrgModel();
                navigateOrgModel.setId(navigateOrgId);
                navigateOrgModel.setName(this.queryOrgNameByOrgPk(navigateOrgId));
                navigateBarOrgList.add(navigateOrgModel);
            }
        }
        this.cacheNavigateBar(navigateBar);
    }

    private Map<Long, Boolean> queryHasSub(List<Long> orgIdList) {
        List<QFilter> listDataQFilterList = this.getQFilterList4queryMasterData();
        DynamicObject[] adminOrgs = HRAdOrgRepository.getInstance().queryOriginalAdminOrgByParent("id, parent.id", orgIdList, listDataQFilterList);
        return Arrays.stream(adminOrgs).collect(Collectors.groupingBy(org -> org.getLong("parent.id"), Collectors.mapping(dy -> true, Collectors.reducing(true, (b, b2) -> true))));
    }

    private DynamicObject[] querySearchData() {
        String inputString = this.getInputString();
        Pair<Integer, Integer> paging = this.getPaging4Search();
        List<QFilter> listDataQFilterList = this.getQFilterList4queryMasterData();
        return HRAdOrgRepository.getInstance().loadQueryEntityByNameOrNumberOrderBySortCode("id, name, number", inputString, listDataQFilterList, ((Integer)paging.getKey()).intValue(), ((Integer)paging.getValue()).intValue());
    }

    private DynamicObject[] queryDrillDownNextPage() {
        if (CACHE_KEY_NAVIGATE_TYPE_COMMON_ROOT.equals(this.getNavigateType())) {
            long navigateOrg = this.getNavigateOrg();
            List<QFilter> listDataQFilterList = this.getQFilterList4queryMasterData();
            Pair<Integer, Integer> startVsLimit = this.getPaging4DrillDown();
            return HRAdOrgRepository.getInstance().loadAdminOrgByOneLevel("id, name, number", navigateOrg, listDataQFilterList, "index", ((Integer)startVsLimit.getKey()).intValue(), ((Integer)startVsLimit.getValue()).intValue());
        }
        List<Long> navigateOrgList = this.getNavigateOrgList();
        return this.queryFirstLevelNextPage(navigateOrgList);
    }

    private DynamicObject[] queryFirstLevelNextPage(List<Long> adminOrgList) {
        Pair<Integer, Integer> startVsLimit = this.getPaging4DrillDown();
        ArrayList<QFilter> listDataQFilterList = new ArrayList<QFilter>();
        QFilter boFilter = new QFilter("boid", "in", adminOrgList);
        listDataQFilterList.add(boFilter);
        listDataQFilterList.addAll(this.getQFilterList4queryMasterData());
        return HRAdOrgRepository.getInstance().loadAdminOrg("id, name, number", listDataQFilterList, "index", ((Integer)startVsLimit.getKey()).intValue(), ((Integer)startVsLimit.getValue()).intValue());
    }

    private DynamicObject[] querySearchNextPage() {
        String inputString = this.getInputString();
        Pair<Integer, Integer> startVsLimit = this.getPaging4Search();
        List<QFilter> listDataQFilterList = this.getQFilterList4queryMasterData();
        return HRAdOrgRepository.getInstance().loadQueryEntityByNameOrNumberOrderBySortCode("id, name, number", inputString, listDataQFilterList, ((Integer)startVsLimit.getKey()).intValue(), ((Integer)startVsLimit.getValue()).intValue());
    }

    private List<QFilter> getQFilterList4queryMasterData() {
        List<QFilter> listDataQFilterList = this.getListDataQFilterList();
        listDataQFilterList.add(this.createAdminOrgFilterByLevel());
        return listDataQFilterList;
    }

    private QFilter createAdminOrgFilterByLevel() {
        Object levelCustomParam = this.getView().getFormShowParameter().getCustomParam("query_level");
        if (levelCustomParam != null) {
            int level = Integer.parseInt(levelCustomParam.toString());
            return AdminOrgFilterCreationHelper.convertLevelFilter((int)level);
        }
        return QFilterHelper.create1Equals1Filter();
    }

    private String queryOrgNameByOrgPk(long id) {
        DynamicObject org = HRAdOrgRepository.getInstance().queryOriginalOneByPk("name", (Object)id);
        return org.getString("name");
    }

    private void packageLongName(List<OrgModel> orgModelList) {
        List idSet = orgModelList.stream().map(OrgModel::getId).collect(Collectors.toList());
        DynamicObject[] adOrgDys = HRAdOrgRepository.getInstance().queryOriginalByPks("id, company.name", idSet);
        Map<Long, String> idVsCompanyName = Arrays.stream(adOrgDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> {
            String name = dy.getString("company.name");
            return name == null ? "" : name;
        }, (v, v2) -> v));
        for (OrgModel orgModel : orgModelList) {
            orgModel.setLongName(idVsCompanyName.getOrDefault(orgModel.getId(), ""));
        }
    }

    private void cacheListFilterList(List<QFilter> qFilterList) {
        this.getView().getFormShowParameter().setCustomParam(CACHE_KEY_LIST_FILTER, (Object)SerializationUtils.toJsonString(qFilterList.stream().map(QFilter::toSerializedString).collect(Collectors.toList())));
    }

    private List<QFilter> getListDataQFilterList() {
        List objList = SerializationUtils.fromJsonStringToList((String)((String)this.getView().getFormShowParameter().getCustomParam(CACHE_KEY_LIST_FILTER)), String.class);
        return objList.stream().map(obj -> QFilter.fromSerializedString((String)obj.toString())).collect(Collectors.toList());
    }

    private NavigationBar getNavigateBar() {
        return (NavigationBar)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam(CACHE_KEY_NAVIGATION_BAR)), NavigationBar.class);
    }

    private void cacheNavigateBar(NavigationBar navigateBar) {
        this.getView().getFormShowParameter().setCustomParam(CACHE_KEY_NAVIGATION_BAR, (Object)SerializationUtils.toJsonString((Object)navigateBar));
    }

    private long getNavigateOrg() {
        return Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam(CACHE_KEY_NAVIGATE_ORG));
    }

    private void cacheNavigateOrg(String orgId) {
        this.getView().getFormShowParameter().setCustomParam(CACHE_KEY_NAVIGATE_ORG, (Object)orgId);
        this.cacheNavigateType(CACHE_KEY_NAVIGATE_TYPE_COMMON_ROOT);
    }

    private void cacheNavigateOrgList(List<Long> orgList) {
        this.getView().getFormShowParameter().setCustomParam(CACHE_KEY_NAVIGATE_ORG_LIST, (Object)SerializationUtils.toJsonString(orgList));
        this.cacheNavigateType(CACHE_KEY_NAVIGATE_TYPE_NO_COMMON_ROOT);
    }

    private List<Long> getNavigateOrgList() {
        String orgListJson = (String)this.getView().getFormShowParameter().getCustomParam(CACHE_KEY_NAVIGATE_ORG_LIST);
        return SerializationUtils.fromJsonStringToList((String)orgListJson, Long.class);
    }

    private void cacheNavigateType(String type) {
        this.getView().getFormShowParameter().setCustomParam(CACHE_KEY_NAVIGATE_TYPE, (Object)type);
    }

    private String getNavigateType() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CACHE_KEY_NAVIGATE_TYPE);
    }

    private void cacheInputString(String inputString) {
        this.getView().getFormShowParameter().setCustomParam(CACHE_KEY_INPUT_STRING, (Object)inputString);
    }

    private String getInputString() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CACHE_KEY_INPUT_STRING);
    }

    private void initPaging4DrillDown() {
        this.cachePagingParam4DrillDown(0, ((BillList)this.getControl(CONTROL_KEY_BILL_LIST)).getPageRow());
    }

    private void updatePaging4DrillDown() {
        Pair<Integer, Integer> paging = this.getPaging4DrillDown();
        this.cachePagingParam4DrillDown((Integer)paging.getKey() + 1, (Integer)paging.getValue());
    }

    private void cachePagingParam4DrillDown(int start, int limit) {
        this.getView().getFormShowParameter().setCustomParam(CACHE_KEY_PAGING_DRILL_DOWN, (Object)String.format("%s_%s", start, limit));
    }

    private Pair<Integer, Integer> getPaging4DrillDown() {
        String paging = (String)this.getView().getFormShowParameter().getCustomParam(CACHE_KEY_PAGING_DRILL_DOWN);
        String[] split = paging.split("_");
        return new Pair((Object)Integer.valueOf(split[0]), (Object)Integer.valueOf(split[1]));
    }

    private void initPaging4Search() {
        this.cachePagingParam4Search(0, ((BillList)this.getControl(CONTROL_KEY_BILL_LIST)).getPageRow());
    }

    private void updatePaging4Search() {
        Pair<Integer, Integer> paging = this.getPaging4Search();
        this.cachePagingParam4Search((Integer)paging.getKey() + 1, (Integer)paging.getValue());
    }

    private void cachePagingParam4Search(int start, int limit) {
        this.getView().getFormShowParameter().setCustomParam(CACHE_KEY_PAGING_SEARCH, (Object)String.format("%s_%s", start, limit));
    }

    private Pair<Integer, Integer> getPaging4Search() {
        String paging = (String)this.getView().getFormShowParameter().getCustomParam(CACHE_KEY_PAGING_SEARCH);
        String[] split = paging.split("_");
        return new Pair((Object)Integer.valueOf(split[0]), (Object)Integer.valueOf(split[1]));
    }

    private void setCustomControl(AbstractCustomApVO customApVO) {
        ResponseData responseData = ResponseData.success((Object)customApVO);
        responseData.setEventName(this.eventName);
        responseData.setEventStatus(this.eventStatus);
        CustomControl customcontrol = (CustomControl)this.getView().getControl(CONTROL_KEY_DRILL_DOWN_LIST);
        Map data = responseData.toMap();
        customcontrol.setData((Object)data);
    }

    private boolean isMultiSelect() {
        return ((ListShowParameter)this.getView().getFormShowParameter()).isMultiSelect();
    }

    private boolean isFirstIn() {
        return !Boolean.parseBoolean(this.getPageCache().get(CACHE_KEY_FIRST_IN));
    }

    private void markAlreadyIn() {
        this.getPageCache().put(CACHE_KEY_FIRST_IN, Boolean.TRUE.toString());
    }

    private static class CommonRootResult {
        DynamicObject commonRoot;
        boolean permission;

        private CommonRootResult() {
        }
    }
}

