/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg.mob;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.service.adminorg.util.AdminOrgFilterCreationHelper;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.formplugin.web.HRDataBaseMobList;

public class AdminOrgEmptyMobListPlugin
extends HRDataBaseMobList {
    private static final String PANEL_LIST_CONTROL = "listflexpanelap";
    private static final String PANEL_EMPTY_CONTROL = "emptypanelap";
    private static final String KEY_FIRST_IN = "is_first_in";
    public static final String KEY_USER_INPUT_STRING = "user_input_string";
    public static final String KEY_QUERY_DATE = "query_date";
    public static final String KEY_LEVEL = "query_level";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isFirstIn()) {
            this.showEmptyFlexPanel();
            this.markAlreadyIn();
        }
    }

    public void setFilter(SetFilterEvent e) {
        this.setLevelFilter(e);
        this.setNameOrNumberFilter(e);
        this.setDateFilter(e);
        e.getQFilters().add(QFilterHelper.createInitFinishedFilter());
        e.setDataPermQFilters(Collections.emptyList());
        e.getQFilters().add(new QFilter("isvirtualorg", "=", (Object)"0"));
    }

    public void mobileSearchTextChange(MobileSearchTextChangeEvent args) {
        super.mobileSearchTextChange(args);
        String inputText = args.getText();
        if (StringUtils.isNotEmpty((CharSequence)inputText)) {
            this.showListFlexPanel();
            this.cacheUserInputString(inputText);
        } else {
            this.showEmptyFlexPanel();
            args.setCancel(true);
        }
    }

    private void setNameOrNumberFilter(SetFilterEvent e) {
        String userInputString = this.getUserInputString();
        QFilter nameOrNumberFilter = QFilterHelper.create1NotEquals1Filter();
        if (StringUtils.isNotEmpty((CharSequence)userInputString)) {
            nameOrNumberFilter = new QFilter("name", "=", (Object)userInputString).or("number", "=", (Object)userInputString);
        }
        e.getQFilters().add(0, nameOrNumberFilter);
    }

    private void setDateFilter(SetFilterEvent e) {
        Date customDate = this.getCustomDate();
        e.getQFilters().add(QFilterHelper.createValidHisVersionFilterByOnePoint((Date)customDate));
    }

    private void setLevelFilter(SetFilterEvent e) {
        Object levelCustomParam = this.getView().getFormShowParameter().getCustomParam(KEY_LEVEL);
        if (levelCustomParam != null) {
            int level = Integer.parseInt(levelCustomParam.toString());
            QFilter boFilter = AdminOrgFilterCreationHelper.convertLevelFilter((int)level, (Date)this.getCustomDate());
            e.getQFilters().add(boFilter);
        }
    }

    private void showListFlexPanel() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{PANEL_LIST_CONTROL});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PANEL_EMPTY_CONTROL});
    }

    private void showEmptyFlexPanel() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PANEL_LIST_CONTROL});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{PANEL_EMPTY_CONTROL});
    }

    private boolean isFirstIn() {
        return !Boolean.parseBoolean(this.getPageCache().get(KEY_FIRST_IN));
    }

    private void markAlreadyIn() {
        this.getPageCache().put(KEY_FIRST_IN, Boolean.TRUE.toString());
    }

    private Date getCustomDate() {
        String dateString = (String)this.getView().getFormShowParameter().getCustomParam(KEY_QUERY_DATE);
        return OrgDateTimeUtil.str2DateIfNullToday((String)dateString, (boolean)true);
    }

    private String getUserInputString() {
        return this.getPageCache().get(KEY_USER_INPUT_STRING);
    }

    private void cacheUserInputString(String userInputString) {
        this.getPageCache().put(KEY_USER_INPUT_STRING, userInputString);
    }
}

