/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg.template;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class AdminOrgBatchBillF7
extends HRDataBaseList {
    private static final Log log = LogFactory.getLog(AdminOrgBatchBillF7.class);
    private static final String ADMIN_ORG_ID = "adminorg.id";
    private static final String HAOS_ADMINORGDETAIL = "haos_adminorgdetail";
    protected Map<Long, DynamicObject> orgGroupDataMap = new HashMap<Long, DynamicObject>(16);
    protected Map<Long, DynamicObject> orgCompanyDataMap = new HashMap<Long, DynamicObject>(16);
    protected Map<Long, DynamicObject> departmentDataMap = new HashMap<Long, DynamicObject>(16);
    protected Map<Long, DynamicObject> structDataMap = new HashMap<Long, DynamicObject>(16);
    protected Map<Long, Long> orgBoIdMap = new HashMap<Long, Long>(16);

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        log.info("[\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7F7]");
        event.setOrderBy("datastatus desc, number asc");
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageData = e.getPageData();
        if (!pageData.isEmpty()) {
            ArrayList<Long> rowIds = new ArrayList<Long>();
            for (DynamicObject row : pageData) {
                rowIds.add(row.getLong("id"));
            }
            if (!rowIds.isEmpty()) {
                HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(HAOS_ADMINORGDETAIL);
                QFilter qFilter = new QFilter("id", "in", rowIds);
                DynamicObjectCollection dynamicObjects = hrBaseServiceHelper.queryOriginalCollection("id,boid", qFilter.toArray());
                ArrayList<Long> orgBoids = new ArrayList<Long>();
                this.orgBoIdMap = dynamicObjects.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getLong("boid")));
                dynamicObjects.stream().forEach(dynamicObject -> orgBoids.add(dynamicObject.getLong("boid")));
                this.orgGroupDataMap.putAll(this.getOrgDataInfoMap(orgBoids, AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), "adminorg,groupvision,groupleader,groupmission", null));
                this.orgCompanyDataMap.putAll(this.getOrgDataInfoMap(orgBoids, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), "adminorg,companytype,industrytype", null));
                this.departmentDataMap.putAll(this.getOrgDataInfoMap(orgBoids, AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), "adminorg,departmenttype", null));
                this.structDataMap.putAll(this.getOrgDataInfoMap(orgBoids, AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), "adminorg,level,parentorg", new QFilter("structproject", "=", (Object)AdminOrgConstants.ADMINORG_STRUCT)));
            }
        }
    }

    public Map<Long, DynamicObject> getOrgDataInfoMap(List<Long> rowIds, String formId, String fieldNames, QFilter qFilter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(formId);
        QFilter idFilter = new QFilter(ADMIN_ORG_ID, "in", rowIds);
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        QFilter[] qFilterArr = qFilter != null ? new QFilter[]{qFilter, idFilter, isCurrentVersionFilter} : new QFilter[]{idFilter, isCurrentVersionFilter};
        Object[] dynObjArr = helper.query(fieldNames, qFilterArr);
        if (ObjectUtils.isEmpty((Object[])dynObjArr)) {
            return Maps.newHashMap();
        }
        return Arrays.stream(dynObjArr).collect(Collectors.toMap(dynObj -> dynObj.getLong(ADMIN_ORG_ID), dynObj -> dynObj));
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        this.packageData(event, this.orgGroupDataMap, this.orgCompanyDataMap, this.departmentDataMap, this.structDataMap);
    }

    private void packageData(PackageDataEvent event, Map<Long, DynamicObject> orgGroupDataMap, Map<Long, DynamicObject> orgCompanyDataMap, Map<Long, DynamicObject> departmentDataMap, Map<Long, DynamicObject> structDataMap) {
        DynamicObject structData;
        DynamicObject departmentData;
        DynamicObject orgCompanyData;
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        DynamicObject rowData = event.getRowData();
        Long rowId = (Long)rowData.get("id");
        Long boId = this.orgBoIdMap.get(rowId);
        DynamicObject orgGroupData = orgGroupDataMap.get(boId);
        if (null != orgGroupData) {
            String groupVision = orgGroupData.getString("groupvision");
            String groupLeader = orgGroupData.getString("groupleader");
            String groupmission = orgGroupData.getString("groupmission");
            if ("groupvision".equals(columnDesc.getFieldKey()) && !StringUtils.isEmpty((CharSequence)groupVision)) {
                event.setFormatValue((Object)groupVision);
            }
            if ("groupleader".equals(columnDesc.getFieldKey()) && !StringUtils.isEmpty((CharSequence)groupLeader)) {
                event.setFormatValue((Object)groupLeader);
            }
            if ("groupmission".equals(columnDesc.getFieldKey()) && !StringUtils.isEmpty((CharSequence)groupmission)) {
                event.setFormatValue((Object)groupmission);
            }
        }
        if (null != (orgCompanyData = orgCompanyDataMap.get(boId))) {
            String companyType = orgCompanyData.getString("companytype.name");
            String industryType = orgCompanyData.getString("industrytype.name");
            if ("companytype.name".equals(columnDesc.getFieldKey()) && companyType != null) {
                event.setFormatValue((Object)companyType);
            }
            if ("industrytype.name".equals(columnDesc.getFieldKey()) && industryType != null) {
                event.setFormatValue((Object)industryType);
            }
        }
        if (null != (departmentData = departmentDataMap.get(boId))) {
            String departmentType = departmentData.getString("departmenttype.name");
            if ("departmenttype.name".equals(columnDesc.getFieldKey()) && departmentType != null) {
                event.setFormatValue((Object)departmentType);
            }
        }
        if (null != (structData = structDataMap.get(boId))) {
            int level = structData.getInt("level");
            if ("level".equals(columnDesc.getFieldKey())) {
                event.setFormatValue((Object)level);
            }
        }
    }
}

