/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg.template;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.filter.SortType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.org.OrgTreeDynEnum;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRExactMatchBasedataListDataProvider;

public class AdminOrgExactMatchBasedataListDataProvider
extends HRExactMatchBasedataListDataProvider {
    private static final Log LOGGER = LogFactory.getLog(AdminOrgExactMatchBasedataListDataProvider.class);
    private static final String ADMIN_ORG_ID = "adminorg.id";
    private Map<Long, DynamicObject> orgGroupDataMap;
    private boolean queryGroup = true;
    private Map<Long, DynamicObject> orgCompanyDataMap;
    private boolean queryCompany = true;
    private Map<Long, DynamicObject> departmentDataMap;
    private boolean queryDepartment = true;
    private Map<Long, DynamicObject> structDataMap;
    private boolean queryStruct = true;
    private Map<Long, DynamicObject> belongCompanyMap;
    private Map<String, Object> listInfoMap;
    private boolean queryBelongCompany = true;
    private Map<Long, DynamicObject> parentOrgMap;
    private boolean queryParent = true;
    private boolean isHisTree = false;
    private Date searchDate;
    private Long structProject;
    private boolean deleteParentQf = false;
    private QFilter structParentQf;
    private boolean isHisCurDate;
    private String isvirtualorg;

    public void setHisTree(boolean hisTree) {
        this.isHisTree = hisTree;
    }

    public void setHisCurDate(boolean hisCurDate) {
        this.isHisCurDate = hisCurDate;
    }

    public String getIsvirtualorg() {
        return this.isvirtualorg;
    }

    public void setIsvirtualorg(String isvirtualorg) {
        this.isvirtualorg = isvirtualorg;
    }

    public void setSearchDate(Date searchDate) {
        this.searchDate = searchDate;
    }

    public AdminOrgExactMatchBasedataListDataProvider() {
    }

    public AdminOrgExactMatchBasedataListDataProvider(Map<Long, DynamicObject> orgGroupDataMap, Map<Long, DynamicObject> orgCompanyDataMap, Map<Long, DynamicObject> departmentDataMap, Map<Long, DynamicObject> structDataMap, Map<Long, DynamicObject> belongCompanyMap, Map<Long, DynamicObject> parentOrgMap, boolean mapFlag, Long structProject, Map<String, Object> listInfoMap) {
        this.orgGroupDataMap = orgGroupDataMap;
        this.orgCompanyDataMap = orgCompanyDataMap;
        this.departmentDataMap = departmentDataMap;
        this.structDataMap = structDataMap;
        this.belongCompanyMap = belongCompanyMap;
        this.parentOrgMap = parentOrgMap;
        this.structProject = structProject;
        this.listInfoMap = listInfoMap;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection sortedDynamicObjectColl;
        if (this.isHisTree && !this.isHisCurDate || !AdminOrgConstants.ADMINORG_STRUCT.equals(this.structProject)) {
            sortedDynamicObjectColl = this.getSortedDynObjColl(start, limit);
        } else {
            String orderBy = super.getOrderByExpr();
            String orderByExpr = HRStringUtils.isEmpty((String)orderBy) ? " sortcode asc" : orderBy + ", sortcode asc";
            super.setOrderByExpr(orderByExpr);
            sortedDynamicObjectColl = super.getData(start, limit);
            this.setGroupCompanyDepartmentData(sortedDynamicObjectColl);
        }
        this.getQueryResult().setCollection(sortedDynamicObjectColl);
        return sortedDynamicObjectColl;
    }

    public int getBillDataCount() {
        if (!AdminOrgConstants.ADMINORG_STRUCT.equals(this.structProject)) {
            List listDataFilterList = super.getQFilters();
            if (this.structParentQf != null) {
                listDataFilterList.add(this.structParentQf);
            }
            List<QFilter> listDataFilterListCopy = this.getStructFilterList(listDataFilterList);
            if ("0".equals(this.isvirtualorg)) {
                listDataFilterListCopy.add(new QFilter("haos_adminorghr.isvirtualorg", "=", (Object)this.isvirtualorg));
            }
            QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"haos_adminsortcodequery");
            List objects = HRQueryEntityHelper.getInstance().queryAllPkByKSql(queryEntityType, listDataFilterListCopy.toArray(new QFilter[0]), "");
            return objects != null ? objects.size() : 0;
        }
        return super.getBillDataCount();
    }

    public List<QFilter> getQFilters() {
        List qFilters = super.getQFilters();
        if (this.deleteParentQf) {
            for (int i = 0; i < qFilters.size(); ++i) {
                QFilter qFilter = (QFilter)qFilters.get(i);
                if (qFilter == null || !qFilter.getProperty().startsWith("struct_parent_org")) continue;
                qFilters.remove(i);
                this.structParentQf = qFilter;
                return qFilters;
            }
        }
        return qFilters;
    }

    private DynamicObjectCollection getSortedDynObjColl(int start, int limit) {
        DynamicObjectCollection resultColl;
        List<QFilter> listDataFilterListCopy;
        List listDataFilterList = super.getQFilters();
        if (this.structParentQf != null) {
            listDataFilterList.add(this.structParentQf);
        }
        if (AdminOrgConstants.ADMINORG_STRUCT.equals(this.structProject)) {
            listDataFilterListCopy = this.getSortCodeFilterList(listDataFilterList);
            List<QFilter> structFilter = this.getStructFilterList(listDataFilterList);
            listDataFilterListCopy.addAll(structFilter);
        } else {
            listDataFilterListCopy = this.getStructFilterList(listDataFilterList);
        }
        if ("0".equals(this.isvirtualorg)) {
            listDataFilterListCopy.add(new QFilter("haos_adminorghr.isvirtualorg", "=", (Object)this.isvirtualorg));
        }
        List<Object> orgObjIdList = this.getQueryMainEntityObjId(start, limit, listDataFilterListCopy);
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"haos_adminsortcodequery");
        List objects = HRQueryEntityHelper.getInstance().queryAllPkByKSql(queryEntityType, listDataFilterListCopy.toArray(new QFilter[0]), "");
        this.listInfoMap.put("list_count", objects != null ? objects.size() : 0);
        this.deleteParentQf = true;
        if (orgObjIdList == null) {
            super.setQFilters(listDataFilterList);
            super.setOrderByExpr("number asc");
            resultColl = super.getData(start, limit);
        } else {
            List<Long> orgIdList = orgObjIdList.stream().filter(Objects::nonNull).map(orgObjId -> Long.parseLong(orgObjId.toString())).collect(Collectors.toList());
            resultColl = this.sortDynObjColl(limit, orgIdList);
        }
        if (this.isHisTree) {
            this.setHisGroupCompanyDepartmentData(resultColl);
        } else {
            this.setGroupCompanyDepartmentData(resultColl);
        }
        return resultColl;
    }

    private List<Object> getQueryMainEntityObjId(int start, int limit, List<QFilter> listDataFilterListCopy) {
        String orderByExpr = this.getSortCodeOrderByExpr();
        Map<String, List<QFilter>> relationMap = this.getSortCodeRelationMap();
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"haos_adminsortcodequery");
        return HRQueryEntityHelper.getInstance().queryAllPkByKSql(queryEntityType, listDataFilterListCopy.toArray(new QFilter[0]), orderByExpr, start, limit, relationMap);
    }

    private Map<String, List<QFilter>> getSortCodeRelationMap() {
        HashMap<String, List<QFilter>> relationMap = new HashMap<String, List<QFilter>>();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if (this.isHisTree) {
            QFilter currentVersionFilter = new QFilter("haos_orgsortcode.iscurrentversion", "=", (Object)Character.valueOf('0'));
            QFilter dataStatusFilter = new QFilter("haos_orgsortcode.datastatus", "in", (Object)new String[]{EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()});
            QFilter bsedFilter = new QFilter("haos_orgsortcode.bsed", "<=", (Object)this.searchDate);
            QFilter bsledFilter = new QFilter("haos_orgsortcode.bsled", ">=", (Object)this.searchDate);
            qFilterList.add(currentVersionFilter);
            qFilterList.add(dataStatusFilter);
            qFilterList.add(bsedFilter);
            qFilterList.add(bsledFilter);
        } else {
            QFilter currentVersionFilter = new QFilter("haos_orgsortcode.iscurrentversion", "=", (Object)Character.valueOf('1'));
            qFilterList.add(currentVersionFilter);
        }
        relationMap.put("haos_orgsortcode", qFilterList);
        return relationMap;
    }

    private DynamicObjectCollection sortDynObjColl(int limit, List<Long> orgIdList) {
        if (orgIdList == null || orgIdList.isEmpty()) {
            return super.getData(0, 0);
        }
        QFilter idFilter = new QFilter("id", "in", orgIdList);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(idFilter);
        super.setQFilters(filterList);
        DynamicObjectCollection queryDynColl = super.getData(0, limit);
        DynamicObjectCollection resultColl = new DynamicObjectCollection(queryDynColl.getDynamicObjectType(), queryDynColl.getParent());
        Map<Long, DynamicObject> idDynMap = queryDynColl.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        for (Long sortedId : orgIdList) {
            DynamicObject sortedDynObj = idDynMap.get(sortedId);
            if (sortedDynObj == null) {
                LOGGER.info("AdminOrgExactMatchBasedataListDataProvider.sortDynObjColl,sortedId={}", (Object)sortedId);
                continue;
            }
            resultColl.add((Object)sortedDynObj);
        }
        return resultColl;
    }

    private List<QFilter> getSortCodeFilterList(List<QFilter> listDataFilterList) {
        ArrayList<QFilter> listDataFilterListCopy = new ArrayList<QFilter>(listDataFilterList.size());
        for (QFilter listDataFilter : listDataFilterList) {
            listDataFilterListCopy.add(listDataFilter.copy());
        }
        this.mapFilterListProperty(listDataFilterListCopy);
        if (this.isHisTree) {
            QFilter filterBSED = new QFilter("haos_orgsortcode.bsed", "<=", (Object)this.searchDate);
            QFilter filterBSLED = new QFilter("haos_orgsortcode.bsled", ">=", (Object)this.searchDate);
            QFilter dataStatusFilter = new QFilter("haos_orgsortcode.datastatus", "in", Arrays.asList("1", "2"));
            QFilter sortCodeCurrentVersionFilter = new QFilter("haos_orgsortcode.iscurrentversion", "=", (Object)Character.valueOf('0'));
            QFilter initStatusFilter = new QFilter("haos_orgsortcode.initstatus", "=", (Object)"2");
            listDataFilterListCopy.add(filterBSED);
            listDataFilterListCopy.add(filterBSLED);
            listDataFilterListCopy.add(dataStatusFilter);
            listDataFilterListCopy.add(initStatusFilter);
            listDataFilterListCopy.add(sortCodeCurrentVersionFilter);
        }
        return listDataFilterListCopy;
    }

    private List<QFilter> getStructFilterList(List<QFilter> listDataFilterList) {
        QFilter structCurrentVersionFilter;
        QFilter structFilter = new QFilter("haos_adminorgstruct.structproject", "=", (Object)this.structProject);
        ArrayList<QFilter> listDataFilterListCopy = new ArrayList<QFilter>(listDataFilterList.size());
        for (QFilter listDataFilter : listDataFilterList) {
            listDataFilterListCopy.add(listDataFilter.copy());
        }
        this.mapFilterListProperty(listDataFilterListCopy);
        if (this.isHisTree) {
            QFilter filterBSED = new QFilter("haos_adminorgstruct.bsed", "<=", (Object)this.searchDate);
            QFilter filterBSLED = new QFilter("haos_adminorgstruct.bsled", ">=", (Object)this.searchDate);
            QFilter dataStatusFilter = new QFilter("haos_adminorgstruct.datastatus", "in", Arrays.asList("1", "2"));
            structCurrentVersionFilter = new QFilter("haos_adminorgstruct.iscurrentversion", "=", (Object)Character.valueOf('0'));
            QFilter initStatusFilter = new QFilter("haos_adminorgstruct.initstatus", "=", (Object)"2");
            QFilter enableFilter = new QFilter("haos_adminorgstruct.enable", "in", (Object)new String[]{"1", "10"});
            listDataFilterListCopy.add(filterBSED);
            listDataFilterListCopy.add(filterBSLED);
            listDataFilterListCopy.add(dataStatusFilter);
            listDataFilterListCopy.add(initStatusFilter);
            listDataFilterListCopy.add(enableFilter);
        } else {
            structCurrentVersionFilter = new QFilter("haos_adminorgstruct.iscurrentversion", "=", (Object)Character.valueOf('1'));
            structCurrentVersionFilter.and(new QFilter("haos_adminorgstruct.enable", "in", (Object)new String[]{"1", "10"}));
        }
        listDataFilterListCopy.add(structCurrentVersionFilter);
        listDataFilterListCopy.add(structFilter);
        return listDataFilterListCopy;
    }

    private String getSortCodeOrderByExpr() {
        String orderBy = super.getOrderByExpr();
        String orderByExpr = HRStringUtils.isEmpty((String)orderBy) ? (AdminOrgConstants.ADMINORG_STRUCT.equals(this.structProject) ? "haos_orgsortcode.sortcode asc" : "haos_adminorgstruct.structlongnumber asc,number asc") : (AdminOrgConstants.ADMINORG_STRUCT.equals(this.structProject) ? orderBy + ",haos_orgsortcode.sortcode asc" : orderBy + ",haos_adminorgstruct.structlongnumber asc,number asc");
        return orderByExpr;
    }

    public List<ListField> getListFields() {
        List listFields = super.getListFields();
        ListField listField = new ListField();
        listField.setSortType(SortType.NotOrder);
        listField.setKey("boid");
        listField.setListFieldKey("boid");
        listField.setFieldName("boid");
        listField.setEntityName(OrgTreeDynEnum.ADMIN_MAIN_ENTITY.getDynEntity());
        IDataEntityProperty boIdPro = (IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)OrgTreeDynEnum.ADMIN_MAIN_ENTITY.getDynEntity()).getProperties().get((Object)"boid");
        listField.setSrcFieldProp(boIdPro);
        listFields.add(listField);
        return listFields;
    }

    private void mapFilterListProperty(List<QFilter> listDataFilterList) {
        if (listDataFilterList == null || listDataFilterList.isEmpty()) {
            return;
        }
        for (QFilter qFilter : listDataFilterList) {
            String mapField;
            Object[] propertyArr = qFilter.getProperty().split("\\.");
            if (HRArrayUtils.isEmpty((Object[])propertyArr)) {
                String property = qFilter.getProperty();
                mapField = this.getMapField(property);
                if (mapField != null) {
                    qFilter.__setProperty(mapField);
                }
            } else {
                Object propertyName = propertyArr[0];
                mapField = this.getMapField((String)propertyName);
                if (mapField != null) {
                    propertyArr[0] = mapField;
                    qFilter.__setProperty(String.join((CharSequence)".", (CharSequence[])propertyArr));
                }
            }
            List nests = qFilter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                String nestPropertyName = nest.getFilter().getProperty();
                Object[] nestPropertyArr = nestPropertyName.split("\\.");
                if (HRArrayUtils.isEmpty((Object[])nestPropertyArr)) {
                    String mapField2 = this.getMapField(nestPropertyName);
                    if (mapField2 == null) continue;
                    nest.getFilter().__setProperty(mapField2);
                    continue;
                }
                Object propertyName = nestPropertyArr[0];
                String mapField3 = this.getMapField((String)propertyName);
                if (mapField3 == null) continue;
                nestPropertyArr[0] = mapField3;
                nest.getFilter().__setProperty(String.join((CharSequence)".", (CharSequence[])nestPropertyArr));
            }
        }
    }

    private String getMapField(String propertyName) {
        HashMap<String, String> fieldMap = new HashMap<String, String>(8);
        fieldMap.put("adminorgtype", "orgtype");
        fieldMap.put("parentorg", "parent");
        fieldMap.put("belongcompany", "company");
        fieldMap.put("detailaddress", "businessaddress");
        fieldMap.put("struct_parent_org", "haos_adminorgstruct.parentorg");
        return (String)fieldMap.get(propertyName);
    }

    private void setGroupCompanyDepartmentData(DynamicObjectCollection adminOrgDynObjColl) {
        if (adminOrgDynObjColl.isEmpty()) {
            return;
        }
        List<Long> adminOrgIdList = adminOrgDynObjColl.stream().map(dynObj -> dynObj.getLong("id")).collect(Collectors.toList());
        this.orgGroupDataMap.putAll(this.getOrgVsGroupMap(adminOrgIdList));
        this.orgCompanyDataMap.putAll(this.getOrgVsCompanyMap(adminOrgIdList));
        this.departmentDataMap.putAll(this.getOrgVsDepartmentMap(adminOrgIdList));
        this.structDataMap.putAll(this.getOrgVsStructMap(adminOrgIdList));
    }

    private Map<Long, DynamicObject> getOrgDataInfoMap(List<Long> rowIds, String formId, String fieldNames, QFilter infoQf) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(formId);
        QFilter qFilter = new QFilter(ADMIN_ORG_ID, "in", rowIds);
        if (HRStringUtils.equals((String)AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), (String)formId)) {
            qFilter = new QFilter("boid", "in", rowIds);
        }
        if (!this.isHisTree) {
            QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            Object[] dynObjArr = helper.queryOriginalArray(fieldNames, new QFilter[]{qFilter, currentVersionFilter, infoQf});
            if (HRArrayUtils.isEmpty((Object[])dynObjArr)) {
                return Maps.newHashMap();
            }
            if (formId.equals("haos_adminorgdetail")) {
                return Arrays.stream(dynObjArr).collect(Collectors.toMap(dynObj -> dynObj.getLong("id"), dynObj -> dynObj));
            }
            return Arrays.stream(dynObjArr).collect(Collectors.toMap(dynObj -> dynObj.getLong(ADMIN_ORG_ID), dynObj -> dynObj));
        }
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)this.searchDate);
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)this.searchDate);
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        Object[] dynObjArr = helper.queryOriginalArray(fieldNames, new QFilter[]{qFilter, dataStatusFilter, bsedFilter, bsledFilter, isCurrentVersionFilter, initStatusFilter, infoQf});
        if (HRArrayUtils.isEmpty((Object[])dynObjArr)) {
            return Maps.newHashMap();
        }
        if (HRStringUtils.equals((String)AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), (String)formId)) {
            return Arrays.stream(dynObjArr).collect(Collectors.toMap(dynObj -> dynObj.getLong("boid"), dynObj -> dynObj, (k1, k2) -> k1));
        }
        return Arrays.stream(dynObjArr).collect(Collectors.toMap(dynObj -> dynObj.getLong(ADMIN_ORG_ID), dynObj -> dynObj, (k1, k2) -> k1));
    }

    public void setHisGroupCompanyDepartmentData(DynamicObjectCollection coll) {
        if (coll.isEmpty()) {
            return;
        }
        List<Long> adminOrgBoIdList = coll.stream().map(dynObj -> dynObj.getLong("boid")).collect(Collectors.toList());
        List<Long> parentOrgBoIdList = coll.stream().map(dynObj -> dynObj.containsProperty("parentorg") ? dynObj.getLong("parentorg.id") : dynObj.getLong("parent.id")).collect(Collectors.toList());
        this.orgGroupDataMap.putAll(this.getOrgVsGroupMap(adminOrgBoIdList));
        this.orgCompanyDataMap.putAll(this.getOrgVsCompanyMap(adminOrgBoIdList));
        this.departmentDataMap.putAll(this.getOrgVsDepartmentMap(adminOrgBoIdList));
        this.structDataMap.putAll(this.getOrgVsStructMap(adminOrgBoIdList));
        this.belongCompanyMap.putAll(this.getOrgVsBelongComapnyMap(adminOrgBoIdList));
        this.parentOrgMap.putAll(this.getOrgVsParentMap(parentOrgBoIdList));
    }

    private Map<Long, DynamicObject> getOrgVsGroupMap(List<Long> adminOrgBoIdList) {
        return this.query(() -> this.getOrgDataInfoMap(adminOrgBoIdList, AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), "adminorg.id,groupvision,groupleader,groupmission", new QFilter("1", "=", (Object)1)), this.isQueryGroup());
    }

    private Map<Long, DynamicObject> getOrgVsCompanyMap(List<Long> adminOrgBoIdList) {
        return this.query(() -> this.getOrgDataInfoMap(adminOrgBoIdList, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), "adminorg.id,companytype.name,industrytype.name", new QFilter("1", "=", (Object)1)), this.isQueryCompany());
    }

    private Map<Long, DynamicObject> getOrgVsDepartmentMap(List<Long> adminOrgBoIdList) {
        return this.query(() -> this.getOrgDataInfoMap(adminOrgBoIdList, AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), "adminorg.id,departmenttype.name", new QFilter("1", "=", (Object)1)), this.isQueryDepartment());
    }

    private Map<Long, DynamicObject> getOrgVsStructMap(List<Long> adminOrgBoIdList) {
        Map<Long, DynamicObject> structMap = this.query(() -> this.getOrgDataInfoMap(adminOrgBoIdList, AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), "adminorg.id,level,parentorg.id,parentorg.name", new QFilter("structproject", "=", (Object)this.structProject)), this.isQueryStruct());
        Set<Map.Entry<Long, DynamicObject>> entrySet = structMap.entrySet();
        Iterator<Map.Entry<Long, DynamicObject>> iterator = entrySet.iterator();
        ArrayList<Long> parentOrgIds = new ArrayList<Long>(structMap.size());
        while (iterator.hasNext()) {
            Map.Entry<Long, DynamicObject> next = iterator.next();
            DynamicObject structDy = next.getValue();
            if (structDy == null || structDy.getLong("parentorg.id") == 0L) continue;
            parentOrgIds.add(structDy.getLong("parentorg.id"));
        }
        if (parentOrgIds.size() > 0) {
            Map<Long, DynamicObject> orgVsParentMap = this.getOrgVsParentMap(parentOrgIds);
            for (Map.Entry<Long, DynamicObject> next : entrySet) {
                long parentOrgId;
                DynamicObject parentDy;
                DynamicObject structDy = next.getValue();
                if (structDy == null || structDy.getLong("parentorg.id") == 0L || (parentDy = orgVsParentMap.get(parentOrgId = structDy.getLong("parentorg.id"))) == null) continue;
                structDy.set("parentorg.name", (Object)parentDy.getString("name"));
            }
        }
        return structMap;
    }

    private Map<Long, DynamicObject> getOrgVsBelongComapnyMap(List<Long> adminOrgBoIdList) {
        return this.query(() -> this.getbelongcompanyDataInfoMap(adminOrgBoIdList, AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), "id,name,boid"), this.isQueryBelongCompany());
    }

    private Map<Long, DynamicObject> getOrgVsParentMap(List<Long> adminOrgBoIdList) {
        return this.query(() -> this.getOrgDataInfoMap(adminOrgBoIdList, AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), "id,boid,name", new QFilter("1", "=", (Object)1)), this.isQueryParent());
    }

    private Map<Long, DynamicObject> query(Supplier<Map<Long, DynamicObject>> querySupplier, boolean isQuery) {
        return isQuery ? querySupplier.get() : new HashMap();
    }

    private Map<Long, DynamicObject> getbelongcompanyDataInfoMap(List<Long> rowIds, String formId, String fieldNames) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(formId);
        QFilter qFilter = new QFilter("boid", "in", rowIds);
        HRBaseServiceHelper orghelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)this.searchDate);
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)this.searchDate);
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        DynamicObject[] belongcompanies = orghelper.query("belongcompany,boid", new QFilter[]{qFilter, dataStatusFilter, bsedFilter, bsledFilter, isCurrentVersionFilter, initStatusFilter});
        if (belongcompanies.length == 0) {
            return Maps.newHashMap();
        }
        if (!this.isHisTree) {
            return Maps.newHashMap();
        }
        ArrayList belongcompanyIds = new ArrayList(belongcompanies.length);
        Arrays.stream(belongcompanies).forEach(dynamicObject -> belongcompanyIds.add(dynamicObject.getLong("belongcompany.id")));
        QFilter belongcompanyQf = new QFilter("boid", "in", belongcompanyIds);
        Object[] dynObjArr = helper.queryOriginalArray(fieldNames, new QFilter[]{belongcompanyQf, dataStatusFilter, bsedFilter, bsledFilter, isCurrentVersionFilter, initStatusFilter});
        if (HRArrayUtils.isEmpty((Object[])dynObjArr)) {
            return Maps.newHashMap();
        }
        Map<Long, DynamicObject> belongcompanyMap = Arrays.stream(dynObjArr).collect(Collectors.toMap(dynObj -> dynObj.getLong("boid"), dynObj -> dynObj));
        HashMap<Long, DynamicObject> orgBelongcompanyMap = new HashMap<Long, DynamicObject>(belongcompanies.length);
        for (DynamicObject org : belongcompanies) {
            long belongcompanyId = org.getLong("belongcompany.id");
            if (!belongcompanyMap.containsKey(belongcompanyId)) continue;
            orgBelongcompanyMap.put(org.getLong("boid"), belongcompanyMap.get(belongcompanyId));
        }
        return orgBelongcompanyMap;
    }

    public Map<Long, DynamicObject> getOrgGroupDataMap() {
        return this.orgGroupDataMap;
    }

    public void setOrgGroupDataMap(Map<Long, DynamicObject> orgGroupDataMap) {
        this.orgGroupDataMap = orgGroupDataMap;
    }

    public Map<Long, DynamicObject> getOrgCompanyDataMap() {
        return this.orgCompanyDataMap;
    }

    public void setOrgCompanyDataMap(Map<Long, DynamicObject> orgCompanyDataMap) {
        this.orgCompanyDataMap = orgCompanyDataMap;
    }

    public Map<Long, DynamicObject> getDepartmentDataMap() {
        return this.departmentDataMap;
    }

    public void setDepartmentDataMap(Map<Long, DynamicObject> departmentDataMap) {
        this.departmentDataMap = departmentDataMap;
    }

    public Map<Long, DynamicObject> getStructDataMap() {
        return this.structDataMap;
    }

    public void setStructDataMap(Map<Long, DynamicObject> structDataMap) {
        this.structDataMap = structDataMap;
    }

    public Map<Long, DynamicObject> getBelongCompanyMap() {
        return this.belongCompanyMap;
    }

    public void setBelongCompanyMap(Map<Long, DynamicObject> belongCompanyMap) {
        this.belongCompanyMap = belongCompanyMap;
    }

    public Map<Long, DynamicObject> getParentOrgMap() {
        return this.parentOrgMap;
    }

    public void setParentOrgMap(Map<Long, DynamicObject> parentOrgMap) {
        this.parentOrgMap = parentOrgMap;
    }

    public boolean isQueryGroup() {
        return this.queryGroup;
    }

    public void setQueryGroup(boolean queryGroup) {
        this.queryGroup = queryGroup;
    }

    public boolean isQueryCompany() {
        return this.queryCompany;
    }

    public void setQueryCompany(boolean queryCompany) {
        this.queryCompany = queryCompany;
    }

    public boolean isQueryDepartment() {
        return this.queryDepartment;
    }

    public void setQueryDepartment(boolean queryDepartment) {
        this.queryDepartment = queryDepartment;
    }

    public boolean isQueryStruct() {
        return this.queryStruct;
    }

    public void setQueryStruct(boolean queryStruct) {
        this.queryStruct = queryStruct;
    }

    public boolean isQueryBelongCompany() {
        return this.queryBelongCompany;
    }

    public void setQueryBelongCompany(boolean queryBelongCompany) {
        this.queryBelongCompany = queryBelongCompany;
    }

    public boolean isQueryParent() {
        return this.queryParent;
    }

    public void setQueryParent(boolean queryParent) {
        this.queryParent = queryParent;
    }

    public void setListInfoMap(Map<String, Object> listInfoMap) {
        this.listInfoMap = listInfoMap;
    }

    public void setStructProject(Long structProject) {
        this.structProject = structProject;
    }
}

