/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg.template;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.filter.SortType;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.org.OrgTreeDynEnum;
import kd.hr.hbp.formplugin.web.HRExactMatchBasedataListDataProvider;

public class AdminOrgInitDataListDataProvider
extends HRExactMatchBasedataListDataProvider {
    private static final String ADMIN_ORG_ID = "adminorg.id";
    private Map<Long, DynamicObject> orgGroupDataMap;
    private Map<Long, DynamicObject> orgCompanyDataMap;
    private Map<Long, DynamicObject> departmentDataMap;

    public AdminOrgInitDataListDataProvider(Map<Long, DynamicObject> orgGroupDataMap, Map<Long, DynamicObject> orgCompanyDataMap, Map<Long, DynamicObject> departmentDataMap) {
        this.orgGroupDataMap = orgGroupDataMap;
        this.orgCompanyDataMap = orgCompanyDataMap;
        this.departmentDataMap = departmentDataMap;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        super.setQFilters(super.getQFilters());
        super.setOrderByExpr("number asc");
        DynamicObjectCollection resultColl = super.getData(start, limit);
        this.setData(resultColl);
        return resultColl;
    }

    public List<ListField> getListFields() {
        List listFields = super.getListFields();
        ListField listField = new ListField();
        listField.setSortType(SortType.NotOrder);
        listField.setKey("boid");
        listField.setListFieldKey("boid");
        listField.setFieldName("boid");
        listField.setEntityName(OrgTreeDynEnum.ADMIN_MAIN_ENTITY.getDynEntity());
        IDataEntityProperty boIdPro = (IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)OrgTreeDynEnum.ADMIN_MAIN_ENTITY.getDynEntity()).getProperties().get((Object)"boid");
        listField.setSrcFieldProp(boIdPro);
        listFields.add(listField);
        return listFields;
    }

    public void setData(DynamicObjectCollection dynamicObjectCollection) {
        if (!dynamicObjectCollection.isEmpty()) {
            ArrayList<Long> rowIds = new ArrayList<Long>();
            for (DynamicObject row : dynamicObjectCollection) {
                rowIds.add(row.getLong("id"));
            }
            if (!rowIds.isEmpty()) {
                this.orgGroupDataMap.putAll(this.getOrgDataInfoMap(rowIds, AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), "adminorg,groupvision,groupleader,groupmission"));
                this.orgCompanyDataMap.putAll(this.getOrgDataInfoMap(rowIds, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), "adminorg,companytype,industrytype"));
                this.departmentDataMap.putAll(this.getOrgDataInfoMap(rowIds, AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), "adminorg,departmenttype"));
            }
        }
    }

    public Map<Long, DynamicObject> getOrgDataInfoMap(List<Long> rowIds, String formId, String fieldNames) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(formId);
        QFilter qFilter = new QFilter(ADMIN_ORG_ID, "in", rowIds);
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        Object[] dynObjArr = helper.query(fieldNames, new QFilter[]{qFilter, isCurrentVersionFilter});
        if (ObjectUtils.isEmpty((Object[])dynObjArr)) {
            return Maps.newHashMap();
        }
        return Arrays.stream(dynObjArr).collect(Collectors.toMap(dynObj -> dynObj.getLong(ADMIN_ORG_ID), dynObj -> dynObj));
    }
}

