/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorghr;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.org.util.OrgTreeUtils;
import kd.hr.hbp.common.constants.org.OrgTreeDynEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.org.model.OrgTreeModel;
import kd.hr.hbp.formplugin.web.org.template.AdminOrgTreeListTemplate;

public class AdminOrgCreateTreeListF7Plugin
extends AdminOrgTreeListTemplate {
    private static final long NOT_EXIST_ORG_ID = -1L;
    private static final String TREE_ORG_FILTER_CACHE_KEY = "TREE_ORG_ID_FILTER";
    private static final String CUSTOMER_PARAM_ORG_KEY = "OrgIdSet";

    public AdminOrgCreateTreeListF7Plugin() {
        super(new OrgTreeModel(OrgTreeDynEnum.ADMIN_STRUCT.getDynEntity(), OrgTreeDynEnum.ADMIN_MAIN_ENTITY.getDynEntity(), Boolean.TRUE, Boolean.FALSE, Boolean.FALSE.booleanValue()));
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        Set<Long> passedOrgIds = this.getPassedOrgIds();
        if (CollectionUtils.isEmpty(passedOrgIds)) {
            passedOrgIds.add(-1L);
        }
        setFilterEvent.setCustomQFilters(Collections.singletonList(this.getCustomerFilter("id", null)));
        super.setFilter(setFilterEvent);
    }

    protected QFilter getCurTreeBizQFilter() {
        Set<Long> orgIdSet = this.getTreeFilterOrgIds();
        return this.getCustomerFilter("adminorg", orgIdSet);
    }

    private Set<Long> getTreeFilterOrgIds() {
        Set orgIdSet;
        String serializedOrgIds = this.getPageCache().get(TREE_ORG_FILTER_CACHE_KEY);
        if (HRStringUtils.isEmpty((String)serializedOrgIds)) {
            orgIdSet = this.getPassedOrgIds();
            if (CollectionUtils.isEmpty(orgIdSet)) {
                return null;
            }
            List<String> orgStructLongNumberList = this.batchQueryCurOrgStructLongNumbers(orgIdSet);
            String commonPrefixStructLongNumber = OrgTreeUtils.getCommonPrefixStructLongNumber(orgStructLongNumberList);
            if (HRStringUtils.isEmpty((String)commonPrefixStructLongNumber)) {
                return null;
            }
            Set<String> structNumberSet = orgStructLongNumberList.stream().map(structLongNumber -> {
                String[] structLongNumberSplit = structLongNumber.split("!");
                if (structLongNumberSplit.length > 1) {
                    structLongNumberSplit[structLongNumberSplit.length - 1] = "";
                }
                return Arrays.asList(structLongNumberSplit);
            }).flatMap(Collection::stream).filter(HRStringUtils::isNotEmpty).collect(Collectors.toSet());
            String[] split = commonPrefixStructLongNumber.split("!");
            if (split.length > 1) {
                for (int i = 0; i < split.length - 1; ++i) {
                    structNumberSet.remove(split[i]);
                }
            }
            List<Long> orgIdList = this.batchQueryOrgIdByStructNumber(structNumberSet);
            orgIdSet.addAll(orgIdList);
            this.getPageCache().put(TREE_ORG_FILTER_CACHE_KEY, SerializationUtils.toJsonString((Object)orgIdSet));
        } else {
            orgIdSet = (Set)SerializationUtils.fromJsonString((String)serializedOrgIds, Set.class);
        }
        return orgIdSet;
    }

    private QFilter getCustomerFilter(String filterField, Set<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            orgIds = this.getPassedOrgIds();
        }
        if (orgIds == null) {
            orgIds = new HashSet<Long>(16);
            orgIds.add(-1L);
        }
        return new QFilter(filterField, "in", orgIds);
    }

    private Set<Long> getPassedOrgIds() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String orgIdSet = (String)formShowParameter.getCustomParam(CUSTOMER_PARAM_ORG_KEY);
        if (StringUtils.isEmpty((Object)orgIdSet)) {
            return Sets.newHashSetWithExpectedSize((int)1);
        }
        return (Set)SerializationUtils.fromJsonString((String)orgIdSet, Set.class);
    }

    private List<Long> batchQueryOrgIdByStructNumber(Set<String> structNumberSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.orgTreeModel.getMainEntityName());
        QFilter structNumberFilter = new QFilter("structnumber", "in", structNumberSet);
        structNumberFilter.and("iscurrentversion", "=", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("id", new QFilter[]{structNumberFilter});
        return Stream.of(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    private List<String> batchQueryCurOrgStructLongNumbers(Set<Long> orgIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.getEntityName());
        QFilter orgIdFilter = new QFilter("adminorg", "in", orgIds);
        orgIdFilter.and("iscurrentversion", "=", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("structlongnumber", new QFilter[]{orgIdFilter});
        return Stream.of(dynamicObjects).map(dy -> dy.getString("structlongnumber")).collect(Collectors.toList());
    }

    public Long getCurNodeIdByRowClick(ListRowClickEvent evt) {
        return Long.valueOf(evt.getCurrentListSelectedRow().getPrimaryKeyValue().toString());
    }

    protected QFilter buildNodeClickFilter(BuildTreeListFilterEvent buildTreeListFilterEvent) {
        String nodeId = buildTreeListFilterEvent.getNodeId().toString();
        if (!StringUtils.isEmpty((Object)nodeId)) {
            TreeNode treeNode = OrgTreeUtils.getNode((TreeNode)this.getTreeModel().getRoot(), (Object)nodeId);
            if (null == treeNode) {
                return null;
            }
            String parentStructLongNumber = treeNode.getLongNumber();
            QFilter parentStructFilter = new QFilter("structlongnumber", "like", (Object)(parentStructLongNumber + "%"));
            DynamicObjectCollection dynamicObjects = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl("adminorg", new QFilter[]{parentStructFilter, this.getDataStatusAndBSedFilter()}, null);
            Set adminOrgIds = dynamicObjects.stream().map(adminOrg -> adminOrg.getLong("adminorg")).collect(Collectors.toSet());
            return new QFilter("boid", "in", adminOrgIds);
        }
        return null;
    }

    protected boolean isShowDisable() {
        return Boolean.TRUE;
    }
}

