/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorghr;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.list.BillList;
import kd.hr.haos.formplugin.web.adminorghr.AdminOrgSearchExactMatchDataProvider;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;

public class AdminOrgEmptyListF7Plugin
extends HRCoreBaseList {
    private static final String LIST_FLEX_PANEL = "flexpanelap1";
    private static final String EMPTY_FLEX_PANEL = "emptyflexpanel";
    private static final String PAGE_INITIALIZED_CACHE_KEY = "PAGE_INITIALIZED";
    private static final String SEARCH_FIELD_CACHE_KEY = "SEARCH_FIELD";
    private static final String SEARCH_VALUE_CACHE_KEY = "SEARCH_VALUE";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Date searchDate = Optional.ofNullable((Date)formShowParameter.getCustomParam("SearchDate")).orElseGet(Date::new);
        IPageCache pageCache = this.getView().getPageCache();
        String searchFieldStr = pageCache.get(SEARCH_FIELD_CACHE_KEY);
        Set searchFields = null;
        Set searchValues = null;
        if (StringUtils.isNotEmpty((CharSequence)searchFieldStr)) {
            searchFields = (Set)SerializationUtils.fromJsonString((String)searchFieldStr, Set.class);
            searchValues = (Set)SerializationUtils.fromJsonString((String)pageCache.get(SEARCH_VALUE_CACHE_KEY), Set.class);
        }
        args.setListDataProvider((IListDataProvider)new AdminOrgSearchExactMatchDataProvider(searchDate, searchFields, searchValues));
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        args.getListColumns().forEach(listColumn -> listColumn.setColumnOrderAndFilter(false));
    }

    public void afterBindData(EventObject e) {
        Object source = e.getSource();
        if (source instanceof BillList) {
            String pageInitialized = this.getView().getPageCache().get(PAGE_INITIALIZED_CACHE_KEY);
            if (Boolean.parseBoolean(pageInitialized)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{LIST_FLEX_PANEL});
                this.getView().setVisible(Boolean.FALSE, new String[]{EMPTY_FLEX_PANEL});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{LIST_FLEX_PANEL});
                this.getView().setVisible(Boolean.TRUE, new String[]{EMPTY_FLEX_PANEL});
            }
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        IPageCache pageCache = this.getView().getPageCache();
        if (!Boolean.parseBoolean(pageCache.get(PAGE_INITIALIZED_CACHE_KEY))) {
            pageCache.put(PAGE_INITIALIZED_CACHE_KEY, String.valueOf(Boolean.TRUE));
        }
        List fastFilterValues = args.getFastFilterValues();
        Set searchFields = fastFilterValues.stream().map(m -> (List)m.get("FieldName")).flatMap(Collection::stream).collect(Collectors.toSet());
        Set searchValues = fastFilterValues.stream().map(m -> (List)m.get("Value")).flatMap(Collection::stream).collect(Collectors.toSet());
        pageCache.put(SEARCH_FIELD_CACHE_KEY, SerializationUtils.toJsonString(searchFields));
        pageCache.put(SEARCH_VALUE_CACHE_KEY, SerializationUtils.toJsonString(searchValues));
    }
}

