/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.customrole;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.haos.business.domain.repository.CommonRepository;
import kd.hr.haos.business.util.CustomRoleEmpUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class AddHasRoleListPlugin
extends HRDataBaseList {
    private static Log LOGGER = LogFactory.getLog(AddHasRoleListPlugin.class);
    private static final HRBaseServiceHelper CUSTOMOROLE_HELPER = new HRBaseServiceHelper("haos_customorole");

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List listColumns = args.getListColumns();
        listColumns.removeIf(val -> {
            String key = val.getListFieldKey();
            return "index".equals(key);
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (rows == null || rows.size() == 0) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AddHasRoleListPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            CustomRoleEmpUtils.showMsg((String)msg, (IFormView)this.getView(), (boolean)false);
            args.setCancel(true);
            return;
        }
        args.setCancel(true);
        if (this.getView().getParentView() != null && this.getView().getParentView() instanceof ListView) {
            String pref = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("numberprefix");
            String meta = "haos_customorole_" + pref;
            if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"homs", (String)meta, (String)"47156aff000000ac")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8be5\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AddHasRoleListPlugin_2", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Object currentNodeId = ((ListView)this.getView().getParentView()).getTreeListView().getTreeModel().getCurrentNodeId();
            QFilter idsFilter = null;
            if (rows != null) {
                idsFilter = new QFilter("id", "in", (Object)rows.getPrimaryKeyValues());
            }
            DynamicObject[] sourceDys = CommonRepository.queryDynamicObjects((String)"haos_addhasrole", (String)"", (QFilter[])new QFilter[]{idsFilter});
            ArrayList<DynamicObject> hisDys = new ArrayList<DynamicObject>(sourceDys.length);
            for (DynamicObject dy : sourceDys) {
                DynamicObject newDy = CUSTOMOROLE_HELPER.generateEmptyDynamicObject();
                HashSet<String> ignoreKeys = new HashSet<String>();
                ignoreKeys.add("id");
                ignoreKeys.add("boid");
                ignoreKeys.add("iscurrentversion");
                HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)newDy, ignoreKeys);
                newDy.set("orgteam", currentNodeId);
                newDy.set("bsed", (Object)new Date());
                newDy.set("sourcetpl", dy.getPkValue());
                hisDys.add(newDy);
            }
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"tblsave", (String)"haos_customorole", (DynamicObject[])hisDys.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            LOGGER.info("call_tblsave_result:{}", (Object)operationResult);
            if (operationResult != null && operationResult.isSuccess()) {
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"AddHasRoleListPlugin_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
                this.getView().close();
                CustomRoleEmpUtils.showMsg((String)msg, (IFormView)this.getView(), (boolean)true);
            } else {
                this.getView().getParentView().showOperationResult(operationResult);
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().close();
                this.getView().sendFormAction(this.getView().getParentView());
            }
        }
    }
}

