/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.customstruct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.common.util.tree.TreeAssistUtils;
import kd.hr.haos.formplugin.web.structproject.OrgStructTreeView;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;

public class CustomOrgStructTreeView
extends OrgStructTreeView {
    private String permEntityNumber;

    public CustomOrgStructTreeView(TreeView treeView, boolean isInitTree, String permEntityNumber) {
        super(treeView, isInitTree);
        this.permEntityNumber = permEntityNumber;
    }

    @Override
    protected TreeNode initRootNode() {
        AuthorizedOrgTeamResult authorizedOrgResult = this.getPermOrgResult();
        if (authorizedOrgResult.isHasAllOrgPerm()) {
            DynamicObjectCollection col = this.queryValidColByStructProject(this.structSelectFields(), this.getStructProjectId(), null, this.getOtherQFilter(), this.getOrderBys());
            return this.buildTreeNode(col, null);
        }
        return this.buildPermTreeNode(authorizedOrgResult);
    }

    private AuthorizedOrgTeamResult getPermOrgResult() {
        Long userId = RequestContext.get().getCurrUserId();
        String appId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)this.treeView.getView().getFormShowParameter());
        String propKey = "adminorghr";
        return (AuthorizedOrgTeamResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedOrgTeamsF7", (Object[])new Object[]{userId, appId, this.permEntityNumber, "47150e89000000ac", propKey});
    }

    private TreeNode buildPermTreeNode(AuthorizedOrgTeamResult authorizedOrgResult) {
        Set<String> permStructSet = this.getPermStructSets(authorizedOrgResult);
        String minStructLongNumber = TreeAssistUtils.getCommonPrefixStructLongNumber(new ArrayList<String>(permStructSet));
        if (HRStringUtils.isEmpty((String)minStructLongNumber)) {
            return this.defaultRootNode();
        }
        HashSet<String> allStructSet = new HashSet<String>(permStructSet.size());
        int index = minStructLongNumber.lastIndexOf("!");
        allStructSet.add(index == -1 ? minStructLongNumber : minStructLongNumber.substring(index + 1));
        permStructSet.forEach(struct -> {
            if ((struct = struct.replace(minStructLongNumber, "")).contains("!")) {
                allStructSet.addAll(Arrays.asList(struct.split("!")));
            }
        });
        allStructSet.remove("");
        QFilter structLongNumberFilter = new QFilter("adminorg.structnumber", "in", allStructSet);
        DynamicObjectCollection col = this.queryValidColByStructProject(this.structSelectFields(), this.getStructProjectId(), structLongNumberFilter, this.getOtherQFilter(), this.getOrderBys());
        return this.buildTreeNode(col, permStructSet);
    }

    private Set<String> getPermStructSets(AuthorizedOrgTeamResult authorizedOrgResult) {
        Map hasPermOrgTeamMap = authorizedOrgResult.getHasPermOrgTeamMap();
        if (hasPermOrgTeamMap == null || hasPermOrgTeamMap.isEmpty()) {
            return Collections.emptySet();
        }
        List hasPermOrgIds = (List)hasPermOrgTeamMap.get(1010L);
        if (CollectionUtils.isEmpty((Collection)hasPermOrgIds)) {
            return Collections.emptySet();
        }
        QFilter permFilter = new QFilter("adminorg", "in", (Object)hasPermOrgIds);
        DynamicObjectCollection col = this.queryValidColByStructProject("structlongnumber", this.getStructProjectId(), permFilter, this.getOtherQFilter(), null);
        return col.stream().map(dy -> dy.getString("structlongnumber")).collect(Collectors.toSet());
    }
}

