/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.customstruct;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.tree.TreeNodeLabel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.customstruct.CustomStructHelper;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.org.TreeTemplateHelper;
import kd.hr.hbp.business.servicehelper.org.util.OrgTreeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.org.model.OrgTreeModel;
import kd.hr.hbp.formplugin.web.org.structproject.StructProjectCapable;
import kd.hr.hbp.formplugin.web.org.structproject.imp.DefaultStructProjectProcessor;
import kd.hr.hbp.formplugin.web.org.template.OrgTeamTreeListTemplate;

public class CustomOrgTeamTreeListTemplate
extends OrgTeamTreeListTemplate {
    private static final String CUR_SUB_TREE_STRUCT_FIELDS = "orgteam.id id, orgteam.boid boid, orgteam.name name, orgteam.number number,parentorgteam.id parentorgteam, structlongnumber, isleaf, orgteam.otclassify.id otclassify, orgteam.enable enable,orgteam.sortcode";
    private static final String SEARCH_CUR_SUB_TREE_STRUCT_FIELDS = "orgteam.id id,orgteam.id as boid, orgteam.name name, parentorgteam.id parentorgteam, structlongnumber, isleaf,orgteam.sortcode";
    private static final String CUR_TREE_ROOT_STRUCT_FIELDS = "orgteam.id id, orgteam.boid boid, orgteam.name name,structlongnumber, orgteam.otclassify.id otclassify, orgteam.enable enable";

    public CustomOrgTeamTreeListTemplate(OrgTreeModel orgTreeModel) {
        super(orgTreeModel);
        super.setStructProjectCapable((StructProjectCapable)new DefaultStructProjectProcessor(){

            public Set<Long> getStructProjectIdSet() {
                return Sets.newHashSet((Object[])new Long[]{this.getStructProjectId()});
            }

            public QFilter getOtClassifyStructProjectFilter() {
                return new QFilter("otclassify.id", "=", (Object)this.getOtClassify());
            }

            public long getDefaultFirstStructProjectId() {
                return this.getStructProjectId();
            }

            protected long getOtClassify() {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                return CustomStructHelper.getOtClassifyId((FormShowParameter)formShowParameter);
            }

            private Long getStructProjectId() {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                return CustomStructHelper.getStructProjectId((FormShowParameter)formShowParameter);
            }
        });
        orgTreeModel.setListOtClassify(null);
        orgTreeModel.setTreeOtClassify(null);
        super.setSubTreeOrderBys("orgteam.sortcode");
    }

    public List<Long> getOTTreeFocus() {
        return this.getOrgTreeListClassify();
    }

    protected List<Long> getOrgTreeListClassify() {
        Long classifyId = (Long)this.getView().getFormShowParameter().getCustomParam("struct_project_classify_id");
        return Lists.newArrayList((Object[])new Long[]{classifyId});
    }

    public Long getCurNodeIdByRowClick(ListRowClickEvent evt) {
        return Long.valueOf(evt.getCurrentListSelectedRow().getPrimaryKeyValue().toString());
    }

    public List<String> getAllPermissionStructLongNumbers() {
        DynamicObjectCollection collection = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl("structlongnumber", new QFilter[]{this.getOrgTreeFilter()}, null);
        return collection.stream().map(dynamicObject -> dynamicObject.getString("structlongnumber")).collect(Collectors.toList());
    }

    public boolean isInCludeChild() {
        return this.getModel().getDataEntity(true).getBoolean("chkincludechild");
    }

    public DynamicObjectCollection queryCurTreeViewDynamicCollection(QFilter[] qFilters) {
        logger.info("queryCurTreeViewDynamicCollection, qFilters={}", (Object)JSON.toJSONString((Object)qFilters));
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl(CUR_SUB_TREE_STRUCT_FIELDS, qFilters, null);
        if (dynCol == null) {
            return null;
        }
        OrgTreeUtils.sortDynColsOrderBys((DynamicObjectCollection)dynCol, (String)this.getSubTreeOrderBys());
        logger.info("queryCurTreeViewDynamicCollection, dynCol.size={}", (Object)dynCol.size());
        return dynCol;
    }

    public List<TreeNode> getSearchNodesBySearchId(Long searchIdVal) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
        if (null == searchIdVal) {
            return treeNodes;
        }
        DynamicObject orgMainDyn = TreeTemplateHelper.getMainDynByVidAndCommonFilter((String)this.orgTreeModel.getMainEntityName(), (QFilter)this.getOrgEnableFilter(), (QFilter)this.getDataStatusAndBSedFilter(), (Long)searchIdVal);
        if (orgMainDyn == null) {
            return treeNodes;
        }
        QFilter orgIdFilter = new QFilter("orgteam.id", "=", (Object)orgMainDyn.getLong("boid"));
        if (this.orgTreeModel.isHisTree()) {
            return this.getHisTreeSearchDynCol(searchIdVal, "parentorgteam", this.queryHisTreeDateCount, this.getSubTreeOrderBys());
        }
        QFilter[] filters = new QFilter[]{orgIdFilter, this.getDataStatusAndBSedFilter(), this.getOrgEnableFilter()};
        TreeTemplateHelper.assemblyCurTreeSearchNodes(treeNodes, (String)this.getEntityName(), (String)CUR_SUB_TREE_STRUCT_FIELDS, (String)"parentorgteam", (QFilter[])filters, null);
        return treeNodes;
    }

    public List<TreeNode> searchCurTreeNode(String searchText, QFilter structFilter) {
        ArrayList treeNodes = Lists.newArrayListWithCapacity((int)16);
        QFilter nameFilter = new QFilter("orgteam.name", "like", (Object)("%" + searchText + "%"));
        QFilter[] filters = new QFilter[]{nameFilter, structFilter, this.getOrgTreeFilter()};
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl(SEARCH_CUR_SUB_TREE_STRUCT_FIELDS, filters, null);
        if (dynCol == null) {
            return treeNodes;
        }
        this.setOrgLeaf(dynCol, "parentorgteam");
        OrgTreeUtils.sortDynColsOrderBys((DynamicObjectCollection)dynCol, (String)this.getSubTreeOrderBys());
        dynCol.forEach(dynamicObject -> {
            String orgId = dynamicObject.getString("id");
            TreeNode treeNode = new TreeNode(dynamicObject.getString("parentorgteam"), orgId, dynamicObject.getString("name"));
            treeNode.setLongNumber(dynamicObject.getString("structlongnumber"));
            treeNodes.add(treeNode);
        });
        return treeNodes;
    }

    protected void resetOrgNameByEnableInfo(TreeNode node, DynamicObject dyn) {
        if (node == null || dyn == null) {
            return;
        }
        String enable = dyn.getString("enable");
        node.setLabelShowType(1);
        this.addDisabledOrgTeamNameLabel(node, enable);
    }

    protected void resetOrgNameByEnableInfo(TreeNode node, Map<String, String> nodeMap) {
        if (node == null || nodeMap == null) {
            return;
        }
        String enable = nodeMap.get("enable");
        node.setLabelShowType(1);
        this.addDisabledOrgTeamNameLabel(node, enable);
    }

    public DynamicObject getCurTreeRootNodeDyn(String selectFields) {
        QFilter orgTreeFilter = this.getOrgRootTreeFilter();
        if (orgTreeFilter == null) {
            return this.getRootDynByRootId();
        }
        orgTreeFilter.and(new QFilter("parentorgteam", "=", (Object)0L));
        orgTreeFilter.and(new QFilter("isroot", "=", (Object)"1"));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.getEntityName());
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("structlongnumber", new QFilter[]{orgTreeFilter});
        if (null == dynamicObjects || 1 > dynamicObjects.length) {
            return this.getRootDynByRootId();
        }
        String commonParentStructLongNumber = TreeTemplateHelper.getParentOrgStructLongNumberByOrgArray((DynamicObject[])dynamicObjects);
        QFilter[] filters = new QFilter[]{new QFilter("structlongnumber", "=", (Object)commonParentStructLongNumber), this.getDataStatusAndBSedFilter()};
        return serviceHelper.queryOriginalOne(selectFields, filters);
    }

    protected String getListPermProKey() {
        return "boid";
    }

    public DynamicObject getCurVerTreeNodeDynInPerm(QFilter permFilter, QFilter orgTreeFilter) {
        return TreeTemplateHelper.getCurTreeRootNodeDynamicObj((String)this.orgTreeModel.getEntityName(), (String)CUR_TREE_ROOT_STRUCT_FIELDS, (QFilter)permFilter, (QFilter)orgTreeFilter, (QFilter)this.getCurTreeBizCommonQFilter());
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        if (!this.getPermOrgResult().isHasAllOrgPerm()) {
            ArrayList<QFilter> list = new ArrayList<QFilter>(1);
            list.add(this.getListPermFilter());
            ((BillList)this.getView().getControl("billlistap")).setDataPermQFilters(list);
            List dataPermQFilters = setFilterEvent.getDataPermQFilters();
            if (dataPermQFilters != null && !dataPermQFilters.isEmpty()) {
                setFilterEvent.setDataPermQFilters(list);
            }
        }
    }

    public QFilter getTreeStructProjectFilter() {
        Set structProjectIdSet = this.getStructProjectCapable().getStructProjectIdSet();
        QFilter filter = new QFilter("structproject", "in", (Object)structProjectIdSet);
        filter.and(new QFilter("enable", "in", (Object)new String[]{"1", "0"}));
        return filter;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"refresh")) {
            ITreeListView treeListView = this.getTreeListView();
            treeListView.refreshTreeView();
        }
    }

    private void addDisabledOrgTeamNameLabel(TreeNode node, String enable) {
        if (HRStringUtils.equals((String)enable, (String)"0")) {
            ArrayList<TreeNodeLabel> labelParaList = new ArrayList<TreeNodeLabel>(2);
            TreeNodeLabel treeNodeLabel = new TreeNodeLabel(ResManager.loadKDString((String)"\u5df2\u505c\u7528", (String)"CustomOrgTeamTreeListTemplate_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), "#999999");
            labelParaList.add(treeNodeLabel);
            node.setLabelPara(labelParaList);
        }
    }
}

