/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.customstruct;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.customstruct.CustomStructProjectRepository;
import kd.hr.haos.business.meta.StructClassHelper;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class CustomStructProjectListPlugin
extends HRDataBaseList
implements ClickListener,
StructProjectConstants {
    private static final String MAINTAINORG = "maintainorg";
    private static final String MAINTAINROLE = "maintainrole";
    private static final String MAINTAINPERSON = "maintainperson";
    protected static final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_otherstructtype");
    private static final HRBaseServiceHelper STRUCTPROJECT_SERVICEHELPER = new HRBaseServiceHelper("haos_customstructproject");

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        Object structTypeId = e.getFormShowParameter().getCustomParam("structTypeId");
        if (structTypeId == null) {
            e.setCancel(true);
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        event.getQFilters().add(new QFilter("id", "in", this.getSpecifiedStructProjects()));
    }

    private List<Long> getSpecifiedStructProjects() {
        DynamicObjectCollection dynamicObjectCollection;
        long structTypeId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("structTypeId"));
        DynamicObject structTypeDy = serviceHelper.queryOne((Object)structTypeId);
        if (structTypeDy != null && !CollectionUtils.isEmpty((Collection)(dynamicObjectCollection = structTypeDy.getDynamicObjectCollection("entryentity")))) {
            return dynamicObjectCollection.stream().filter(dynamicObject -> HRStringUtils.equals((String)"1", (String)dynamicObject.getString("structproject.enable"))).map(dynamicObject -> dynamicObject.getLong("structproject_id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String opKey = eventArgs.getOperateKey();
        if (eventArgs.getOperationResult() != null && eventArgs.getOperationResult().isSuccess() && (MAINTAINORG.equals(opKey) || MAINTAINROLE.equals(opKey) || MAINTAINPERSON.equals(opKey))) {
            this.showStructProjectMaintainPage(eventArgs, opKey);
        }
    }

    private void showStructProjectMaintainPage(AfterDoOperationEventArgs eventArgs, String opType) {
        OperationResult operationResult = eventArgs.getOperationResult();
        if (CollectionUtils.isEmpty((Collection)operationResult.getSuccessPkIds())) {
            return;
        }
        Long primaryKeyValue = (Long)operationResult.getSuccessPkIds().get(0);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("haos_structprojecttab");
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            formShowParameter.setPageId(parentView.getPageId() + "haos_structprojecttab_" + primaryKeyValue);
        }
        formShowParameter.setCustomParam("type", (Object)opType);
        formShowParameter.setCustomParam("numberprefix", (Object)StructClassHelper.getPrefixNumberByStructTypeId((Long)Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("structTypeId"))));
        formShowParameter.setCustomParam("struct_project_ids", (Object)JSONArray.toJSONString((Object)new Long[]{primaryKeyValue}));
        DynamicObject customStructProject = CustomStructProjectRepository.getRepository().queryOne("otclassify", operationResult.getSuccessPkIds().get(0));
        if (!HRObjectUtils.isEmpty((Object)customStructProject)) {
            DynamicObject otClassify = customStructProject.getDynamicObject("otclassify");
            formShowParameter.setCustomParam("struct_project_classify_id", (Object)otClassify.getLong("id"));
            formShowParameter.setCaption(customStructProject.getString("name"));
        }
        this.getView().showForm(formShowParameter);
    }
}

