/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.customstruct;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.haos.business.StructProjectPermUitl;
import kd.hr.haos.business.domain.repository.customstruct.CustomStructProjectRepository;
import kd.hr.haos.business.meta.StructClassHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class CustomStructProjectTabPlugin
extends HRDynamicFormBasePlugin
implements TabSelectListener {
    private static Log LOGGER = LogFactory.getLog(CustomStructProjectTabPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        Object structTypeId = args.getFormShowParameter().getCustomParam("structProjectId");
        if (structTypeId == null) {
            args.setCancel(true);
            return;
        }
        Map permMap = StructProjectPermUitl.hasStructProjectPerm((Long)Long.valueOf(structTypeId.toString()));
        if (!Boolean.TRUE.equals(permMap.get("result"))) {
            args.setCancel(true);
            args.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u8be5\u201c\u67b6\u6784\u65b9\u6848\u201d\u7684\u201c\u67e5\u770b\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CustomStructProjectTabPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return;
        }
        args.getFormShowParameter().setCustomParam("per", (Object)SerializationUtils.toJsonString((Object)permMap));
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("maintainorg".equals(tabKey) || "maintainrole".equals(tabKey) || "maintainperson".equals(tabKey)) {
            this.showMaintainList(tabKey);
        }
    }

    private void showMaintainList(String tabKey) {
        String billFormIdPrefix;
        LOGGER.info("showMaintainOrgForm_tabKey:{}", (Object)tabKey);
        if ("maintainorg".equals(tabKey)) {
            billFormIdPrefix = "haos_cusadminorgteam_";
        } else if ("maintainrole".equals(tabKey)) {
            billFormIdPrefix = "haos_customorole_";
        } else if ("maintainperson".equals(tabKey)) {
            billFormIdPrefix = "haos_cusempposorgrel_";
        } else {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey(tabKey + "flex");
        String structProjectId = (String)formShowParameter.getCustomParam("structProjectId");
        if (structProjectId != null) {
            Long projectId = Long.parseLong(structProjectId);
            listShowParameter.setCustomParam("struct_project_ids", (Object)JSONArray.toJSONString((Object)new Long[]{projectId}));
            DynamicObject customStructProject = CustomStructProjectRepository.getRepository().queryOne("otclassify", (Object)projectId);
            if (!HRObjectUtils.isEmpty((Object)customStructProject)) {
                DynamicObject otClassify = customStructProject.getDynamicObject("otclassify");
                listShowParameter.setCustomParam("struct_project_classify_id", (Object)otClassify.getLong("id"));
                String prefix = StructClassHelper.getPrefixNumberByStructTypeId((Long)otClassify.getLong("id"));
                listShowParameter.setBillFormId(billFormIdPrefix + prefix);
                listShowParameter.setCustomParam("numberprefix", (Object)prefix);
            }
        } else {
            String prefix = (String)formShowParameter.getCustomParam("numberprefix");
            listShowParameter.setBillFormId(billFormIdPrefix + prefix);
            listShowParameter.setCustomParam("struct_project_ids", formShowParameter.getCustomParam("struct_project_ids"));
            listShowParameter.setCustomParam("struct_project_classify_id", formShowParameter.getCustomParam("struct_project_classify_id"));
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Tab tab = (Tab)this.getControl("tabap");
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        String activeTab = null;
        String per = (String)this.getView().getFormShowParameter().getCustomParam("per");
        Map permMap = (Map)SerializationUtils.fromJsonString((String)per, Map.class);
        for (Map.Entry entry : permMap.entrySet()) {
            if ("result".equals(entry.getKey())) continue;
            if (Boolean.FALSE.equals(entry.getValue())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{(String)entry.getKey()});
                continue;
            }
            if (type == null || !type.equals(entry.getKey())) continue;
            activeTab = type;
        }
        if (activeTab == null) {
            activeTab = Boolean.TRUE.equals(permMap.get("maintainorg")) ? "maintainorg" : (Boolean.TRUE.equals(permMap.get("maintainrole")) ? "maintainrole" : "maintainperson");
        }
        tab.activeTab(activeTab);
    }
}

