/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.customstruct;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.TreeView;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamStructRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomStructProjectRepository;
import kd.hr.haos.business.domain.repository.customstruct.NumberPrefixRepository;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.util.tree.TreeAssistUtils;
import kd.hr.haos.formplugin.web.structproject.OtherStructTreeView;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;

public class CustomStructTreeView
extends OtherStructTreeView {
    private final String permEntityNumber;
    private final Long structProjectId;
    private static final String ADD_NODE_IDS_CACHE_KEY = "addNodeIds";
    private static final String COPY_COUNT_CACHE_KEY = "copy_count_cache_key";
    private static final String NEWNODEIDS_CACHE_KEY = "newNodeIds_cache_key";
    private static final String NEWOLDNODERELATION_CACHE_KEY = "newOldNodeRelation_cache_key";

    public CustomStructTreeView(TreeView treeView, boolean isInitTree, String permEntityNumber, Long structProjectId) {
        super(treeView, isInitTree);
        this.permEntityNumber = permEntityNumber;
        this.structProjectId = structProjectId;
    }

    @Override
    protected String getOrderBys() {
        return "level,orgteam.number asc";
    }

    @Override
    protected String structSelectFields() {
        return "structlongnumber,parentorgteam parentorg,orgteam.id id,orgteam.name name,orgteam.enable enable,orgteam.isvirtualorg isvirtualorg";
    }

    @Override
    protected String structSimpleSelectFields() {
        return "orgteam.id id,parentorgteam parentorg";
    }

    @Override
    protected String orgSelectFields() {
        return "id,name,enable,isvirtualorg";
    }

    @Override
    protected String orgStructSelectFields() {
        return "structlongnumber,parentorg,adminorg.id id,adminorg.name name,adminorg.enable enable,adminorg.isvirtualorg isvirtualorg,adminorg.tobedisableflag tobedisableflag,adminorg.belongcompany.name belongcompany.name,adminorg.adminorgtype.adminorgtypestd adminorgtype.adminorgtypestd.id,adminorg.number number";
    }

    @Override
    protected void setNodeValue(TreeNode node, DynamicObject dy) {
        if (!HRObjectUtils.isEmpty((Object)dy)) {
            node.setText(dy.getString("name"));
        }
    }

    @Override
    protected DynamicObjectCollection queryValidColByStructProject(String selectFields, Long structProjectId, QFilter permQFilter, QFilter otherQFilter, String orderBys) {
        return CustomOrgTeamStructRepository.getRepository().queryValidColByStructProject(selectFields, structProjectId, permQFilter, otherQFilter, orderBys);
    }

    @Override
    protected DynamicObjectCollection queryOriginalColByPks(String selectFields, Collection<Long> pks) {
        QFilter filter = new QFilter("id", "in", pks);
        return CustomOrgTeamRepository.getRepository().queryOriginalCollection(selectFields, filter.toArray());
    }

    @Override
    protected DynamicObjectCollection queryColByOrgAndStructProject(String selectFields, Set<Long> orgIds, Long structProjectId) {
        return CustomOrgTeamStructRepository.getRepository().queryColByOrgAndStructProject(selectFields, orgIds, structProjectId);
    }

    @Override
    public void treeNodeDragged(String nodeId, String newParentId) {
        TreeNode node = OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)nodeId);
        ArrayList orgTreeNodeList = Lists.newArrayListWithCapacity((int)10);
        OrgTreeUtils.getAllNodeId((TreeNode)node, (boolean)Boolean.TRUE, (List)orgTreeNodeList);
        if (orgTreeNodeList.contains(newParentId)) {
            return;
        }
        Set<Long> addNodeIds = this.getAddNodeIds();
        if (!addNodeIds.contains(Long.parseLong(nodeId))) {
            return;
        }
        this.deleteNodes(Lists.newArrayList((Object[])new String[]{nodeId}));
        HashMap<String, TreeNode> allTargetNodes = new HashMap<String, TreeNode>(1);
        allTargetNodes.put(newParentId, OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)newParentId));
        node.setParentid(newParentId);
        this.addNodes(allTargetNodes, Lists.newArrayList((Object[])new TreeNode[]{node}), newParentId);
        this.updateRootNodeCache();
    }

    @Override
    protected List<TreeNode> buildSrcSelectedNodeList(List<String> srcSelectedNodeIds, String parentId) {
        Set<Long> idSet = srcSelectedNodeIds.stream().map(Long::valueOf).collect(Collectors.toSet());
        Map<String, List<Long>> newNodeMap = this.getNewNodeIds();
        List newNodeIds = newNodeMap.computeIfAbsent(parentId, val -> new ArrayList(idSet.size()));
        idSet.removeAll(newNodeIds);
        if (idSet.isEmpty()) {
            return new ArrayList<TreeNode>(0);
        }
        DynamicObjectCollection col = AdminOrgStructRepository.getInstance().queryColByOrgAndStructProject(this.orgStructSelectFields(), idSet, AdminOrgConstants.ADMINORG_STRUCT);
        this.filterSameName(col, parentId);
        if (col.isEmpty()) {
            return new ArrayList<TreeNode>(0);
        }
        int size = col.size();
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(size);
        HashMap<String, TreeNode> longNumberMap = new HashMap<String, TreeNode>(size);
        this.setExtendResultMap(col);
        Map<String, String> copyCountMap = this.getCopyCountMap((List<DynamicObject>)col);
        Map<String, String> newOldNodeRelationMap = this.getNewOldNodeRelation();
        long[] orgTeamIds = ORM.create().genLongIds("haos_cusadminorgteam", size);
        HashMap newNodeInfoMap = new HashMap(size);
        Set<Long> addNodeIds = this.getAddNodeIds();
        for (int index = 0; index < col.size(); ++index) {
            DynamicObject dy = (DynamicObject)col.get(index);
            TreeNode node2 = this.buildTreeNodeByDy(dy);
            node2.setId(orgTeamIds[index] + "");
            nodeList.add(node2);
            node2.setText(dy.getString("name"));
            longNumberMap.put(node2.getLongNumber(), node2);
            String number = dy.getString("number");
            String countStr = copyCountMap.get(dy.getString("id"));
            long longCount = 1L;
            if (countStr != null) {
                longCount = Long.parseLong(countStr);
                number = number + "_" + longCount;
                ++longCount;
            }
            String originalId = dy.getString("id");
            copyCountMap.put(originalId, String.valueOf(longCount));
            HashMap<String, String> info = new HashMap<String, String>(2);
            info.put("number", number);
            info.put("name", dy.getString("name"));
            newNodeInfoMap.put(node2.getId(), info);
            addNodeIds.add(orgTeamIds[index]);
            newOldNodeRelationMap.put(node2.getId(), parentId + "-" + originalId);
        }
        this.updateAddNodeIdsPageCache(addNodeIds);
        nodeList.forEach(node -> {
            int index;
            TreeNode parentNode;
            String longNumber = node.getLongNumber();
            do {
                if ((index = longNumber.lastIndexOf("!")) != -1) continue;
                node.setParentid(parentId);
                return;
            } while ((parentNode = (TreeNode)longNumberMap.get(longNumber = longNumber.substring(0, index))) == null);
            node.setParentid(parentNode.getId());
            parentNode.addChild(node);
        });
        idSet.forEach(val -> {
            if (!newNodeIds.contains(val)) {
                newNodeIds.add(val);
            }
        });
        this.updateCopyCountMapPageCache(copyCountMap);
        this.updateNewNodeIdsPageCache(newNodeMap);
        this.updateNewOldNodeRelationPageCache(newOldNodeRelationMap);
        String newNodeInfoMapStr = this.pageCache.get("newNodeInfo_cache_key");
        Map newNodeInfoMapCache = newNodeInfoMapStr != null ? (Map)SerializationUtils.fromJsonString((String)newNodeInfoMapStr, Map.class) : new HashMap(2);
        newNodeInfoMapCache.putAll(newNodeInfoMap);
        this.pageCache.put("newNodeInfo_cache_key", SerializationUtils.toJsonString(newNodeInfoMapCache));
        nodeList.forEach(node -> node.setLongNumber(null));
        return nodeList;
    }

    private void filterSameName(DynamicObjectCollection col, String nodeId) {
        if (col.isEmpty()) {
            return;
        }
        TreeNode treeNode = this.findTreeNode(this.rootNode, nodeId);
        if (treeNode == null || treeNode.getChildren() == null) {
            return;
        }
        Set names = treeNode.getChildren().stream().map(val -> val.getText()).collect(Collectors.toSet());
        if (names != null) {
            col.removeIf(val -> names.contains(val.getString("name")));
        }
    }

    private TreeNode findTreeNode(TreeNode treeNode, String nodeId) {
        if (nodeId.equals(treeNode.getId())) {
            return treeNode;
        }
        List list = treeNode.getChildren();
        if (list == null) {
            return null;
        }
        for (TreeNode node : list) {
            TreeNode target = this.findTreeNode(node, nodeId);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    @Override
    public List<String> deleteNodes() {
        List selectedList;
        List selectedNodes = this.treeView.getTreeState().getSelectedNodeId();
        Set selectedNodeIds = selectedNodes.stream().map(Long::valueOf).collect(Collectors.toSet());
        Map<String, String> newOldNodeRelationMap = this.getNewOldNodeRelation();
        ArrayList<String> delRelationList = new ArrayList<String>(selectedNodeIds.size());
        Set<Long> addNodeIds = this.getAddNodeIds();
        for (Long selectedNodeId : selectedNodeIds) {
            if (!addNodeIds.contains(selectedNodeId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u53ef\u79fb\u9664\u65b0\u589e\u7684\u7ec4\u7ec7\u3002", (String)"CustomStructTreeView_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            }
            String delStr = newOldNodeRelationMap.remove(selectedNodeId.toString());
            if (delStr == null) continue;
            delRelationList.add(delStr);
        }
        List<String> allDeleteNodeIds = this.deleteNodes(selectedNodes);
        addNodeIds.removeAll(allDeleteNodeIds.stream().map(Long::valueOf).collect(Collectors.toSet()));
        this.updateAddNodeIdsPageCache(addNodeIds);
        if (delRelationList.size() > 0) {
            this.updateNewOldNodeRelationPageCache(newOldNodeRelationMap);
            Map<String, List<Long>> newNodeMap = this.getNewNodeIds();
            delRelationList.forEach(val -> {
                String[] strs = val.split("-");
                List lst = (List)newNodeMap.get(strs[0]);
                if (!CollectionUtils.isEmpty((Collection)lst)) {
                    lst.removeIf(orgId -> orgId.equals(Long.valueOf(strs[1])));
                }
            });
            this.updateNewNodeIdsPageCache(newNodeMap);
        }
        if (!CollectionUtils.isEmpty((Collection)(selectedList = this.treeView.getTreeState().getSelectedNodeId()))) {
            this.treeView.uncheckNodes(selectedList);
        }
        this.updateRootNodeCache();
        return allDeleteNodeIds;
    }

    @Override
    protected TreeNode initRootNode() {
        AuthorizedOrgTeamResult authorizedOrgResult = this.getPermOrgResult();
        if (authorizedOrgResult.isHasAllOrgPerm()) {
            DynamicObjectCollection col = this.queryValidColByStructProject(this.structSelectFields(), this.getStructProjectId(), null, this.getOtherQFilter(), this.getOrderBys());
            return this.buildTreeNode(col, null);
        }
        return this.buildPermTreeNode(authorizedOrgResult);
    }

    private AuthorizedOrgTeamResult getPermOrgResult() {
        Long userId = RequestContext.get().getCurrUserId();
        String appId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)this.treeView.getView().getFormShowParameter());
        String propKey = "boid";
        return (AuthorizedOrgTeamResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedOrgTeamsF7", (Object[])new Object[]{userId, appId, this.permEntityNumber, "47150e89000000ac", propKey});
    }

    private TreeNode buildPermTreeNode(AuthorizedOrgTeamResult authorizedOrgResult) {
        Set<String> permStructSet = this.getPermStructSets(authorizedOrgResult);
        String minStructLongNumber = TreeAssistUtils.getCommonPrefixStructLongNumber(new ArrayList<String>(permStructSet));
        if (HRStringUtils.isEmpty((String)minStructLongNumber)) {
            return this.defaultRootNode();
        }
        HashSet<String> allStructSet = new HashSet<String>(permStructSet.size());
        int index = minStructLongNumber.lastIndexOf("!");
        allStructSet.add(index == -1 ? minStructLongNumber : minStructLongNumber.substring(index + 1));
        permStructSet.forEach(struct -> {
            if ((struct = struct.replace(minStructLongNumber, "")).contains("!")) {
                allStructSet.addAll(Arrays.asList(struct.split("!")));
            }
        });
        allStructSet.remove("");
        QFilter structLongNumberFilter = new QFilter("orgteam.structnumber", "in", allStructSet);
        DynamicObjectCollection col = this.queryValidColByStructProject(this.structSelectFields(), this.getStructProjectId(), structLongNumberFilter, this.getOtherQFilter(), this.getOrderBys());
        return this.buildTreeNode(col, permStructSet);
    }

    private Set<String> getPermStructSets(AuthorizedOrgTeamResult authorizedOrgResult) {
        Map hasPermOrgTeamMap = authorizedOrgResult.getHasPermOrgTeamMap();
        if (hasPermOrgTeamMap == null || hasPermOrgTeamMap.isEmpty()) {
            return Collections.emptySet();
        }
        List hasPermOrgIds = (List)hasPermOrgTeamMap.get(this.structProjectId);
        if (CollectionUtils.isEmpty((Collection)hasPermOrgIds)) {
            return Collections.emptySet();
        }
        QFilter permFilter = new QFilter("orgteam", "in", (Object)hasPermOrgIds);
        DynamicObjectCollection col = this.queryValidColByStructProject("structlongnumber", this.getStructProjectId(), permFilter, this.getOtherQFilter(), null);
        return col.stream().map(dy -> dy.getString("structlongnumber")).collect(Collectors.toSet());
    }

    private Set<Long> getAddNodeIds() {
        String addNodeIdsStr = this.pageCache.get(ADD_NODE_IDS_CACHE_KEY);
        HashSet<Long> addNodeIds = new HashSet<Long>(16);
        if (HRStringUtils.isNotEmpty((String)addNodeIdsStr)) {
            addNodeIds.addAll(JSON.parseArray((String)addNodeIdsStr, Long.class));
        }
        return addNodeIds;
    }

    private void updateAddNodeIdsPageCache(Set<Long> addNodeIds) {
        this.pageCache.put(ADD_NODE_IDS_CACHE_KEY, JSON.toJSONString(addNodeIds));
    }

    private Map<String, List<Long>> getNewNodeIds() {
        String newNodeMapStr = this.pageCache.get(NEWNODEIDS_CACHE_KEY);
        return newNodeMapStr != null ? (Map)SerializationUtils.fromJsonString((String)newNodeMapStr, Map.class) : new HashMap(2);
    }

    private void updateNewNodeIdsPageCache(Map<String, List<Long>> newNodeMap) {
        this.pageCache.put(NEWNODEIDS_CACHE_KEY, SerializationUtils.toJsonString(newNodeMap));
    }

    private Map<String, String> getCopyCountMap(List<DynamicObject> col) {
        String numberPrefix;
        DynamicObject structProject;
        HashMap<String, String> copyCountMap;
        String str = this.pageCache.get(COPY_COUNT_CACHE_KEY);
        if (str == null) {
            copyCountMap = new HashMap<String, String>(col.size());
        } else {
            copyCountMap = (HashMap<String, String>)SerializationUtils.fromJsonString((String)str, Map.class);
            col = col.stream().filter(val -> !copyCountMap.containsKey(val.getString("id"))).collect(Collectors.toList());
        }
        if (!col.isEmpty() && (structProject = CustomStructProjectRepository.getRepository().queryOne("otclassify.id", (Object)this.structProjectId)) != null && HRStringUtils.isNotEmpty((String)(numberPrefix = NumberPrefixRepository.getRepository().getNumberPrefixById(Long.valueOf(structProject.getLong("otclassify.id")))))) {
            CustomOrgTeamRepository customOrgTeamRepository = CustomOrgTeamRepository.getRepository();
            QFilter dataQ = new QFilter("datastatus", "not in", Arrays.asList("-1", "-2"));
            QFilter numberFilter = null;
            HashMap<String, Long> numDyMap = new HashMap<String, Long>(col.size());
            for (DynamicObject dynamicObject : col) {
                String number = numberPrefix + "_" + dynamicObject.getString("number");
                if (numberFilter == null) {
                    numberFilter = new QFilter("number", "like", (Object)(number + "%"));
                } else {
                    numberFilter.or("number", "like", (Object)(number + "%"));
                }
                numDyMap.put(number, dynamicObject.getLong("id"));
            }
            DynamicObject[] dys = customOrgTeamRepository.query("number", new QFilter[]{dataQ, numberFilter});
            if (dys != null && dys.length > 0) {
                numDyMap.forEach((numberPre, orgId) -> {
                    for (DynamicObject dy : dys) {
                        String suffix;
                        String num = dy.getString("number");
                        if (!num.equals(numberPre) && !num.startsWith(numberPre + "_")) continue;
                        String string = suffix = num.equals(numberPre) ? "0" : num.substring(numberPre.length() + 1);
                        if (!suffix.matches("\\d+")) continue;
                        String orgIdStr = String.valueOf(orgId);
                        Long suffixCount = Long.valueOf(suffix);
                        String countStr = (String)copyCountMap.get(orgIdStr);
                        if (countStr != null && suffixCount < Long.parseLong(countStr)) continue;
                        Long l = suffixCount;
                        Long l2 = suffixCount = Long.valueOf(suffixCount + 1L);
                        if (suffixCount >= Long.MAX_VALUE) continue;
                        copyCountMap.put(orgIdStr, String.valueOf(suffixCount));
                    }
                });
            }
        }
        return copyCountMap;
    }

    private void updateCopyCountMapPageCache(Map<String, String> copyCountMap) {
        this.pageCache.put(COPY_COUNT_CACHE_KEY, SerializationUtils.toJsonString(copyCountMap));
    }

    private Map<String, String> getNewOldNodeRelation() {
        String str = this.pageCache.get(NEWOLDNODERELATION_CACHE_KEY);
        return str != null ? (Map)SerializationUtils.fromJsonString((String)str, Map.class) : new HashMap(2);
    }

    private void updateNewOldNodeRelationPageCache(Map<String, String> newOldNodeRelationMap) {
        this.pageCache.put(NEWOLDNODERELATION_CACHE_KEY, SerializationUtils.toJsonString(newOldNodeRelationMap));
    }
}

