/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.iexport;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.StructProjectPermUitl;
import kd.hr.haos.business.domain.repository.CommonRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.formplugin.web.iexport.CustomImportBase;
import kd.hr.haos.formplugin.web.iexport.util.CustomeImportUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.plugin.AfterConvertDynamicObjectsEventArgs;
import kd.hr.impt.common.plugin.AfterParseBillDataEventArgs;
import kd.hr.impt.common.plugin.AfterQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;

public class CustomRoleEmpImport
extends CustomImportBase {
    private static final Log LOGGER = LogFactory.getLog(CustomRoleEmpImport.class);

    public void afterParseBillData(AfterParseBillDataEventArgs args) {
        String number;
        ImportBillData importBillData = args.getData();
        String exParams = args.getExtParams();
        if (importBillData == null || importBillData.getData() == null || importBillData.getMainEntityId() == null || HRStringUtils.isEmpty((String)exParams)) {
            LOGGER.error("afterParseBillData");
            return;
        }
        Map params = (Map)SerializationUtils.fromJsonString((String)exParams, Map.class);
        String numberPrefix = (String)params.get("numberprefix");
        if (HRStringUtils.isEmpty((String)numberPrefix)) {
            LOGGER.error("afterParseBillData numberPrefix is empty");
            return;
        }
        JSONObject jsonObject = importBillData.getData().getJSONObject(importBillData.getMainEntityId());
        if (jsonObject == null) {
            return;
        }
        JSONObject orgTeam = jsonObject.getJSONObject("orgteam");
        if (orgTeam != null && HRStringUtils.isNotEmpty((String)(number = orgTeam.getString("number")))) {
            orgTeam.put("number", (Object)(numberPrefix.toUpperCase(Locale.ROOT) + "_" + number));
        }
    }

    public void afterQueryRefBd(AfterQueryRefBdEventArgs args) {
        super.afterQueryRefBd(args);
        String baseDataName = args.getBaseDataName();
        if (!args.isImportInvoke() && ("haos_outperson".equals(baseDataName) || "haos_customorole".equals(baseDataName) || "haos_cusadminorgteam".equals(baseDataName) || "hrpi_depempf7query".equals(baseDataName))) {
            args.setDatas(null);
            return;
        }
        if ("haos_customorole".equals(baseDataName)) {
            DynamicObject[] datas = args.getDatas();
            if (datas != null && datas.length > 0) {
                ArrayList<DynamicObject> newDatas = new ArrayList<DynamicObject>(datas.length);
                HashSet<String> numbers = new HashSet<String>(datas.length);
                for (DynamicObject data : datas) {
                    String number = data.getString("number");
                    if (!numbers.add(number)) continue;
                    newDatas.add(data);
                }
                args.setDatas(newDatas.toArray(new DynamicObject[0]));
            }
        } else if ("hrpi_depempf7query".equals(baseDataName)) {
            String numberPrefix;
            Map<String, Object> extParamsMap = CustomeImportUtil.convertExtParamsMap(args.getExtParams());
            String string = numberPrefix = extParamsMap != null ? (String)extParamsMap.get("numberprefix") : null;
            if (HRStringUtils.isEmpty((String)numberPrefix)) {
                LOGGER.error("afterQueryRefBd numberPrefix is empty");
                return;
            }
            String personMeta = "haos_cusempposorgrel_" + numberPrefix;
            Set orgs = null;
            DynamicObject[] datas = args.getDatas();
            if (datas != null && datas.length > 0) {
                ArrayList<DynamicObject> newDatas = new ArrayList<DynamicObject>(datas.length);
                HashSet<String> numbers = new HashSet<String>(datas.length);
                for (DynamicObject data : datas) {
                    String number = data.getString("person.number");
                    if (numbers.add(number)) {
                        newDatas.add(data);
                        continue;
                    }
                    if (orgs == null) {
                        orgs = StructProjectPermUitl.getCustomRoleEmpAuthorizedAdminOrgsF7((String)personMeta);
                    }
                    if (orgs.size() != 0 && !orgs.contains(data.getLong("adminorg.id"))) continue;
                    newDatas.removeIf(val -> number.equals(val.getString("person.number")));
                    newDatas.add(data);
                }
                args.setDatas(newDatas.toArray(new DynamicObject[0]));
            }
        }
    }

    public void afterConvertDynamicObjects(AfterConvertDynamicObjectsEventArgs args) {
        Map<Object, ImportBillData> map = CustomeImportUtil.initIdAndbillDataMap(args.getImportBillDatas());
        HashMap newMap = new HashMap();
        HashMap<String, List> tempMap = new HashMap<String, List>();
        Map dynamicObjects = args.getDynamicObjects();
        HashSet<String> roleNumbers = new HashSet<String>(map.size());
        HashSet<String> names = new HashSet<String>(map.size());
        HashSet<String> phones = new HashSet<String>(map.size());
        for (Map.Entry entry : dynamicObjects.entrySet()) {
            DynamicObject[] dys = (DynamicObject[])entry.getValue();
            for (DynamicObject dy : dys) {
                DynamicObject outPer;
                DynamicObject customorole = dy.getDynamicObject("customorole");
                DynamicObject orgteam = dy.getDynamicObject("orgteam");
                if (!HRObjectUtils.isEmpty((Object)customorole) && !HRObjectUtils.isEmpty((Object)orgteam) && customorole.getLong("orgteam.id") != orgteam.getLong("id")) {
                    roleNumbers.add(customorole.getString("number"));
                }
                if ((outPer = dy.getDynamicObject("outperson")) == null) continue;
                names.add(outPer.getString("name"));
                phones.add(dy.getString("phone"));
            }
        }
        Map<String, DynamicObject> orgRoleMap = this.getRealOrgRoleMap(roleNumbers);
        Map<String, DynamicObject> outPerMap = this.getRealOutPerMap(names, phones);
        for (Map.Entry entry : dynamicObjects.entrySet()) {
            DynamicObject[] dys;
            for (DynamicObject dy : dys = (DynamicObject[])entry.getValue()) {
                ImportBillData billData = map.get(dy.getPkValue());
                dy.set("bsed", (Object)new Date());
                if (dy.get("depemp") == null) {
                    dy.set("datasource", (Object)Boolean.FALSE);
                } else {
                    dy.set("datasource", (Object)Boolean.TRUE);
                    dy.set("name", dy.get("depemp.person.name"));
                    dy.set("person", dy.get("depemp.person"));
                }
                if (orgRoleMap != null) {
                    DynamicObject roleDy;
                    DynamicObject customorole = dy.getDynamicObject("customorole");
                    DynamicObject orgteam = dy.getDynamicObject("orgteam");
                    if (!HRObjectUtils.isEmpty((Object)customorole) && !HRObjectUtils.isEmpty((Object)orgteam) && customorole.getLong("orgteam.id") != orgteam.getLong("id") && (roleDy = orgRoleMap.get(orgteam.getLong("id") + "_" + customorole.getString("number"))) != null) {
                        dy.set("customorole", (Object)roleDy);
                    }
                }
                if (outPerMap != null) {
                    String name = dy.getString("name");
                    String phone = dy.getString("phone");
                    DynamicObject outPerDy = outPerMap.get(name + "_" + phone);
                    if (outPerDy != null) {
                        dy.set("outperson", (Object)outPerDy);
                    }
                }
                if ("new".equalsIgnoreCase(billData.getOpType())) {
                    List newdys = tempMap.computeIfAbsent("new", val -> new LinkedList());
                    newdys.add(dy);
                    continue;
                }
                if (!"update".equalsIgnoreCase(billData.getOpType())) continue;
                List updatedys = tempMap.computeIfAbsent("update", val -> new LinkedList());
                updatedys.add(dy);
            }
        }
        for (Map.Entry entry : tempMap.entrySet()) {
            if (entry == null || entry.getValue() == null || ((List)entry.getValue()).size() <= 0) continue;
            List values = (List)entry.getValue();
            newMap.put(entry.getKey(), values.toArray(new DynamicObject[values.size()]));
        }
        args.setDynamicObjects(newMap);
    }

    private Map<String, DynamicObject> getRealOrgRoleMap(Set<String> roleNumbers) {
        QFilter filter;
        DynamicObject[] roleDys;
        HashMap<String, DynamicObject> orgRoleMap = null;
        if (roleNumbers.size() > 0 && (roleDys = CommonRepository.queryDynamicObjects((String)"haos_customorole", (String)"number,name,orgteam", (QFilter[])new QFilter[]{filter = new QFilter("number", "in", roleNumbers).and(QFilterHelper.createValidHisCurrentDataFilter())})) != null && roleDys.length > 0) {
            orgRoleMap = new HashMap<String, DynamicObject>(roleDys.length);
            for (DynamicObject role : roleDys) {
                Long orgId = role.getLong("orgteam.id");
                orgRoleMap.put(orgId + "_" + role.getString("number"), role);
            }
        }
        return orgRoleMap;
    }

    private Map<String, DynamicObject> getRealOutPerMap(Set<String> names, Set<String> phones) {
        QFilter filter;
        DynamicObject[] outPerDys;
        HashMap<String, DynamicObject> outPerMap = null;
        if (names.size() > 0 && (outPerDys = CommonRepository.queryDynamicObjects((String)"haos_outperson", (String)"name,phone", (QFilter[])new QFilter[]{filter = new QFilter("name", "in", names).and("phone", "in", phones)})) != null && outPerDys.length > 0) {
            outPerMap = new HashMap<String, DynamicObject>(outPerDys.length);
            for (DynamicObject outPer : outPerDys) {
                String name = outPer.getString("name");
                String phone = outPer.getString("phone");
                outPerMap.put(name + "_" + phone, outPer);
            }
        }
        return outPerMap;
    }

    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
        Map submitOPs = args.getSubmitOPs();
        switch (args.getGroupName()) {
            case "new": {
                submitOPs.put(submitOPs.keySet().stream().findFirst().get(), "import_addperson");
                break;
            }
            case "update": {
                submitOPs.put(submitOPs.keySet().stream().findFirst().get(), "import_updperson");
                break;
            }
        }
    }
}

