/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.iexport;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.haos.formplugin.web.iexport.CustomImportBase;
import kd.hr.haos.formplugin.web.iexport.util.CustomeImportUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.plugin.AfterConvertDynamicObjectsEventArgs;
import kd.hr.impt.common.plugin.AfterParseBillDataEventArgs;
import kd.hr.impt.common.plugin.AfterQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;

public class CustomRoleImport
extends CustomImportBase {
    private static final Log LOGGER = LogFactory.getLog(CustomRoleImport.class);

    public void afterQueryRefBd(AfterQueryRefBdEventArgs args) {
        super.afterQueryRefBd(args);
        if ("haos_cusadminorgteam".equals(args.getBaseDataName()) && !args.isImportInvoke()) {
            args.setDatas(null);
        }
    }

    public void afterParseBillData(AfterParseBillDataEventArgs args) {
        String number;
        ImportBillData importBillData = args.getData();
        String exParams = args.getExtParams();
        if (importBillData == null || importBillData.getData() == null || importBillData.getMainEntityId() == null || HRStringUtils.isEmpty((String)exParams)) {
            LOGGER.error("afterParseBillData");
            return;
        }
        Map params = (Map)SerializationUtils.fromJsonString((String)exParams, Map.class);
        String numberPrefix = (String)params.get("numberprefix");
        if (HRStringUtils.isEmpty((String)numberPrefix)) {
            LOGGER.error("afterParseBillData numberPrefix is empty");
            return;
        }
        JSONObject jsonObject = importBillData.getData().getJSONObject(importBillData.getMainEntityId());
        if (jsonObject == null) {
            return;
        }
        JSONObject orgTeam = jsonObject.getJSONObject("orgteam");
        if (orgTeam != null && HRStringUtils.isNotEmpty((String)(number = orgTeam.getString("number")))) {
            orgTeam.put("number", (Object)(numberPrefix.toUpperCase(Locale.ROOT) + "_" + number));
        }
    }

    public void afterConvertDynamicObjects(AfterConvertDynamicObjectsEventArgs args) {
        Map<Object, ImportBillData> map = CustomeImportUtil.initIdAndbillDataMap(args.getImportBillDatas());
        HashMap newMap = new HashMap();
        HashMap<String, List> tempMap = new HashMap<String, List>();
        Map dynamicObjects = args.getDynamicObjects();
        for (Map.Entry entry : dynamicObjects.entrySet()) {
            DynamicObject[] dys;
            for (DynamicObject dy : dys = (DynamicObject[])entry.getValue()) {
                ImportBillData billData = map.get(dy.getPkValue());
                dy.set("bsed", (Object)new Date());
                if ("new".equalsIgnoreCase(billData.getOpType())) {
                    List newdys = tempMap.computeIfAbsent("new", val -> new LinkedList());
                    newdys.add(dy);
                    continue;
                }
                if (!"update".equalsIgnoreCase(billData.getOpType())) continue;
                List updatedys = tempMap.computeIfAbsent("update", val -> new LinkedList());
                updatedys.add(dy);
            }
        }
        for (Map.Entry next : tempMap.entrySet()) {
            if (next == null || next.getValue() == null || ((List)next.getValue()).size() <= 0) continue;
            List values = (List)next.getValue();
            newMap.put(next.getKey(), values.toArray(new DynamicObject[values.size()]));
        }
        args.setDynamicObjects(newMap);
    }

    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
        Map submitOPs = args.getSubmitOPs();
        switch (args.getGroupName()) {
            case "new": {
                submitOPs.put(submitOPs.keySet().stream().findFirst().get(), "save");
                break;
            }
            case "update": {
                submitOPs.put(submitOPs.keySet().stream().findFirst().get(), "his_rolemodify");
                break;
            }
        }
    }
}

