/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.projectgroup.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.util.coderule.ProjectGroupCodeRuleHelper;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.common.model.coderule.HAOSCodeRuleModel;
import kd.hr.haos.formplugin.web.projectgroup.util.PrjOrgPermHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class ProjectGroupAddEdit
extends HRDataBaseEdit
implements ProjectGroupMDConstants,
BeforeF7SelectListener {
    private static final List<String> REGISTER_BEFORE_F7_LISTENER = new ArrayList<String>(1);
    private HAOSCodeRuleModel codeRuleModel;
    private static final String CODE_RULE_MODEL = "prjorgadd_code_rule_model";
    private static final String SAVE_OP_SUCCESS = "prjorgadd_save_success";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String currentNodeId = (String)formShowParameter.getCustomParam("currentNodeId");
        this.getModel().setValue("parentorg", (Object)currentNodeId);
        this.setParentProp(formShowParameter, currentNodeId);
        String operateType = (String)formShowParameter.getCustomParam("operate_type");
        if ("addNew".equals(operateType)) {
            this.getModel().setValue("changetype", (Object)1010L);
        }
    }

    private void setRootProjectTeam() {
        long parentProjectTeamId;
        if (!this.isRootProjectTeam() && (parentProjectTeamId = this.getModel().getDataEntity().getLong("parentprojectteam.rootprojectteam.id")) != 0L) {
            DynamicObject[] parentProjectTeam = PRJOrgRepository.getInstance().queryByPks("id,name,number,projectname,projectnumber", Collections.singleton(parentProjectTeamId));
            this.getModel().setValue("rootprojectteam", (Object)parentProjectTeam[0]);
        }
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.setRootProjectTeam();
        this.setProjectInfo();
        String operateType = (String)this.getView().getFormShowParameter().getCustomParam("operate_type");
        if ("addNew".equals(operateType)) {
            this.getModel().deleteEntryRows("entryentity", new int[]{0});
            this.getModel().setDataChanged(false);
            Date establishmentDate = this.getModel().getDataEntity().getDate("establishmentdate");
            this.getModel().setValue("startdate", (Object)establishmentDate);
            this.getModel().setValue("changetype", (Object)1010L);
        }
        this.setIndex(this.getModel().getDataEntity().getDynamicObject("parentorg"));
        this.getModel().setDataChanged(false);
        this.setNumberFromCodeRule();
        this.getView().updateView("projectname");
        this.getView().updateView("projectnumber");
    }

    private void setProjectInfo() {
        if (!this.isRootProjectTeam()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"projectname", "projectnumber", "description"});
            DynamicObject projectTeamDy = this.getModel().getDataEntity();
            this.getModel().setValue("projectname", projectTeamDy.get("rootprojectteam.projectname"));
            this.getModel().setValue("projectnumber", projectTeamDy.get("rootprojectteam.projectnumber"));
            this.getModel().setValue("description", projectTeamDy.get("rootprojectteam.description"));
        }
    }

    private void setIndex(DynamicObject parentDy) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_projteambaseinfo");
        int max = 1;
        if (parentDy != null && parentDy.getLong("id") != 0L) {
            QFilter qFilter = new QFilter("parentorg", "=", (Object)parentDy.getLong("id")).and("iscurrentversion", "=", (Object)"1");
            DynamicObjectCollection dynamicObjects = serviceHelper.queryOriginalCollection("id,parentorg.id,index", qFilter.toArray());
            if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                for (DynamicObject dy : dynamicObjects) {
                    int idx = dy.getInt("index");
                    if (idx < max || idx >= IDX_MAX) continue;
                    max = idx + 1;
                }
            }
            if (max > IDX_MAX) {
                max = IDX_MAX;
            }
        }
        this.getModel().setValue("index", (Object)max);
    }

    private void setParentProp(FormShowParameter formShowParameter, String currentNodeId) {
        String newType = (String)formShowParameter.getCustomParam("newType");
        BasedataEdit parentProjectTeam = (BasedataEdit)this.getView().getControl("parentprojectteam");
        BasedataEdit belongCompanyEdit = (BasedataEdit)this.getView().getControl("belongadminorg");
        if (HRStringUtils.equals((String)newType, (String)"donothing_new_parent")) {
            this.getModel().setValue("belongadminorg", (Object)currentNodeId);
            belongCompanyEdit.setMustInput(true);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"parentprojectteam"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"belongadminorg"});
        } else if (HRStringUtils.equals((String)newType, (String)"donothing_new_son")) {
            parentProjectTeam.setMustInput(true);
            this.getModel().setValue("parentprojectteam", (Object)currentNodeId);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"parentprojectteam"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"belongadminorg"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject parentProjectTeam;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        String newType = (String)this.getView().getFormShowParameter().getCustomParam("newType");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("operateKey", operateKey);
        map.put("newType", newType);
        if (HRStringUtils.equals((String)newType, (String)"donothing_new_parent")) {
            this.getModel().setValue("parentorg", this.getModel().getValue("belongadminorg"));
        } else if (HRStringUtils.equals((String)newType, (String)"donothing_new_son") && (parentProjectTeam = this.getModel().getDataEntity().getDynamicObject("parentprojectteam")) != null) {
            this.getModel().setValue("belongadminorg", (Object)parentProjectTeam.getDynamicObject("belongadminorg"));
        }
        this.updateCodeRuleModel();
        this.getView().returnDataToParent(map);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)"donothing_save", (String)operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().getPageCache().put(SAVE_OP_SUCCESS, "true");
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String property = event.getProperty().getName();
        Object newValue = event.getChangeSet()[0].getNewValue();
        if (HRStringUtils.equals((String)"startdate", (String)property)) {
            IDataModel model = this.getModel();
            model.setValue("firstbsed", model.getValue("startdate"));
        } else if ("establishmentdate".equals(property)) {
            this.getModel().setValue("startdate", newValue);
        } else if ("index".equals(property)) {
            if (event.getChangeSet()[0].getNewValue() == null && this.getModel().getDataEntity().get("parentorg") != null) {
                this.setIndex(this.getModel().getDataEntity().getDynamicObject("parentorg"));
            }
        } else if ("parentprojectteam".equals(property)) {
            this.setRootProjectTeam();
            this.setProjectInfo();
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        REGISTER_BEFORE_F7_LISTENER.forEach(propertyName -> {
            Control control = this.getView().getControl(propertyName);
            if (control instanceof BasedataEdit) {
                ((BasedataEdit)control).addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        });
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propertyName = event.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
        if ("parentprojectteam".equals(propertyName)) {
            listShowParameter.setCustomParam("parentprojectteam", (Object)"parentprojectteam");
            QFilter permFilter = PrjOrgPermHelper.getPrjOrgPermFilterWithBU();
            event.getCustomQFilters().add(permFilter);
        } else if ("belongadminorg".equals(propertyName)) {
            QFilter permFilter = PrjOrgPermHelper.getAdOrgPermFilterWithBU();
            event.getCustomQFilters().add(permFilter);
        }
    }

    public void pageRelease(EventObject e) {
        this.recycleNumber();
    }

    private void setNumberFromCodeRule() {
        HAOSCodeRuleModel codeRuleModel = this.getCodeRuleModel(false);
        if (ProjectGroupCodeRuleHelper.isExist((HAOSCodeRuleModel)codeRuleModel)) {
            String[] batchNumber = this.getAndCacheNumber(codeRuleModel);
            this.getModel().setValue("number", (Object)batchNumber[0]);
            this.getModel().setDataChanged(false);
        }
    }

    private String[] getAndCacheNumber(HAOSCodeRuleModel codeRuleModel) {
        String[] batchNumber = ProjectGroupCodeRuleHelper.getBatchNumber((HAOSCodeRuleModel)codeRuleModel, (int)1);
        codeRuleModel.setNumbers(batchNumber);
        this.getView().getPageCache().put(CODE_RULE_MODEL, SerializationUtils.toJsonString((Object)codeRuleModel));
        return batchNumber;
    }

    private void updateCodeRuleModel() {
        HAOSCodeRuleModel model = this.getCodeRuleModel(false);
        String[] currentNumbers = new String[]{this.getModel().getDataEntity().getString("number")};
        model.setCurrentNumbers(currentNumbers);
        this.getView().getPageCache().put(CODE_RULE_MODEL, SerializationUtils.toJsonString((Object)model));
    }

    private void recycleNumber() {
        ProjectGroupCodeRuleHelper.recycleNumber((HAOSCodeRuleModel)this.getCodeRuleModel(true), (!this.isSaveSuccess() ? 1 : 0) != 0);
    }

    private HAOSCodeRuleModel getCodeRuleModel(boolean isRelease) {
        if (this.codeRuleModel != null) {
            return this.codeRuleModel;
        }
        String modelJsonStr = this.getView().getPageCache().get(CODE_RULE_MODEL);
        if (StringUtils.isNotEmpty((CharSequence)modelJsonStr)) {
            this.codeRuleModel = (HAOSCodeRuleModel)SerializationUtils.fromJsonString((String)modelJsonStr, HAOSCodeRuleModel.class);
        } else {
            this.codeRuleModel = new HAOSCodeRuleModel();
            this.codeRuleModel.setEntityNumber("haos_projectgroupadd");
            this.codeRuleModel.setOrgId(this.getModel().getDataEntity().getString("org.id"));
            this.codeRuleModel.setNumbers(null);
            this.getView().getPageCache().put(CODE_RULE_MODEL, SerializationUtils.toJsonString((Object)this.codeRuleModel));
        }
        this.codeRuleModel.setDy(!isRelease ? this.getModel().getDataEntity() : null);
        return this.codeRuleModel;
    }

    private boolean isSaveSuccess() {
        return this.getView().getPageCache().get(SAVE_OP_SUCCESS) != null;
    }

    private boolean isRootProjectTeam() {
        String newType = (String)this.getView().getFormShowParameter().getCustomParam("newType");
        return HRStringUtils.equals((String)newType, (String)"donothing_new_parent");
    }

    static {
        REGISTER_BEFORE_F7_LISTENER.add("parentprojectteam");
        REGISTER_BEFORE_F7_LISTENER.add("belongadminorg");
        REGISTER_BEFORE_F7_LISTENER.add("cooporgteam");
    }
}

