/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.projectgroup.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.TipsSupport;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.rpc.HRCSRPCServiceHelper;
import kd.hr.haos.business.service.projectgroup.bean.ProjectInfoBo;
import kd.hr.haos.business.service.projectgroup.service.ProjectInfoService;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.formplugin.web.projectgroup.util.PrjOrgPermHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class ProjectGroupChangeEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
ProjectGroupMDConstants {
    private static final String BAR_OPERATE_CHANGEPARENT = "barconfirmchangeparent";
    private static final String BAR_OPERATE_CHANGEINFO = "barconfirmchangeinfo";
    private static final List<String> REGISTER_BEFORE_F7_LISTENER = new ArrayList<String>(1);
    private static final String CACHE_KEY_PROJECT_INFO = "project_info";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        REGISTER_BEFORE_F7_LISTENER.forEach(propertyName -> {
            Control control = this.getView().getControl(propertyName);
            if (control instanceof BasedataEdit) {
                ((BasedataEdit)control).addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        });
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String operateType = (String)formShowParameter.getCustomParam("operate_type");
        if (HRStringUtils.equals((String)"changeparent", (String)operateType)) {
            this.setTips();
            this.getModel().setValue("changetype", (Object)CHANGETYPE_CHANGEPARENT);
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_OPERATE_CHANGEPARENT});
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_OPERATE_CHANGEINFO});
            this.getView().setEnable(Boolean.TRUE, new String[]{"parentprojectteam", "belongadminorg"});
        } else if (HRStringUtils.equals((String)"changeinfo", (String)operateType)) {
            this.getModel().setValue("changetype", (Object)ProjectGroupMDConstants.CHANGETYPE_CHANGEPINFO);
            this.getView().setEnable(Boolean.FALSE, new String[]{"parentprojectteam", "belongadminorg"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"parentorg"});
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_OPERATE_CHANGEPARENT});
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_OPERATE_CHANGEINFO});
        }
        this.initProjectInfo();
        this.getModel().setDataChanged(false);
    }

    private void setTips() {
        IFormView iFormView = this.getView();
        Tips tips = new Tips();
        List tipsStr = HRCSRPCServiceHelper.queryPromptForString((IFormView)iFormView, (String)"haos_projectgroupchange", (String)"parentprojectteam");
        if (!CollectionUtils.isEmpty((Collection)tipsStr)) {
            tips.setContent(new LocaleString((String)tipsStr.get(0)));
            tips.setType("text");
            tips.setTriggerType("hover");
            tips.setIsConfirm(false);
            tips.setShowIcon(true);
            TipsSupport control = (TipsSupport)iFormView.getControl("parentprojectteam");
            if (control != null) {
                control.addTips(tips);
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        this.getView().setStatus(OperationStatus.EDIT);
        DynamicObject projectTeamDy = this.getModel().getDataEntity();
        ProjectInfoBo projectInfoBo = ProjectInfoBo.create((DynamicObject)projectTeamDy);
        projectInfoBo.setBelongAdOrg(projectTeamDy.getLong("belongadminorg.id"));
        projectInfoBo.setRootProject(this.isRootProjectTeam());
        this.getPageCache().put(CACHE_KEY_PROJECT_INFO, SerializationUtils.serializeToBase64((Object)projectInfoBo));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            this.getView().getModel().setDataChanged(false);
            this.getView().invokeOperation("close");
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String operationKey = event.getProperty().getName();
        if (HRStringUtils.equals((String)"parentprojectteam", (String)operationKey)) {
            DynamicObject parentTeam = (DynamicObject)this.getModel().getValue("parentprojectteam");
            if (parentTeam != null) {
                DynamicObject belongCompany = parentTeam.getDynamicObject("belongadminorg");
                this.getModel().setValue("belongadminorg", (Object)belongCompany);
            }
            this.setRootProjectTeam();
            this.setProjectInfoAfterParentChange();
        } else if ("belongadminorg".equals(operationKey)) {
            this.setRootProjectTeam();
            this.setProjectInfoAfterParentChange();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"donothing_confirmchangeparent")) {
            DynamicObject parentBelongAdminOrg;
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject belongAdminOrg = dataEntity.getDynamicObject("belongadminorg");
            DynamicObject parentProjectTeam = dataEntity.getDynamicObject("parentprojectteam");
            if (belongAdminOrg == null && parentProjectTeam == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u4e0a\u7ea7\u9879\u76ee\u56e2\u961f\u201d\u548c\u201c\u6240\u5c5e\u884c\u653f\u7ec4\u7ec7\u201d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ProjectGroupChangeEdit_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (belongAdminOrg != null && parentProjectTeam != null && (parentBelongAdminOrg = parentProjectTeam.getDynamicObject("belongadminorg")).getLong("id") != belongAdminOrg.getLong("id")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0a\u7ea7\u9879\u76ee\u56e2\u961f\u4e0e\u6240\u5c5e\u7684\u884c\u653f\u7ec4\u7ec7\u5173\u7cfb\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ProjectGroupChangeEdit_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (parentProjectTeam != null) {
                this.getModel().setValue("parentorg", (Object)parentProjectTeam);
            } else {
                this.getModel().setValue("parentorg", (Object)belongAdminOrg);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propertyName = event.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
        if ("parentprojectteam".equals(propertyName)) {
            listShowParameter.setCustomParam("parentprojectteam", (Object)"parentprojectteam");
            QFilter permFilter = PrjOrgPermHelper.getPrjOrgPermFilterWithBU(this.getOrgId());
            event.getCustomQFilters().add(permFilter);
        } else if ("belongadminorg".equals(propertyName)) {
            QFilter permFilter = PrjOrgPermHelper.getAdOrgPermFilterWithBU(this.getOrgId());
            event.getCustomQFilters().add(permFilter);
        }
    }

    private long getOrgId() {
        return this.getModel().getDataEntity().getLong("org.id");
    }

    private void initProjectInfo() {
        if (!this.isRootProjectTeam()) {
            this.setProjectInfoFromRootProjectTeam();
        }
        if (this.isParentChangePage()) {
            this.setProjectInfoStateDisabled();
        } else if (this.isInfoChangePage()) {
            if (this.isRootProjectTeam()) {
                this.setProjectInfoStateEnabled();
            } else {
                this.setProjectInfoStateDisabled();
            }
        }
    }

    private void setProjectInfoFromRootProjectTeam() {
        DynamicObject projectTeamDy = this.getModel().getDataEntity();
        this.getModel().setValue("projectname", projectTeamDy.get("rootprojectteam.projectname"));
        this.getModel().setValue("projectnumber", projectTeamDy.get("rootprojectteam.projectnumber"));
        this.getModel().setValue("description", projectTeamDy.get("rootprojectteam.description"));
    }

    private void setProjectInfoAfterParentChange() {
        ProjectInfoService projectInfoService = new ProjectInfoService();
        int changeType = projectInfoService.getChangeType(this.getCacheProjectTeamDy(), this.getCurrentProjectTeamDy());
        switch (changeType) {
            case 4: {
                if (this.getCacheBelongAdOrgId() == this.getModel().getDataEntity().getLong("belongadminorg.id")) {
                    this.setProjectInfoStateDisabled();
                    this.rollBackProjectInfo();
                    break;
                }
                this.setProjectInfoStateEnabled();
                break;
            }
            case 1: {
                this.setProjectInfoStateEnabled();
                break;
            }
            case 2: 
            case 3: {
                this.initProjectInfo();
                break;
            }
        }
    }

    private void setProjectInfoStateEnabled() {
        this.setProjectInfoState(true);
    }

    private void setProjectInfoStateDisabled() {
        this.setProjectInfoState(false);
    }

    private void setProjectInfoState(boolean b) {
        this.getView().setEnable(Boolean.valueOf(b), new String[]{"projectname", "projectnumber", "description"});
        FieldEdit projectNameEdit = (FieldEdit)this.getView().getControl("projectname");
        projectNameEdit.setMustInput(b);
    }

    private void setRootProjectTeam() {
        if (this.isRootProjectTeam()) {
            this.getModel().setValue("rootprojectteam", (Object)this.getModel().getDataEntity().getLong("boid"));
            this.setBelongAdOrgState(true);
        } else {
            long parentProjectTeamId = this.getModel().getDataEntity().getLong("parentprojectteam.rootprojectteam.id");
            DynamicObject[] parentProjectTeam = PRJOrgRepository.getInstance().queryByPks("id,name,number,projectname,projectnumber", Collections.singleton(parentProjectTeamId));
            this.getModel().setValue("rootprojectteam", (Object)parentProjectTeam[0]);
            this.setBelongAdOrgState(false);
        }
    }

    private void setBelongAdOrgState(boolean isRootProjectTeam) {
        this.getView().setEnable(Boolean.valueOf(isRootProjectTeam), new String[]{"belongadminorg"});
    }

    private boolean isRootProjectTeam() {
        return this.getModel().getDataEntity().get("parentprojectteam") == null;
    }

    private long getCacheBelongAdOrgId() {
        return this.getCacheProjectInfoBo().getBelongAdOrg();
    }

    private ProjectInfoBo getCacheProjectInfoBo() {
        String cacheStr = this.getPageCache().get(CACHE_KEY_PROJECT_INFO);
        if (cacheStr == null) {
            return new ProjectInfoBo();
        }
        return (ProjectInfoBo)SerializationUtils.deSerializeFromBase64((String)cacheStr);
    }

    private DynamicObject getCacheProjectTeamDy() {
        return this.getProjectTeamDy(this.getCacheIsRootProjectTeam() ? 1010L : 1020L);
    }

    private DynamicObject getCurrentProjectTeamDy() {
        return this.getProjectTeamDy(this.isRootProjectTeam() ? 1010L : 1020L);
    }

    private DynamicObject getProjectTeamDy(long otClassifyId) {
        DynamicObjectType projectTeamDyType = this.getModel().getDataEntity().getDynamicObjectType();
        DynamicObjectType parentOrgDyType = ((BasedataProp)projectTeamDyType.getProperty("parentorg")).getDynamicComplexPropertyType();
        DynamicObjectType otClassifyDyType = ((BasedataProp)parentOrgDyType.getProperty("otclassify")).getDynamicComplexPropertyType();
        DynamicObject projectTeamDy = new DynamicObject(projectTeamDyType);
        DynamicObject parentOrgDy = new DynamicObject(parentOrgDyType);
        DynamicObject otClassifyDy = new DynamicObject(otClassifyDyType);
        projectTeamDy.set("parentorg", (Object)parentOrgDy);
        parentOrgDy.set("otclassify", (Object)otClassifyDy);
        otClassifyDy.set("id", (Object)otClassifyId);
        return projectTeamDy;
    }

    private boolean getCacheIsRootProjectTeam() {
        return this.getCacheProjectInfoBo().isRootProject();
    }

    private boolean isInfoChangePage() {
        String operateType = (String)this.getView().getFormShowParameter().getCustomParam("operate_type");
        return HRStringUtils.equals((String)"changeinfo", (String)operateType);
    }

    private boolean isParentChangePage() {
        String operateType = (String)this.getView().getFormShowParameter().getCustomParam("operate_type");
        return HRStringUtils.equals((String)"changeparent", (String)operateType);
    }

    private void rollBackProjectInfo() {
        this.getCacheProjectInfoBo().setValue2Dy(this.getModel().getDataEntity());
        this.getView().updateView("projectname");
        this.getView().updateView("projectnumber");
        this.getView().updateView("description");
    }

    static {
        REGISTER_BEFORE_F7_LISTENER.add("parentprojectteam");
        REGISTER_BEFORE_F7_LISTENER.add("belongadminorg");
    }
}

