/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.projectgroup.form;

import java.util.Date;
import java.util.EventObject;
import java.util.Optional;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class ProjectGroupShowEdit
extends HRDataBaseEdit
implements ProjectGroupMDConstants {
    public void afterLoadData(EventObject e) {
        if (!this.isRootProjectTeam()) {
            DynamicObject projectTeamDy = this.getModel().getDataEntity();
            this.getModel().setValue("projectname", projectTeamDy.get("rootprojectteam.projectname"));
            this.getModel().setValue("projectnumber", projectTeamDy.get("rootprojectteam.projectnumber"));
            this.getModel().setValue("description", projectTeamDy.get("rootprojectteam.description"));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isRootProjectTeam()) {
            FieldEdit projectNameEdit;
            BasedataEdit parentProjectTeamEdit = (BasedataEdit)this.getView().getControl("parentprojectteam");
            if (parentProjectTeamEdit != null) {
                parentProjectTeamEdit.setMustInput(false);
            }
            if ((projectNameEdit = (FieldEdit)this.getView().getControl("projectname")) != null) {
                projectNameEdit.setMustInput(true);
            }
        }
        this.setDateEditMaxDate();
        this.setProjectInfoCollapse();
        this.forceSetFormTitle();
    }

    private void forceSetFormTitle() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam("force_set_caption");
        if (customParam != null && Boolean.parseBoolean(customParam.toString())) {
            this.getView().setFormTitle(new LocaleString(formShowParameter.getCaption()));
        }
    }

    private void setProjectInfoCollapse() {
        Container projectInfoContainer = (Container)this.getControl("fs_projectinfo");
        if (projectInfoContainer == null) {
            return;
        }
        Object operateType = this.getView().getFormShowParameter().getCustomParam("operate_type");
        if (operateType != null && "addNew".equals(operateType.toString())) {
            projectInfoContainer.setCollapse(!this.isRootProjectTeam());
        }
    }

    private void setDateEditMaxDate() {
        Consumer<Control> setMaxDate = control -> Optional.ofNullable(control).ifPresent(dateEdit -> ((DateEdit)dateEdit).setMaxDate(new Date()));
        setMaxDate.accept(this.getControl("bsed"));
        setMaxDate.accept(this.getControl("startdate"));
    }

    private boolean isRootProjectTeam() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        return dataEntity.getLong("parentorg.otclassify.id") == 1010L;
    }
}

