/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.projectgroup.list;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.QueryResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRExactMatchBasedataListDataProvider;

public class ProjectBaseDataListDataProvider
extends HRExactMatchBasedataListDataProvider {
    private static final Log logger = LogFactory.getLog(ProjectBaseDataListDataProvider.class);
    private int realCount;
    private DynamicObjectCollection sortedDynamicObjectColl;

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection sortedDynObjColl = this.getSortedDynObjColl(start, limit);
        this.setParentName(sortedDynObjColl);
        return sortedDynObjColl;
    }

    private DynamicObjectCollection getSortedDynObjColl(int start, int limit) {
        DynamicObjectCollection resultColl;
        long startTime = System.currentTimeMillis();
        logger.info("ProjectBaseDataListDataProvider.getSortedDynObjColl is start");
        List listDataFilterList = super.getQFilters();
        List<QFilter> listDataFilterListCopy = this.getSortCodeFilterList(listDataFilterList);
        List<Object> orgObjIdList = this.getQueryMainEntityObjId(start, limit, listDataFilterListCopy);
        this.realCount = super.getRealCount();
        if (orgObjIdList == null) {
            super.setQFilters(listDataFilterList);
            return super.getData(start, limit);
        }
        List<Long> orgIdList = orgObjIdList.stream().filter(Objects::nonNull).map(orgObjId -> Long.parseLong(orgObjId.toString())).collect(Collectors.toList());
        this.sortedDynamicObjectColl = resultColl = this.sortDynObjColl(limit, orgIdList);
        logger.info("ProjectBaseDataListDataProvider.getSortedDynObjColl is end, orgIdList.size={}, cost={}", (Object)orgIdList.size(), (Object)(System.currentTimeMillis() - startTime));
        return resultColl;
    }

    private DynamicObjectCollection sortDynObjColl(int limit, List<Long> orgIdList) {
        QFilter idFilter = new QFilter("id", "in", orgIdList);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(idFilter);
        super.setQFilters(filterList);
        DynamicObjectCollection queryDynColl = super.getData(0, limit);
        DynamicObjectCollection resultColl = new DynamicObjectCollection(queryDynColl.getDynamicObjectType(), queryDynColl.getParent());
        Map<Long, DynamicObject> idDynMap = queryDynColl.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn, (k1, k2) -> k2));
        if (idDynMap == null) {
            return resultColl;
        }
        logger.info("orgIdList={}", (Object)SerializationUtils.toJsonString(orgIdList));
        for (Long sortedId : orgIdList) {
            DynamicObject sortedDynObj = idDynMap.get(sortedId);
            if (sortedDynObj == null) {
                logger.info("sortedId={}", (Object)sortedId);
                continue;
            }
            resultColl.add((Object)sortedDynObj);
        }
        return resultColl;
    }

    private List<QFilter> getSortCodeFilterList(List<QFilter> listDataFilterList) {
        ArrayList<QFilter> listDataFilterListCopy = new ArrayList<QFilter>(listDataFilterList.size());
        for (QFilter listDataFilter : listDataFilterList) {
            listDataFilterListCopy.add(listDataFilter.copy());
        }
        QFilter sortCodeCurrentVersionFilter = new QFilter("haos_adminorgstructure.iscurrentversion", "=", (Object)"1");
        sortCodeCurrentVersionFilter.and(new QFilter("haos_projteambaseinfo.iscurrentversion", "=", (Object)"1"));
        listDataFilterListCopy.add(sortCodeCurrentVersionFilter);
        return listDataFilterListCopy;
    }

    private List<Object> getQueryMainEntityObjId(int start, int limit, List<QFilter> listDataFilterListCopy) {
        String orderByExpr = this.getSortCodeOrderByExpr();
        long starTime = System.currentTimeMillis();
        logger.info("ProjectBaseDataListDataProvider.getQueryMainEntityObjId is start");
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"haos_projteamsortquery");
        List retDataList = HRQueryEntityHelper.getInstance().queryAllPkByKSql(queryEntityType, listDataFilterListCopy.toArray(new QFilter[0]), orderByExpr, start, limit);
        logger.info("ProjectBaseDataListDataProvider.getQueryMainEntityObjId is end,retDataList.size={},cost={}", (Object)(retDataList == null ? 0 : retDataList.size()), (Object)(System.currentTimeMillis() - starTime));
        return retDataList;
    }

    public QueryResult getQueryResult() {
        QueryResult queryResult = super.getQueryResult();
        if (this.sortedDynamicObjectColl == null) {
            return queryResult;
        }
        queryResult.setDataCount(this.realCount);
        queryResult.setBillDataCount(this.realCount);
        queryResult.setCollection(this.sortedDynamicObjectColl);
        return queryResult;
    }

    private String getSortCodeOrderByExpr() {
        String orderBy = super.getOrderByExpr();
        String orderByExpr = HRStringUtils.isEmpty((String)orderBy) ? "haos_adminorgstructure.level asc,index asc" : orderBy + ",haos_adminorgstructure.level asc,haos_projteambaseinfo.index asc";
        return orderByExpr;
    }

    private void setParentName(DynamicObjectCollection sortedDynObjColl) {
        sortedDynObjColl.forEach(datum -> {
            long otClassifyId;
            DynamicObject parentOrg = datum.getDynamicObject("parentorg");
            if (parentOrg != null && (otClassifyId = parentOrg.getLong("otclassify.id")) != 1020L) {
                parentOrg.set("name", (Object)"");
            }
        });
    }
}

