/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.projectgroup.list;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.ListHyperLinkClickEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.service.projectgroup.service.ProjectGroupBaseService;
import kd.hr.haos.business.servicehelper.ProjectGroupServiceHelper;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.formplugin.web.projectgroup.util.PrjOrgPermHelper;
import kd.hr.hbp.business.servicehelper.AppIdServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;
import org.apache.commons.lang3.StringUtils;

public class ProjectTeamListPlugin
extends HRDataBaseList
implements ProjectGroupMDConstants {
    private static final String FORBIDDEN = "forbidden";
    private static final String CALL_BACK_DISABLE = "callback_disable";
    private HRBaseServiceHelper orgTeamServiceHelper = new HRBaseServiceHelper("haos_adminorgteam");

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        HasPermOrgResult orgPermResult2;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("parentprojectteam.name".equals(fieldName)) {
            this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)"haos_projteambaseinfo");
            this.getView().getFormShowParameter().setCustomParam("parentprojectteam", (Object)"parentprojectteam");
            args.getCustomParams().put("customHREntityNumber", "haos_projteambaseinfo");
            args.getCustomParams().put("parentprojectteam", "parentprojectteam");
            this.getView().cacheFormShowParameter();
            QFilter permFilter = new QFilter("1", "=", (Object)1);
            HasPermOrgResult hrPermOrg = PrjOrgPermHelper.getOrgPermResult();
            Optional.of(hrPermOrg).filter(orgPermResult -> !orgPermResult.hasAllOrgPerm()).ifPresent(orgPermResult -> permFilter.and("org", "in", (Object)orgPermResult.getHasPermOrgs()));
            args.getCustomQFilters().add(permFilter);
            QFilter proTeamCoopOrgPermFilter = ProjectGroupBaseService.getInstance().getProTeamCoopOrgPermFilter("homs", "haos_projteambaseinfo", "parentorg");
            args.getCustomQFilters().add(proTeamCoopOrgPermFilter);
        } else {
            this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", null);
            this.getView().getFormShowParameter().setCustomParam("parentprojectteam", null);
            this.getView().cacheFormShowParameter();
        }
        if (("belongadminorg.name".equals(fieldName) || "belongadminorg.id".equals(fieldName)) && !(orgPermResult2 = PrjOrgPermHelper.getOrgPermResult()).hasAllOrgPerm()) {
            QFilter baseDataFilter = BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgdetail", (List)orgPermResult2.getHasPermOrgs());
            args.getCustomQFilters().add(baseDataFilter);
        }
    }

    public void setFilter(SetFilterEvent e) {
        this.convertFilter(e);
    }

    private void convertFilter(SetFilterEvent e) {
        Optional.ofNullable(e.getQFilters()).ifPresent(qFilterList -> {
            List newQFilterList = qFilterList.stream().filter(Objects::nonNull).map(this::mapFilter).collect(Collectors.toList());
            e.getQFilters().clear();
            e.getQFilters().addAll(newQFilterList);
        });
    }

    public void filterColumnSetFilter(SetFilterEvent event) {
        super.filterColumnSetFilter(event);
        String fieldName = event.getFieldName();
        if ("belongadminorg.name".equals(fieldName)) {
            QFilter permFilter = new QFilter("1", "=", (Object)1);
            HasPermOrgResult hrPermOrg = PrjOrgPermHelper.getOrgPermResult();
            Optional.of(hrPermOrg).filter(orgPermResult -> !orgPermResult.hasAllOrgPerm()).ifPresent(orgPermResult -> permFilter.and("org", "in", (Object)orgPermResult.getHasPermOrgs()));
            String hisCustomQFilters = this.getPageCache().get("hisCustomQFilters");
            Map customQFilterMap = HRStringUtils.isNotEmpty((String)hisCustomQFilters) ? (Map)SerializationUtils.fromJsonString((String)hisCustomQFilters, Map.class) : Maps.newHashMapWithExpectedSize((int)16);
            event.getCustomQFilters().add(permFilter);
            ArrayList customQFilters = Lists.newArrayListWithCapacity((int)10);
            customQFilters.add(permFilter.toSerializedString());
            customQFilterMap.put(fieldName, customQFilters);
            this.getPageCache().put("hisCustomQFilters", SerializationUtils.toJsonString(customQFilterMap));
        }
    }

    private HasPermOrgResult getOrgPermResult() {
        return OrgPermHelper.getHRPermOrg((String)"haos_projteambaseinfo");
    }

    private AuthorizedOrgResult getAuthorizedAdOrgResult() {
        long userId = RequestContext.get().getCurrUserId();
        String permItemId = "47150e89000000ac";
        ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String permEntityId = listParameter.getBillFormId();
        String entryAppId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)listParameter);
        String appId = AppIdServiceHelper.getPermAppId((String)entryAppId, (String)permEntityId);
        return (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgSet", (Object[])new Object[]{userId, appId, "haos_projteambaseinfo", permItemId, "boid"});
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter billShowParameter = e.getParameter();
        if (!billShowParameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            Object pkId = billShowParameter.getPkId();
            DynamicObject dataEntity = new HRBaseServiceHelper("haos_projteambaseinfo").queryOne("name", pkId);
            String name = dataEntity.getString("name");
            String prefix = ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f", (String)"ProjectTeamListPlugin_3", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            billShowParameter.setCaption(prefix + "-" + name);
            billShowParameter.setCustomParam("ue_param", (Object)"true");
            billShowParameter.setCustomParam("force_set_caption", (Object)"true");
        }
    }

    public void itemClickForbidden(String key) {
        if (FORBIDDEN.equals(key)) {
            List selectIds = this.getSelectedRows().stream().map(x -> (Long)x.getPrimaryKeyValue()).collect(Collectors.toList());
            if (selectIds.size() < 1) {
                return;
            }
            DynamicObject[] groups = ProjectGroupServiceHelper.getProjectGroupByFilters((QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectIds.toArray())});
            int enableCount = (int)Arrays.stream(groups).filter(x -> 1 == x.getInt("enable")).count();
            if (enableCount == selectIds.size()) {
                this.showDisableInfoPage();
                return;
            }
            int disableCount = (int)Arrays.stream(groups).filter(x -> 0 == x.getInt("enable")).count();
            if (disableCount == selectIds.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"ProjectTeamListPlugin_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showDisableInfoPage();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (!FORBIDDEN.equals(callBackId) || !"Yes".equals(evt.getResultValue())) {
            return;
        }
        this.showDisableInfoPage();
    }

    private void showDisableInfoPage() {
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.setFormId("haos_projectgroupforbidde");
        formShowParameter.setCustomParam("selectIds", this.getSelectedRows().stream().map(s -> (Long)s.getPrimaryKeyValue()).collect(Collectors.toList()));
        formShowParameter.setCustomParam("pkId", this.getSelectedRows().get(0).getPrimaryKeyValue());
        formShowParameter.setCustomParam("disableFlag1", (Object)Boolean.FALSE);
        formShowParameter.setCustomParam("operate_type", (Object)"donothing_disable");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_DISABLE));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        switch (operateKey) {
            case "donothing_new_parent": {
                DynamicObject adTeam = this.getCurrentNode();
                if (adTeam.getLong("otclassify.id") == 1020L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7236\u9879\u76ee\u56e2\u961f\u5fc5\u987b\u6210\u7acb\u5728\u884c\u653f\u7ec4\u7ec7\u4e0b\uff0c\u8bf7\u5728\u5de6\u6811\u9009\u62e9\u5bf9\u5e94\u7684\u884c\u653f\u7ec4\u7ec7\u3002", (String)"ProjectTeamListPlugin_6", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (!this.isCurNodeHasAdOrgPerm(adTeam)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u884c\u653f\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ProjectTeamListPlugin_8", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (!this.checkDisableData()) break;
                this.showNewProjectPage(operateKey);
                break;
            }
            case "donothing_new_son": {
                DynamicObject project = this.getCurrentNode();
                if (project.getLong("otclassify.id") == 1010L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u9879\u76ee\u56e2\u961f\u5fc5\u987b\u6210\u7acb\u5728\u9879\u76ee\u56e2\u961f\u4e0b\uff0c\u8bf7\u5728\u5de6\u6811\u9009\u62e9\u5bf9\u5e94\u9879\u76ee\u56e2\u961f\u3002", (String)"ProjectTeamListPlugin_7", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (!this.isCurNodeHasPrjOrgPerm(project)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u9879\u76ee\u56e2\u961f\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ProjectTeamListPlugin_9", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (!this.checkDisableData()) break;
                this.showNewProjectPage(operateKey);
                break;
            }
            case "cooprel_change": {
                this.showCoOpRelChangePage("coopreltype");
                break;
            }
            case "donothing_changeparent": {
                if (!this.isLegal(selectedRows)) break;
                this.showChangeInfoPage((Long)selectedRows.get(0).getPrimaryKeyValue(), "changeparent");
                break;
            }
            case "donothing_changeinfo": {
                if (!this.isLegal(selectedRows)) break;
                this.showChangeInfoPage((Long)selectedRows.get(0).getPrimaryKeyValue(), "changeinfo");
                break;
            }
            case "forbidden": {
                this.itemClickForbidden(FORBIDDEN);
                break;
            }
            case "donothing_memberjoin": {
                this.showMemberJoinPage();
                break;
            }
            case "enable_donothing": {
                if (afterDoOperationEventArgs.getOperationResult() == null || !afterDoOperationEventArgs.getOperationResult().isSuccess() && CollectionUtils.isEmpty((Collection)afterDoOperationEventArgs.getOperationResult().getSuccessPkIds())) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private boolean isCurNodeHasAdOrgPerm(DynamicObject adTeam) {
        QFilter permFilter = PrjOrgPermHelper.getAdOrgPermFilterWithBU();
        DynamicObject[] dynamicObjects = AdOrgRepository.getInstance().queryOriginalArray("boid", new QFilter[]{permFilter});
        Set permIdSet = Arrays.stream(dynamicObjects).map(dy -> dy.get("boid")).collect(Collectors.toSet());
        return permIdSet.contains(adTeam.getLong("boid"));
    }

    private boolean isCurNodeHasPrjOrgPerm(DynamicObject projectTeam) {
        QFilter permFilter = PrjOrgPermHelper.getPrjOrgPermFilterWithBU();
        DynamicObject[] dynamicObjects = PRJOrgRepository.getInstance().queryOriginalArray("boid", new QFilter[]{permFilter});
        Set permIdSet = Arrays.stream(dynamicObjects).map(dy -> dy.get("boid")).collect(Collectors.toSet());
        return permIdSet.contains(projectTeam.getLong("boid"));
    }

    public void packageData(PackageDataEvent e) {
        long otClassifyId;
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("parentorg.name".equals(columnDesc.getFieldKey()) && (otClassifyId = e.getRowData().getLong("parentorg.otclassify.id")) != 1020L) {
            e.setFormatValue((Object)"");
        }
    }

    private DynamicObject getCurrentNode() {
        ListView view = (ListView)this.getView();
        String currentNodeId = (String)view.getTreeListView().getTreeModel().getCurrentNodeId();
        QFilter filter = new QFilter("id", "=", (Object)Long.valueOf(currentNodeId));
        return this.orgTeamServiceHelper.queryOne("id,boid,name,otclassify.id", filter.toArray());
    }

    private void doMutex(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        List<String> list = Arrays.asList("cooprel_change", "donothing_changeparent", "donothing_changeinfo");
        if (!list.contains(operateKey)) {
            return;
        }
        StringBuilder errMsg = new StringBuilder();
        String entityId = "haos_projectgroupchange";
        String positionId = this.getSelectedRows().get(0).toString();
        if (!MutexHelper.require((String)entityId, (Object)positionId, (String)"modify", (boolean)true, (StringBuilder)errMsg)) {
            args.setCancel(true);
            this.getView().showTipNotification(errMsg.toString());
            return;
        }
        this.getView().getPageCache().put("isMutex", "true");
    }

    private void showNewProjectPage(String newType) {
        ListView view = (ListView)this.getView();
        Object currentNodeId = view.getTreeListView().getTreeModel().getCurrentNodeId();
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("haos_projectgroupadd");
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "haos_projectgroupadd"));
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.ADDNEW);
        baseShowParameter.setCustomParam("operate_type", (Object)"addNew");
        String caption = "";
        if (HRStringUtils.equals((String)newType, (String)"donothing_new_parent")) {
            caption = ResManager.loadKDString((String)"\u521b\u5efa\u9879\u76ee\u53ca\u56e2\u961f", (String)"ProjectTeamListPlugin_4", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
        } else if (HRStringUtils.equals((String)newType, (String)"donothing_new_son")) {
            caption = ResManager.loadKDString((String)"\u65b0\u589e\u5b50\u9879\u76ee\u56e2\u961f", (String)"ProjectTeamListPlugin_5", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
        }
        baseShowParameter.setCaption(caption);
        baseShowParameter.setCustomParam("newType", (Object)newType);
        baseShowParameter.setCustomParam("currentNodeId", currentNodeId);
        baseShowParameter.setCustomParam("ue_param", (Object)"true");
        view.showForm((FormShowParameter)baseShowParameter);
    }

    private boolean checkDisableData() {
        ListView view = (ListView)this.getView();
        Object currentNodeId = view.getTreeListView().getTreeModel().getCurrentNodeId();
        if (currentNodeId == null || StringUtils.isEmpty((CharSequence)currentNodeId.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u4e0a\u7ea7\u7ec4\u7ec7\u3002", (String)"PositionTeamListPlugin_6", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return false;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_projteambaseinfo");
        Long pkValue = Long.valueOf(currentNodeId.toString());
        DynamicObject projectGroupDyn = serviceHelper.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)pkValue)});
        if (projectGroupDyn == null) {
            return true;
        }
        String enable = projectGroupDyn.getString("enable");
        if ("0".equals(enable)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u7ea7\u5df2\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PositionTeamListPlugin_5", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isLegal(ListSelectedRowCollection selectedRows) {
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u53d8\u66f4\u3002", (String)"PositionTeamListPlugin_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"PositionTeamListPlugin_2", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return false;
        }
        ListSelectedRowCollection selectedRowCollection = selectedRows.getBillListSelectedRowCollection();
        Long pkValue = (Long)selectedRowCollection.get(0).getPrimaryKeyValue();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_projteambaseinfo");
        DynamicObject projectGroupDyn = serviceHelper.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)pkValue)});
        String enable = projectGroupDyn.getString("enable");
        if ("0".equals(enable)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u53d8\u66f4\u5df2\u7981\u7528\u7684\u9879\u76ee\u56e2\u961f\u4fe1\u606f\u3002", (String)"PositionTeamListPlugin_3", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void showMemberJoinPage() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (this.isLegal(selectedRows)) {
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("ptmm_teammemberjoin");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ptmm_teammemberjoin"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("projectTeamId", this.getSelectedRows().stream().map(x -> (Long)x.getPrimaryKeyValue()).toArray()[0]);
            String prefix = ResManager.loadKDString((String)"\u52a0\u5165\u6210\u5458", (String)"ProjectTeamListPlugin_3", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            showParameter.setCaption(prefix + "-" + this.getSelectedRows().get(0).getName());
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void showChangeInfoPage(Long id, String operatetype) {
        if (id != 0L) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setFormId("haos_projectgroupchange");
            ArrayList idList = Lists.newArrayListWithExpectedSize((int)16);
            idList.add(id);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_projteambaseinfo");
            DynamicObject[] projectGroups = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)idList)});
            String prefix = ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f", (String)"ProjectTeamListPlugin_3", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            showParameter.setCaption(prefix + "-" + projectGroups[0].getString("name"));
            showParameter.setCustomParam("operate_type", (Object)operatetype);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setPkId((Object)id);
            showParameter.setCustomParam("ue_param", (Object)"true");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void showCoOpRelChangePage(String operatetype) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (this.isLegal(selectedRows)) {
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("haos_projteamcooprelalter");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "haos_projteamcooprelalter"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("operate_type", (Object)operatetype);
            showParameter.setPkId(this.getSelectedRows().stream().map(x -> (Long)x.getPrimaryKeyValue()).toArray()[0]);
            String prefix = ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f", (String)"ProjectTeamListPlugin_3", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            showParameter.setCaption(prefix + "-" + this.getSelectedRows().get(0).getName());
            showParameter.setCustomParam("fromPage", (Object)"page_custom_param");
            showParameter.setCustomParam("ue_param", (Object)"true");
            showParameter.setCustomParam("force_set_caption", (Object)"true");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        IFormView view = this.getView();
        if ("haos_projectgroupadd".equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                Map map = (Map)returnData;
                String operateKey = (String)map.get("operateKey");
                if (HRStringUtils.equals((String)operateKey, (String)"donothing_saveandnew")) {
                    this.showNewProjectPage((String)map.get("newType"));
                }
                view.invokeOperation("refresh");
                view.sendFormAction(view);
            }
        } else if (CALL_BACK_DISABLE.equals(actionId)) {
            OperateOption operateOption = OperateOption.create();
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData == null || returnData.size() <= 0) {
                return;
            }
            operateOption.setVariableValue("bsed", returnData.get("bsed").toString());
            operateOption.setVariableValue("changescene", returnData.get("changescene").toString());
            operateOption.setVariableValue("changereason", returnData.get("changereason").toString());
            operateOption.setVariableValue("changeoperate", returnData.get("changeoperate").toString());
            operateOption.setVariableValue("interactionconfirmresult", "interactionconfirmresult");
            OperationResult result = this.getView().invokeOperation("disable_donothing", operateOption);
            if (result.isSuccess()) {
                view.invokeOperation("refresh");
                view.sendFormAction(view);
            }
        }
    }

    public void hyperLinkClick(ListHyperLinkClickEvent event) {
        this.getView().getFormShowParameter().setCustomParam("operate_type", (Object)"detail");
    }

    private QFilter mapFilter(QFilter qFilter) {
        QFilter mappedFilter;
        String property;
        switch (property = qFilter.getProperty()) {
            case "parentprojectteam.id": {
                mappedFilter = new QFilter("parentorg.id", qFilter.getCP(), qFilter.getValue());
                break;
            }
            case "projectname": {
                mappedFilter = new QFilter("rootprojectteam.projectname", qFilter.getCP(), qFilter.getValue());
                break;
            }
            case "projectnumber": {
                mappedFilter = new QFilter("rootprojectteam.projectnumber", qFilter.getCP(), qFilter.getValue());
                break;
            }
            case "description": {
                mappedFilter = new QFilter("rootprojectteam.description", qFilter.getCP(), qFilter.getValue());
                break;
            }
            default: {
                mappedFilter = qFilter;
            }
        }
        return mappedFilter;
    }
}

