/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.staff.form;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.TaskInfo;
import kd.hr.haos.business.domain.service.impl.staff.StaffProjectServiceImpl;
import kd.hr.haos.business.domain.service.impl.staff.SyncPersonStaffServiceImpl;
import kd.hr.haos.business.domain.service.staff.IStaffProjectService;
import kd.hr.haos.business.domain.service.staff.ISyncPersonStaffService;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class OrgParameterconsoleEdit
extends HRDataBaseEdit
implements OrgStaffConstants {
    private static final Log logger = LogFactory.getLog(OrgParameterconsoleEdit.class);
    private IStaffProjectService staffProjectService = new StaffProjectServiceImpl();
    private ISyncPersonStaffService syncPersonStaffService = new SyncPersonStaffServiceImpl();
    private static final String TASKCLOSEBACK = "taskcloseback";
    private boolean ruleChange = false;

    public void initialize() {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (!HRStringUtils.equals((String)"save", (String)itemKey)) {
            return;
        }
        this.handleSpecialRulePolicy(evt);
    }

    private DynamicObject getConfigDyn() {
        IFormView parameterView = this.getView().getViewNoPlugin(this.getPageCache().get("TabParaSettings_PageId"));
        IDataModel parameterModel = (IDataModel)parameterView.getService(IDataModel.class);
        return parameterModel.getDataEntity();
    }

    private void handleSpecialRulePolicy(BeforeItemClickEvent evt) {
        String newSpecialRule;
        String ruleOrg;
        Long orgId = this.getOrgId();
        Map specialRuleFormSys = this.syncPersonStaffService.getSystemParameterRule(orgId);
        String oldSpeicalRule = specialRuleFormSys.getOrDefault("rule", "").toString();
        DynamicObject newConfigDyn = this.getConfigDyn();
        String newSpecialRuleStr = newConfigDyn.getString("staffspecialrule");
        Map newRuleMap = (Map)JSONObject.parseObject((String)newSpecialRuleStr, Map.class);
        if (newRuleMap == null) {
            newRuleMap = Maps.newHashMapWithExpectedSize((int)8);
        }
        if (!HRStringUtils.equals((String)(ruleOrg = String.valueOf(newRuleMap.getOrDefault("org", 0L))), (String)String.valueOf(orgId))) {
            newRuleMap.clear();
        }
        if (!HRStringUtils.equals((String)oldSpeicalRule, (String)(newSpecialRule = newRuleMap.getOrDefault("rule", "").toString()))) {
            boolean sync = this.syncPersonStaffService.isOrgSyncIng(orgId);
            if (sync) {
                evt.setCancel(true);
                String msg = ResManager.loadKDString((String)"\u4e0a\u4e00\u6b21\u4e0d\u5360\u7f16\u89c4\u5219\u4fee\u6539\u672a\u5b8c\u6210\u540c\u6b65\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"OrgParameterconsoleEdit_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return;
            }
            this.ruleChange = true;
            if (newRuleMap.size() != 0) {
                Long newPolicyId = this.staffProjectService.addPolicy(newRuleMap);
                if (newPolicyId == null || newPolicyId == 0L) {
                    evt.setCancel(true);
                    String msg = ResManager.loadKDString((String)"\u4fee\u6539\u4e0d\u5360\u7f16\u89c4\u5219\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"OrgParameterconsoleEdit_3", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(msg);
                    return;
                }
                newRuleMap.put("policyid", newPolicyId);
                newConfigDyn.set("staffspecialrule", (Object)JSONObject.toJSONString((Object)newRuleMap));
            }
            this.syncPersonStaffService.cacheSyncIngTag(orgId, true);
            this.staffProjectService.delPolicy(Long.valueOf(((Object)specialRuleFormSys.getOrDefault("policyid", 0L)).toString()));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (HRStringUtils.equals((String)itemKey, (String)"save")) {
            Long orgId = this.getOrgId();
            if (this.ruleChange) {
                String taskName = String.format(Locale.ROOT, ResManager.loadKDString((String)"[\u6279\u91cf\u540c\u6b65]-%s-\u5458\u5de5\u5360\u7f16\u4fe1\u606f", (String)"OrgParameterconsoleEdit_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), this.getOrgName());
                Date firstDayOfCurYear = OrgDateTimeUtil.getFirstDayOfCurYear();
                this.syncPersonStaffService.dispatchSyncSpecialRuleStaffTask(orgId, taskName, new CloseCallBack((IFormPlugin)this, TASKCLOSEBACK), this.getView(), firstDayOfCurYear);
            } else {
                this.syncPersonStaffService.cacheSyncIngTag(orgId, false);
            }
        }
    }

    private Long getOrgId() {
        return Optional.ofNullable(this.getModel().getDataEntity().getDynamicObject("orgfield")).map(it -> it.getLong("id")).orElse(0L);
    }

    private String getOrgName() {
        return Optional.ofNullable(this.getModel().getDataEntity().getDynamicObject("orgfield")).map(it -> it.getString("name")).orElse("");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)TASKCLOSEBACK)) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    private void taskCallBack(Object returnData) {
        if (!(returnData instanceof Map)) {
            return;
        }
        Map result = (Map)returnData;
        String taskInfoStr = (String)result.get("taskinfo");
        if (HRStringUtils.isBlank((CharSequence)taskInfoStr)) {
            return;
        }
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
        if (!taskInfo.isTaskEnd()) {
            return;
        }
        String data = taskInfo.getData();
        Map dataMap = (Map)JSONObject.parseObject((String)data, Map.class);
        if (dataMap == null) {
            return;
        }
        Boolean success = (Boolean)dataMap.get("success");
        if (success != null && success.booleanValue()) {
            String msg = ResManager.loadKDString((String)"[\u6279\u91cf\u540c\u6b65]-\u5458\u5de5\u5360\u7f16\u4fe1\u606f\u4efb\u52a1\u5b8c\u6210", (String)"OrgParameterconsoleEdit_2", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(msg);
        }
    }
}

