/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.staff.form;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.haos.formplugin.web.staff.service.StaffFormService;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class OrgStaffChangeEdit
extends HRDataBaseEdit
implements OrgStaffConstants {
    public void beforeBindData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        OperationStatus operateStatus = view.getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)operateStatus) && !"true".equals(this.getPageCache().get("isInit"))) {
            StaffFormService staffFormService = StaffFormService.create(view, model);
            staffFormService.staffProjectChanged(model.getDataEntity(true).getDynamicObject("staffproject"));
            staffFormService.setDimensionBtnVisible();
            model.setDataChanged(false);
        }
        this.setEntryLongName();
        this.setCopyButtonVisible();
    }

    private void setCopyButtonVisible() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        String enable = dataEntity.getString("enable");
        if (!HRStringUtils.equals((String)enable, (String)"10")) {
            DynamicObject staffCycleDyn = dataEntity.getDynamicObject("staffcycle");
            long id = staffCycleDyn.getLong("id");
            Date now = new Date();
            Date year = dataEntity.getDate("year");
            int curYearInt = HRDateTimeUtils.getYear((Date)now);
            int yearInt = HRDateTimeUtils.getYear((Date)year);
            if (id == STAFF_CYCLE_MONTH && yearInt < curYearInt) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"copyuseorgdetail", "copymuldimendetail"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        String enable = dataEntity.getString("enable");
        super.beforeDoOperation(args);
        this.getPageCache().put("isInit", null);
        if ("importuseorgdetail".equals(operateKey)) {
            this.getPageCache().put("isInit", "true");
        }
    }

    private void setEntryLongName() {
        List<DynamicObject> list;
        DynamicObjectCollection useOrgEntry = this.getModel().getEntryEntity("bentryentity");
        if (CollectionUtils.isEmpty((Collection)useOrgEntry)) {
            return;
        }
        OperationStatus operateStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)operateStatus)) {
            StaffFormService.create(this.getView(), this.getModel()).setVisibleByUseOrg();
        }
        if (CollectionUtils.isEmpty(list = useOrgEntry.stream().filter(dy -> HRStringUtils.isEmpty((String)dy.getString("bparentlongname")) && dy.getLong("buseorg.id") != PlatformRootUtils.getLongRootIdOfPlatform()).collect(Collectors.toList()))) {
            return;
        }
        Set adminOrgIds = list.stream().map(dyn -> dyn.getLong("buseorg.id")).collect(Collectors.toSet());
        Map orgLongNameMap = StaffCommonService.getOrgNameMap(adminOrgIds, (Date)new Date());
        list.forEach(dy -> dy.set("bparentlongname", orgLongNameMap.get(dy.getLong("buseorg.id"))));
    }

    public void afterBindData(EventObject event) {
        StaffFormService.create(this.getView()).setEntryFieldEnable();
    }
}

