/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.staff.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageCallBackType;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.haos.business.domain.repository.staff.StaffRepository;
import kd.hr.haos.business.service.staff.bean.DimensionEntryParamBO;
import kd.hr.haos.business.service.staff.bean.StaffProjectBo;
import kd.hr.haos.business.service.staff.bean.UseOrgEntryParamBO;
import kd.hr.haos.business.service.staff.helper.StaffEntryTempHelperEnum;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.business.service.staff.service.StaffEntryHelper;
import kd.hr.haos.business.service.staff.service.StaffExtEntryHelper;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.haos.business.util.TimeLogger;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.formplugin.web.staff.helper.OrgStaffFormOperationHelper;
import kd.hr.haos.formplugin.web.staff.service.StaffFormService;
import kd.hr.haos.formplugin.web.staff.service.StaffInitEntryDataService;
import kd.hr.haos.formplugin.web.staff.service.StaffSummaryCalcService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class OrgStaffMainEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
AfterF7SelectListener,
RowClickEventListener,
TabSelectListener,
OrgStaffConstants {
    private static final Log logger = LogFactory.getLog(OrgStaffMainEdit.class);
    private TimeLogger timeLogger = TimeLogger.create();
    private static final String STAFF_CYCLE_CHANGE_CALL_BACK = "staffCycleChangeCallBack";
    private static final String DIMENSION_CHANGE_CACHE_KEY = "dimensionChange";
    private HRBaseServiceHelper orgStaffHelper = new HRBaseServiceHelper("haos_staff");
    private Map<Long, String> dimensionIdVsEntryNameMap = Maps.newHashMapWithExpectedSize((int)3);
    private Map<Long, String> dimensionIdVsPrefixNameMap = Maps.newHashMapWithExpectedSize((int)3);
    private StaffExtEntryHelper staffExtEntryHelper = new StaffExtEntryHelper();

    private void initDimMap() {
        if (this.dimensionIdVsEntryNameMap.size() == 0 || this.dimensionIdVsPrefixNameMap.size() == 0) {
            this.dimensionIdVsEntryNameMap.put(1010L, "centryentity");
            this.dimensionIdVsEntryNameMap.put(1020L, "dentryentity");
            this.dimensionIdVsEntryNameMap.put(1050L, "eentryentity");
            this.dimensionIdVsPrefixNameMap.put(1010L, "c");
            this.dimensionIdVsPrefixNameMap.put(1020L, "d");
            this.dimensionIdVsPrefixNameMap.put(1050L, "e");
            for (DynamicObject extDim : this.staffExtEntryHelper.getExtDim()) {
                long dimId = extDim.getLong("id");
                String prefix = this.staffExtEntryHelper.getExtDimPrefix(extDim.getString("staffdimension"));
                this.dimensionIdVsEntryNameMap.put(dimId, prefix + "entryentity");
                this.dimensionIdVsPrefixNameMap.put(dimId, prefix);
            }
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit orgTeam = (BasedataEdit)this.getView().getControl("orgteam");
        orgTeam.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("bentryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit staffProject = (BasedataEdit)this.getView().getControl("staffproject");
        staffProject.addAfterF7SelectListener((AfterF7SelectListener)this);
        staffProject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit useOrg = (BasedataEdit)this.getView().getControl("buseorg");
        useOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        IFormView view = this.getView();
        if (OperationStatus.VIEW.equals((Object)status)) {
            Tab tab = (Tab)view.getControl("tabap");
            String currentTab = tab.getCurrentTab();
            view.setVisible(Boolean.TRUE, new String[]{"exportuseorgdetail", "flexpanelap5", "flexpanelap2"});
            view.setVisible(Boolean.valueOf("tabpage_job".equals(currentTab)), new String[]{"exportjob"});
            view.setVisible(Boolean.valueOf("tabpage_laborreltype".equals(currentTab)), new String[]{"exportlaborreltype"});
            view.setVisible(Boolean.valueOf("tabpage_position".equals(currentTab)), new String[]{"exportposition"});
            view.updateView("exportjob");
            view.updateView("exportlaborreltype");
            view.updateView("exportposition");
            view.updateView("exportuseorgdetail");
            for (DynamicObject extDim : this.staffExtEntryHelper.getExtDim()) {
                String dimName = extDim.getString("staffdimension");
                String extTabName = "tabpage_" + dimName;
                String exportButtonName = "export" + dimName;
                view.setVisible(Boolean.valueOf(extTabName.equals(currentTab)), new String[]{exportButtonName});
                view.updateView(exportButtonName);
            }
            view.updateView("flexpanelap2");
        }
    }

    public void afterBindData(EventObject event) {
        OperationStatus status;
        boolean haveImportData = this.setEntryValueForImport();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        IFormView view = this.getView();
        this.setButtonVisible(view);
        this.setBaseInfoInteraction();
        DynamicObject org = (DynamicObject)model.getValue("org");
        String clickImportCacheStr = this.getPageCache().get("clickImport");
        StaffFormService staffFormService = StaffFormService.create(this.getView(), this.getModel());
        if (!HRStringUtils.equals((String)clickImportCacheStr, (String)"true") && org != null) {
            StaffInitEntryDataService.create(view, (IDataModel)model).loadEntryData();
            StaffFormService.create(view, (IDataModel)model).setVisibleByUseOrg();
        } else {
            this.getPageCache().remove("clickImport");
            if (haveImportData) {
                StaffInitEntryDataService.create(view, (IDataModel)model).buildStaffNumWithSub(staffFormService);
            }
            if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
                int focusRowIndex = ((EntryGrid)this.getView().getControl("bentryentity")).getEntryState().getFocusRow();
                staffFormService.setUseOrgEntryAndMultiEntryEnableForPerm(focusRowIndex);
            }
        }
        staffFormService.setDefaultOrgTeam();
        StringBuilder errMsg = new StringBuilder();
        Long staffId = this.getModel().getDataEntity().getLong("id");
        if (!MutexHelper.require((IFormView)view, (String)"haos_staff", (Object)staffId, (String)"modify", (boolean)true, (StringBuilder)errMsg)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_modify", "bar_enable", "bar_disable"});
            this.getView().showTipNotification(errMsg.toString());
        }
        if (OperationStatus.VIEW.equals((Object)(status = this.getView().getFormShowParameter().getStatus()))) {
            Tab tab = (Tab)view.getControl("tabap");
            String currentTab = tab.getCurrentTab();
            view.setVisible(Boolean.TRUE, new String[]{"exportuseorgdetail", "flexpanelap5", "flexpanelap2", "flexpanelap7"});
            view.setVisible(Boolean.valueOf("tabpage_job".equals(currentTab)), new String[]{"exportjob"});
            view.setVisible(Boolean.valueOf("tabpage_laborreltype".equals(currentTab)), new String[]{"exportlaborreltype"});
            view.setVisible(Boolean.valueOf("tabpage_position".equals(currentTab)), new String[]{"exportposition"});
            view.updateView("exportjob");
            view.updateView("exportlaborreltype");
            view.updateView("exportposition");
            view.updateView("exportuseorgdetail");
            for (DynamicObject extDim : this.staffExtEntryHelper.getExtDim()) {
                String dimName = extDim.getString("staffdimension");
                String extTabName = "tabpage_" + dimName;
                String exportButtonName = "export" + dimName;
                view.setVisible(Boolean.valueOf(extTabName.equals(currentTab)), new String[]{exportButtonName});
                view.updateView(exportButtonName);
            }
            view.updateView("flexpanelap2");
        }
        model.setDataChanged(false);
    }

    private boolean setEntryValueForImport() {
        List prefixList = StaffEntryTempHelperEnum.getPrefixListExcludeDutyOrg();
        boolean noData = true;
        for (String prefix : prefixList) {
            String importEntryName = StaffCommonService.addPrefixAndPostfix((String)prefix, (String)"entryentity");
            try {
                DynamicObjectCollection importEntryDynCol = this.getView().getModel().getEntryEntity(importEntryName);
                if (CollectionUtils.isEmpty((Collection)importEntryDynCol)) continue;
                noData = false;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (noData) {
            return false;
        }
        HashMap useOrgNumberVsDynMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap orgNumkeyNumVsDynMap = Maps.newHashMapWithExpectedSize((int)16);
        this.buildImportEntryMap(prefixList, useOrgNumberVsDynMap, orgNumkeyNumVsDynMap);
        Map<Long, List<String>> orgBoIdVsPreKeyFieldStrMap = this.buildMultiEntryPageMap();
        this.setEntryValueForImport(useOrgNumberVsDynMap, orgNumkeyNumVsDynMap, orgBoIdVsPreKeyFieldStrMap);
        StaffEntryHelper.deleteEntryDataByPrefix((AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), (List)prefixList);
        return true;
    }

    private Map<Long, List<String>> buildMultiEntryPageMap() {
        HashMap orgBoIdVsPreKeyFieldStrMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObjectCollection useOrgEntryDynCol = this.getView().getModel().getEntryEntity("bentryentity");
        List multiPrefixList = StaffEntryTempHelperEnum.getMultiPrefixList();
        for (DynamicObject useOrgEntryDyn : useOrgEntryDynCol) {
            long useOrgBoId = useOrgEntryDyn.getLong("buseorg.boid");
            for (String multiPrefix : multiPrefixList) {
                String keyFieldIdNameStr = multiPrefix + StaffEntryTempHelperEnum.getKeyFieldByPrefix((String)multiPrefix) + ".id";
                String multiEntryName = multiPrefix + "entryentity";
                DynamicObjectCollection multiEntryDynCol = useOrgEntryDyn.getDynamicObjectCollection(multiEntryName);
                if (CollectionUtils.isEmpty((Collection)multiEntryDynCol) && Objects.isNull(orgBoIdVsPreKeyFieldStrMap.get(useOrgBoId))) {
                    orgBoIdVsPreKeyFieldStrMap.put(useOrgBoId, Lists.newArrayListWithExpectedSize((int)16));
                    continue;
                }
                for (DynamicObject multiEntryDyn : multiEntryDynCol) {
                    long keyFieldId = multiEntryDyn.getLong(keyFieldIdNameStr);
                    String value = multiPrefix + keyFieldId;
                    List prefixKeyFieldList = (List)orgBoIdVsPreKeyFieldStrMap.get(useOrgBoId);
                    if (prefixKeyFieldList == null) {
                        prefixKeyFieldList = Lists.newArrayListWithExpectedSize((int)16);
                    }
                    prefixKeyFieldList.add(value);
                    orgBoIdVsPreKeyFieldStrMap.put(useOrgBoId, prefixKeyFieldList);
                }
            }
        }
        return orgBoIdVsPreKeyFieldStrMap;
    }

    private void buildImportEntryMap(List<String> prefixList, Map<String, DynamicObject> useOrgNumberVsDynMap, Map<String, Map<String, DynamicObject>> orgNumkeyNumVsDynMap) {
        for (String prefix : prefixList) {
            String importEntryName = StaffCommonService.addPrefixAndPostfix((String)prefix, (String)"entryentity");
            DynamicObjectCollection importEntryDynCol = this.getView().getModel().getEntryEntity(importEntryName);
            if (HRStringUtils.equals((String)prefix, (String)"b")) {
                for (DynamicObject importEntryDyn : importEntryDynCol) {
                    useOrgNumberVsDynMap.put(importEntryDyn.getString(StaffCommonService.addPrefixAndPostfix((String)prefix, (String)"useorg") + ".number"), importEntryDyn);
                }
                continue;
            }
            for (DynamicObject importEntryDyn : importEntryDynCol) {
                String orgNumStr = importEntryDyn.getString(StaffCommonService.addPrefixAndPostfix((String)prefix, (String)"useorg") + ".number");
                String keyField = StaffEntryTempHelperEnum.getKeyFieldByPrefix((String)prefix);
                String keyFieldNumStr = importEntryDyn.getString(StaffCommonService.addPrefixAndPostfix((String)prefix, (String)keyField) + ".id");
                String prefixKeyFieldNumStr = prefix + keyFieldNumStr;
                Map<String, DynamicObject> prefixKeyNumVsDynMap = orgNumkeyNumVsDynMap.getOrDefault(orgNumStr, Maps.newHashMapWithExpectedSize((int)16));
                prefixKeyNumVsDynMap.put(prefixKeyFieldNumStr, importEntryDyn);
                orgNumkeyNumVsDynMap.put(orgNumStr, prefixKeyNumVsDynMap);
            }
        }
    }

    private void setEntryValueForImport(Map<String, DynamicObject> useOrgNumberVsDynMap, Map<String, Map<String, DynamicObject>> orgNumkeyNumVsDynMap, Map<Long, List<String>> orgBoIdVsPreKeyFieldStrMap) {
        String useOrgEntryName = "bentryentity";
        DynamicObjectCollection useOrgDynCol = this.getView().getModel().getEntryEntity(useOrgEntryName);
        for (int parentIndex = 0; parentIndex < useOrgDynCol.size(); ++parentIndex) {
            DynamicObject useOrgDyn = (DynamicObject)useOrgDynCol.get(parentIndex);
            String useOrgNum = useOrgDyn.getString("buseorg.number");
            Long useOrgBoId = useOrgDyn.getLong("buseorg.boid");
            List<String> prefixKeyFieldStrList = orgBoIdVsPreKeyFieldStrMap.get(useOrgBoId);
            this.updateUseOrgEntryForImport(useOrgNumberVsDynMap, useOrgNum, parentIndex);
            Map<String, DynamicObject> prefixKeyNumVsDynMap = orgNumkeyNumVsDynMap.get(useOrgNum);
            if (Objects.isNull(prefixKeyNumVsDynMap)) continue;
            this.newMultiEntryDynForImport(useOrgDyn, prefixKeyFieldStrList, prefixKeyNumVsDynMap);
            this.updateMultiEntryDynForImport(useOrgDyn, prefixKeyNumVsDynMap, parentIndex);
        }
    }

    private void updateUseOrgEntryForImport(Map<String, DynamicObject> useOrgNumberVsDynMap, String useOrgNum, int parentIndex) {
        DynamicObject useOrgImporDyn = useOrgNumberVsDynMap.get(useOrgNum);
        if (Objects.nonNull(useOrgImporDyn)) {
            List useOrgEntryFields = StaffEntryTempHelperEnum.getEntryFieldsByPrefix((String)"b");
            for (String useOrgEntryField : useOrgEntryFields) {
                boolean colNotWrite;
                String entryField = StaffCommonService.addPrefix((String)"b", (String)useOrgEntryField);
                String importEntryField = HRStringUtils.equals((String)"yearstaffnumwithsub", (String)useOrgEntryField) ? "b" + useOrgEntryField + "_impo" : StaffCommonService.addPrefixAndPostfix((String)"b", (String)useOrgEntryField);
                Object importFieldValue = useOrgImporDyn.get(importEntryField);
                boolean intNotWrite = importFieldValue instanceof Integer && (Integer)importFieldValue == 0;
                boolean bl = colNotWrite = importFieldValue instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)importFieldValue));
                if (!Objects.nonNull(importFieldValue) || intNotWrite || colNotWrite) continue;
                this.getView().getModel().setValue(entryField, importFieldValue, parentIndex);
            }
        }
    }

    private void updateMultiEntryDynForImport(DynamicObject useOrgDyn, Map<String, DynamicObject> prefixKeyNumVsDynMap, int parentIndex) {
        List multiPrefixList = StaffEntryTempHelperEnum.getMultiPrefixList();
        for (String multiPrefix : multiPrefixList) {
            DynamicObjectCollection multiEntryDynCol = useOrgDyn.getDynamicObjectCollection(StaffCommonService.addPrefix((String)multiPrefix, (String)"entryentity"));
            for (int subIndex = 0; subIndex < multiEntryDynCol.size(); ++subIndex) {
                DynamicObject multiDyn = (DynamicObject)multiEntryDynCol.get(subIndex);
                String keyField = StaffEntryTempHelperEnum.getKeyFieldByPrefix((String)multiPrefix);
                String keyFieldNum = multiDyn.getString(StaffCommonService.addPrefix((String)multiPrefix, (String)keyField) + ".id");
                String prefixKeyNumStr = multiPrefix + keyFieldNum;
                DynamicObject multiImportDyn = prefixKeyNumVsDynMap.get(prefixKeyNumStr);
                if (!Objects.nonNull(multiImportDyn)) continue;
                List multiEntryFields = StaffEntryTempHelperEnum.getEntryFieldsByPrefix((String)multiPrefix);
                for (String multiEntryField : multiEntryFields) {
                    String importEntryField = StaffCommonService.addPrefixAndPostfix((String)multiPrefix, (String)multiEntryField);
                    Object importFieldValue = multiImportDyn.get(importEntryField);
                    if (!Objects.nonNull(importFieldValue)) continue;
                    this.getView().getModel().setValue(StaffCommonService.addPrefix((String)multiPrefix, (String)multiEntryField), importFieldValue, subIndex, parentIndex);
                }
            }
        }
        this.getView().updateView("centryentity");
        this.getView().updateView("dentryentity");
        this.getView().updateView("eentryentity");
        for (String prefix : this.staffExtEntryHelper.getExtDimPrefix()) {
            this.getView().updateView(prefix + "entryentity");
        }
    }

    private void newMultiEntryDynForImport(DynamicObject useOrgDyn, List<String> prefixKeyFieldStrList, Map<String, DynamicObject> prefixKeyNumVsDynMap) {
        Set<Map.Entry<String, DynamicObject>> prefixKeyNumVsDynEntries = prefixKeyNumVsDynMap.entrySet();
        HashSet keyFieldIds = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry<String, DynamicObject> prefixKeyNumVsDynEntry : prefixKeyNumVsDynEntries) {
            String prefix = prefixKeyNumVsDynEntry.getKey().substring(0, 1);
            String entryName = prefix + "entryentity";
            DynamicObjectCollection multiEntryDynCol = useOrgDyn.getDynamicObjectCollection(entryName);
            String keyFieldName = prefix + StaffEntryTempHelperEnum.getKeyFieldByPrefix((String)prefix);
            String keyFieldImportName = keyFieldName + "_import";
            DynamicObject multiImportDyn = prefixKeyNumVsDynEntry.getValue();
            long keyFieldId = multiImportDyn.getLong(keyFieldImportName + ".id");
            if (prefixKeyFieldStrList.contains(prefix + keyFieldId)) continue;
            DynamicObject multiEmptyEntryDyn = this.orgStaffHelper.generateEmptyEntryDynamicObject(StaffCommonService.addPrefix((String)prefix, (String)"entryentity"));
            List multiEntryFields = StaffEntryTempHelperEnum.getEntryFieldsByPrefix((String)prefix);
            for (String multiEntryField : multiEntryFields) {
                String importEntryField = StaffCommonService.addPrefixAndPostfix((String)prefix, (String)multiEntryField);
                Object importFieldValue = multiImportDyn.get(importEntryField);
                if (!Objects.nonNull(importFieldValue)) continue;
                multiEmptyEntryDyn.set(StaffCommonService.addPrefix((String)prefix, (String)multiEntryField), importFieldValue);
            }
            multiEmptyEntryDyn.set(keyFieldName, multiImportDyn.get(keyFieldImportName));
            multiEntryDynCol.add((Object)multiEmptyEntryDyn);
            keyFieldIds.add(keyFieldId);
        }
        this.putDimensionIdToCache(useOrgDyn.getLong("buseorg.boid"), keyFieldIds);
        this.getView().updateView("centryentity");
        this.getView().updateView("dentryentity");
        this.getView().updateView("eentryentity");
        for (String prefix : this.staffExtEntryHelper.getExtDimPrefix()) {
            this.getView().updateView(prefix + "entryentity");
        }
    }

    private void setBaseInfoInteraction() {
        String staffControlStrategy;
        List halfYearStaffList = StaffCommonService.getHalfYearStaff(null, (String)"num");
        halfYearStaffList.forEach(propertyName -> this.getView().setVisible(Boolean.valueOf(false), new String[]{propertyName}));
        List quarterStaffList = StaffCommonService.getQuarterStaff(null, (String)"num");
        quarterStaffList.forEach(propertyName -> this.getView().setVisible(Boolean.valueOf(false), new String[]{propertyName}));
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject staffProjectDyn = dataEntity.getDynamicObject("staffproject");
        if (Objects.isNull(staffProjectDyn)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"staffdimension"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"staffcontrolstrategy"});
        }
        if (HRStringUtils.equals((String)(staffControlStrategy = dataEntity.getString("staffcontrolstrategy")), (String)"3")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"staffelasticcontrol", "staffelasticcount", "staffpercent"});
            ComboEdit elasticControlEdit = (ComboEdit)this.getControl("staffelasticcontrol");
            elasticControlEdit.setMustInput(true);
            DecimalEdit elasticCountEdit = (DecimalEdit)this.getControl("staffelasticcount");
            elasticCountEdit.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"staffelasticcontrol", "staffelasticcount", "staffpercent"});
        }
        DynamicObject staffCycleDyn = dataEntity.getDynamicObject("staffcycle");
        if (Objects.isNull(staffCycleDyn) || staffCycleDyn.getString("number").equals("1020_S")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"copyuseorgdetail", "copymuldimendetail"});
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String openType = (String)e.getFormShowParameter().getCustomParams().get("opentype");
        if (!e.getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW) && !HRStringUtils.equals((String)openType, (String)"1")) {
            e.getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
    }

    private void setButtonVisible(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        String enable = dataEntity.getString("enable");
        Long id = dataEntity.getLong("id");
        boolean isExistFromDB = StaffRepository.getInstance().isExistDynById(id);
        Map customParams = view.getFormShowParameter().getCustomParams();
        String openType = (String)customParams.get("opentype");
        if (HRStringUtils.equals((String)openType, (String)"1")) {
            view.getFormShowParameter().getCustomParams().put("opentype", null);
            view.cacheFormShowParameter();
            view.getFormShowParameter().setStatus(OperationStatus.EDIT);
            view.setVisible(Boolean.TRUE, new String[]{"bar_save"});
            view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_enable", "bar_disable"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap9"});
            return;
        }
        if (!isExistFromDB || this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_save"});
            view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_enable", "bar_disable"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap9"});
        } else if ("10".equals(enable)) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_modify", "bar_enable"});
            view.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_disable"});
        } else if ("1".equals(enable)) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_modify", "bar_disable"});
            view.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_enable"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"bar_modify", "bar_enable"});
            view.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_disable"});
        }
        if (view.getParentView() != null && !"bos_list".equals(view.getParentView().getFormShowParameter().getFormId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_enable", "bar_disable"});
        }
        view.cacheFormShowParameter();
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        long userId = RequestContext.get().getCurrUserId();
        if ("bar_modify".equals(itemKey) && PermissionServiceHelper.hasSpecificPerm((long)userId, (String)"11", (String)"homs", (String)"haos_staff", (String)"4730fc9f000029ae")) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_enable", "bar_disable"});
            this.getView().getPageCache().remove("showDisable");
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap9"});
            this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u53d8\u66f4\u7f16\u5236\u4fe1\u606f-", (String)"OrgStaffMainEdit_2", (String)"hrmp-haos-formplugin", (Object[])new Object[0]).concat(this.getModel().getDataEntity().getString("name"))));
            String enable = this.getModel().getDataEntity().getString("enable");
            this.getView().updateView();
            this.getModel().setDataChanged(false);
        }
    }

    public void afterLoadData(EventObject e) {
        DynamicObject staffCycle = (DynamicObject)this.getModel().getValue("staffcycle");
        if (staffCycle != null) {
            StaffFormService staffFormService = StaffFormService.create(this.getView(), this.getModel());
            staffFormService.staffCycleChange(staffCycle.getLong("id"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        this.getPageCache().put("ImportEntryTypeVisible", "false");
        OrgStaffFormOperationHelper operationHelper = new OrgStaffFormOperationHelper(this.getView(), this.getModel(), this.getPageCache(), this.staffExtEntryHelper);
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setClassName(this.getPluginName());
        operationHelper.beforeDoOperation(args, closeCallBack);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OrgStaffFormOperationHelper operationHelper = new OrgStaffFormOperationHelper(this, this.getView(), this.getModel(), this.getPageCache(), this.staffExtEntryHelper);
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener();
        confirmCallBackListener.setTypeName(this.getPluginName());
        confirmCallBackListener.setMessageCallBackType(MessageCallBackType.Plugin);
        operationHelper.afterDoOperation(afterDoOperationEventArgs, confirmCallBackListener);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listForm = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ListFilterParameter listFilterParameter = listForm.getListFilterParameter();
        if ("orgteam".equals(propertyName)) {
            DynamicObjectCollection useOrgDetails = this.getModel().getEntryEntity("bentryentity");
            Set useOrgIds = useOrgDetails.stream().map(dyn -> dyn.getLong("buseorg.id")).collect(Collectors.toSet());
            QFilter idFilter = new QFilter("id", "in", useOrgIds);
            QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
            idFilter.and(isCurrentVersionFilter);
            QFilter baseDataFilter = BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_staff", Collections.singletonList(((DynamicObject)this.getModel().getValue("org")).getLong("id")));
            idFilter.and(baseDataFilter);
            listForm.setCustomParam("searchdate", (Object)new Date());
            listFilterParameter.setFilter(idFilter);
        } else if ("staffproject".equals(propertyName)) {
            QFilter filter = StaffCommonService.getBaseDataAuthByOrg((DynamicObject)((DynamicObject)this.getModel().getValue("org")), (String)"haos_staffproject");
            listFilterParameter.setFilter(filter);
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        BasedataEdit basedataEdit;
        String key;
        Object source = afterF7SelectEvent.getSource();
        if (source instanceof BasedataEdit && "staffproject".equals(key = (basedataEdit = (BasedataEdit)source).getKey())) {
            DynamicObject staffProject = (DynamicObject)this.getModel().getValue("staffproject");
            if (staffProject == null) {
                return;
            }
            StaffFormService staffFormService = StaffFormService.create(this.getView(), this.getModel());
            staffFormService.refreshEntryStaffProject(staffProject);
            DynamicObjectCollection useOrgInfos = this.getModel().getEntryEntity("bentryentity");
            this.setTabPageVisible(CollectionUtils.isEmpty((Collection)useOrgInfos) ? null : (DynamicObject)useOrgInfos.get(0));
            if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
                int focusRowIndex = ((EntryGrid)this.getView().getControl("bentryentity")).getEntryState().getFocusRow();
                staffFormService.setUseOrgEntryAndMultiEntryEnableForPerm(focusRowIndex);
            }
            staffFormService.staffProjectChanged(staffProject);
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        HashMap customValueMap = Maps.newHashMapWithExpectedSize((int)16);
        String name = event.getProperty().getName();
        ChangeData[] changeSet = event.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        DynamicObjectCollection useOrgInfos = this.getModel().getEntryEntity("bentryentity");
        StaffFormService staffFormService = StaffFormService.create(this.getView(), this.getModel());
        this.initDimMap();
        switch (name) {
            case "staffcontrolstrategy": {
                staffFormService.controlStrategyChange((String)changeSet[0].getNewValue());
                break;
            }
            case "staffelasticcount": {
                int value = (Integer)this.getModel().getValue("staffelasticcount");
                if (value >= 0) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f39\u6027\u989d\u5ea6\u53ea\u80fd\u586b\u5199\u6b63\u6574\u6570\uff0c\u8bf7\u4fee\u6539\u3002", (String)"StaffProjectPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("staffelasticcount", null);
                break;
            }
            case "staffdimension": {
                if (CollectionUtils.isEmpty((Collection)useOrgInfos)) break;
                DynamicObjectCollection staffDimensionDynCol = (DynamicObjectCollection)changeSet[0].getNewValue();
                for (DynamicObject useOrgInfo : useOrgInfos) {
                    DynamicObjectCollection bStaffDimensionDynCol = useOrgInfo.getDynamicObjectCollection("bstaffdimension");
                    if (!CollectionUtils.isEmpty((Collection)bStaffDimensionDynCol)) continue;
                    useOrgInfo.set("bstaffdimension", (Object)staffDimensionDynCol);
                    this.getView().getPageCache().put(DIMENSION_CHANGE_CACHE_KEY, String.valueOf(true));
                }
                EntryGrid useOrgEntry = (EntryGrid)this.getView().getControl("bentryentity");
                int focusRow = useOrgEntry.getEntryState().getFocusRow();
                useOrgEntry.entryRowClick(Integer.valueOf(focusRow));
                this.getView().updateView("bentryentity");
                break;
            }
            case "bstaffdimension": {
                if (CollectionUtils.isEmpty((Collection)useOrgInfos)) break;
                this.setTabPageVisibleForPropertyChange(changeSet, (DynamicObject)useOrgInfos.get(changeSet[0].getRowIndex()));
                break;
            }
            case "year": {
                staffFormService.yearStaffChange((Date)changeSet[0].getNewValue());
                break;
            }
            case "staffcycle": {
                DynamicObject staffCycleNewValue = (DynamicObject)changeSet[0].getNewValue();
                DynamicObject staffCycleOldValue = (DynamicObject)changeSet[0].getOldValue();
                if (staffCycleOldValue != null) {
                    if (staffCycleNewValue != null) {
                        customValueMap.put("newValue", staffCycleNewValue.getLong("id"));
                    }
                    long oldStaffCycleId = staffCycleOldValue.getLong("id");
                    customValueMap.put("oldValue", oldStaffCycleId);
                    if (StaffEntryHelper.entryStaffCycleHasValue((long)oldStaffCycleId, (DynamicObjectCollection)useOrgInfos)) {
                        this.getView().showConfirm("", ResManager.loadKDString((String)"\u91cd\u65b0\u9009\u62e9\u7f16\u5236\u5468\u671f\u540e\uff0c\u5c06\u6e05\u7a7a\u5df2\u586b\u5199\u7684\u7f16\u5236\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u64cd\u4f5c\uff1f", (String)"OrgStaffMainEdit_4", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(STAFF_CYCLE_CHANGE_CALL_BACK, (IFormPlugin)this), null, JSON.toJSONString((Object)customValueMap));
                        break;
                    }
                }
                staffFormService.staffCycleChange(staffCycleNewValue == null ? null : Long.valueOf(staffCycleNewValue.getLong("id")));
                break;
            }
            case "bcontrolstrategy": {
                staffFormService.useOrgControlStrategyChange(changeSet);
                break;
            }
            case "orgteam": {
                staffFormService.orgTeamChange((DynamicObject)changeSet[0].getNewValue());
                break;
            }
            case "org": {
                DynamicObject orgNewValue = (DynamicObject)changeSet[0].getNewValue();
                DynamicObject orgOldValue = (DynamicObject)changeSet[0].getOldValue();
                staffFormService.mainOrgChange(orgOldValue, orgNewValue, new ConfirmCallBackListener("orgChangeCallBack", (IFormPlugin)this));
                break;
            }
        }
        staffFormService.propertyChanged(name, changeSet);
    }

    public void loadData(LoadDataEventArgs e) {
        this.showDisableButton(this.getView());
    }

    public void afterCreateNewData(EventObject e) {
        this.showDisableButton(this.getView());
    }

    private void showDisableButton(IFormView formView) {
        if (Objects.isNull(formView.getPageCache().get("showdisable"))) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey("flexpanelap9");
            formShowParameter.setFormId("haos_staffshowdisable");
            formView.showForm(formShowParameter);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int rowIndex = evt.getRow();
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String entryKey = entryGrid.getEntryKey();
        StaffFormService staffFormService = StaffFormService.create(this.getView(), this.getModel());
        if (rowIndex >= 0 && "bentryentity".equals(entryKey)) {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (OperationStatus.ADDNEW.equals((Object)status)) {
                staffFormService.setMultiEntryEnableForPerm(rowIndex);
            }
            DynamicObject currentUseOrg = this.getModel().getEntryRowEntity("bentryentity", rowIndex);
            long useOrgId = currentUseOrg.getLong("buseorg.id");
            DynamicObject orgTeam = (DynamicObject)this.getModel().getValue("orgteam");
            String dimensionChangeCache = this.getView().getPageCache().get(DIMENSION_CHANGE_CACHE_KEY);
            if (orgTeam == null || orgTeam.getLong("id") != useOrgId || !HRStringUtils.isEmpty((String)dimensionChangeCache)) {
                this.getPageCache().put("useOrgEntryClick", "true");
                this.getView().getPageCache().remove(DIMENSION_CHANGE_CACHE_KEY);
                this.getModel().setValue("orgteam", (Object)useOrgId);
                DynamicObjectCollection dimensionInfos = currentUseOrg.getDynamicObjectCollection("bstaffdimension");
                Set dimensionIds = dimensionInfos.stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toSet());
                this.getView().setVisible(Boolean.valueOf(!CollectionUtils.isEmpty(dimensionIds)), new String[]{"tabap", "importmuldimendetail"});
                this.getView().setVisible(Boolean.valueOf(CollectionUtils.isEmpty(dimensionIds)), new String[]{"flexnodata2"});
                this.getView().setVisible(Boolean.valueOf(dimensionIds.contains(1010L)), new String[]{"tabpage_position"});
                this.getView().setVisible(Boolean.valueOf(dimensionIds.contains(1020L)), new String[]{"tabpage_job"});
                this.getView().setVisible(Boolean.valueOf(dimensionIds.contains(1050L)), new String[]{"tabpage_laborreltype"});
                staffFormService.setControlStrategyFieldVisible("c");
                staffFormService.setControlStrategyFieldVisible("d");
                staffFormService.setControlStrategyFieldVisible("e");
                for (DynamicObject dim : this.staffExtEntryHelper.getExtDim()) {
                    this.getView().setVisible(Boolean.valueOf(dimensionIds.contains(dim.getLong("id"))), new String[]{"tabpage_" + dim.getString("staffdimension")});
                    staffFormService.setControlStrategyFieldVisible(this.staffExtEntryHelper.getExtDimPrefix(dim.getString("staffdimension")));
                }
                StaffEntryHelper.setActiveTab((Tab)((Tab)this.getView().getControl("tabap")), dimensionIds);
            }
        }
        staffFormService.setEntryFieldEnable();
    }

    private void setTabPageVisible(DynamicObject currentUseOrg) {
        if (currentUseOrg == null || currentUseOrg.getLong("buseorg.id") == 0L) {
            return;
        }
        DynamicObjectCollection staffDimensions = currentUseOrg.getDynamicObjectCollection("bstaffdimension");
        this.getView().setVisible(Boolean.valueOf(!CollectionUtils.isEmpty((Collection)staffDimensions)), new String[]{"tabap"});
        this.getView().setVisible(Boolean.valueOf(CollectionUtils.isEmpty((Collection)staffDimensions)), new String[]{"flexnodata2"});
        if (!CollectionUtils.isEmpty((Collection)staffDimensions)) {
            Set dimensionIds = staffDimensions.stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toSet());
            UseOrgEntryParamBO useOrgEntryParamBO = new UseOrgEntryParamBO();
            useOrgEntryParamBO.setStaffProjectBo(new StaffProjectBo(staffDimensions));
            useOrgEntryParamBO.setDyn(currentUseOrg);
            useOrgEntryParamBO.buildSubEntryInfoAllAndExtEntry(this.staffExtEntryHelper);
            this.updateDimensionEntry(useOrgEntryParamBO);
            StaffEntryHelper.setActiveTab((Tab)((Tab)this.getView().getControl("tabap")), dimensionIds);
        }
    }

    private void setTabPageVisibleForPropertyChange(ChangeData[] changeSet, DynamicObject currentUseOrg) {
        String cacheKey;
        if (currentUseOrg == null || currentUseOrg.getLong("buseorg.id") == 0L) {
            return;
        }
        IFormView view = this.getView();
        long useOrgBoId = currentUseOrg.getLong("buseorg.boid");
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        List oldDimensionIdList = ((MulBasedataDynamicObjectCollection)oldValue).stream().map(entry -> entry.getLong("fbasedataid.id")).collect(Collectors.toList());
        List newDimensionIdList = ((MulBasedataDynamicObjectCollection)newValue).stream().map(entry -> entry.getLong("fbasedataid.id")).collect(Collectors.toList());
        ArrayList deleteDimensionIdList = new ArrayList(oldDimensionIdList);
        ArrayList addDimensionIdList = new ArrayList(newDimensionIdList);
        deleteDimensionIdList.removeAll(newDimensionIdList);
        addDimensionIdList.removeAll(oldDimensionIdList);
        for (Long dimensionId : deleteDimensionIdList) {
            cacheKey = "" + useOrgBoId + dimensionId;
            String entryName = this.dimensionIdVsEntryNameMap.get(dimensionId);
            view.getPageCache().put(cacheKey, SerializationUtils.toJsonString((Object)currentUseOrg.getDynamicObjectCollection(entryName)));
            this.getModel().deleteEntryData(entryName);
        }
        for (Long dimensionId : addDimensionIdList) {
            cacheKey = "" + useOrgBoId + dimensionId;
            String cacheValue = view.getPageCache().get(cacheKey);
            if (Objects.isNull(cacheValue)) {
                if (dimensionId != 1010L) continue;
                DynamicObjectCollection newUseOrgEntryCol = new DynamicObjectCollection();
                newUseOrgEntryCol.add((Object)currentUseOrg);
                StaffInitEntryDataService.create(this.getView(), this.getModel()).syncPositionEntryData(newUseOrgEntryCol);
                view.updateView("centryentity");
                continue;
            }
            List fieldValueMapList = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
            String entryName = this.dimensionIdVsEntryNameMap.get(dimensionId);
            DynamicObjectCollection dynamicObjectCollection = currentUseOrg.getDynamicObjectCollection(entryName);
            DynamicObjectType dynamicObjectType = dynamicObjectCollection.getDynamicObjectType();
            for (LinkedHashMap fieldValueMap : fieldValueMapList) {
                String prefix = this.dimensionIdVsPrefixNameMap.get(dimensionId);
                DynamicObject entryDyn = new DynamicObject(dynamicObjectType);
                List entryFieldsByPrefix = StaffEntryTempHelperEnum.getEntryFieldsByPrefix((String)prefix);
                for (String field : entryFieldsByPrefix) {
                    String fieldName = prefix + field;
                    entryDyn.set(fieldName, fieldValueMap.get(fieldName));
                }
                entryDyn.set("id", fieldValueMap.get("id"));
                String keyFieldEntityName = this.staffExtEntryHelper.getKeyFieldEntityNameByPrefix(prefix);
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(keyFieldEntityName);
                DynamicObject keyFieldDyn = serviceHelper.generateEmptyDynamicObject();
                String keyField = StaffEntryTempHelperEnum.getKeyFieldByPrefix((String)prefix);
                keyFieldDyn.set("id", ((Map)fieldValueMap.get(prefix + keyField)).get("id"));
                keyFieldDyn.set("name", ((Map)fieldValueMap.get(prefix + keyField)).get("name"));
                keyFieldDyn.set("number", ((Map)fieldValueMap.get(prefix + keyField)).get("number"));
                entryDyn.set(prefix + keyField, (Object)keyFieldDyn);
                dynamicObjectCollection.add((Object)entryDyn);
            }
            view.updateView(entryName);
        }
        this.setTabPageVisible(currentUseOrg);
    }

    private void updateDimensionEntry(UseOrgEntryParamBO useOrgEntryParamBO) {
        Set dimensionIds = useOrgEntryParamBO.getStaffProjectBo().getStaffDimensionIds();
        DynamicObject currentUseOrg = useOrgEntryParamBO.getDyn();
        List subEntryInfos = useOrgEntryParamBO.getSubEntryInfos();
        for (DimensionEntryParamBO subEntryInfo : subEntryInfos) {
            String entryName = subEntryInfo.getEntryName();
            if (dimensionIds.contains(subEntryInfo.getDimensionId())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{subEntryInfo.getTabPageName()});
                continue;
            }
            currentUseOrg.getDynamicObjectCollection(entryName).clear();
            this.getModel().updateEntryCache(this.getModel().getEntryEntity("bentryentity"));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{subEntryInfo.getTabPageName()});
            this.getView().updateView(entryName);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        IFormView view = this.getView();
        StaffFormService staffFormService = StaffFormService.create(view, (IDataModel)model);
        if ("sumCalcCallBack".equals(callBackId)) {
            DynamicObject staffCycle = (DynamicObject)model.getValue("staffcycle");
            if (MessageBoxResult.Yes.equals((Object)result) && staffCycle != null) {
                DynamicObjectCollection useOrgInfos = model.getEntryEntity("bentryentity");
                EntryGrid entryGrid = (EntryGrid)view.getControl("bentryentity");
                int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
                StaffSummaryCalcService service = new StaffSummaryCalcService(staffCycle.getLong("id"), useOrgInfos);
                Map<Integer, Map<String, Long>> summaryInfoMap = service.buildSummary(selectedRows);
                summaryInfoMap.forEach((index, fieldInfoMap) -> fieldInfoMap.forEach((property, value) -> model.setValue(property, value, index.intValue())));
            }
        } else if (STAFF_CYCLE_CHANGE_CALL_BACK.equals(callBackId)) {
            String customValueStr = messageBoxClosedEvent.getCustomVaule();
            Map customValueMap = (Map)JSON.parseObject((String)customValueStr, (TypeReference)new TypeReference<Map<String, Long>>(){}, (Feature[])new Feature[0]);
            Long newValue = (Long)customValueMap.get("newValue");
            Long oldValue = (Long)customValueMap.get("oldValue");
            model.beginInit();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                staffFormService.staffCycleChange(newValue);
                model.setValue("staffcycle", (Object)newValue);
            } else {
                model.setValue("staffcycle", (Object)oldValue);
            }
            model.endInit();
            view.updateView("staffcycle");
        } else if ("orgChangeCallBack".equals(callBackId)) {
            String customValueStr = messageBoxClosedEvent.getCustomVaule();
            Map customValueMap = (Map)JSON.parseObject((String)customValueStr, (TypeReference)new TypeReference<Map<String, Long>>(){}, (Feature[])new Feature[0]);
            Long newValue = (Long)customValueMap.get("newValue");
            Long oldValue = (Long)customValueMap.get("oldValue");
            model.beginInit();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                staffFormService.fillDataFromMainOrg(newValue);
                staffFormService.setEntryLineEnableForPerm();
            } else {
                model.setValue("org", (Object)oldValue);
            }
            model.endInit();
            view.updateView("org");
        } else if (("deleteJobConfirmActionId".equals(callBackId) || "deleteLaborConfirmActionId".equals(callBackId) || this.staffExtEntryHelper.getExtCallBackIdToEntryMap().containsKey(callBackId)) && MessageBoxResult.Yes.equals((Object)result)) {
            this.deleteJobAndLaborTypeConfirm(callBackId, model, view, staffFormService);
        }
    }

    private void deleteJobAndLaborTypeConfirm(String callBackId, AbstractFormDataModel model, IFormView view, StaffFormService staffFormService) {
        String idProperty;
        IPageCache pageCache = this.getPageCache();
        String entityName = (String)this.staffExtEntryHelper.getExtCallBackIdToEntryMap().get(callBackId);
        if (HRStringUtils.isEmpty((String)entityName)) {
            entityName = "deleteJobConfirmActionId".equals(callBackId) ? "dentryentity" : "eentryentity";
        }
        String jobLaborTypeIdStr = pageCache.get("jobLaborTypeIdPageCacheKey");
        HashMap jobLaborTypeIdMap = (HashMap)JSON.parseObject((String)jobLaborTypeIdStr, (TypeReference)new TypeReference<HashMap<Long, Set<Long>>>(){}, (Feature[])new Feature[0]);
        Object useOrg = model.getValue("orgteam");
        if (useOrg == null) {
            return;
        }
        long useOrgBoId = ((DynamicObject)useOrg).getLong("boid");
        DynamicObjectCollection jobInfos = model.getEntryEntity(entityName);
        EntryGrid entryGrid = (EntryGrid)view.getControl(entityName);
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        ArrayList toDeleteRow = Lists.newArrayListWithExpectedSize((int)selectedRows.length);
        Set keyFieldIds = Sets.newHashSetWithExpectedSize((int)16);
        if (jobLaborTypeIdMap != null) {
            keyFieldIds = jobLaborTypeIdMap.getOrDefault(useOrgBoId, new HashSet());
        }
        StringBuilder dimensionName = new StringBuilder();
        String nameProperty = (String)this.staffExtEntryHelper.getExtCallBackIdToPropNameMap().get(callBackId);
        if (HRStringUtils.isEmpty((String)nameProperty)) {
            String string = nameProperty = "deleteJobConfirmActionId".equals(callBackId) ? "djob.name" : "elaborreltype.name";
        }
        if (HRStringUtils.isEmpty((String)(idProperty = (String)this.staffExtEntryHelper.getExtCallBackIdToPropIdMap().get(callBackId)))) {
            idProperty = "deleteJobConfirmActionId".equals(callBackId) ? "djob.id" : "elaborreltype.id";
        }
        String staffEnable = this.getView().getModel().getDataEntity().getString("enable");
        HashSet toDeleteIds = Sets.newHashSetWithExpectedSize((int)16);
        for (int selectedRow : selectedRows) {
            DynamicObject jobInfo = (DynamicObject)jobInfos.get(selectedRow);
            if (HRStringUtils.equals((String)staffEnable, (String)"10") || keyFieldIds.contains(jobInfo.getLong(idProperty))) {
                toDeleteRow.add(selectedRow);
                toDeleteIds.add(jobInfo.getLong(idProperty));
                continue;
            }
            dimensionName.append(jobInfo.getString(nameProperty)).append(";");
        }
        int size = toDeleteRow.size();
        if (size != 0) {
            model.deleteEntryRows(entityName, toDeleteRow.stream().mapToInt(Integer::intValue).toArray());
            DynamicObject currentDyn = (DynamicObject)jobInfos.getParent();
            staffFormService.rebuildStaffNumWithSubWhenDimEntryChange(currentDyn);
        }
        String title = String.format(ResManager.loadKDString((String)"\u5355\u636e\u603b\u6761\u6570\uff1a%1$s\uff0c\u5220\u9664\u6210\u529f\u6761\u6570\uff1a%2$s\uff0c\u5220\u9664\u5931\u8d25\u603b\u6761\u6570\uff1a%3$s\u3002", (String)"OrgStaffMainEdit_17", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), selectedRows.length, size, selectedRows.length - size);
        String message = "";
        if (dimensionName.length() > 0) {
            dimensionName.deleteCharAt(dimensionName.length() - 1);
            message = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7f16\u5236\u4fe1\u606f\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"OrgStaffMainEdit_18", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), dimensionName.toString());
        }
        StaffFormService.create(view).showOperationResultPage(title, message, null);
        keyFieldIds.removeAll(toDeleteIds);
        if (jobLaborTypeIdMap == null) {
            jobLaborTypeIdMap = Maps.newHashMapWithExpectedSize((int)16);
        }
        if (CollectionUtils.isEmpty(keyFieldIds)) {
            jobLaborTypeIdMap.remove(useOrgBoId);
        } else {
            jobLaborTypeIdMap.put(useOrgBoId, keyFieldIds);
        }
        pageCache.put("jobLaborTypeIdPageCacheKey", JSON.toJSONString((Object)jobLaborTypeIdMap));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObject = closedCallBackEvent.getReturnData();
        IDataModel model = this.getModel();
        if (returnDataObject != null && ("newJobCloseActionId".equals(actionId) || "newLaborCloseActionId".equals(actionId) || this.staffExtEntryHelper.getExtCallBackActionToEntryMap().containsKey(actionId))) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)returnDataObject;
            Object[] primaryKeyValues = returnData.getPrimaryKeyValues();
            if (primaryKeyValues != null && primaryKeyValues.length > 0) {
                ArrayList dimensionEntryParamBOS = Lists.newArrayListWithExpectedSize((int)primaryKeyValues.length);
                StaffProjectBo staffProjectBo = new StaffProjectBo(model.getValue("staffcontrolstrategy"), model.getValue("staffelasticcontrol"), model.getValue("staffelasticcount"), (DynamicObjectCollection)model.getValue("staffdimension"));
                HashSet keyFieldIds = Sets.newHashSetWithExpectedSize((int)primaryKeyValues.length);
                for (Object primaryKeyValue : primaryKeyValues) {
                    String keyFieldName;
                    String entityName = (String)this.staffExtEntryHelper.getExtCallBackActionToEntryMap().get(actionId);
                    if (HRStringUtils.isEmpty((String)entityName)) {
                        String string = entityName = "newJobCloseActionId".equals(actionId) ? "dentryentity" : "eentryentity";
                    }
                    if (HRStringUtils.isEmpty((String)(keyFieldName = (String)this.staffExtEntryHelper.getExtCallBackActionToDimMap().get(actionId)))) {
                        keyFieldName = "newJobCloseActionId".equals(actionId) ? "djob" : "elaborreltype";
                    }
                    DimensionEntryParamBO dimensionEntryParamBO = new DimensionEntryParamBO(entityName, keyFieldName, ((Long)primaryKeyValue).longValue());
                    dimensionEntryParamBO.setKeepOriginalData(true);
                    dimensionEntryParamBO.setStaffProjectBo(staffProjectBo);
                    dimensionEntryParamBOS.add(dimensionEntryParamBO);
                    keyFieldIds.add((Long)primaryKeyValue);
                }
                StaffEntryHelper.batchCreateNewEntryRow((AbstractFormDataModel)((AbstractFormDataModel)model), (IFormView)this.getView(), (List)dimensionEntryParamBOS);
                Object useOrg = this.getModel().getValue("orgteam");
                if (useOrg != null) {
                    this.putDimensionIdToCache(((DynamicObject)useOrg).getLong("boid"), keyFieldIds);
                }
                StaffFormService.create(this.getView()).setEntryFieldEnable();
            }
        } else if ("taskcloseback".equals(actionId)) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    private void taskCallBack(Object returnData) {
        if (!(returnData instanceof Map)) {
            return;
        }
        Map result = (Map)returnData;
        String taskInfoStr = (String)result.get("taskinfo");
        if (HRStringUtils.isBlank((CharSequence)taskInfoStr)) {
            return;
        }
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
        if (!taskInfo.isTaskEnd()) {
            return;
        }
        String data = taskInfo.getData();
        Map dataMap = (Map)JSONObject.parseObject((String)data, Map.class);
        if (dataMap == null) {
            return;
        }
        Boolean success = (Boolean)dataMap.get("success");
        if (success != null && success.booleanValue()) {
            String msg = ResManager.loadKDString((String)"[\u6279\u91cf\u540c\u6b65]-\u5458\u5de5\u5360\u7f16\u4fe1\u606f\u4efb\u52a1\u5b8c\u6210", (String)"OrgParameterconsoleEdit_2", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(msg);
        }
    }

    private void putDimensionIdToCache(long useOrgId, Set<Long> keyFieldIds) {
        if (CollectionUtils.isEmpty(keyFieldIds)) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        String jobLaborTypeIdStr = pageCache.get("jobLaborTypeIdPageCacheKey");
        HashMap jobLaborTypeIdMap = (HashMap)JSON.parseObject((String)jobLaborTypeIdStr, (TypeReference)new TypeReference<HashMap<Long, Set<Long>>>(){}, (Feature[])new Feature[0]);
        if (useOrgId != 0L) {
            Set keyFieldIdOld = Sets.newHashSetWithExpectedSize((int)16);
            if (jobLaborTypeIdMap != null) {
                keyFieldIdOld = jobLaborTypeIdMap.getOrDefault(useOrgId, new HashSet());
            } else {
                jobLaborTypeIdMap = Maps.newHashMapWithExpectedSize((int)16);
            }
            keyFieldIds.addAll(keyFieldIdOld);
            jobLaborTypeIdMap.put(useOrgId, keyFieldIds);
        }
        pageCache.put("jobLaborTypeIdPageCacheKey", JSON.toJSONString((Object)jobLaborTypeIdMap));
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        this.getView().setVisible(Boolean.valueOf("tabpage_job".equals(tabKey)), new String[]{"addjob", "deletejob", "exportjob"});
        this.getView().setVisible(Boolean.valueOf("tabpage_laborreltype".equals(tabKey)), new String[]{"addlaborreltype", "deletelaborreltype", "exportlaborreltype"});
        this.getView().setVisible(Boolean.valueOf("tabpage_position".equals(tabKey)), new String[]{"exportposition"});
        for (DynamicObject extDim : this.staffExtEntryHelper.getExtDim()) {
            String dimName = extDim.getString("staffdimension");
            String extTabName = "tabpage_" + dimName;
            this.getView().setVisible(Boolean.valueOf(extTabName.equals(tabKey)), new String[]{"export" + dimName, "add" + dimName, "delete" + dimName});
        }
    }
}

