/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.staff.form;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.ruleengine.controls.RuleCondition;
import kd.bos.ext.hr.ruleengine.controls.RuleControl;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class RuleConfigEdit
extends HRDataBaseEdit
implements OrgStaffConstants {
    private static final String RULECONDITIONAP = "ruleconditionap";

    private RuleCondition getRuleCondition() {
        return (RuleCondition)this.getControl(RULECONDITIONAP);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        JSONObject dyn = (JSONObject)params.get("dy");
        if (dyn == null) {
            dyn = new JSONObject();
        }
        RuleCondition ruleCondition = this.getRuleCondition();
        this.initControl((RuleControl)ruleCondition, dyn.getString("rule"));
        this.getModel().setValue("name", dyn.get((Object)"rulename"));
    }

    private void initControl(RuleControl ruleControl, String value) {
        ruleControl.setBizApp("217WYC/L9U7E");
        ruleControl.setScene(String.valueOf(RULE_SCENE));
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            ruleControl.setValue(value);
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        evt.setCheckDataChange(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String conditionJson = this.getRuleCondition().getValue();
        if (HRStringUtils.isEmpty((String)conditionJson)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u89c4\u5219\u6761\u4ef6\u3002", (String)"RuleConfigEdit_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            args.setCancel(true);
        } else {
            RuleValidateInfo conditionInfo = RuleValidateUtil.validCondition((String)conditionJson);
            if (!conditionInfo.isSuccess()) {
                for (String msg : conditionInfo.getMsgList()) {
                    this.getView().showTipNotification(msg);
                }
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("donothing_confirm".equals(afterDoOperationEventArgs.getOperateKey())) {
            HashMap returnMap = Maps.newHashMap();
            HashMap returnDataMap = Maps.newHashMap();
            returnDataMap.put("rulename", this.getModel().getValue("name"));
            returnDataMap.put("rule", this.getRuleCondition().getValue());
            returnDataMap.put("modifierfield", RequestContext.get().getCurrUserId());
            returnDataMap.put("modifydatefield", new Date());
            returnMap.put("rtnData", returnDataMap);
            returnMap.put("rowIndex", this.getView().getFormShowParameter().getCustomParams().get("rowIndex"));
            this.getView().returnDataToParent((Object)returnMap);
        }
    }
}

