/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.staff.form;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.staff.StaffCaseRepository;
import kd.hr.haos.common.constants.staff.StaffCaseConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class StaffCaseEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
StaffCaseConstants {
    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit personnelBaseData = (BasedataEdit)this.getView().getControl("personnel");
        personnelBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit personnelBaseData1 = (BasedataEdit)this.getView().getControl("person");
        personnelBaseData1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long id = dataEntity.getLong("id");
        if (id != 0L && StaffCaseRepository.getInstance().isExistsById(Long.valueOf(id))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"personnel"});
        }
        if (HRStringUtils.equals((String)"0", (String)dataEntity.getString("enable"))) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)"personnel", (String)name)) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("businessstatus", "=", (Object)"1"));
            beforeF7SelectEvent.addCustomQFilter(new QFilter("postype.postcategory.id", "=", (Object)1010L));
            beforeF7SelectEvent.addCustomQFilter(new QFilter("hrpi_empposorgrel.posstatus.poststatecls.id", "=", (Object)1020L));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        Object newValue;
        String name = e.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"personnel") && (newValue = (changeSet = e.getChangeSet())[0].getNewValue()) != null) {
            long personId = ((DynamicObject)newValue).getLong("person.id");
            HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hrpi_person");
            DynamicObject personDyn = personHelper.generateEmptyDynamicObject();
            personDyn.set("id", (Object)personId);
            this.getModel().getDataEntity().set("person", (Object)personDyn);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject personnelDyn = dataEntity.getDynamicObject("personnel");
        if (personnelDyn != null && personnelDyn.getDynamicObject("person") != null) {
            String personName = personnelDyn.getString("person.number");
            this.getModel().setValue("number", (Object)personName);
            Long depEmpId = personnelDyn.getLong("id");
            List<DynamicObject> depEmpOrgRelDynList = this.getEmpOrgRelDyn(Collections.singletonList(depEmpId));
            this.getModel().setValue("adminorg", (Object)depEmpOrgRelDynList.get(0).getLong("company.id"));
        }
    }

    public List<DynamicObject> getEmpOrgRelDyn(List<Long> depEmpIdList) {
        List rtnList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIDepempService", (String)"listEmpOrgrelDys", (Object[])new Object[]{depEmpIdList});
        return rtnList;
    }
}

