/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.staff.form;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Map;
import java.util.Optional;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class StaffInnerEdit
extends HRDataBaseEdit
implements HyperLinkClickListener,
OrgStaffConstants {
    private static final String ADD_SPECIAL_RULE_CALL_BACK = "specialRuleCallBack";
    private static final String DELETEENTRYROW = "deleteEntryRow";

    public void afterBindData(EventObject e) {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return;
        }
        String staffspecialruleStr = parentView.getModel().getDataEntity().getString("staffspecialrule");
        if (HRStringUtils.isEmpty((String)staffspecialruleStr)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"deleterule"});
            return;
        }
        Map staffspecialrule = (Map)JSONObject.parseObject((String)staffspecialruleStr, Map.class);
        Long org = this.getOrgId();
        String ruleOrg = String.valueOf(staffspecialrule.getOrDefault("org", 0L));
        if (!ruleOrg.equals(String.valueOf(org))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"deleterule"});
            return;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", 1);
        DynamicObject dy = this.getModel().getEntryRowEntity("entryentity", 0);
        this.assembleEntry(dy, staffspecialrule);
        this.getView().updateView("entryentity");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconbaritemap"});
    }

    private void assembleEntry(DynamicObject dy, Map<String, Object> staffspecialrule) {
        dy.set("rulename", staffspecialrule.get("rulename"));
        dy.set("rule", staffspecialrule.get("rule"));
        dy.set("modifierfield", (Object)this.getBosUser(staffspecialrule.get("modifierfield")));
        dy.set("modifydatefield", staffspecialrule.get("modifydatefield"));
    }

    private DynamicObject getBosUser(Object id) {
        String selectFields = "id, name";
        QFilter idFilter = new QFilter("id", "=", id);
        QFilter[] filters = new QFilter[]{idFilter};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)selectFields, (QFilter[])filters);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"deleteentry")) {
            args.setCancel(true);
            String msg = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"StaffinnerEdit_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            ConfirmCallBackListener listener = new ConfirmCallBackListener(DELETEENTRYROW, (IFormPlugin)this);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, listener);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key = evt.getCallBackId();
        if (DELETEENTRYROW.equals(key) && "Yes".equals(evt.getResultValue())) {
            this.getModel().deleteEntryRow("entryentity", 0);
            this.getView().getParentView().getModel().setValue("staffspecialrule", (Object)"");
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"deleterule"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconbaritemap"});
        }
    }

    public void registerListener(EventObject event) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        super.registerListener(event);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"donothing_new")) {
            this.showSpecialRule(null, -1);
        }
    }

    private void showSpecialRule(DynamicObject dy, int rowIndex) {
        BaseShowParameter form = new BaseShowParameter();
        form.getOpenStyle().setShowType(ShowType.Modal);
        form.setFormId("haos_specialrule");
        form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADD_SPECIAL_RULE_CALL_BACK));
        form.setCustomParam("dy", (Object)dy);
        form.setCustomParam("rowIndex", (Object)rowIndex);
        form.setStatus(this.getView().getFormShowParameter().getStatus());
        form.setHasRight(true);
        Long createOrgId = this.getOrgId();
        form.setCustomParam("createorg", (Object)createOrgId);
        this.getView().showForm((FormShowParameter)form);
    }

    private Long getOrgId() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return 0L;
        }
        IFormView consoleView = this.getView().getParentView().getParentView();
        if (consoleView == null) {
            return 0L;
        }
        return Optional.ofNullable(consoleView.getModel().getDataEntity().getDynamicObject("orgfield")).map(it -> it.getLong("id")).orElse(0L);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (HRStringUtils.equals((String)fieldName, (String)"rulename")) {
            DynamicObject dy = this.getModel().getEntryRowEntity("entryentity", evt.getRowIndex());
            this.showSpecialRule(dy, evt.getRowIndex());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (ADD_SPECIAL_RULE_CALL_BACK.equals(actionId)) {
            this.handleSpecialRuleCallbackData((Map)closedCallBackEvent.getReturnData());
        }
    }

    private void handleSpecialRuleCallbackData(Map<String, Object> returnMap) {
        if (returnMap == null) {
            return;
        }
        int index = (Integer)returnMap.get("rowIndex");
        if (index == -1) {
            this.getModel().beginInit();
            index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().endInit();
        }
        Map returnDataMap = (Map)returnMap.get("rtnData");
        DynamicObject dy = this.getModel().getEntryRowEntity("entryentity", index);
        this.assembleEntry(dy, returnDataMap);
        this.getView().updateView("entryentity");
        returnDataMap.put("org", this.getOrgId());
        String staffspecialruleStr = JSONObject.toJSONString((Object)returnDataMap);
        IFormView homsConfigView = this.getView().getParentView();
        homsConfigView.getModel().setValue("staffspecialrule", (Object)staffspecialruleStr);
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"deleterule"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconbaritemap"});
    }
}

