/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.staff.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.userconfig.GridConfigDAO;
import kd.hr.haos.business.domain.repository.other.LaborRelTypeRepository;
import kd.hr.haos.business.service.staff.bean.StaffProjectBo;
import kd.hr.haos.business.service.staff.helper.StaffEntryTempHelperEnum;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.business.service.staff.service.StaffEntryHelper;
import kd.hr.haos.business.service.staff.service.StaffExtEntryHelper;
import kd.hr.haos.business.servicehelper.SystemParamHelper;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.formplugin.web.staff.service.StaffInitEntryDataService;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class StaffFormService
implements OrgStaffConstants {
    private IFormView formView;
    private IDataModel model;
    private String CACHE_NORIGHT_INDEXLIST = "noRightCacheIndexList";
    private StaffExtEntryHelper staffExtEntryHelper = new StaffExtEntryHelper();

    private StaffFormService(IFormView formView) {
        this.formView = formView;
    }

    private StaffFormService(IDataModel model) {
        this.model = model;
    }

    private StaffFormService(IFormView formView, IDataModel model) {
        this.formView = formView;
        this.model = model;
    }

    public static StaffFormService create(IFormView formView) {
        return new StaffFormService(formView);
    }

    public static StaffFormService create(IFormView formView, IDataModel model) {
        return new StaffFormService(formView, model);
    }

    public static StaffFormService create(IDataModel model) {
        return new StaffFormService(model);
    }

    public void setEntryFieldEnable() {
        block3: {
            int yearInt;
            int curYearInt;
            Date now;
            block5: {
                long id;
                block4: {
                    this.formView.setEnable(Boolean.FALSE, new String[]{"year", "staffcycle"});
                    DynamicObject dataEntity = this.formView.getModel().getDataEntity();
                    long orgId = dataEntity.getLong("org.id");
                    Boolean enableModify = SystemParamHelper.getStaffPastMonthModifyParameter((Long)orgId);
                    String enable = dataEntity.getString("enable");
                    if (enableModify.booleanValue() || HRStringUtils.equals((String)enable, (String)"10")) break block3;
                    DynamicObject staffCycleDyn = dataEntity.getDynamicObject("staffcycle");
                    id = staffCycleDyn.getLong("id");
                    now = new Date();
                    Date year = dataEntity.getDate("year");
                    curYearInt = HRDateTimeUtils.getYear((Date)now);
                    yearInt = HRDateTimeUtils.getYear((Date)year);
                    if (id != STAFF_CYCLE_YEAR || curYearInt <= yearInt) break block4;
                    this.setEntryFieldOfYearEnable("b", "c", "d", "e");
                    for (String prefix : this.staffExtEntryHelper.getExtDimPrefix()) {
                        this.setEntryFieldOfYearEnable(prefix);
                    }
                    break block3;
                }
                if (id != STAFF_CYCLE_MONTH) break block3;
                if (curYearInt <= yearInt) break block5;
                this.setEntryFieldOfMonthEnable(13, "b", "c", "d", "e");
                for (String prefix : this.staffExtEntryHelper.getExtDimPrefix()) {
                    this.setEntryFieldOfMonthEnable(13, prefix);
                }
                break block3;
            }
            if (curYearInt != yearInt) break block3;
            int nowOfMonth = HRDateTimeUtils.getMonth((Date)now);
            this.setEntryFieldOfMonthEnable(nowOfMonth, "b", "c", "d", "e");
            for (String prefix : this.staffExtEntryHelper.getExtDimPrefix()) {
                this.setEntryFieldOfMonthEnable(nowOfMonth, prefix);
            }
        }
    }

    private void setEntryFieldOfYearEnable(String ... prefixArr) {
        for (String prefix : prefixArr) {
            DynamicObjectCollection entryEntity = this.formView.getModel().getEntryEntity(prefix + "entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) continue;
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.formView.setEnable(Boolean.FALSE, i, new String[]{prefix + "yearstaff"});
            }
        }
    }

    private void setEntryFieldOfMonthEnable(int monthIndex, String ... prefixArr) {
        for (String prefix : prefixArr) {
            DynamicObjectCollection entryEntity = this.formView.getModel().getEntryEntity(prefix + "entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) continue;
            for (int i = 0; i < entryEntity.size(); ++i) {
                for (int j = 1; j < monthIndex; ++j) {
                    this.formView.setEnable(Boolean.FALSE, i, new String[]{prefix + "monthstaff" + j});
                }
            }
        }
    }

    public void setDefaultOrgTeam() {
        DynamicObjectCollection useOrgEntryEntity = this.formView.getModel().getEntryEntity("bentryentity");
        if (useOrgEntryEntity.size() > 0) {
            long userOrgId = ((DynamicObject)useOrgEntryEntity.get(0)).getLong("buseorg.id");
            this.formView.getModel().setValue("orgteam", (Object)userOrgId);
            this.formView.updateView("orgteam");
        }
    }

    public void yearStaffChange(Date year) {
        DynamicObject org = (DynamicObject)this.model.getValue("org");
        DynamicObject staffRuleConfig = null;
        if (org != null) {
            staffRuleConfig = StaffCommonService.getOrgStaffRuleConfig((DynamicObject)org, (Date)year);
        }
        this.staffRuleInit(staffRuleConfig, true);
    }

    public void staffCycleChange(Long staffCycleId) {
        List yearStaffList = StaffCommonService.getYearStaff(null, (String)"num");
        List monthStaffList = StaffCommonService.getMonthStaff(null, (String)"num");
        if (staffCycleId == null || staffCycleId == 0L) {
            yearStaffList.forEach(propertyName -> this.formView.setVisible(Boolean.valueOf(false), new String[]{propertyName}));
            monthStaffList.forEach(propertyName -> this.formView.setVisible(Boolean.valueOf(false), new String[]{propertyName}));
            this.formView.setVisible(Boolean.FALSE, new String[]{"copyuseorgdetail", "copymuldimendetail"});
        } else if (staffCycleId == 1010L) {
            yearStaffList.forEach(propertyName -> this.formView.setVisible(Boolean.valueOf(false), new String[]{propertyName}));
            monthStaffList.forEach(propertyName -> this.formView.setVisible(Boolean.valueOf(true), new String[]{propertyName}));
            this.formView.setVisible(Boolean.TRUE, new String[]{"copyuseorgdetail", "copymuldimendetail"});
        } else if (staffCycleId == 1020L) {
            yearStaffList.forEach(propertyName -> this.formView.setVisible(Boolean.valueOf(true), new String[]{propertyName}));
            monthStaffList.forEach(propertyName -> this.formView.setVisible(Boolean.valueOf(false), new String[]{propertyName}));
            this.formView.setVisible(Boolean.FALSE, new String[]{"copyuseorgdetail", "copymuldimendetail"});
        }
    }

    public void controlStrategyChange(String controlStrategy) {
        boolean unityControlMode;
        ComboEdit elasticControlEdit = (ComboEdit)this.formView.getControl("staffelasticcontrol");
        DecimalEdit elasticCountEdit = (DecimalEdit)this.formView.getControl("staffelasticcount");
        boolean flag = HRStringUtils.equals((String)controlStrategy, (String)"3");
        this.formView.setVisible(Boolean.valueOf(flag), new String[]{"staffelasticcontrol", "staffelasticcount", "staffpercent"});
        elasticControlEdit.setMustInput(flag);
        elasticCountEdit.setMustInput(flag);
        if (!flag) {
            this.model.setValue("staffelasticcontrol", null);
            this.model.setValue("staffelasticcount", null);
        }
        if (!(unityControlMode = this.model.getDataEntity().getBoolean("staffproject.unitycontrolmode"))) {
            DynamicObjectCollection useOrgDynCol = this.model.getEntryEntity("bentryentity");
            for (int i = 0; i < useOrgDynCol.size(); ++i) {
                DynamicObject entryDyn = (DynamicObject)useOrgDynCol.get(i);
                String bControlStrategy = entryDyn.getString("bcontrolstrategy");
                if (!HRStringUtils.isEmpty((String)bControlStrategy)) continue;
                entryDyn.set("bcontrolstrategy", (Object)controlStrategy);
                this.model.setValue("bcontrolstrategy", (Object)controlStrategy, i);
            }
            this.formView.updateView("bentryentity");
        }
    }

    public void useOrgControlStrategyChange(ChangeData[] changeSet) {
        String newValue = (String)changeSet[0].getNewValue();
        String oldValue = (String)changeSet[0].getOldValue();
        DynamicObjectCollection useOrgInfos = this.model.getEntryEntity("bentryentity");
        int rowIndex = changeSet[0].getRowIndex();
        DynamicObject currentUseOrg = (DynamicObject)useOrgInfos.get(rowIndex);
        if ("4".equals(newValue)) {
            DynamicObjectCollection positionInfos = currentUseOrg.getDynamicObjectCollection("centryentity");
            DynamicObjectCollection jobInfos = currentUseOrg.getDynamicObjectCollection("dentryentity");
            DynamicObjectCollection laborInfos = currentUseOrg.getDynamicObjectCollection("eentryentity");
            positionInfos.clear();
            jobInfos.clear();
            laborInfos.clear();
            for (String prefix : this.staffExtEntryHelper.getExtDimPrefix()) {
                DynamicObjectCollection extDimInfos = currentUseOrg.getDynamicObjectCollection(prefix + "entryentity");
                extDimInfos.clear();
            }
            this.model.updateEntryCache(this.model.getEntryEntity("bentryentity"));
            this.formView.setVisible(Boolean.valueOf(false), new String[]{"tabap", "importmuldimendetail"});
            this.formView.setVisible(Boolean.valueOf(true), new String[]{"flexnodata2"});
            this.model.setValue("belasticcontrol", null, rowIndex);
            this.model.setValue("belasticcount", null, rowIndex);
            this.formView.updateView("flexpanelap3");
        } else if ("4".equals(oldValue)) {
            DynamicObjectCollection dimensionInfos = (DynamicObjectCollection)this.model.getValue("staffdimension");
            Set dimensionIds = dimensionInfos.stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(dimensionIds)) {
                return;
            }
            long useOrgBoId = currentUseOrg.getLong("buseorg.boid");
            Map positionAndJobIdMap = StaffCommonService.getPositionAndJobIds(Collections.singletonList(useOrgBoId));
            HashSet[] positionAndJobIds = (HashSet[])positionAndJobIdMap.get(useOrgBoId);
            Set laborRelTypeIds = LaborRelTypeRepository.getInstance().queryLaborRelType();
            StaffProjectBo staffProjectBo = new StaffProjectBo(currentUseOrg.get("bcontrolstrategy"), currentUseOrg.get("belasticcontrol"), currentUseOrg.get("belasticcount"));
            DynamicObjectCollection positionListAll = new DynamicObjectCollection();
            DynamicObjectCollection jobListAll = new DynamicObjectCollection();
            DynamicObjectCollection laborListAll = new DynamicObjectCollection();
            StaffEntryHelper.buildChildEntryData(dimensionIds, (HashSet[])positionAndJobIds, (DynamicObjectCollection)positionListAll, (DynamicObjectCollection)jobListAll, (DynamicObjectCollection)laborListAll, (Set)laborRelTypeIds, (StaffProjectBo)staffProjectBo, (DynamicObject)currentUseOrg);
            this.fillReferenceData(positionListAll);
            this.fillReferenceData(jobListAll);
            this.fillReferenceData(laborListAll);
            this.setVisibleByUseOrg();
        }
    }

    public void staffProjectChanged(DynamicObject staffProjectNewValue) {
        if (Objects.isNull(staffProjectNewValue)) {
            this.model.setValue("staffdimension", null);
            this.model.setValue("staffcontrolstrategy", null);
            this.formView.setEnable(Boolean.FALSE, new String[]{"staffdimension", "staffcontrolstrategy"});
            this.formView.setVisible(Boolean.FALSE, new String[]{"staffelasticcontrol", "staffelasticcount", "staffpercent"});
        } else {
            if (staffProjectNewValue.getBoolean("unitycontrolmode")) {
                this.formView.setEnable(Boolean.FALSE, new String[]{"staffcontrolstrategy", "staffelasticcontrol", "staffelasticcount", "staffpercent"});
            } else {
                this.formView.setEnable(Boolean.TRUE, new String[]{"staffcontrolstrategy", "staffelasticcontrol", "staffelasticcount"});
            }
            if (staffProjectNewValue.getBoolean("unitystaffdimension")) {
                this.formView.setEnable(Boolean.FALSE, new String[]{"staffdimension"});
            } else {
                this.formView.setEnable(Boolean.TRUE, new String[]{"staffdimension"});
            }
        }
    }

    public void staffRuleInit(DynamicObject staffRuleConfig, boolean staffCycleChange) {
        DynamicObject staffProject = null;
        DynamicObjectCollection staffFDimension = null;
        Object staffControlStrategy = null;
        Object elasticControl = null;
        Object elasticCount = null;
        if (staffRuleConfig != null) {
            Object year = staffRuleConfig.get("year");
            this.model.setValue("year", year);
            this.model.setValue("staffcycle", staffRuleConfig.get("staffcycle"));
            staffProject = staffRuleConfig.getDynamicObject("staffproject");
            staffFDimension = staffProject.getDynamicObjectCollection("staffdimension");
            staffControlStrategy = staffProject.get("controlstrategy");
            elasticControl = staffProject.get("elasticcontrol");
            elasticCount = staffProject.get("elasticcount");
            if (staffCycleChange) {
                this.refreshEntryStaffProject(staffProject);
            }
        }
        this.model.setValue("staffproject", staffProject);
        this.model.setValue("staffdimension", staffFDimension);
        this.model.setValue("staffcontrolstrategy", staffControlStrategy);
        this.model.setValue("staffelasticcontrol", elasticControl);
        this.model.setValue("staffelasticcount", elasticCount);
        this.formView.setEnable(Boolean.valueOf(staffRuleConfig == null), new String[]{"staffproject", "staffcycle"});
        this.formView.updateView("flexbaseinfo");
    }

    public void refreshEntryStaffProject(DynamicObject staffProject) {
        DynamicObjectCollection staffDimensions = staffProject.getDynamicObjectCollection("staffdimension");
        StaffProjectBo staffProjectBo = new StaffProjectBo(staffProject.get("controlstrategy"), staffProject.get("elasticcontrol"), staffProject.get("elasticcount"), staffDimensions);
        staffProjectBo.setUnityStaffDimension(staffProject.getBoolean("unitystaffdimension"));
        staffProjectBo.setUnityControlMode(staffProject.getBoolean("unitycontrolmode"));
        Set dimensionIds = staffProjectBo.getStaffDimensionIds();
        DynamicObjectCollection useOrgInfos = this.model.getEntryEntity("bentryentity");
        if (CollectionUtils.isEmpty((Collection)useOrgInfos)) {
            return;
        }
        List adminOrgBoId = useOrgInfos.stream().map(dyn -> dyn.getLong("buseorg.boid")).collect(Collectors.toList());
        Map positionAndJobIdMap = StaffCommonService.getPositionAndJobIds(adminOrgBoId);
        Set laborRelTypeIds = LaborRelTypeRepository.getInstance().queryLaborRelType();
        DynamicObjectCollection positionListAll = new DynamicObjectCollection();
        DynamicObjectCollection jobListAll = new DynamicObjectCollection();
        DynamicObjectCollection laborListAll = new DynamicObjectCollection();
        for (DynamicObject useOrgInfo : useOrgInfos) {
            HashSet[] positionAndJobIds = (HashSet[])positionAndJobIdMap.get(useOrgInfo.getLong("buseorg.boid"));
            DynamicObjectCollection positionInfos = useOrgInfo.getDynamicObjectCollection("centryentity");
            DynamicObjectCollection jobInfo = useOrgInfo.getDynamicObjectCollection("dentryentity");
            DynamicObjectCollection laborInfos = useOrgInfo.getDynamicObjectCollection("eentryentity");
            HashMap<Long, DynamicObjectCollection> extInfosMap = new HashMap<Long, DynamicObjectCollection>(8);
            for (DynamicObject extDim : this.staffExtEntryHelper.getExtDim()) {
                String prefix = this.staffExtEntryHelper.getExtDimPrefix(extDim.getString("staffdimension"));
                if (!HRStringUtils.isNotEmpty((String)prefix)) continue;
                DynamicObjectCollection extDimInfos = useOrgInfo.getDynamicObjectCollection(prefix + "entryentity");
                extInfosMap.put(extDim.getLong("id"), extDimInfos);
            }
            DynamicObjectCollection currentDimensions = useOrgInfo.getDynamicObjectCollection("bstaffdimension");
            Set currentDimensionIds = currentDimensions.stream().map(dimensionDyn -> dimensionDyn.getLong("fbasedataid.id")).collect(Collectors.toSet());
            HashSet toAddDimension = new HashSet(dimensionIds);
            toAddDimension.removeAll(currentDimensionIds);
            HashSet toDeleteDimension = new HashSet(currentDimensionIds);
            toDeleteDimension.removeAll(dimensionIds);
            HashSet toUpdateDimension = new HashSet(dimensionIds);
            toUpdateDimension.retainAll(currentDimensionIds);
            if (staffProjectBo.isUnityStaffDimension() || CollectionUtils.isEmpty((Collection)currentDimensions)) {
                useOrgInfo.set("bstaffdimension", (Object)staffProjectBo.getStaffDimensions());
                StaffEntryHelper.buildChildEntryData(toAddDimension, (HashSet[])positionAndJobIds, (DynamicObjectCollection)positionListAll, (DynamicObjectCollection)jobListAll, (DynamicObjectCollection)laborListAll, (Set)laborRelTypeIds, (StaffProjectBo)staffProjectBo, (DynamicObject)useOrgInfo);
                if (toDeleteDimension.contains(1010L)) {
                    positionInfos.clear();
                }
                if (toDeleteDimension.contains(1020L)) {
                    jobInfo.clear();
                }
                if (toDeleteDimension.contains(1050L)) {
                    laborInfos.clear();
                }
                for (Map.Entry extDim : extInfosMap.entrySet()) {
                    if (!toDeleteDimension.contains(extDim.getKey())) continue;
                    ((DynamicObjectCollection)extDim.getValue()).clear();
                }
            }
            if (!staffProjectBo.isUnityControlMode()) continue;
            if (toUpdateDimension.contains(1010L)) {
                positionInfos.forEach(position -> this.setStaffProject((DynamicObject)position, staffProjectBo, "c"));
            }
            if (toUpdateDimension.contains(1020L)) {
                jobInfo.forEach(job -> this.setStaffProject((DynamicObject)job, staffProjectBo, "d"));
            }
            if (toUpdateDimension.contains(1050L)) {
                laborInfos.forEach(labor -> this.setStaffProject((DynamicObject)labor, staffProjectBo, "e"));
            }
            for (Map.Entry extDim : extInfosMap.entrySet()) {
                if (!toUpdateDimension.contains(extDim.getKey())) continue;
                ((DynamicObjectCollection)extDim.getValue()).forEach(dim -> this.setStaffProject((DynamicObject)dim, staffProjectBo, this.staffExtEntryHelper.getExtDimPrefix(((Long)extDim.getKey()).longValue())));
            }
            this.setStaffProject(useOrgInfo, staffProjectBo, "b");
        }
        this.fillReferenceData(positionListAll);
        this.fillReferenceData(jobListAll);
        this.fillReferenceData(laborListAll);
        this.setVisibleByUseOrg();
        this.formView.updateView("bentryentity");
    }

    private void setStaffProject(DynamicObject entryInfo, StaffProjectBo staffProjectBo, String prefix) {
        if (HRStringUtils.isEmpty((String)prefix)) {
            return;
        }
        if (staffProjectBo.isUnityControlMode() || HRStringUtils.isEmpty((String)entryInfo.getString(prefix + "controlstrategy"))) {
            entryInfo.set(prefix + "controlstrategy", staffProjectBo.getControlStrategy());
        }
        String controlStrategy = entryInfo.getString(prefix + "controlstrategy");
        if (staffProjectBo.isUnityControlMode() || entryInfo.get(prefix + "elasticcontrol") == null) {
            entryInfo.set(prefix + "elasticcontrol", staffProjectBo.getElasticControl());
        }
        if (staffProjectBo.isUnityControlMode() || entryInfo.getInt(prefix + "elasticcount") == 0) {
            entryInfo.set(prefix + "elasticcount", staffProjectBo.getElasticCount());
        }
        if (!controlStrategy.equals("3")) {
            entryInfo.set(prefix + "elasticcontrol", null);
            entryInfo.set(prefix + "elasticcount", null);
        }
    }

    public static void frozeColumn(String form, String entity, String ... columnNames) {
        ArrayList<GridConfigurationRow> gridConfigurationList = new ArrayList<GridConfigurationRow>(columnNames.length);
        for (String columnNam : columnNames) {
            GridConfigurationRow gridConfigurationRow = new GridConfigurationRow();
            gridConfigurationRow.setFieldKey(columnNam);
            gridConfigurationRow.setColWidth(0);
            gridConfigurationRow.setFreeze(true);
            gridConfigurationRow.setHide(false);
            gridConfigurationRow.setTextAlign("default");
            gridConfigurationList.add(gridConfigurationRow);
        }
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        gridConfigDAO.saveGridConfig(form, entity, gridConfigurationList);
    }

    public void setColumnStyle(String entity, List<Integer> rowIndex, String ... columnNames) {
        TreeEntryGrid entryEntity = (TreeEntryGrid)this.formView.getControl(entity);
        ArrayList<CellStyle> cellStyleList = new ArrayList<CellStyle>();
        for (int index : rowIndex) {
            for (String columnName : columnNames) {
                CellStyle cellStyle = new CellStyle();
                cellStyle.setBackColor("#FFFBF2");
                cellStyle.setFieldKey(columnName);
                cellStyle.setRow(index);
                cellStyleList.add(cellStyle);
            }
        }
        entryEntity.setCellStyle(cellStyleList);
    }

    public void setEntryLineEnableForPerm() {
        List<Integer> noRightUseOrgIndexList = this.getNoRightUseOrgEntryIndexList();
        this.setEntryLineEnableFalse(noRightUseOrgIndexList);
    }

    private List<Integer> getNoRightUseOrgEntryIndexList() {
        ArrayList noRightUseOrgIndexList = Lists.newArrayList();
        DynamicObjectCollection userOrgEntryCol = this.formView.getModel().getEntryEntity("bentryentity");
        AuthorizedOrgResultWithSub permResult = StaffCommonService.getOrgAuthWithSub();
        if (!permResult.isHasAllOrgPerm()) {
            Set hasRightOrgIdSet = StaffCommonService.getHasPermOrgIdSet((AuthorizedOrgResultWithSub)permResult);
            for (int i = 0; i < userOrgEntryCol.size(); ++i) {
                DynamicObject useOrgEntry = (DynamicObject)userOrgEntryCol.get(i);
                long orgId = useOrgEntry.getLong("buseorgboid.id");
                if (hasRightOrgIdSet.contains(orgId)) continue;
                noRightUseOrgIndexList.add(i);
            }
        }
        return noRightUseOrgIndexList;
    }

    private void setEntryLineEnableFalse(List<Integer> noRightUseOrgIndexList) {
        if (CollectionUtils.isEmpty(noRightUseOrgIndexList)) {
            return;
        }
        this.formView.getPageCache().put(this.CACHE_NORIGHT_INDEXLIST, SerializationUtils.toJsonString(noRightUseOrgIndexList));
        DynamicObject useOrgEntry = (DynamicObject)this.formView.getModel().getDataEntity().getDynamicObjectCollection("bentryentity").get(0);
        DataEntityPropertyCollection useOrgEntryProperties = useOrgEntry.getDataEntityType().getProperties();
        String[] useOrgEntryPropertiesArray = this.buildEntryPropArray(useOrgEntryProperties);
        noRightUseOrgIndexList.forEach(noRightUseOrgIndex -> this.formView.setEnable(Boolean.valueOf(false), noRightUseOrgIndex.intValue(), useOrgEntryPropertiesArray));
        if (noRightUseOrgIndexList.contains(0)) {
            this.setMultiEntryEnable();
        }
    }

    public void setMultiEntryEnableForPerm(Integer rowIndex) {
        String noRightIndexListJsonStr = this.formView.getPageCache().get(this.CACHE_NORIGHT_INDEXLIST);
        if (HRStringUtils.isEmpty((String)noRightIndexListJsonStr)) {
            return;
        }
        List noRightIndexList = SerializationUtils.fromJsonStringToList((String)this.formView.getPageCache().get(this.CACHE_NORIGHT_INDEXLIST), Integer.class);
        if (noRightIndexList.contains(rowIndex)) {
            this.setMultiEntryEnable();
        }
    }

    public void setUseOrgEntryAndMultiEntryEnableForPerm(int rowIndex) {
        String noRightIndexListJsonStr = this.formView.getPageCache().get(this.CACHE_NORIGHT_INDEXLIST);
        if (HRStringUtils.isEmpty((String)noRightIndexListJsonStr)) {
            return;
        }
        List noRightIndexList = SerializationUtils.fromJsonStringToList((String)this.formView.getPageCache().get(this.CACHE_NORIGHT_INDEXLIST), Integer.class);
        DynamicObject useOrgEntry = (DynamicObject)this.formView.getModel().getDataEntity().getDynamicObjectCollection("bentryentity").get(0);
        DataEntityPropertyCollection useOrgEntryProperties = useOrgEntry.getDataEntityType().getProperties();
        String[] useOrgEntryPropertiesArray = this.buildEntryPropArray(useOrgEntryProperties);
        noRightIndexList.forEach(noRightUseOrgIndex -> this.formView.setEnable(Boolean.valueOf(false), noRightUseOrgIndex.intValue(), useOrgEntryPropertiesArray));
        if (noRightIndexList.contains(rowIndex)) {
            this.setMultiEntryEnable();
        }
    }

    private void setMultiEntryEnable() {
        List multiPrefixList = StaffEntryTempHelperEnum.getMultiPrefixList();
        for (String multiPrefix : multiPrefixList) {
            String multiEntryName = multiPrefix + "entryentity";
            DynamicObjectCollection multiEntryCol = this.formView.getModel().getEntryEntity(multiEntryName);
            if (CollectionUtils.isEmpty((Collection)multiEntryCol)) continue;
            DataEntityPropertyCollection multiEntryProperties = ((DynamicObject)multiEntryCol.get(0)).getDataEntityType().getProperties();
            String[] multiEntryPropertiesArray = this.buildEntryPropArray(multiEntryProperties);
            for (int i = 0; i < multiEntryCol.size(); ++i) {
                this.formView.setEnable(Boolean.valueOf(false), i, multiEntryPropertiesArray);
            }
        }
    }

    private String[] buildEntryPropArray(DataEntityPropertyCollection entryProperties) {
        String[] useOrgEntryPropertiesArray = new String[entryProperties.size()];
        for (int i = 0; i < entryProperties.size(); ++i) {
            useOrgEntryPropertiesArray[i] = ((IDataEntityProperty)entryProperties.get(i)).getName();
        }
        return useOrgEntryPropertiesArray;
    }

    public void setVisibleByUseOrg() {
        DynamicObjectCollection useOrgEntry = this.model.getDataEntity(true).getDynamicObjectCollection("bentryentity");
        if (!CollectionUtils.isEmpty((Collection)useOrgEntry)) {
            this.formView.setVisible(Boolean.valueOf(false), new String[]{"flexnodata1"});
            this.formView.setVisible(Boolean.valueOf(true), new String[]{"bentryentity"});
            this.setControlStrategyFieldVisible("b");
            this.setControlStrategyFieldVisible("c");
            this.setControlStrategyFieldVisible("d");
            this.setControlStrategyFieldVisible("e");
            for (String prefix : this.staffExtEntryHelper.getExtDimPrefix()) {
                this.setControlStrategyFieldVisible(prefix);
            }
            DynamicObject currentUseOrg = this.model.getEntryRowEntity("bentryentity", 0);
            DynamicObjectCollection dimensionInfos = currentUseOrg.getDynamicObjectCollection("bstaffdimension");
            Set dimensionIds = dimensionInfos.stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toSet());
            this.formView.setVisible(Boolean.valueOf(!CollectionUtils.isEmpty(dimensionIds)), new String[]{"tabap"});
            this.formView.setVisible(Boolean.valueOf(CollectionUtils.isEmpty(dimensionIds)), new String[]{"flexnodata2"});
            this.formView.setVisible(Boolean.valueOf(dimensionIds.contains(1010L)), new String[]{"tabpage_position"});
            this.formView.setVisible(Boolean.valueOf(dimensionIds.contains(1020L)), new String[]{"tabpage_job"});
            this.formView.setVisible(Boolean.valueOf(dimensionIds.contains(1050L)), new String[]{"tabpage_laborreltype"});
            for (DynamicObject extDim : this.staffExtEntryHelper.getExtDim()) {
                this.formView.setVisible(Boolean.valueOf(dimensionIds.contains(extDim.getLong("id"))), new String[]{"tabpage_" + extDim.getString("staffdimension")});
            }
        } else {
            this.formView.setVisible(Boolean.valueOf(false), new String[]{"bentryentity"});
            this.formView.setVisible(Boolean.valueOf(true), new String[]{"flexnodata1"});
            this.formView.setVisible(Boolean.valueOf(false), new String[]{"tabap"});
        }
        this.formView.updateView("centryentity");
        this.formView.updateView("dentryentity");
        this.formView.updateView("eentryentity");
        for (String prefix : this.staffExtEntryHelper.getExtDimPrefix()) {
            this.formView.updateView(prefix + "entryentity");
        }
    }

    public void propertyChanged(String propertyName, ChangeData[] changeSet) {
        DynamicObject org = (DynamicObject)this.model.getValue("org");
        if (org == null) {
            return;
        }
        this.controlStrategyChange(propertyName, changeSet);
        this.strategySpringCalc(propertyName, changeSet);
        this.yearStaffNumWithSubChange(propertyName, changeSet);
        this.useOrgCycleFieldChange(propertyName, changeSet);
    }

    private void controlStrategyChange(String propertyName, ChangeData[] changeSet) {
        block4: {
            if (!"bcontrolstrategy".equals(propertyName) && !"ccontrolstrategy".equals(propertyName) && !"dcontrolstrategy".equals(propertyName) && !"econtrolstrategy".equals(propertyName) && !this.staffExtEntryHelper.getExtControlstrategy().contains(propertyName)) break block4;
            String prefix = propertyName.substring(0, 1);
            this.setControlStrategyFieldVisible(prefix);
            int rowIndex = changeSet[0].getRowIndex();
            if ("bcontrolstrategy".equals(propertyName)) {
                this.model.setValue(prefix + "elasticcontrol", null, rowIndex);
                this.model.setValue(prefix + "elasticcount", null, rowIndex);
                for (String commonCycleField : COMMON_CYCLE_FIELD) {
                    this.model.setValue(prefix + commonCycleField + "num", (Object)0, rowIndex);
                }
            } else {
                int parentRowIndex = changeSet[0].getParentRowIndex();
                this.model.setValue(prefix + "elasticcontrol", null, rowIndex, parentRowIndex);
                this.model.setValue(prefix + "elasticcount", null, rowIndex, parentRowIndex);
                for (String commonCycleField : COMMON_CYCLE_FIELD) {
                    this.model.setValue(prefix + commonCycleField + "num", (Object)0, rowIndex, parentRowIndex);
                }
            }
        }
    }

    private void useOrgCycleFieldChange(String propertyName, ChangeData[] changeSet) {
        List staffCyCleField = StaffCommonService.getMonthStaff((String)"b", null);
        if (staffCyCleField.contains(propertyName) || "byearstaff".equals(propertyName) || this.isChangefieldFromDim(propertyName)) {
            DynamicObject currentDyn;
            if (this.isChangefieldFromDim(propertyName)) {
                currentDyn = (DynamicObject)changeSet[0].getDataEntity().getParent();
            } else {
                String prefix = propertyName.substring(0, 1);
                int rowIndex = changeSet[0].getRowIndex();
                currentDyn = this.model.getEntryRowEntity(prefix + "entryentity", rowIndex);
            }
            Object currentYearStaffNumWithSubObject = currentDyn.get("byearstaffnumwithsub");
            if (Objects.nonNull(currentYearStaffNumWithSubObject) && currentDyn.getInt("byearstaffnumwithsub") != 0) {
                return;
            }
            DynamicObjectCollection useOrgInfos = this.model.getEntryEntity("bentryentity");
            DynamicObject parentUseOrgInfo = this.findDirectDutyOrg(currentDyn);
            if (parentUseOrgInfo == null) {
                return;
            }
            int parentIndex = useOrgInfos.indexOf((Object)parentUseOrgInfo);
            this.rebuildStaffNumWithSub(parentUseOrgInfo, parentIndex);
        }
    }

    public void rebuildStaffNumWithSubWhenDimEntryChange(DynamicObject currentDyn) {
        DynamicObject parentUseOrgInfo = this.findDirectDutyOrg(currentDyn);
        if (parentUseOrgInfo == null) {
            return;
        }
        DynamicObjectCollection useOrgInfos = this.model.getEntryEntity("bentryentity");
        int parentIndex = useOrgInfos.indexOf((Object)parentUseOrgInfo);
        this.rebuildStaffNumWithSub(parentUseOrgInfo, parentIndex);
    }

    private boolean isChangefieldFromDim(String propertyName) {
        List staffCyCleFieldDimC = StaffCommonService.getMonthStaff((String)"c", null);
        List staffCyCleFieldDimD = StaffCommonService.getMonthStaff((String)"d", null);
        List staffCyCleFieldDimE = StaffCommonService.getMonthStaff((String)"e", null);
        ArrayList<String> propNames = new ArrayList<String>(160);
        propNames.addAll(staffCyCleFieldDimC);
        propNames.addAll(staffCyCleFieldDimD);
        propNames.addAll(staffCyCleFieldDimE);
        propNames.add("cyearstaff");
        propNames.add("dyearstaff");
        propNames.add("eyearstaff");
        for (String prefix : this.staffExtEntryHelper.getExtDimPrefix()) {
            propNames.addAll(StaffCommonService.getMonthStaff((String)prefix, null));
            propNames.add(prefix + "yearstaff");
        }
        return propNames.contains(propertyName);
    }

    private DynamicObject findDirectDutyOrg(DynamicObject currentDyn) {
        DynamicObjectCollection useOrgInfos = this.model.getEntryEntity("bentryentity");
        Map<String, DynamicObject> structInfoMap = useOrgInfos.stream().filter(useOrgInfo -> !HRStringUtils.isEmpty((String)useOrgInfo.getString("bstructlongnumber"))).collect(Collectors.toMap(useOrgInfo -> useOrgInfo.getString("bstructlongnumber"), useOrgInfo -> useOrgInfo));
        String currentStructLongNumber = currentDyn.getString("bstructlongnumber");
        String[] structLongNumbers = StaffCommonService.buildStructLongNumberArr((String)currentStructLongNumber);
        int length = structLongNumbers.length;
        for (int i = length - 1; i >= 0; --i) {
            Object parentYearStaffNumWithSubObj;
            if (currentStructLongNumber.equals(structLongNumbers[i])) continue;
            DynamicObject useOrgInfo2 = structInfoMap.get(structLongNumbers[i]);
            int parentRowIndex = useOrgInfos.indexOf((Object)useOrgInfo2);
            if (useOrgInfo2 == null || parentRowIndex < 0 || (parentYearStaffNumWithSubObj = this.model.getValue("byearstaffnumwithsub", parentRowIndex)) == null) continue;
            return useOrgInfo2;
        }
        return null;
    }

    private void yearStaffNumWithSubChange(String propertyName, ChangeData[] changeSet) {
        DynamicObject staffCycle = (DynamicObject)this.model.getValue("staffcycle");
        if (staffCycle == null) {
            return;
        }
        if ("byearstaffnumwithsub".equals(propertyName)) {
            String prefix = propertyName.substring(0, 1);
            int rowIndex = changeSet[0].getRowIndex();
            DynamicObject currentDyn = this.model.getEntryRowEntity(prefix + "entryentity", rowIndex);
            if (changeSet[0].getNewValue() != null && (Integer)changeSet[0].getNewValue() > 0) {
                this.rebuildStaffNumWithSub(currentDyn, rowIndex);
            } else {
                this.model.setValue("bstaffnumwithsub", (Object)0, rowIndex);
            }
            DynamicObject parentUseOrgInfo = this.findDirectDutyOrg(currentDyn);
            if (parentUseOrgInfo == null) {
                return;
            }
            DynamicObjectCollection useOrgInfos = this.model.getEntryEntity("bentryentity");
            int parentIndex = useOrgInfos.indexOf((Object)parentUseOrgInfo);
            this.rebuildStaffNumWithSub(parentUseOrgInfo, parentIndex);
        }
    }

    public void rebuildStaffNumWithSub(DynamicObject currentDyn, int rowIndex) {
        if (currentDyn == null) {
            return;
        }
        List staffCyCleField = StaffCommonService.getMonthStaff((String)"b", null);
        List monthStaffWithNum = StaffCommonService.getMonthStaff((String)"b", (String)"num", (boolean)true);
        DynamicObject staffCycle = (DynamicObject)this.model.getValue("staffcycle");
        String currentStructLongNumber = currentDyn.getString("bstructlongnumber");
        Integer staffNumWithSubSum = 0;
        Integer staffNumWithSubNumSum = 0;
        DynamicObjectCollection useOrgInfos = this.model.getEntryEntity("bentryentity");
        ArrayList modelList = Lists.newArrayListWithExpectedSize((int)useOrgInfos.size());
        useOrgInfos.forEach(info -> modelList.add(new IdEntryDynModel((DynamicObject)info)));
        Map<Long, IdEntryDynModel> idVsModelMap = modelList.stream().collect(Collectors.toMap(model -> model.getId(), model -> model));
        for (IdEntryDynModel model2 : modelList) {
            Long pId = model2.getPId();
            IdEntryDynModel idEntryDynModel = idVsModelMap.get(pId);
            if (Objects.isNull(idEntryDynModel)) continue;
            idEntryDynModel.getChildModelList().add(model2);
        }
        ArrayList useOrgDynList = Lists.newArrayListWithExpectedSize((int)16);
        List<IdEntryDynModel> rootModelList = modelList.stream().filter(model -> model.getPId().equals(0L)).collect(Collectors.toList());
        this.recursiveAdd(useOrgDynList, rootModelList);
        String forbidStructLongNumber = "";
        for (DynamicObject useOrgInfo : useOrgDynList) {
            String structLongNumber = useOrgInfo.getString("bstructlongnumber");
            if (!structLongNumber.startsWith(currentStructLongNumber + "!") || structLongNumber.startsWith(forbidStructLongNumber + "!")) continue;
            Object subYearStaffObj = useOrgInfo.get("byearstaffnumwithsub");
            if (subYearStaffObj != null) {
                staffNumWithSubSum = staffNumWithSubSum + (Integer)subYearStaffObj;
                Object staffNumWithSubNumObject = useOrgInfo.get("byearstaffnumwithsubnum");
                if (staffNumWithSubNumObject != null) {
                    staffNumWithSubNumSum = staffNumWithSubNumSum + (Integer)staffNumWithSubNumObject;
                }
                forbidStructLongNumber = structLongNumber;
                continue;
            }
            if (staffCycle.getLong("id") == STAFF_CYCLE_YEAR.longValue()) {
                Object yearStaffNumObject;
                Object yearStaffObject = useOrgInfo.get("byearstaff");
                if (Objects.nonNull(yearStaffObject)) {
                    staffNumWithSubSum = staffNumWithSubSum + (Integer)yearStaffObject;
                } else {
                    int maxDim = StaffEntryHelper.getDimMaxValue((DynamicObject)useOrgInfo, (Long)staffCycle.getLong("id"), (String)"");
                    staffNumWithSubSum = staffNumWithSubSum + maxDim;
                }
                if (!Objects.nonNull(yearStaffNumObject = useOrgInfo.get("byearstaffnum"))) continue;
                staffNumWithSubNumSum = staffNumWithSubNumSum + (Integer)yearStaffNumObject;
                continue;
            }
            if (staffCycle.getLong("id") != STAFF_CYCLE_MONTH.longValue()) continue;
            ArrayList cycleFieldValue = Lists.newArrayListWithExpectedSize((int)16);
            ArrayList cycleFieldWithNumValue = Lists.newArrayListWithExpectedSize((int)16);
            staffCyCleField.forEach(name -> {
                if (Objects.nonNull(useOrgInfo.get(name))) {
                    cycleFieldValue.add(useOrgInfo.getInt(name));
                } else {
                    int maxDim = StaffEntryHelper.getDimMaxValue((DynamicObject)useOrgInfo, (Long)staffCycle.getLong("id"), (String)name.substring(1));
                    cycleFieldValue.add(maxDim);
                }
            });
            monthStaffWithNum.forEach(name -> {
                if (Objects.nonNull(useOrgInfo.get(name))) {
                    cycleFieldWithNumValue.add(useOrgInfo.getInt(name));
                }
            });
            cycleFieldValue.sort(Comparator.reverseOrder());
            cycleFieldWithNumValue.sort(Comparator.reverseOrder());
            if (!CollectionUtils.isEmpty((Collection)cycleFieldValue)) {
                staffNumWithSubSum = staffNumWithSubSum + (Integer)cycleFieldValue.get(0);
            }
            if (CollectionUtils.isEmpty((Collection)cycleFieldWithNumValue)) continue;
            staffNumWithSubNumSum = staffNumWithSubNumSum + (Integer)cycleFieldWithNumValue.get(0);
        }
        this.model.setValue("bstaffnumwithsub", (Object)staffNumWithSubSum, rowIndex);
        String controlStrategy = currentDyn.getString("bcontrolstrategy");
        if ("3".equals(controlStrategy)) {
            this.model.setValue("bstaffnumwithsubnum", (Object)staffNumWithSubNumSum, rowIndex);
        }
    }

    private void recursiveAdd(List<DynamicObject> useOrgDynList, List<IdEntryDynModel> rootModelList) {
        for (IdEntryDynModel rootModel : rootModelList) {
            useOrgDynList.add(rootModel.getEntryDyn());
            List<IdEntryDynModel> childModelList = rootModel.getChildModelList();
            if (CollectionUtils.isEmpty(childModelList)) continue;
            this.recursiveAdd(useOrgDynList, childModelList);
        }
    }

    private void strategySpringCalc(String propertyName, ChangeData[] changeSet) {
        DynamicObject org = (DynamicObject)this.model.getValue("org");
        List<String> staffCyCleField = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObject staffCycle = (DynamicObject)this.model.getValue("staffcycle");
        if (staffCycle != null) {
            staffCyCleField = staffCycle.getLong("id") == STAFF_CYCLE_MONTH.longValue() ? StaffCommonService.getMonthStaff(null, null) : StaffCommonService.getYearStaff(null, null);
        }
        if ("byearstaffnumwithsub".equals(propertyName) || staffCyCleField.contains(propertyName) || "elasticcontrol".equals(propertyName.substring(1)) || "elasticcount".equals(propertyName.substring(1))) {
            DynamicObject currentDyn;
            String prefix = propertyName.substring(0, 1);
            int rowIndex = changeSet[0].getRowIndex();
            int parentRowIndex = 0;
            if (!"b".equals(prefix)) {
                parentRowIndex = changeSet[0].getParentRowIndex();
                currentDyn = this.model.getEntryRowEntity(prefix + "entryentity", rowIndex, parentRowIndex);
            } else {
                currentDyn = this.model.getEntryRowEntity(prefix + "entryentity", rowIndex);
            }
            if ("3".equals(currentDyn.getString(prefix + "controlstrategy"))) {
                Object elasticCountObject = currentDyn.get(prefix + "elasticcount");
                if (Objects.isNull(elasticCountObject)) {
                    return;
                }
                String elasticControl = currentDyn.getString(prefix + "elasticcontrol");
                int elasticCount = currentDyn.getInt(prefix + "elasticcount");
                String roundType = (String)StaffCommonService.getSystemParam((long)org.getLong("id"), (String)"elasticcountgroup");
                if ("elasticcontrol".equals(propertyName.substring(1)) || "elasticcount".equals(propertyName.substring(1))) {
                    if ("b".equals(prefix)) {
                        staffCyCleField.add("byearstaffnumwithsub");
                    }
                    for (String property : staffCyCleField) {
                        if (!prefix.equals(property.substring(0, 1))) continue;
                        Object oldValue = this.model.getValue(property, rowIndex);
                        Integer value = StaffCommonService.elasticValueCalc((String)roundType, (String)elasticControl, (int)elasticCount, (Integer)((Integer)oldValue));
                        if ("b".equals(prefix)) {
                            this.model.setValue(property + "num", (Object)value, rowIndex);
                            continue;
                        }
                        this.model.setValue(property + "num", (Object)value, rowIndex, parentRowIndex);
                    }
                } else {
                    Integer newValue = (Integer)changeSet[0].getNewValue();
                    Integer value = StaffCommonService.elasticValueCalc((String)roundType, (String)elasticControl, (int)elasticCount, (Integer)newValue);
                    if ("b".equals(prefix)) {
                        this.model.setValue(propertyName + "num", (Object)value, rowIndex);
                    } else {
                        this.model.setValue(propertyName + "num", (Object)value, rowIndex, parentRowIndex);
                    }
                }
            }
        }
    }

    public void setControlStrategyFieldVisible(String prefix) {
        DynamicObjectCollection entryInfos = this.model.getEntryEntity(prefix + "entryentity");
        if (CollectionUtils.isEmpty((Collection)entryInfos)) {
            return;
        }
        boolean allControlStrategyNone = entryInfos.stream().anyMatch(dyn -> "3".equals(dyn.getString(prefix + "controlstrategy")));
        String groupName = "b".equals(prefix) ? "bgroup3" : prefix + "group2";
        this.formView.setVisible(Boolean.valueOf(allControlStrategyNone), new String[]{prefix + "elasticcontrol", prefix + "elasticcount", groupName});
    }

    public void orgTeamChange(DynamicObject newValue) {
        if (newValue != null) {
            long selectOrgId = newValue.getLong("id");
            DynamicObjectCollection useOrgInfos = this.model.getEntryEntity("bentryentity");
            List useOrgIds = useOrgInfos.stream().map(dyn -> dyn.getLong("buseorg.id")).collect(Collectors.toList());
            int selectRowIndex = useOrgIds.indexOf(selectOrgId);
            String isFromEntryClick = this.formView.getPageCache().get("useOrgEntryClick");
            if (!HRStringUtils.equals((String)isFromEntryClick, (String)"true")) {
                EntryGrid useOrgEntry = (EntryGrid)this.formView.getControl("bentryentity");
                useOrgEntry.selectRows(selectRowIndex);
            }
            this.formView.getPageCache().remove("useOrgEntryClick");
            DynamicObject currentUseOrg = this.model.getEntryRowEntity("bentryentity", selectRowIndex);
            DynamicObjectCollection dimensionInfos = currentUseOrg.getDynamicObjectCollection("bstaffdimension");
            Set dimensionIds = dimensionInfos.stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toSet());
            StaffEntryHelper.setActiveTab((Tab)((Tab)this.formView.getControl("tabap")), dimensionIds);
        } else {
            this.formView.setVisible(Boolean.valueOf(false), new String[]{"tabap"});
            this.formView.setVisible(Boolean.valueOf(true), new String[]{"flexnodata2"});
        }
    }

    public void mainOrgChange(DynamicObject orgOldValue, DynamicObject orgNewValue, ConfirmCallBackListener callBackListener) {
        if (orgOldValue == null && orgNewValue != null) {
            this.fillDataFromMainOrg(orgNewValue.getLong("id"));
        } else if (orgOldValue != null && orgNewValue == null) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u201c\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StaffFormService_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            this.model.setValue("org", (Object)orgOldValue);
        } else if (orgOldValue != null && orgOldValue.getLong("id") != orgNewValue.getLong("id")) {
            HashMap customValueMap = Maps.newHashMapWithExpectedSize((int)16);
            customValueMap.put("newValue", orgNewValue.getLong("id"));
            customValueMap.put("oldValue", orgOldValue.getLong("id"));
            this.formView.showConfirm("", ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"OrgStaffMainEdit_7", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, JSON.toJSONString((Object)customValueMap));
        }
    }

    public void fillDataFromMainOrg(long mainOrgId) {
        this.model.setValue("org", (Object)mainOrgId);
        DynamicObject orgDyn = (DynamicObject)this.model.getValue("org");
        Date year = (Date)this.model.getValue("year");
        DynamicObject staffRuleConfig = StaffCommonService.getOrgStaffRuleConfig((DynamicObject)orgDyn, (Date)year);
        this.staffRuleInit(staffRuleConfig, false);
        StaffEntryHelper.deleteEntryDataByName((AbstractFormDataModel)((AbstractFormDataModel)this.model), (String)"bentryentity");
        StaffInitEntryDataService.create(this.formView, this.model).loadEntryData();
        this.setVisibleByUseOrg();
        this.formView.updateView("bentryentity");
    }

    public void fillReferenceData(DynamicObjectCollection entryData) {
        if (!CollectionUtils.isEmpty((Collection)entryData)) {
            DynamicObjectType dataEntityType = ((DynamicObject)entryData.get(0)).getDynamicObjectType();
            ((FormDataModel)this.model).fillReferenceData(entryData.toArray(), (IDataEntityType)dataEntityType);
        }
    }

    public void setDimensionBtnVisible() {
        Tab tab = (Tab)this.formView.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        this.formView.setVisible(Boolean.valueOf("tabpage_job".equals(currentTab)), new String[]{"addjob", "deletejob", "exportjob"});
        this.formView.setVisible(Boolean.valueOf("tabpage_laborreltype".equals(currentTab)), new String[]{"addlaborreltype", "deletelaborreltype", "exportlaborreltype"});
        this.formView.setVisible(Boolean.valueOf("tabpage_position".equals(currentTab)), new String[]{"exportposition"});
        for (DynamicObject extDim : this.staffExtEntryHelper.getExtDim()) {
            String dimName = extDim.getString("staffdimension");
            String extTabName = "tabpage_" + dimName;
            this.formView.setVisible(Boolean.valueOf(extTabName.equals(currentTab)), new String[]{"export" + dimName, "add" + dimName, "delete" + dimName});
        }
    }

    public void showBaseDataForm(String billFormId, String formId, QFilter filter, CloseCallBack closeCallBack) {
        ListShowParameter formView = new ListShowParameter();
        formView.getOpenStyle().setShowType(ShowType.Modal);
        formView.setBillFormId(billFormId);
        formView.setFormId(formId);
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("960px");
        cssValue.setHeight("620px");
        formView.getOpenStyle().setInlineStyleCss(cssValue);
        formView.setLookUp(true);
        formView.setShowTitle(false);
        formView.setHasRight(true);
        formView.getListFilterParameter().getQFilters().add(filter);
        formView.setCloseCallBack(closeCallBack);
        this.formView.showForm((FormShowParameter)formView);
    }

    public void showOperationResultPage(String title, String message, CloseCallBack closeCallBack) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("title", (Object)title);
        parameters.setCustomParam("errorMsg", (Object)message);
        parameters.setCloseCallBack(closeCallBack);
        this.formView.showForm(parameters);
    }

    public static class IdEntryDynModel {
        Long id;
        Long pId;
        DynamicObject entryDyn;
        List<IdEntryDynModel> childModelList;

        public IdEntryDynModel(DynamicObject dyn) {
            this.id = dyn.getLong("id");
            this.pId = dyn.getLong("pid");
            this.entryDyn = dyn;
            this.childModelList = Lists.newArrayListWithExpectedSize((int)16);
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Long getPId() {
            return this.pId;
        }

        public void setPId(Long pId) {
            this.pId = pId;
        }

        public DynamicObject getEntryDyn() {
            return this.entryDyn;
        }

        public void setEntryDyn(DynamicObject entryDyn) {
            this.entryDyn = entryDyn;
        }

        public List<IdEntryDynModel> getChildModelList() {
            return this.childModelList;
        }

        public void setChildModelList(List<IdEntryDynModel> childModelList) {
            this.childModelList = childModelList;
        }
    }
}

