/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.staff.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.staff.service.StaffExtEntryHelper;

public class StaffSummaryCalcService {
    private DynamicObjectCollection data;
    private List<String> summaryFieldList = Lists.newArrayListWithExpectedSize((int)16);
    private StaffExtEntryHelper staffExtEntryHelper = new StaffExtEntryHelper();

    public StaffSummaryCalcService(long staffCycleId, DynamicObjectCollection data) {
        this.data = data;
        if (staffCycleId == 1010L) {
            for (int i = 1; i <= 12; ++i) {
                this.summaryFieldList.add("monthstaff" + i);
            }
        } else {
            this.summaryFieldList.add("yearstaff");
        }
    }

    public Map<Integer, Map<String, Long>> buildSummary(int[] selectedRows) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList<String> prefixList = new ArrayList<String>(Arrays.asList("c", "d", "e"));
        prefixList.addAll(this.staffExtEntryHelper.getExtDimPrefix());
        for (int selectedRow : selectedRows) {
            DynamicObject dynamicObject = (DynamicObject)this.data.get(selectedRow);
            HashMap<String, DynamicObjectCollection> infosMap = new HashMap<String, DynamicObjectCollection>(8);
            for (String prefix : prefixList) {
                DynamicObjectCollection infos = dynamicObject.getDynamicObjectCollection(prefix + "entryentity");
                if (CollectionUtils.isEmpty((Collection)infos)) continue;
                infosMap.put(prefix, infos);
            }
            if (infosMap.size() == 0) continue;
            HashMap fieldInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            for (String property : this.summaryFieldList) {
                ArrayList<Long> summaryList = new ArrayList<Long>(16);
                for (Map.Entry infos : infosMap.entrySet()) {
                    String prefix = (String)infos.getKey();
                    DynamicObjectCollection infoCol = (DynamicObjectCollection)infos.getValue();
                    long summary = CollectionUtils.isEmpty((Collection)infoCol) ? 0L : infoCol.stream().filter(dyn -> dyn.get(prefix + property) != null).mapToLong(dyn -> dyn.getLong(prefix + property)).sum();
                    summaryList.add(summary);
                }
                fieldInfoMap.put("b" + property, summaryList.stream().filter(Objects::nonNull).max(Long::compareTo).orElseGet(() -> 0L));
            }
            result.put(selectedRow, fieldInfoMap);
        }
        return result;
    }
}

