/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.structproject;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.servicehelper.SystemParamHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class OrgStructListPlugin
extends HRDataBaseList {
    private static final String STRUCT_EDIT = "struct_edit";
    private static final String ORG_CHART = "orgchart";
    private Boolean allStructProjectOrg;
    private static final String HAOS_STRUCTPROJECT = "haos_structproject";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (HRStringUtils.equals((String)operate.getOperateKey(), (String)STRUCT_EDIT)) {
            String rootOrgIdStr = (String)this.getView().getFormShowParameter().getCustomParam("rootorg");
            String structProjectIdStr = (String)this.getView().getFormShowParameter().getCustomParam("struct_project_ids");
            if (!HRStringUtils.isEmpty((String)rootOrgIdStr) && !HRStringUtils.isEmpty((String)structProjectIdStr)) {
                long rootOrgId = Long.parseLong(rootOrgIdStr);
                List structProjectIds = SerializationUtils.fromJsonStringToList((String)structProjectIdStr, Long.class);
                DynamicObject structProject = StructProjectRepository.getInstance().queryOneByStructProjectId("id, rootorg.id", ((Long)structProjectIds.get(0)).longValue());
                if (structProject == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ba1\u7406\u67b6\u6784\u5df2\u88ab\u5220\u9664,\u8bf7\u5237\u65b0\u9875\u9762\u540e\u8fdb\u5165\u3002", (String)"OrgStructProjectPermTreeListPlugin_2", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                } else if (structProject.getLong("rootorg.id") != rootOrgId) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ba1\u7406\u67b6\u6784\u6839\u8282\u70b9\u5df2\u88ab\u4fee\u6539,\u8bf7\u5237\u65b0\u9875\u9762\u540e\u8fdb\u5165\u3002", (String)"OrgStructProjectPermTreeListPlugin_3", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
            String modifyClockStr = this.getView().getPageCache().get("edit_struct_clock");
            if (!args.isCancel() && (modifyClockStr == null || HRStringUtils.equals((String)modifyClockStr, (String)"false"))) {
                DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("structproject");
                boolean modifyClock = MutexHelper.require((IFormView)this.getView(), (String)HAOS_STRUCTPROJECT, (Object)dynamicObject.getLong("id"), (String)"edit_struct", (boolean)true, (StringBuilder)new StringBuilder());
                this.getView().getPageCache().put("edit_struct_clock", String.valueOf(modifyClock));
                if (!modifyClock) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u5728\u5176\u4ed6\u9875\u7b7e\u4e2d\u6253\u5f00\uff0c\u5982\u9700\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5173\u95ed\u5355\u636e\u540e\u91cd\u8bd5\uff0c\u6216\u91cd\u65b0\u767b\u5f55\u540e\uff0c\u518d\u6b21\u5c1d\u8bd5\u3002", (String)"OrgStructProjectPermTreeListPlugin_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && HRStringUtils.equals((String)operateKey, (String)ORG_CHART)) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("homs_orgchart");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            long structProject = this.getModel().getDataEntity().getDynamicObject("structproject").getLong("id");
            showParameter.setCustomParam("showStructProjectType", (Object)String.valueOf(structProject));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("structproject".equals(actionId)) {
            Object obj = closedCallBackEvent.getReturnData();
            if (obj != null) {
                this.getView().showSuccessNotification(obj.toString());
            }
            DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("structproject");
            MutexHelper.release((String)HAOS_STRUCTPROJECT, (String)"edit_struct", (String)String.valueOf(dynamicObject.getLong("id")));
            this.getView().getPageCache().remove("edit_struct_clock");
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IPageCache pageCache = this.getView().getPageCache();
        Optional.ofNullable(pageCache.get("isimport")).ifPresent(cacheValue -> {
            pageCache.remove("isimport");
            this.getView().invokeOperation("refresh");
        });
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        DynamicObject structProject;
        List listColumns = args.getListColumns();
        if (this.getView().getModel().getDataEntity().containsProperty("structproject") && (structProject = this.getView().getModel().getDataEntity().getDynamicObject("structproject")) != null) {
            String isIncludeVirtualOrg = structProject.getString("isincludevirtualorg");
            listColumns.removeIf(listColumn -> HRStringUtils.equals((String)"isvirtualorg", (String)listColumn.getListFieldKey()) && !HRStringUtils.equals((String)isIncludeVirtualOrg, (String)"true"));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        DynamicObject dynamicObject;
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        Object primaryKeyValue = list.getFocusRowPkId();
        ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listParameter.isLookUp()) {
            return;
        }
        if (primaryKeyValue != null && (dynamicObject = AdOrgRepository.getInstance().queryByPk("id,name,isvirtualorg", primaryKeyValue)) != null && HRStringUtils.equals((String)"true", (String)dynamicObject.getString("isvirtualorg"))) {
            args.setCancel(Boolean.TRUE.booleanValue());
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setFormId("haos_virtualorgdetail");
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (this.getView().getMainView() != null) {
                baseShowParameter.setPageId(primaryKeyValue.toString() + "_" + this.getView().getMainView().getPageId());
            }
            String prefix = this.getView().getModel().getDataEntity().getString("structproject.name");
            baseShowParameter.setCaption(prefix + "-" + dynamicObject.getString("name"));
            DynamicObject structProject = this.getView().getModel().getDataEntity().getDynamicObject("structproject");
            baseShowParameter.setCustomParam("custom_parent_f7_prop", (Object)"boid");
            baseShowParameter.setCustomParam("structproject", (Object)String.valueOf(structProject.getLong("id")));
            baseShowParameter.setStatus(OperationStatus.VIEW);
            baseShowParameter.setCustomParam("edit", (Object)"true");
            baseShowParameter.setPkId(primaryKeyValue);
            if (this.getAllStructProjectOrg()) {
                baseShowParameter.setHasRight(Boolean.TRUE.booleanValue());
            }
            this.getView().showForm((FormShowParameter)baseShowParameter);
        }
    }

    private boolean getAllStructProjectOrg() {
        Long creatorId;
        Long userId;
        long orgId;
        if (this.allStructProjectOrg != null) {
            return this.allStructProjectOrg;
        }
        this.allStructProjectOrg = false;
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("struct_project_ids");
        List ids = SerializationUtils.fromJsonStringToList((String)customParam, Long.class);
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return this.allStructProjectOrg;
        }
        Long structProjectId = (Long)ids.get(0);
        DynamicObject dy = StructProjectRepository.getInstance().queryByPk("id,creator,org", (Object)structProjectId);
        if (dy != null && SystemParamHelper.getCreatorHasPermission((Long)(orgId = dy.getLong("org.id"))) && (userId = Long.valueOf(RequestContext.get().getCurrUserId())).equals(creatorId = Long.valueOf(dy.getLong("creator.id")))) {
            this.allStructProjectOrg = true;
        }
        return this.allStructProjectOrg;
    }
}

