/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.structproject;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.QueryExceedMaxCountEvent;
import kd.bos.list.events.QueryExceedMaxCountListener;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.servicehelper.SystemParamHelper;
import kd.hr.haos.formplugin.web.adminorg.template.AdminOrgPermTreeListBase;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.org.TreeTemplateHelper;
import kd.hr.hbp.business.servicehelper.org.util.OrgTreeUtils;
import kd.hr.hbp.common.constants.org.OrgTreeDynEnum;
import kd.hr.hbp.common.constants.org.OrgTreeSearchParam;
import kd.hr.hbp.common.constants.org.TreeTemplateConstants;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.AuthorizedStructResult;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.org.model.OrgTreeModel;

public class OrgStructProjectPermTreeListPlugin
extends AdminOrgPermTreeListBase {
    private static final String CUR_SUB_TREE_STRUCT_FIELDS = "adminorg.id id, adminorg.boid boid, adminorg.name name, parentorg.id parentorg, structlongnumber, isleaf, adminorg.enable enable,adminorg.tobedisableflag tobedisableflag";
    private Boolean allStructProjectOrg;
    public static final String CHK_INCLUDE_CHILD = "chkincludechild";
    private static final String HAOS_STRUCTPROJECT = "haos_structproject";
    private boolean rebuildTreeNodeFinish = false;
    private static final String LIST_COUNT = "list_count";
    private static final String STRUCT_EDIT = "struct_edit";

    public OrgStructProjectPermTreeListPlugin() {
        super(new OrgTreeModel(OrgTreeDynEnum.ADMIN_STRUCT.getDynEntity(), OrgTreeDynEnum.ADMIN_MAIN_ENTITY.getDynEntity(), Boolean.FALSE, Boolean.TRUE, Boolean.FALSE.booleanValue()));
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        final String listCountStr = this.getView().getPageCache().get(LIST_COUNT);
        QueryExceedMaxCountListener listener = new QueryExceedMaxCountListener(){

            public void queryExceedMaxCount(QueryExceedMaxCountEvent queryExceedMaxCountEvent) {
                if (HRStringUtils.isNotEmpty((String)listCountStr)) {
                    queryExceedMaxCountEvent.setDataCount(Integer.parseInt(listCountStr));
                } else {
                    queryExceedMaxCountEvent.setDataCount(0);
                }
                queryExceedMaxCountEvent.setCancel(true);
            }
        };
        billList.addQueryExceedMaxCountListener(listener);
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        if (this.listInfoMap != null && this.listInfoMap.containsKey(LIST_COUNT)) {
            this.getView().getPageCache().put(LIST_COUNT, String.valueOf(this.listInfoMap.get(LIST_COUNT)));
        } else {
            this.getView().getPageCache().put(LIST_COUNT, "0");
        }
    }

    protected boolean isShowDisableAndSearchDate() {
        return Boolean.FALSE;
    }

    protected String getListPermProKey() {
        return "boid";
    }

    @Override
    public void setFilter(SetFilterEvent setFilterEvent) {
        AuthorizedOrgResultWithSub permOrgResultWithSub;
        super.setFilter(setFilterEvent);
        ArrayList qFilterList = Lists.newArrayList((Object[])new QFilter[]{new QFilter("1", "=", (Object)1)});
        setFilterEvent.setDataPermQFilters((List)qFilterList);
        setFilterEvent.getQFilters().add(this.getDataStatusAndBSedFilter());
        if (!this.getAllStructProjectOrg() && !(permOrgResultWithSub = super.getPermOrgResultWithSub()).isHasAllOrgPerm()) {
            if (permOrgResultWithSub.getHasPermOrgsWithSub().size() > 0) {
                List orgIds = permOrgResultWithSub.getHasPermOrgsWithSub().stream().map(orgSubInfo -> orgSubInfo.getOrgId()).collect(Collectors.toList());
                ArrayList structLongNumberList = Lists.newArrayList();
                for (OrgSubInfo orgSubInfo2 : permOrgResultWithSub.getHasPermOrgsWithSub()) {
                    if (!orgSubInfo2.isContainsSub()) continue;
                    structLongNumberList.add(orgSubInfo2.getLongStructNumber());
                }
                if (!CollectionUtils.isEmpty((Collection)structLongNumberList)) {
                    QFilter structLongNumberQf = new QFilter("structlongnumber", "like", (Object)((String)structLongNumberList.get(0) + "%"));
                    for (int i = 1; i < structLongNumberList.size(); ++i) {
                        structLongNumberQf.or(new QFilter("structlongnumber", "like", (Object)((String)structLongNumberList.get(i) + "%")));
                    }
                    QFilter iscurrentVersionQf = new QFilter("iscurrentversion", "=", (Object)"1");
                    QFilter structQf = new QFilter("structproject", "=", (Object)this.getModel().getDataEntity().getDynamicObject("structproject").getLong("id"));
                    DynamicObject[] dynamicObjects = AdminOrgStructRepository.getInstance().queryOriginal("id,adminorg", new QFilter[]{structLongNumberQf, iscurrentVersionQf, structQf});
                    Arrays.asList(dynamicObjects).forEach(dynamicObject -> orgIds.add(dynamicObject.getLong("adminorg")));
                }
                QFilter qFilter = new QFilter("boid", "in", orgIds);
                setFilterEvent.setDataPermQFilters((List)Lists.newArrayList((Object[])new QFilter[]{qFilter}));
            } else {
                QFilter qFilter = new QFilter("1", "!=", (Object)1);
                setFilterEvent.setDataPermQFilters((List)Lists.newArrayList((Object[])new QFilter[]{qFilter}));
            }
        }
    }

    protected AuthorizedOrgResult getPermOrgResult() {
        if (this.getAllStructProjectOrg()) {
            return new AuthorizedOrgResult(Boolean.TRUE.booleanValue());
        }
        AuthorizedOrgResult permOrgResult = super.getPermOrgResult();
        return permOrgResult;
    }

    protected AuthorizedOrgResultWithSub getPermOrgResultWithSub() {
        if (this.getAllStructProjectOrg()) {
            return new AuthorizedOrgResultWithSub(Boolean.TRUE.booleanValue());
        }
        AuthorizedOrgResultWithSub permOrgResultWithSub = super.getPermOrgResultWithSub();
        return permOrgResultWithSub;
    }

    protected QFilter getOrgEnableFilter() {
        return QFilterHelper.create1Equals1Filter();
    }

    protected QFilter getOrgTreeEnableFilter() {
        if (this.isShowDisable()) {
            return QFilterHelper.create1Equals1Filter();
        }
        return new QFilter("adminorg.enable", "in", (Object)new String[]{"1", "10"});
    }

    public QFilter getTreeStructProjectFilter() {
        QFilter result = new QFilter("structproject", "in", (Object)this.getStructProjectCapable().getStructProjectIdSet());
        result.and(new QFilter("enable", "in", (Object)new String[]{"1", "10"}));
        return result;
    }

    private boolean getAllStructProjectOrg() {
        Long creatorId;
        Long userId;
        long orgId;
        if (this.allStructProjectOrg != null) {
            return this.allStructProjectOrg;
        }
        this.allStructProjectOrg = false;
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("struct_project_ids");
        List ids = SerializationUtils.fromJsonStringToList((String)customParam, Long.class);
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return this.allStructProjectOrg;
        }
        Long structProjectId = (Long)ids.get(0);
        DynamicObject dy = StructProjectRepository.getInstance().queryByPk("id,creator,org", (Object)structProjectId);
        if (dy != null && SystemParamHelper.getCreatorHasPermission((Long)(orgId = dy.getLong("org.id"))) && (userId = Long.valueOf(RequestContext.get().getCurrUserId())).equals(creatorId = Long.valueOf(dy.getLong("creator.id")))) {
            this.allStructProjectOrg = true;
        }
        return this.allStructProjectOrg;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent buildTreeListFilterEvent) {
        if (this.getModel().getDataEntity().getString(CHK_INCLUDE_CHILD).equals("true")) {
            this.setInCludeChild(Boolean.TRUE);
        } else {
            this.setInCludeChild(Boolean.FALSE);
        }
        QFilter filter = this.buildNodeClickFilter(buildTreeListFilterEvent);
        QFilter permFiter = this.getPermFilter();
        if (filter != null) {
            filter.and(permFiter);
            buildTreeListFilterEvent.addQFilter(filter);
            buildTreeListFilterEvent.setCancel(true);
        } else if (permFiter != null) {
            buildTreeListFilterEvent.addQFilter(permFiter);
            buildTreeListFilterEvent.setCancel(true);
        }
    }

    protected AuthorizedStructResult getPermStructProject() {
        AuthorizedStructResult authorizedStructResult = new AuthorizedStructResult();
        authorizedStructResult.setHasAllStruct(false);
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("struct_project_ids");
        List ids = SerializationUtils.fromJsonStringToList((String)customParam, Long.class);
        authorizedStructResult.setAuthorizedStructs(ids);
        return authorizedStructResult;
    }

    public TreeNode getRootNode() {
        this.getStructProjectCapable().getStructProject();
        IPageCache pageCache = this.getPageCache();
        String rootNodeStr = pageCache.get("org_root_node");
        if (!StringUtils.isEmpty((CharSequence)rootNodeStr)) {
            return (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
        }
        if (this.getPageCache().get("chkshowdisable") == null) {
            this.getPageCache().put("chkshowdisable", "true");
        }
        String text = ResManager.loadKDString((String)"\u672a\u5206\u914d\u7ec4\u7ec7\u8303\u56f4\u3002", (String)"OrgStructProjectPermTreeListPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
        TreeNode rootNode = new TreeNode("", "0", text, (Object)"0");
        DynamicObject rootNodeDynamicObj = this.getRootDynamicObject();
        if (rootNodeDynamicObj != null && this.getDefinedDyVsCustomNode().containsKey(rootNodeDynamicObj.getLong("id"))) {
            return (TreeNode)((Supplier)this.getDefinedDyVsCustomNode().get(rootNodeDynamicObj.getLong("id"))).get();
        }
        if (rootNodeDynamicObj != null) {
            this.encapsulateRootNode(rootNode, rootNodeDynamicObj);
        }
        pageCache.put("org_root_node", SerializationUtils.toJsonString((Object)rootNode));
        return rootNode;
    }

    protected DynamicObject getRootDynByRootId() {
        return null;
    }

    @Override
    public void refreshNode(RefreshNodeEvent refreshNodeEvent) {
        DynamicObject dynamicObject;
        TreeNode rootNode;
        TreeNode node;
        String nodeId = (String)refreshNodeEvent.getNodeId();
        if (HRStringUtils.isNotEmpty((String)nodeId) && (node = OrgTreeUtils.getNode((TreeNode)(rootNode = this.getTreeModel().getRoot()), (Object)nodeId)) != null && (dynamicObject = AdOrgRepository.getInstance().queryByPk("id,name, isvirtualorg", (Object)Long.parseLong(nodeId))) != null && "true".equals(dynamicObject.getString("isvirtualorg"))) {
            node.setText(dynamicObject.getString("name"));
        }
        if (this.isRootChange() && !this.rebuildTreeNodeFinish) {
            this.rebuildTreeNodeFinish = true;
            this.rebuildTreeNode();
        } else {
            super.refreshNode(refreshNodeEvent);
        }
    }

    private boolean isRootChange() {
        String customParam = this.getView().getPageCache().get("root_change");
        if (customParam == null) {
            return false;
        }
        return (Boolean)SerializationUtils.fromJsonString((String)customParam, Boolean.class);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"boid");
        if (fieldName.startsWith("struct_parent_org")) {
            List orgIds;
            AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub();
            DynamicObject structDy = this.getModel().getDataEntity().getDynamicObject("structproject");
            if (!permOrgResultWithSub.isHasAllOrgPerm()) {
                List authOrgIds = permOrgResultWithSub.getHasPermOrgsWithSub().stream().map(orgSubInfo -> orgSubInfo.getOrgId()).collect(Collectors.toList());
                List structNumberList = permOrgResultWithSub.getHasPermOrgsWithSub().stream().filter(orgSubInfo -> orgSubInfo.isContainsSub()).map(orgSubInfo -> orgSubInfo.getLongStructNumber()).collect(Collectors.toList());
                DynamicObject[] dynamicObjects = AdminOrgStructRepository.getInstance().queryOriginStructInfoLikeStructNumOrOrgIds("id,adminorg.id,adminorg.name", structNumberList, authOrgIds, Long.valueOf(structDy.getLong("id")), "structlongnumber");
                orgIds = Arrays.asList(dynamicObjects).stream().map(dynamicObject -> dynamicObject.getLong("adminorg.id")).collect(Collectors.toList());
            } else {
                DynamicObject[] dynamicObjects = AdminOrgStructRepository.getInstance().queryOriginStructInfoLikeStructNumOrOrgIds("id,adminorg.id,adminorg.name", null, null, Long.valueOf(structDy.getLong("id")), "structlongnumber");
                orgIds = Arrays.asList(dynamicObjects).stream().map(dynamicObject -> dynamicObject.getLong("adminorg.id")).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty(orgIds)) {
                args.addCustomQFilter(new QFilter("boid", "in", orgIds));
            }
            args.addCustomParam("struct_project_ids", this.getView().getFormShowParameter().getCustomParam("struct_project_ids"));
            args.addCustomParam("struct_project_visible", (Object)String.valueOf(Boolean.FALSE));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            String fieldName = filterColumn.getFieldName();
            if (!HRStringUtils.equals((String)fieldName, (String)"struct_parent_org.name")) continue;
            List<ComboItem> combos = this.buildOrgComboItems();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            commonFilterColumn.setComboItems(combos);
            commonFilterColumn.setType("enum");
        }
    }

    private List<ComboItem> buildOrgComboItems() {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub();
        DynamicObject structDy = this.getModel().getDataEntity().getDynamicObject("structproject");
        if (!permOrgResultWithSub.isHasAllOrgPerm() && !CollectionUtils.isEmpty((Collection)permOrgResultWithSub.getHasPermOrgsWithSub())) {
            DynamicObject[] dynamicObjects;
            List orgIds = permOrgResultWithSub.getHasPermOrgsWithSub().stream().map(orgSubInfo -> orgSubInfo.getOrgId()).collect(Collectors.toList());
            List orgStructLongNumberList = permOrgResultWithSub.getHasPermOrgsWithSub().stream().filter(orgSubInfo -> orgSubInfo.isContainsSub()).map(orgSubInfo -> orgSubInfo.getLongStructNumber()).collect(Collectors.toList());
            for (DynamicObject org : dynamicObjects = AdminOrgStructRepository.getInstance().queryOriginStructInfoLikeStructNumOrOrgIds("id,adminorg.id,adminorg.name", orgStructLongNumberList, orgIds, Long.valueOf(structDy.getLong("id")), "structlongnumber")) {
                if (org == null) continue;
                ComboItem item = new ComboItem();
                item.setId(String.valueOf(org.getLong("adminorg.id")));
                item.setValue(String.valueOf(org.getLong("adminorg.id")));
                item.setCaption(new LocaleString(org.getString("adminorg.name")));
                combos.add(item);
            }
        } else {
            DynamicObject[] adminorgDys;
            for (DynamicObject org : adminorgDys = AdminOrgStructRepository.getInstance().queryStructInfoByStruct("adminorg.id,adminorg.name", Long.valueOf(structDy.getLong("id")), "structlongnumber")) {
                if (org == null) continue;
                ComboItem item = new ComboItem();
                item.setId(String.valueOf(org.getLong("adminorg.id")));
                item.setValue(String.valueOf(org.getLong("adminorg.id")));
                item.setCaption(new LocaleString(org.getString("adminorg.name")));
                combos.add(item);
            }
        }
        return combos;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (HRStringUtils.equals((String)operateKey, (String)"searchnode")) {
            String nodeIdStr = this.getView().getPageCache().get("searchnode");
            if (HRStringUtils.isEmpty((String)nodeIdStr)) {
                this.clearParentChangedCache();
                return;
            }
            String oldParentId = this.getView().getPageCache().get("oldModifyParentId");
            if (HRStringUtils.equals((String)oldParentId, (String)nodeIdStr)) {
                this.clearParentChangedCache();
                return;
            }
            this.removeNode(oldParentId, this.getView().getPageCache().get("modifyNodeId"));
            TreeTemplateHelper.removeRootAndStructLongNumberCache((IPageCache)this.getPageCache());
            this.clickNodeById(Long.valueOf(nodeIdStr));
            this.clearParentChangedCache();
            this.getView().invokeOperation("refresh");
        } else if (HRStringUtils.equals((String)operateKey, (String)STRUCT_EDIT) && operationResult != null && operationResult.isSuccess()) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("haos_otherstructdetail");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "structproject"));
            String customParam = (String)this.getView().getFormShowParameter().getCustomParam("struct_project_ids");
            List ids = SerializationUtils.fromJsonStringToList((String)customParam, Long.class);
            if (CollectionUtils.isEmpty((Collection)ids)) {
                return;
            }
            String mainPageId = "";
            if (this.getView().getMainView() != null) {
                mainPageId = this.getView().getMainView().getPageId();
            }
            formShowParameter.setPageId("haos_otherstructdetail_" + String.valueOf(ids.get(0) + "_" + mainPageId));
            formShowParameter.setCustomParam("id", (Object)String.valueOf(ids.get(0)));
            if (this.getTreeModel().getCurrentNodeId() != null) {
                TreeNode treeNode = OrgTreeUtils.getNode((TreeNode)this.getTreeModel().getRoot(), (Object)this.getTreeModel().getCurrentNodeId());
                formShowParameter.setCustomParam("adminorg", (Object)treeNode.getText());
            }
            this.getView().showForm(formShowParameter);
        }
    }

    private void removeNode(String oldParentIdStr, String modifyNodeIdStr) {
        TreeView treeView = this.getTreeListView().getTreeView();
        treeView.deleteNode(modifyNodeIdStr);
        if (HRStringUtils.isEmpty((String)oldParentIdStr)) {
            return;
        }
        TreeNode oldParentNode = OrgTreeUtils.getNode((TreeNode)this.getRootNode(), (Object)oldParentIdStr);
        if (oldParentNode == null) {
            QFilter idFilter = new QFilter("adminorg.id", "=", (Object)Long.valueOf(oldParentIdStr));
            QFilter[] filters = new QFilter[]{idFilter, this.getSearchTreeStructFilter(), this.getOrgTreeFilter()};
            DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl(CUR_SUB_TREE_STRUCT_FIELDS, filters, null);
            if (CollectionUtils.isEmpty((Collection)dynCol)) {
                return;
            }
            DynamicObject dynamicObject = (DynamicObject)dynCol.get(0);
            oldParentNode = new TreeNode(dynamicObject.getString("parentorg"), String.valueOf(dynamicObject.getLong("id")), dynamicObject.getString("name"));
            oldParentNode.setLongNumber(dynamicObject.getString("structlongnumber"));
            oldParentNode.setData((Object)dynamicObject.getString("boid"));
            this.setOrgLeaf(dynCol, "parentorg");
            if (dynamicObject.getBoolean("isleaf")) {
                oldParentNode.setLeaf(true);
                oldParentNode.setChildren(null);
                treeView.updateNode(oldParentNode);
            }
        }
    }

    private void clickNodeById(Long orgId) {
        TreeNode treeNode = OrgTreeUtils.getNode((TreeNode)this.getRootNode(), (Object)orgId);
        if (treeNode != null) {
            TreeView treeView = this.getTreeListView().getTreeView();
            treeView.focusNode(treeNode);
            treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
            return;
        }
        this.searchNodeById(orgId);
    }

    private void clearParentChangedCache() {
        this.getView().getPageCache().remove("searchnode");
        this.getView().getPageCache().remove("modifyNodeId");
        this.getView().getPageCache().remove("oldModifyParentId");
    }

    private void searchNodeById(Long orgId) {
        ArrayList treeNodes = Lists.newArrayListWithCapacity((int)16);
        QFilter idFilter = new QFilter("adminorg.id", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{idFilter, this.getSearchTreeStructFilter(), this.getOrgTreeFilter()};
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl(CUR_SUB_TREE_STRUCT_FIELDS, filters, null);
        if (CollectionUtils.isEmpty((Collection)dynCol)) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)dynCol.get(0);
        TreeNode treeNode = new TreeNode(dynamicObject.getString("parentorg"), String.valueOf(dynamicObject.getLong("id")), dynamicObject.getString("name"));
        treeNode.setLongNumber(dynamicObject.getString("structlongnumber"));
        treeNode.setData((Object)dynamicObject.getString("boid"));
        treeNodes.add(treeNode);
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(treeNode.getText(), (ListView)this.getView());
        this.searchFromLazyOrgTree(searchParam, treeNodes);
        TreeView treeView = this.getTreeListView().getTreeView();
        treeView.addNodes((List)treeNodes);
        treeView.focusNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
    }

    private void searchFromLazyOrgTree(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes) {
        TreeView treeView = this.getTreeListView().getTreeView();
        treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
        this.searchExistsNodeFromLazyOrgTree(searchParam, treeNodes, 0);
    }

    private TreeNode searchExistsNodeFromLazyOrgTree(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes, int recursionCount) {
        if (CollectionUtils.isEmpty(treeNodes) || recursionCount > 20) {
            return null;
        }
        TreeNode node = treeNodes.get(0);
        if (node == null) {
            return null;
        }
        String parentId = node.getParentid();
        TreeNode parentNode = OrgTreeUtils.getNode((TreeNode)searchParam.getRootNode(), (Object)parentId);
        if (OrgTreeUtils.isChildNode((TreeNode)parentNode, (TreeNode)node)) {
            HashSet loopController = Sets.newHashSetWithExpectedSize((int)16);
            ArrayList expendIds = Lists.newArrayListWithCapacity((int)16);
            OrgTreeUtils.expandParentNode((OrgTreeSearchParam)searchParam, (String)parentId, (Set)loopController, (List)expendIds, (int)0);
            for (int i = expendIds.size() - 1; i >= 0; --i) {
                searchParam.getTreeView().expand((String)expendIds.get(i));
            }
        } else {
            this.queryTreeNodeWithParent(searchParam, node);
        }
        node = OrgTreeUtils.getNode((TreeNode)searchParam.getRootNode(), (Object)node.getId());
        if (node == null) {
            TreeNode removeNode = treeNodes.remove(0);
            String subNodeLongNumber = removeNode.getLongNumber() + "!";
            ArrayList removeSubNodes = Lists.newArrayList();
            for (TreeNode subNode : treeNodes) {
                if (subNode.getLongNumber() == null || !subNode.getLongNumber().startsWith(subNodeLongNumber)) continue;
                removeSubNodes.add(subNode);
            }
            treeNodes.removeAll(removeSubNodes);
            return this.searchExistsNodeFromLazyOrgTree(searchParam, treeNodes, recursionCount);
        }
        return node;
    }

    private void queryTreeNodeWithParent(OrgTreeSearchParam searchParam, TreeNode node) {
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        TreeNode curTreeNode = OrgTreeUtils.getNode((TreeNode)this.getTreeModel().getRoot(), (Object)currentNodeId.toString());
        String structLongNumber = node.getLongNumber();
        int nextLongNumberLength = curTreeNode.getLongNumber().length() + TreeTemplateConstants.LONG_NUMBER_AND_SPLIT_LENGTH;
        if (structLongNumber.length() < nextLongNumberLength) {
            return;
        }
        String newParentStructLongNumber = structLongNumber.substring(0, nextLongNumberLength);
        String notLoadParentLongNumber = newParentStructLongNumber.substring(newParentStructLongNumber.lastIndexOf(33) + 1);
        int layerCount = (structLongNumber.length() - newParentStructLongNumber.length()) / TreeTemplateConstants.LONG_NUMBER_AND_SPLIT_LENGTH;
        ArrayList<String> structNumbers = new ArrayList<String>();
        structNumbers.add(notLoadParentLongNumber);
        this.getView().getFormShowParameter().setCustomParam("layerCount", (Object)layerCount);
        this.queryTreeNodeChildrenByStructNumbers(searchParam, structNumbers, node);
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        String currentNodeId = treeNodeEvent.getNodeId().toString();
        TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId, 20);
        if (null != currentNode) {
            List children = currentNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)children) && null == children) {
                children = Lists.newArrayListWithCapacity((int)0);
            }
            this.addChildNodeWrap(currentNodeId, children);
        } else {
            this.getTreeModel().setCurrentNodeId((Object)this.getTreeModel().getRoot().getId());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("structproject".equals(actionId)) {
            this.getView().getPageCache().remove("edit_struct_clock");
        }
    }
}

