/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.structproject;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.TipsSupport;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeDragEvent;
import kd.bos.form.control.events.TreeNodeDragListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.rpc.HRCSRPCServiceHelper;
import kd.hr.haos.business.service.otherstruct.model.OtherStructVO;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.haos.formplugin.web.structproject.OrgStructTreeView;
import kd.hr.haos.formplugin.web.structproject.OtherStructTreeView;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class OtherStructDetailEditPlugin
extends HRDataBaseEdit
implements StructProjectConstants,
TreeNodeDragListener,
TreeNodeClickListener {
    private static final Log LOG = LogFactory.getLog(OtherStructDetailEditPlugin.class);
    private static final String STRUCT_PROJECT_ENABLE = "structproject.enable";
    private final List<String> checkBoxList = Arrays.asList("orgcheckbox", "othercheckbox");
    private static final String HRMP_HBP_FORMPLUGIN = "hrmp-hbp-formplugin";
    private static final String BTNENABLE = "btnenable";
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"OtherStructDetailEditPlugin.ThreadPools", (int)2);
    protected static final String STRUCT_PROJECT_CHANGE = "struct_project_change";
    protected static final String STRUCT_PROJECT_DATE = "struct_project_date";
    private static final String HAOS_ORGTREEFITER = "haos_orgtreefiter";
    private static final String RETRACT = "retract";
    private static final String EXPAND = "expand";
    private static final String VECTORAP_RETRACT = "vectorap_retract";
    private static final String VECTORAP_EXPAND = "vectorap_expand";
    private static final String ORG_FLEX = "org_flex";
    private static final String EXPAND_FLEX = "expand_flex";
    private static final String RETRACT_FLEX = "retract_flex";

    public void initialize() {
        super.initialize();
        IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("key", "org_tree");
        hashMap.put("labelShowType", 1);
        service.addAction("u", hashMap);
        IClientViewProxy service2 = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("key", "other_tree");
        hashMap2.put("labelShowType", 1);
        service2.addAction("u", hashMap2);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().getPageCache().put("chkshowdisableorg_tree_filter", "false");
        String idStr = (String)this.getView().getFormShowParameter().getCustomParam("id");
        this.getModel().setValue("structproject", (Object)Long.valueOf(idStr));
        String currentNodeName = (String)this.getView().getFormShowParameter().getCustomParam("adminorg");
        Future orgTreeFuture = threadPool.submit(() -> {
            this.setDataToOrgTree();
            return Boolean.TRUE;
        });
        Future otherTreeFuture = threadPool.submit(() -> {
            this.initOtherStructView();
            if (StringUtils.isNotEmpty((CharSequence)currentNodeName)) {
                this.getOtherStructTreeView().search(currentNodeName);
            }
            return Boolean.TRUE;
        });
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("structproject");
        if (!dynamicObject.getBoolean("isincludevirtualorg")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"add_org"});
        }
        if (HRStringUtils.equals((String)"10", (String)dynamicObject.getString("enable"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTNENABLE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTNENABLE});
        }
        try {
            orgTreeFuture.get();
            otherTreeFuture.get();
        }
        catch (Exception ex) {
            LOG.error("\u521d\u59cb\u5316\u7ec4\u7ec7\u6811\u5931\u8d25\u3002", (Object)e);
        }
        this.setStructProjectEffdt();
        Label otherlap = (Label)this.getView().getControl("otherlap");
        otherlap.setText(this.getModel().getDataEntity().getString("structproject.name"));
        this.setTips();
        this.getView().setFormTitle(new LocaleString(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s-\u8c03\u6574\u67b6\u6784", (String)"OtherStructDetailEditPlugin_14", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), this.getModel().getDataEntity().getString("structproject.name"))));
    }

    protected void setStructProjectEffdt() {
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("structproject");
        Date date = HRDateTimeUtils.getNowDate();
        if (dynamicObject != null && HRStringUtils.equals((String)"10", (String)dynamicObject.getString("enable"))) {
            date = dynamicObject.getDate("effdt");
        }
        this.getModel().setValue("bsed", (Object)date);
    }

    private void setDataToOrgTree() {
        this.initOrgStructView();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"org_tree_filter", "struct_tree_filter", "clean_org", "clean_struct", "btn_addnode", "btn_delnode", "add_org", RETRACT, EXPAND, VECTORAP_RETRACT, VECTORAP_EXPAND});
        this.addListener();
        TreeView otherTree = (TreeView)this.getView().getControl("other_tree");
        otherTree.addTreeNodeDragListener((TreeNodeDragListener)this);
        otherTree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    private void addListener() {
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(searchEnterEvt -> {
            String searchText = searchEnterEvt.getText();
            if (!HRStringUtils.isEmpty((String)searchText)) {
                this.getOrgStructTreeView().search(searchText);
            }
        });
        ((Search)this.getControl("othersearch")).addEnterListener(searchEnterEvt -> {
            String searchText = searchEnterEvt.getText();
            if (!HRStringUtils.isEmpty((String)searchText)) {
                this.getOtherStructTreeView().search(searchText);
            }
        });
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("org_tree_filter".equals(control.getKey())) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, control.getKey());
            this.showAdminOrgTreeFilterDialog(closeCallBack, control.getKey());
        } else if ("struct_tree_filter".equals(control.getKey())) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, control.getKey());
            this.showAdminOrgTreeFilterDialog(closeCallBack, control.getKey());
        } else if ("clean_org".equals(control.getKey()) || "clean_struct".equals(control.getKey())) {
            TreeView treeView = "clean_org".equals(control.getKey()) ? (TreeView)this.getControl("org_tree") : (TreeView)this.getControl("other_tree");
            List selectIds = treeView.getTreeState().getSelectedNodeId();
            if (CollectionUtils.isEmpty((Collection)selectIds)) {
                return;
            }
            treeView.uncheckNodes(selectIds);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_delnode".equals(key)) {
            OtherStructTreeView otherStructTreeView = this.getOtherStructTreeView();
            if (this.checkDelete(otherStructTreeView)) {
                evt.setCancel(true);
                return;
            }
            if (!this.showVirtualConfirm(otherStructTreeView)) {
                this.deleteNodes(otherStructTreeView);
            }
        } else if ("btn_addnode".equals(key)) {
            TreeView orgTreeView = (TreeView)this.getControl("org_tree");
            OtherStructTreeView otherStructTreeView = this.getOtherStructTreeView();
            if (this.checkAdd(otherStructTreeView, orgTreeView)) {
                evt.setCancel(true);
                return;
            }
            List selectedList = orgTreeView.getTreeState().getSelectedNodeId();
            List<String> allDeleteNodeIds = otherStructTreeView.addNodes(selectedList);
            this.removeEntryEntity(allDeleteNodeIds);
            orgTreeView.uncheckNodes(selectedList);
            this.getView().getPageCache().put(STRUCT_PROJECT_CHANGE, "true");
        } else if ("add_org".equals(control.getKey())) {
            TreeView orgTreeView = (TreeView)this.getControl("other_tree");
            if (this.checkAddOrg(orgTreeView)) {
                evt.setCancel(true);
                return;
            }
            this.openOrg("add_org", null, (String)orgTreeView.getTreeState().getSelectedNodeId().get(0), null);
        }
    }

    private void deleteNodes(OtherStructTreeView otherStructTreeView) {
        this.getView().getPageCache().put(STRUCT_PROJECT_CHANGE, "true");
        List<String> allDeleteNodeIds = otherStructTreeView.deleteNodes();
        this.removeEntryEntity(allDeleteNodeIds);
    }

    private void removeEntryEntity(List<String> allDeleteNodeIds) {
        if (CollectionUtils.isEmpty(allDeleteNodeIds)) {
            return;
        }
        DynamicObjectCollection col = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)col)) {
            return;
        }
        HashSet orgSet = new HashSet(allDeleteNodeIds.size());
        col.removeIf(dy -> {
            boolean flag = allDeleteNodeIds.contains(dy.getString("orgid"));
            if (flag) {
                orgSet.add(dy.getLong("orgid"));
            }
            return flag;
        });
        if (!CollectionUtils.isEmpty(orgSet)) {
            AdOrgRepository.getInstance().deleteTempVirtualOrg(orgSet);
        }
    }

    private boolean showVirtualConfirm(OtherStructTreeView otherStructTreeView) {
        List<String> deleteNodeIds = otherStructTreeView.getAllDeleteNodeIds();
        if (CollectionUtils.isEmpty(deleteNodeIds)) {
            return false;
        }
        Set orgSet = deleteNodeIds.stream().map(Long::valueOf).collect(Collectors.toSet());
        boolean existsVirtual = AdOrgRepository.getInstance().existsVirtualByOrgSet(orgSet);
        if (existsVirtual) {
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("btn_delnode", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u9700\u79fb\u51fa\u865a\u62df\u7ec4\u7ec7\uff0c\u8be5\u52a8\u4f5c\u4e00\u65e6\u751f\u6548\u540e\u5c06\u4e0d\u53ef\u64a4\u9500\uff0c\u53ea\u80fd\u91cd\u65b0\u65b0\u589e\u865a\u62df\u7ec4\u7ec7\uff0c\u786e\u5b9a\u79fb\u9664\uff1f", (String)"OtherStructDetailEditPlugin_13", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, callBackListener);
        }
        return existsVirtual;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"btnsave") || HRStringUtils.equals((String)operateKey, (String)BTNENABLE)) {
            OtherStructTreeView otherStructTreeView = this.getOtherStructTreeView();
            OperateOption op = operate.getOption();
            List<OtherStructVO> list = otherStructTreeView.getOtherStructList();
            op.setVariableValue("other_struct_op_params", SerializationUtils.toJsonString(list));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ((HRStringUtils.equals((String)operateKey, (String)"btnsave") || HRStringUtils.equals((String)operateKey, (String)BTNENABLE)) && args.getOperationResult().isSuccess()) {
            String successMsg;
            this.getView().getPageCache().remove(STRUCT_PROJECT_DATE);
            this.getView().getPageCache().remove(STRUCT_PROJECT_CHANGE);
            String string = successMsg = "btnsave".equals(operateKey) ? ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"OtherStructDetailEditPlugin_6", (String)"hrmp-haos-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fdd\u5b58\u5e76\u542f\u7528\u65b9\u6848\u6210\u529f\u3002", (String)"OtherStructDetailEditPlugin_7", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            if (this.getView().getParentView() != null) {
                IFormView parentView = this.getView().getParentView();
                this.setRootChangeCustomParam(parentView);
                parentView.invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
            }
            this.getView().returnDataToParent((Object)successMsg);
            this.getView().close();
        }
    }

    private void setRootChangeCustomParam(IFormView parentView) {
        if (this.isRootChange()) {
            parentView.getPageCache().put("root_change", Boolean.TRUE.toString());
        } else {
            parentView.getPageCache().put("root_change", Boolean.FALSE.toString());
        }
    }

    private boolean checkAddOrg(TreeView otherTreeView) {
        List srcSelectedList = otherTreeView.getTreeState().getSelectedNodeId();
        if (CollectionUtils.isEmpty((Collection)srcSelectedList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u4f5c\u4e3a\u865a\u62df\u7ec4\u7ec7\u7684\u4e0a\u7ea7\u7ec4\u7ec7\u3002", (String)"OtherStructDetailEditPlugin_8", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (srcSelectedList.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u4f5c\u4e3a\u865a\u62df\u7ec4\u7ec7\u7684\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u5f53\u524d\u5df2\u9009\u6570\u91cf\uff1a%s\u3002", (String)"OtherStructDetailEditPlugin_9", (String)"hrmp-haos-formplugin", (Object[])new Object[]{srcSelectedList.size()}));
            return true;
        }
        return false;
    }

    private boolean checkEditOrg(String nodeId) {
        if (this.isSelectPhysicalRootOrg(nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u6839\u7ec4\u7ec7\u7684\u4e0a\u7ea7\u7ec4\u7ec7\u3002", (String)"OtherStructDetailEditPlugin_12", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkAdd(OtherStructTreeView otherStructTreeView, TreeView orgTreeView) {
        List srcSelectedList = orgTreeView.getTreeState().getSelectedNodeId();
        if (CollectionUtils.isEmpty((Collection)srcSelectedList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u5de6\u6811\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u7ec4\u7ec7\u3002", (String)"OtherStructDetailEditPlugin_3", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (otherStructTreeView.getRootNode() == null) {
            if (srcSelectedList.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4ece\u5de6\u6811\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u6dfb\u52a0\u4e3a\u6839\u7ec4\u7ec7\uff0c\u5f53\u524d\u5df2\u9009\u6570\u91cf\uff1a%s\u3002", (String)"OtherStructDetailEditPlugin_2", (String)"hrmp-haos-formplugin", (Object[])new Object[]{srcSelectedList.size()}));
                return true;
            }
        } else {
            List targetSelectedList = otherStructTreeView.getTreeView().getTreeState().getSelectedNodeId();
            if (CollectionUtils.isEmpty((Collection)targetSelectedList)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u4f5c\u4e3a\u4e0a\u7ea7\u7ec4\u7ec7\u3002", (String)"OtherStructDetailEditPlugin_4", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (targetSelectedList.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u4f5c\u4e3a\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u5f53\u524d\u5df2\u9009\u6570\u91cf\uff1a%s\u3002", (String)"OtherStructDetailEditPlugin_5", (String)"hrmp-haos-formplugin", (Object[])new Object[]{targetSelectedList.size()}));
                return true;
            }
        }
        return otherStructTreeView.checkPerm(srcSelectedList);
    }

    private boolean checkDelete(OtherStructTreeView otherStructTreeView) {
        List selectedList = otherStructTreeView.getTreeView().getTreeState().getSelectedNodes();
        if (CollectionUtils.isEmpty((Collection)selectedList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u9700\u8981\u79fb\u9664\u7684\u7ec4\u7ec7\u3002", (String)"OtherStructDetailEditPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (!HRStringUtils.equals((String)this.getModel().getDataEntity().getString(STRUCT_PROJECT_ENABLE), (String)"10") && selectedList.stream().anyMatch(selected -> "".equals(selected.get("parentid")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u542f\u7528\u7684\u67b6\u6784\u5141\u8bb8\u66f4\u6362\u6839\u7ec4\u7ec7\u3002", (String)"OtherStructDetailEditPlugin_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return true;
        }
        return otherStructTreeView.checkPerm(otherStructTreeView.getTreeView().getTreeState().getSelectedNodeId());
    }

    private void showAdminOrgTreeFilterDialog(CloseCallBack closeCallBack, String key) {
        FormShowParameter formShowParameter = new FormShowParameter();
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Floating);
        openStyle.setFloatingDirection(FloatingDirection.RightCenter);
        openStyle.setTargetKey(key);
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("140px");
        cssValue.setHeight("50px");
        openStyle.setInlineStyleCss(cssValue);
        formShowParameter.setFormId(HAOS_ORGTREEFITER);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u663e\u793a\u7981\u7528", (String)"TreeListTemplateBase_0", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]));
        formShowParameter.setCloseCallBack(closeCallBack);
        String chkShowDisable = this.getPageCache().get("chkshowdisable" + key);
        formShowParameter.setCustomParam("chkshowdisable", (Object)chkShowDisable);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("org_tree_filter".equals(actionId) || "struct_tree_filter".equals(actionId)) {
            Boolean checkShowDisable = (Boolean)closedCallBackEvent.getReturnData();
            if (checkShowDisable == null) {
                return;
            }
            String checkShowDisableStr = String.valueOf(checkShowDisable);
            String oldCheckShowDisableStr = this.getPageCache().get("chkshowdisable" + actionId);
            oldCheckShowDisableStr = HRStringUtils.isEmpty((String)oldCheckShowDisableStr) ? "false" : oldCheckShowDisableStr;
            this.getPageCache().put("chkshowdisable" + actionId, String.valueOf(checkShowDisable));
            if (!oldCheckShowDisableStr.equals(checkShowDisableStr) && "org_tree_filter".equals(actionId)) {
                TreeView orgTreeView = (TreeView)this.getControl("org_tree");
                orgTreeView.deleteAllNodes();
                this.setDataToOrgTree();
                this.getPageCache().put("chkshowdisable" + actionId, checkShowDisableStr);
            }
        } else if ("add_org".equals(actionId) || "edit_org".equals(actionId)) {
            this.closeVirtual(closedCallBackEvent);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (this.checkBoxList.contains(name)) {
            String treeName = "orgcheckbox".equals(name) ? "org_tree" : "other_tree";
            this.setCcn((Boolean)e.getChangeSet()[0].getNewValue(), treeName);
        } else if ("bsed".equals(name)) {
            this.getView().getPageCache().put(STRUCT_PROJECT_DATE, "true");
        } else if ("chkshowdisable".equals(name)) {
            Boolean checkShowDisable = (Boolean)e.getChangeSet()[0].getNewValue();
            this.getPageCache().put("chkshowdisableorg_tree_filter", Boolean.toString(checkShowDisable));
            TreeView orgTreeView = (TreeView)this.getControl("org_tree");
            orgTreeView.deleteAllNodes();
            this.setDataToOrgTree();
        }
    }

    private void setCcn(boolean flag, String name) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("ccn", flag);
        map.put("cpn", Boolean.FALSE);
        this.getView().updateControlMetadata(name, map);
    }

    protected void initOtherStructView() {
        new OtherStructTreeView((TreeView)this.getControl("other_tree"), true).initTree();
    }

    private void initOrgStructView() {
        new OrgStructTreeView((TreeView)this.getControl("org_tree"), true).initTree();
    }

    private OrgStructTreeView getOrgStructTreeView() {
        return new OrgStructTreeView((TreeView)this.getControl("org_tree"), false);
    }

    protected OtherStructTreeView getOtherStructTreeView() {
        return new OtherStructTreeView((TreeView)this.getControl("other_tree"), false);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String dateChg = this.getView().getPageCache().get(STRUCT_PROJECT_DATE);
        String structChg = this.getView().getPageCache().get(STRUCT_PROJECT_CHANGE);
        if (HRStringUtils.isNotEmpty((String)dateChg) || HRStringUtils.isNotEmpty((String)structChg)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_close", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"HRBaseDataCommonBillEdit_0", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"HRBaseDataCommonBillEdit_1", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f{0}\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"HRBaseDataCommonBillEdit_2", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]), System.lineSeparator());
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            e.setCancel(Boolean.TRUE.booleanValue());
        } else {
            this.deleteTempVirtualOrg();
            DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("structproject");
            MutexHelper.release((String)"haos_structproject", (String)"edit_struct", (String)String.valueOf(dynamicObject.getLong("id")));
            this.getPageCache().put("MUTEX_ENTITY_KEY", (String)null);
            this.getPageCache().put("MUTEX_OPER_KEY", (String)null);
            this.getPageCache().put("MUTEX_OBJ_ID", (String)null);
        }
    }

    private void deleteTempVirtualOrg() {
        DynamicObjectCollection col = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        Set orgSet = col.stream().map(dy -> dy.getLong("orgid")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(orgSet)) {
            AdOrgRepository.getInstance().deleteTempVirtualOrg(orgSet);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if ("continue_close".equals(callBackId) && evt.getResult() == MessageBoxResult.Yes) {
            this.getView().getPageCache().remove(STRUCT_PROJECT_DATE);
            this.getView().getPageCache().remove(STRUCT_PROJECT_CHANGE);
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().close();
        } else if ("btn_delnode".equals(callBackId) && evt.getResult() == MessageBoxResult.Yes) {
            this.deleteNodes(this.getOtherStructTreeView());
        }
    }

    private void closeVirtual(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObject orgDy = (DynamicObject)closedCallBackEvent.getReturnData();
        if (orgDy != null) {
            boolean addFlag = "add_org".equals(closedCallBackEvent.getActionId());
            boolean isVirtual = false;
            if (addFlag || (isVirtual = orgDy.getDynamicObject("adminorg").getBoolean("isvirtualorg"))) {
                DynamicObjectCollection col = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                DynamicObject entryDy = col.stream().filter(dy -> dy.getLong("orgid") == orgDy.getLong("orgid")).findFirst().orElse(null);
                if (entryDy == null) {
                    entryDy = new DynamicObject(col.getDynamicObjectType());
                    col.add((Object)entryDy);
                }
                entryDy.set("orgid", (Object)orgDy.getLong("orgid"));
                entryDy.set("number", orgDy.get("number"));
                entryDy.set("name", orgDy.get("name"));
                entryDy.set("description", orgDy.get("description"));
                entryDy.set("org", (Object)orgDy.getLong("org.id"));
            }
            if (addFlag) {
                this.getOtherStructTreeView().addVirtualNode(orgDy);
            } else {
                this.getOtherStructTreeView().editOrg(orgDy, isVirtual);
            }
            this.getView().getPageCache().put(STRUCT_PROJECT_CHANGE, "true");
        }
    }

    private void openOrg(String actionId, String orgId, String parentId, String name) {
        FormShowParameter formShowParameter = new FormShowParameter();
        String entityName = "haos_virtualorg";
        if (!HRStringUtils.isEmpty((String)orgId)) {
            formShowParameter.setCustomParam("orgid", (Object)orgId);
            formShowParameter.setCaption(name);
            DynamicObject orgDy = AdOrgRepository.getInstance().queryOriginalOneByPk("isvirtualorg", (Object)Long.valueOf(orgId));
            if (!orgDy.getBoolean("isvirtualorg")) {
                entityName = "haos_adminorgedit";
            }
        }
        formShowParameter.setCustomParam("parentorg", (Object)parentId);
        formShowParameter.setFormId(entityName);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    protected void setTips() {
        String pro = "otherlap";
        List tipList = HRCSRPCServiceHelper.queryPromptForString((IFormView)this.getView(), (String)"haos_otherstructdetail", (String)pro);
        if (CollectionUtils.isEmpty((Collection)tipList)) {
            return;
        }
        Tips tips = new Tips();
        if (!CollectionUtils.isEmpty((Collection)tipList)) {
            tips.setContent(new LocaleString((String)tipList.get(0)));
            tips.setType("text");
            tips.setTriggerType("hover");
            tips.setIsConfirm(false);
            tips.setShowIcon(true);
            TipsSupport control = (TipsSupport)this.getControl("labelap2");
            if (control != null) {
                control.addTips(tips);
            }
        }
    }

    public void treeNodeDragged(TreeNodeDragEvent treeNodeDragEvent) {
        String nodeId = (String)treeNodeDragEvent.getNodeId();
        String toParentId = (String)treeNodeDragEvent.getToParentId();
        this.getOtherStructTreeView().treeNodeDragged(nodeId, toParentId);
        this.getView().getPageCache().put(STRUCT_PROJECT_CHANGE, "true");
    }

    private OtherStructVO getRootOrg() {
        return this.getOtherStructTreeView().getOtherStructList().stream().filter(vo -> vo.getParentId() == null).findFirst().orElse(null);
    }

    private boolean isRootChange() {
        OtherStructVO rootVO = this.getRootOrg();
        if (rootVO == null) {
            return false;
        }
        return rootVO.getOrgId().longValue() != this.getModel().getDataEntity().getDynamicObject("structproject").getLong("rootorg.id");
    }

    private boolean isSelectPhysicalRootOrg(String nodeId) {
        Long orgId = Long.valueOf(String.valueOf(nodeId));
        Long rootId = this.getModel().getDataEntity().getDynamicObject("structproject").getLong("rootorg.id");
        return rootId.equals(orgId);
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"other_tree")) {
            String nodeId = (String)evt.getNodeId();
            DynamicObject dynamicObject = AdOrgRepository.getInstance().queryByPk("id,name", (Object)Long.valueOf(nodeId));
            this.openOrg("edit_org", (String)evt.getNodeId(), (String)evt.getParentNodeId(), dynamicObject.getString("name"));
        }
    }
}

