/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.structproject;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.haos.formplugin.web.structproject.OtherStructProjectImportDataSaveNew;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.newhismodel.impt.HisBatchImportPlugin;

public class OtherStructProjectOrgImportPlugin
extends HisBatchImportPlugin {
    private static final Log logger = LogFactory.getLog(OtherStructProjectOrgImportPlugin.class);

    public String getDefaultImportType() {
        return "overridenew";
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        List overrideFieldsConfig = super.getOverrideFieldsConfig();
        return overrideFieldsConfig.stream().filter(fieldsConfig -> Lists.newArrayList((Object[])new String[]{"number", "name"}).contains(fieldsConfig.getValue())).collect(Collectors.toList());
    }

    public String getDefaultKeyFields() {
        return "number";
    }

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        try {
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            try {
                FormView formView = (FormView)view.get(ctx);
                IFormView parentView = formView.getParentView();
                String structProjectId = Optional.ofNullable(parentView).map(pView -> {
                    pView.getPageCache().put("isimport", Boolean.TRUE.toString());
                    return pView.getModel().getDataEntity();
                }).map(dataEntity -> dataEntity.getString("structproject.id")).orElse("1010");
                IHRAppCache appCache = HRAppCache.get((String)"haos");
                appCache.put(this.makeKey(), (Object)structProjectId);
                formView.setVisible(Boolean.FALSE, new String[]{"radiofield", "radiofield1"});
            }
            catch (IllegalAccessException exception) {
                logger.error(exception.getMessage());
            }
        }
        catch (NoSuchFieldException exception) {
            logger.error(exception.getMessage());
        }
        return super.setContext(rc, ctx, startArgs);
    }

    protected String getImportSaveOpNum() {
        return "import_save";
    }

    public AbstractOperateWebApi getSaveWebApi() {
        AbstractOperateWebApi superSaveWebApi = super.getSaveWebApi();
        OtherStructProjectImportDataSaveNew thisSaveWebApi = new OtherStructProjectImportDataSaveNew();
        thisSaveWebApi.setOperationNumber(superSaveWebApi.getOperationNumber());
        return thisSaveWebApi;
    }

    private String makeKey() {
        String requestId = RequestContext.get().getRequestId();
        return "structproject" + requestId;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        for (ImportBillData billData : billdatas) {
            String number;
            JSONObject sourceData = billData.getData();
            String isVirtual = ResManager.loadKDString((String)"\u662f", (String)"OtherStructProjectOrgImportPlugin_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            if (HRStringUtils.equals((String)sourceData.getString("isvirtualorg"), (String)isVirtual) && HRStringUtils.isEmpty((String)sourceData.getString("number"))) {
                this.genNumber().ifPresent(genNumber -> sourceData.put("number", genNumber));
            }
            if (!HRStringUtils.isEmpty((String)(number = sourceData.getString("number")))) continue;
            sourceData.put("number", (Object)"NULL");
        }
        super.beforeSave(billdatas, logger);
    }

    private Optional<String> genNumber() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorghr");
        DynamicObject dataEntity = serviceHelper.generateEmptyDynamicObject();
        if (!CodeRuleServiceHelper.isExist((String)"haos_adminorghr", (DynamicObject)dataEntity, (String)String.valueOf(dataEntity.getLong("org.id")))) {
            return Optional.empty();
        }
        String number = CodeRuleServiceHelper.getNumber((String)"haos_adminorghr", (DynamicObject)dataEntity, (String)String.valueOf(dataEntity.getLong("org.id")));
        if (serviceHelper.isExists(new QFilter[]{new QFilter("number", "=", (Object)number)})) {
            return this.genNumber();
        }
        return Optional.of(number);
    }
}

