/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.structproject;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.tree.TreeNodeLabel;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.TreeView;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.service.ext.DefOtherStructTreeExtend;
import kd.hr.haos.business.service.otherstruct.model.OtherStructVO;
import kd.hr.haos.business.servicehelper.SystemParamHelper;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.model.StructProjectVO;
import kd.hr.haos.common.util.HaosOrgUnitServiceHelper;
import kd.hr.haos.formplugin.web.structproject.StructTreeView;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.QueryEntityServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;
import kd.sdk.hr.hrmp.haos.extpoint.IOtherStructTreeExtend;

public class OtherStructTreeView
extends StructTreeView {
    private static final String CACHE_ALL_NODES_OTHER_TREE = "CACHE_ALL_NODES_OTHER_TREE";
    private static final String CACHE_HAS_ALL_PERM = "CACHE_HAS_ALL_PERM";
    private static final String NO_DATA_AP = "nodataap";
    private PluginProxy<IOtherStructTreeExtend> extendPluginProxy;
    private Map<Long, Map<String, String>> extendResultMap;
    private Boolean showBelongCompany;
    private final StructProjectVO structProjectVO;
    private Boolean existsVirtual;

    public OtherStructTreeView(TreeView treeView, boolean isInitTree) {
        super(treeView, isInitTree);
        DynamicObject dy = this.treeView.getView().getModel().getDataEntity().getDynamicObject("structproject");
        this.structProjectVO = new StructProjectVO(Long.valueOf(dy.getLong("id")), Long.valueOf(dy.getLong("org.id")), dy.getString("enable"), Long.valueOf(dy.getLong("creator.id")));
    }

    @Override
    public void initTree() {
        super.initTree();
        this.cacheAllInitialNodes();
        this.showNoDataPerm();
    }

    @Override
    protected String getOrderBys() {
        return "level,adminorg.number asc";
    }

    @Override
    protected String structSelectFields() {
        return this.orgStructSelectFields();
    }

    @Override
    protected String orgSelectFields() {
        return "id,name,enable,tobedisableflag,belongcompany.name,adminorgtype.adminorgtypestd.id,isvirtualorg";
    }

    public List<String> addNodes(List<String> srcSelectedNodeIds) {
        List targetSelected = this.treeView.getTreeState().getSelectedNodeId();
        String parentId = CollectionUtils.isEmpty((Collection)targetSelected) ? "" : (String)targetSelected.get(0);
        HashMap<String, TreeNode> allTargetNodes = new HashMap<String, TreeNode>(16);
        this.getAllNodesMap(allTargetNodes, this.rootNode);
        this.removeAddedParentNode(parentId, allTargetNodes, srcSelectedNodeIds);
        if (CollectionUtils.isEmpty(srcSelectedNodeIds)) {
            return null;
        }
        List<TreeNode> srcSelectedList = this.buildSrcSelectedNodeList(srcSelectedNodeIds, parentId);
        List<String> deleteNodeIds = srcSelectedNodeIds.stream().filter(selectedNodeId -> allTargetNodes.get(selectedNodeId) != null).collect(Collectors.toList());
        List<String> allDeleteNodeIds = this.deleteNodes(deleteNodeIds);
        this.addNodes(allTargetNodes, srcSelectedList, parentId);
        this.updateRootNodeCache();
        return allDeleteNodeIds;
    }

    public void addVirtualNode(DynamicObject dy) {
        String parentId = dy.getLong("parentorg.id") == 0L ? "" : dy.getString("parentorg.id");
        String id = dy.getString("orgid");
        String name = dy.getString("name");
        TreeNode treeNode = new TreeNode(parentId, id, name);
        this.setVirtualLabel(treeNode);
        HashMap<String, TreeNode> allTargetNodes = new HashMap<String, TreeNode>(1);
        allTargetNodes.put(parentId, OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)parentId));
        this.addNodes(allTargetNodes, Lists.newArrayList((Object[])new TreeNode[]{treeNode}), parentId);
        this.updateRootNodeCache();
    }

    public void treeNodeDragged(String nodeId, String newParentId) {
        TreeNode node = OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)nodeId);
        ArrayList orgTreeNodeList = Lists.newArrayListWithCapacity((int)10);
        OrgTreeUtils.getAllNodeId((TreeNode)node, (boolean)Boolean.TRUE, (List)orgTreeNodeList);
        if (orgTreeNodeList.contains(newParentId)) {
            return;
        }
        this.deleteNodes(Lists.newArrayList((Object[])new String[]{nodeId}));
        HashMap<String, TreeNode> allTargetNodes = new HashMap<String, TreeNode>(1);
        allTargetNodes.put(newParentId, OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)newParentId));
        node.setParentid(newParentId);
        this.addNodes(allTargetNodes, Lists.newArrayList((Object[])new TreeNode[]{node}), newParentId);
        this.updateRootNodeCache();
    }

    public void editOrg(DynamicObject dy, boolean isVirtual) {
        String id = dy.getString("orgid");
        String parentId = dy.getLong("parentorg.id") == 0L ? "" : dy.getString("parentorg.id");
        String name = dy.getString("name");
        TreeNode node = OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)id);
        if (!HRStringUtils.equals((String)parentId, (String)node.getParentid())) {
            this.deleteNodes(Lists.newArrayList((Object[])new String[]{id}));
            HashMap<String, TreeNode> allTargetNodes = new HashMap<String, TreeNode>(1);
            allTargetNodes.put(parentId, OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)parentId));
            node.setText(name);
            node.setParentid(parentId);
            this.addNodes(allTargetNodes, Lists.newArrayList((Object[])new TreeNode[]{node}), parentId);
            this.treeView.focusNode(node);
            this.treeView.checkNode(node);
            this.updateRootNodeCache();
        } else if (isVirtual) {
            node.setText(name);
            this.treeView.updateNode(node);
        }
    }

    private void setVirtualLabel(TreeNode treeNode) {
        List map = treeNode.getLabelPara();
        treeNode.setLabelShowType(1);
        map.add(new TreeNodeLabel(ResManager.loadKDString((String)"\u865a\u62df\u7ec4\u7ec7", (String)"OtherStructTreeView_3", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), "#55A0F5").returnPara());
    }

    public List<String> deleteNodes() {
        List selectedNodes = this.treeView.getTreeState().getSelectedNodeId();
        List<String> allDeleteNodeIds = this.deleteNodes(selectedNodes);
        List selectedList = this.treeView.getTreeState().getSelectedNodeId();
        if (!CollectionUtils.isEmpty((Collection)selectedList)) {
            this.treeView.uncheckNodes(selectedList);
        }
        this.updateRootNodeCache();
        return allDeleteNodeIds;
    }

    public List<String> getAllDeleteNodeIds() {
        List selectedNodes = this.treeView.getTreeState().getSelectedNodeId();
        ArrayList<String> allDeleteNodeIds = new ArrayList<String>(selectedNodes.size());
        this.getAllDeleteNode(this.rootNode, selectedNodes, allDeleteNodeIds);
        return allDeleteNodeIds;
    }

    public boolean checkPerm(List<String> selectedNodeIds) {
        if ("true".equals(this.pageCache.get(CACHE_HAS_ALL_PERM))) {
            return false;
        }
        Set idSet = selectedNodeIds.stream().map(Long::valueOf).collect(Collectors.toSet());
        DynamicObjectCollection col = AdminOrgStructRepository.getInstance().queryEnabledColByOrgAndStructProject("structlongnumber,adminorg.id id,adminorg.name name,adminorg.number number", idSet, this.structProjectVO.getStructProjectId());
        if (CollectionUtils.isEmpty((Collection)col)) {
            return false;
        }
        Set permSet = this.getInitOtherStructList().stream().filter(OtherStructVO::isPermFlag).map(OtherStructVO::getOrgId).collect(Collectors.toSet());
        HashMap<String, DynamicObject> longNumberMap = new HashMap<String, DynamicObject>();
        for (DynamicObject dy : col) {
            if (!permSet.contains(dy.getLong("id"))) {
                this.treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u201c{0}\uff0c{1}\u201d\u5df2\u5b58\u5728\u53f3\u6811\u4e2d\uff0c\u60a8\u65e0\u6743\u53d8\u66f4\u8be5\u7ec4\u7ec7\u3002", (String)"OtherStructTreeView_0", (String)"hrmp-haos-formplugin", (Object[])new Object[]{dy.getString("name"), dy.getString("number")}));
                return true;
            }
            longNumberMap.put(dy.getString("structlongnumber"), dy);
        }
        DynamicObject dy = AdminOrgStructRepository.getInstance().querySubDyBySLN(longNumberMap.keySet(), permSet, this.structProjectVO.getStructProjectId());
        if (dy != null && !permSet.contains(dy.getLong("adminorg.id"))) {
            String longNumber = dy.getString("structlongnumber");
            longNumberMap.entrySet().stream().filter(entry -> longNumber.startsWith((String)entry.getKey())).findFirst().ifPresent(mapEntry -> this.treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u7ec4\u7ec7\u201c{0}\u201d\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u4f46\u60a8\u6ca1\u6709\u79fb\u9664\u8fd9\u4e9b\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u6743\u9650\uff0c\u65e0\u6cd5\u79fb\u9664\u7ec4\u7ec7\u201c{1}\u201d\u3002", (String)"OtherStructTreeView_1", (String)"hrmp-haos-formplugin", (Object[])new Object[]{((DynamicObject)mapEntry.getValue()).getString("name"), ((DynamicObject)mapEntry.getValue()).getString("name")})));
            return true;
        }
        return false;
    }

    protected List<String> deleteNodes(List<String> selectedNodes) {
        ArrayList<String> allDeleteNodeIds = new ArrayList<String>(selectedNodes.size());
        this.getAllDeleteNode(this.rootNode, selectedNodes, allDeleteNodeIds);
        if (CollectionUtils.isEmpty(allDeleteNodeIds)) {
            return allDeleteNodeIds;
        }
        ArrayList<String> nodeIds = new ArrayList<String>(allDeleteNodeIds.size());
        ArrayList<TreeNode> updateLeafNodes = new ArrayList<TreeNode>(allDeleteNodeIds.size());
        for (String nodeId : allDeleteNodeIds) {
            if (nodeId.equals(this.rootNode.getId())) {
                this.rootNode = null;
                nodeIds = new ArrayList(1);
                nodeIds.add(nodeId);
                break;
            }
            nodeIds.add(nodeId);
            TreeNode node = OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)nodeId);
            if (node == null) continue;
            TreeNode parentNode = OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)node.getParentid());
            if (parentNode == null) {
                this.rootNode.deleteChildNode(nodeId);
                continue;
            }
            parentNode.deleteChildNode(nodeId);
            if (!this.setTreeNodeLeaf(parentNode)) continue;
            updateLeafNodes.add(parentNode);
        }
        this.treeView.deleteNodes(nodeIds);
        this.treeView.updateNodes(updateLeafNodes);
        return allDeleteNodeIds;
    }

    private void removeAddedParentNode(String parentId, Map<String, TreeNode> allTargetNodes, List<String> srcSelectedNodes) {
        if ("".equals(parentId)) {
            return;
        }
        srcSelectedNodes.remove(parentId);
        if (CollectionUtils.isEmpty(srcSelectedNodes)) {
            return;
        }
        ArrayList<String> parentNodeIds = new ArrayList<String>(srcSelectedNodes.size());
        this.findAllParentNodeIds(allTargetNodes, parentId, parentNodeIds);
        srcSelectedNodes.removeAll(parentNodeIds);
    }

    private void findAllParentNodeIds(Map<String, TreeNode> allTargetNodes, String parentId, List<String> parentNodeIds) {
        TreeNode treeNode = allTargetNodes.get(parentId);
        if (treeNode == null) {
            return;
        }
        parentNodeIds.add(treeNode.getId());
        this.findAllParentNodeIds(allTargetNodes, treeNode.getParentid(), parentNodeIds);
    }

    private void getAllDeleteNode(TreeNode rootNode, List<String> selectedNodes, List<String> allDeleteNodeIds) {
        String nodeId;
        TreeNode node;
        if (!CollectionUtils.isEmpty(selectedNodes) && (node = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)(nodeId = selectedNodes.remove(0)))) != null) {
            OrgTreeUtils.getAllNodeId((TreeNode)node, (boolean)true, allDeleteNodeIds);
            selectedNodes.removeAll(allDeleteNodeIds);
            this.getAllDeleteNode(rootNode, selectedNodes, allDeleteNodeIds);
        }
    }

    private boolean setTreeNodeLeaf(TreeNode node) {
        if (node == null) {
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)node.getChildren())) {
            node.setLeaf(true);
            node.setChildren(null);
            return true;
        }
        return false;
    }

    private List<OtherStructVO> getInitOtherStructList() {
        String str = this.pageCache.get(CACHE_ALL_NODES_OTHER_TREE);
        List list = Collections.emptyList();
        if (!HRStringUtils.isEmpty((String)str)) {
            list = SerializationUtils.fromJsonStringToList((String)str, OtherStructVO.class);
        }
        return list;
    }

    public List<OtherStructVO> getOtherStructList() {
        List<OtherStructVO> allOtherStructList = this.getAllOtherStructList(new LinkedHashMap<String, TreeNode>(16));
        if (HRStringUtils.equals((String)this.structProjectVO.getEnable(), (String)"10")) {
            return allOtherStructList;
        }
        Map<Long, OtherStructVO> initMap = this.getInitOtherStructList().stream().collect(Collectors.toMap(OtherStructVO::getOrgId, otherStructVO -> otherStructVO));
        HashMap<Long, OtherStructVO> addMap = new HashMap<Long, OtherStructVO>(allOtherStructList.size());
        Iterator<OtherStructVO> it = allOtherStructList.iterator();
        while (it.hasNext()) {
            OtherStructVO vo2 = it.next();
            OtherStructVO beforeVO = initMap.get(vo2.getOrgId());
            if (beforeVO == null) {
                vo2.setChangeTypeId(ChangeTransactionConstants.ADD);
                addMap.put(vo2.getOrgId(), vo2);
                continue;
            }
            if (beforeVO.getParentId() != null && !beforeVO.getParentId().equals(vo2.getParentId())) {
                vo2.setChangeTypeId(ChangeTransactionConstants.PARENT);
            } else {
                it.remove();
            }
            initMap.remove(beforeVO.getOrgId());
        }
        initMap.values().forEach(vo -> {
            vo.setChangeTypeId(ChangeTransactionConstants.DISABLE);
            allOtherStructList.add((OtherStructVO)vo);
        });
        this.setAddOtherStructChangeType(addMap);
        return allOtherStructList;
    }

    private void setAddOtherStructChangeType(Map<Long, OtherStructVO> addMap) {
        if (CollectionUtils.isEmpty(addMap)) {
            return;
        }
        DynamicObjectCollection col = this.queryColByOrgAndStructProject(this.structSimpleSelectFields(), addMap.keySet(), this.structProjectVO.getStructProjectId());
        if (CollectionUtils.isEmpty((Collection)col)) {
            return;
        }
        col.forEach(dy -> {
            OtherStructVO otherStructVO = (OtherStructVO)addMap.get(dy.getLong("id"));
            if (otherStructVO != null) {
                otherStructVO.setChangeTypeId(dy.getLong("parentorg") != otherStructVO.getParentId().longValue() ? ChangeTransactionConstants.PARENT : ChangeTransactionConstants.INFO);
            }
        });
    }

    protected List<TreeNode> buildSrcSelectedNodeList(List<String> srcSelectedNodeIds, String parentId) {
        Set idSet = srcSelectedNodeIds.stream().map(Long::valueOf).collect(Collectors.toSet());
        DynamicObjectCollection col = AdminOrgStructRepository.getInstance().queryColByOrgAndStructProject(this.orgStructSelectFields(), idSet, AdminOrgConstants.ADMINORG_STRUCT);
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(col.size());
        HashMap longNumberMap = new HashMap(col.size());
        this.setExtendResultMap(col);
        col.forEach(dy -> {
            TreeNode node = this.buildTreeNodeByDy((DynamicObject)dy);
            nodeList.add(node);
            longNumberMap.put(node.getLongNumber(), node);
        });
        nodeList.forEach(node -> {
            int index;
            TreeNode parentNode;
            String longNumber = node.getLongNumber();
            do {
                if ((index = longNumber.lastIndexOf("!")) != -1) continue;
                node.setParentid(parentId);
                return;
            } while ((parentNode = (TreeNode)longNumberMap.get(longNumber = longNumber.substring(0, index))) == null);
            node.setParentid(parentNode.getId());
            parentNode.addChild(node);
        });
        nodeList.forEach(node -> node.setLongNumber(null));
        return nodeList;
    }

    private void showNoDataPerm() {
        if ("true".equals(this.pageCache.get(CACHE_HAS_ALL_PERM))) {
            this.treeView.getView().setVisible(Boolean.FALSE, new String[]{NO_DATA_AP});
            return;
        }
        if (this.rootNode == null) {
            this.treeView.getView().setVisible(Boolean.TRUE, new String[]{NO_DATA_AP});
            this.treeView.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap7"});
        } else {
            this.treeView.getView().setVisible(Boolean.FALSE, new String[]{NO_DATA_AP});
        }
    }

    @Override
    protected List<OtherStructVO> getAllOtherStructList(Map<String, TreeNode> allTargetNodeMap) {
        return super.getAllOtherStructList(allTargetNodeMap);
    }

    private void cacheAllInitialNodes() {
        this.pageCache.put(CACHE_ALL_NODES_OTHER_TREE, this.pageCache.get(this.getRootNodeKey()));
    }

    protected void addNodes(Map<String, TreeNode> allTargetNodes, List<TreeNode> srcSelectedList, String parentId) {
        if (CollectionUtils.isEmpty(srcSelectedList)) {
            return;
        }
        Map<String, List<TreeNode>> parentNodeMap = srcSelectedList.stream().collect(Collectors.groupingBy(TreeNode::getParentid));
        List<TreeNode> newTreeNodeList = parentNodeMap.get(parentId);
        if (CollectionUtils.isEmpty(newTreeNodeList)) {
            return;
        }
        if (this.rootNode == null) {
            this.rootNode = newTreeNodeList.get(0);
        } else {
            TreeNode parentNode = allTargetNodes.get(parentId);
            newTreeNodeList.forEach(arg_0 -> ((TreeNode)parentNode).addChild(arg_0));
            parentNode.setExpend(true);
            parentNode.setIsOpened(true);
        }
        this.treeView.addNodes(newTreeNodeList);
        this.treeView.expand(parentId);
    }

    private void initCacheHasAllPerm(boolean flag) {
        this.pageCache.put(CACHE_HAS_ALL_PERM, String.valueOf(flag));
    }

    @Override
    protected AuthorizedOrgResultWithSub getPermOrgResultWithSub() {
        if ("10".equals(this.structProjectVO.getEnable())) {
            this.initCacheHasAllPerm(true);
            return new AuthorizedOrgResultWithSub(true);
        }
        if (RequestContext.get().getCurrUserId() == this.structProjectVO.getCreatorId().longValue() && SystemParamHelper.getCreatorHasPermission((Long)this.structProjectVO.getOrgId())) {
            this.initCacheHasAllPerm(true);
            return new AuthorizedOrgResultWithSub(true);
        }
        Long userId = RequestContext.get().getCurrUserId();
        String permEntityId = "haos_structorgdetail";
        permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
        String appId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)this.treeView.getView().getFormShowParameter());
        String propKey = "boid";
        AuthorizedOrgResultWithSub permResult = (AuthorizedOrgResultWithSub)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserAdminOrgsWithSub", (Object[])new Object[]{userId, appId, permEntityId, "47150e89000000ac", propKey, this.getStructProjectCustomInParam(propKey)});
        this.initCacheHasAllPerm(permResult.isHasAllOrgPerm());
        return permResult;
    }

    private PluginProxy<IOtherStructTreeExtend> getExtendPluginProxy() {
        if (this.extendPluginProxy == null) {
            this.extendPluginProxy = PluginProxy.create((Object)new DefOtherStructTreeExtend(), IOtherStructTreeExtend.class, (String)"kd.hr.haos.formplugin.web.structproject.OtherStructTreeView.point");
        }
        return this.extendPluginProxy;
    }

    @Override
    protected Long getStructProjectId() {
        return this.structProjectVO.getStructProjectId();
    }

    @Override
    protected void setExtendResultMap(DynamicObjectCollection col) {
        List orgIdList = col.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        this.getExtendPluginProxy().callAfter(plugin -> {
            this.extendResultMap = plugin.beforePoint(orgIdList);
            return null;
        });
    }

    private Boolean getExistsVirtual(DynamicObject dy) {
        if (this.existsVirtual == null) {
            this.existsVirtual = dy.getDynamicObjectType().getProperty("isvirtualorg") != null;
        }
        return this.existsVirtual;
    }

    @Override
    protected void setNodeValue(TreeNode node, DynamicObject dy) {
        super.setNodeValue(node, dy);
        if (this.isShowBelongCompany() && AdminOrgConstants.ADMIN_ORG_TYPE_COMPANY_AND_AREA.contains(dy.getLong("adminorgtype.adminorgtypestd.id"))) {
            String belongCompany = dy.getString("belongcompany.name");
            String name = dy.getString("name");
            name = HRStringUtils.isEmpty((String)belongCompany) ? name : name + "\uff08" + belongCompany + "\uff09";
            node.setText(name);
        }
        if (this.getExistsVirtual(dy).booleanValue() && dy.getBoolean("isvirtualorg")) {
            this.setVirtualLabel(node);
        }
        if (CollectionUtils.isEmpty(this.extendResultMap)) {
            return;
        }
        this.getExtendPluginProxy().callAfter(plugin -> {
            plugin.afterPoint(node, this.extendResultMap.get(dy.getLong("id")));
            return null;
        });
    }

    public void fillNodeSetNoContainsIdAndChild(Set<String> nodeIdSet, TreeNode node, String nodeId) {
        if (node == null) {
            return;
        }
        if (node.getId().equals(nodeId)) {
            return;
        }
        if (!node.isDisabled()) {
            nodeIdSet.add(node.getId());
        }
        if (CollectionUtils.isEmpty((Collection)node.getChildren())) {
            return;
        }
        for (TreeNode childNode : node.getChildren()) {
            this.fillNodeSetNoContainsIdAndChild(nodeIdSet, childNode, nodeId);
        }
    }

    public String getCurrentLongName(String parentId) {
        String rootNodeCache = this.pageCache.get(this.getRootNodeKey());
        if (HRStringUtils.isEmpty((String)rootNodeCache)) {
            return "";
        }
        List structList = SerializationUtils.fromJsonStringToList((String)rootNodeCache, OtherStructVO.class);
        if (CollectionUtils.isEmpty((Collection)structList)) {
            return "";
        }
        HashSet orgIdSet = Sets.newHashSetWithExpectedSize((int)structList.size());
        Map<String, TreeNode> nodeMap = structList.stream().map(structVO -> {
            orgIdSet.add(structVO.getOrgId());
            return new TreeNode(structVO.getParentId() == null ? "" : String.valueOf(structVO.getParentId()), String.valueOf(structVO.getOrgId()), "");
        }).collect(Collectors.toMap(TreeNode::getId, node -> node));
        DynamicObjectCollection orgDys = AdOrgRepository.getInstance().queryOriginalColByPks(this.orgSelectFields(), (Collection)orgIdSet);
        DynamicObjectCollection editCol = this.getTreeView().getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        Map<Long, String> editMap = editCol.stream().collect(Collectors.toMap(dy -> dy.getLong("orgid"), orgDy -> orgDy.getString("name")));
        for (DynamicObject orgDy2 : orgDys) {
            Long orgId = orgDy2.getLong("id");
            String editName = editMap.get(orgId);
            TreeNode node2 = nodeMap.get(String.valueOf(orgId));
            if (HRStringUtils.isEmpty((String)editName)) {
                node2.setText(orgDy2.getString("name"));
                continue;
            }
            node2.setText(editName);
        }
        StringBuilder longName = new StringBuilder();
        ArrayList<String> parentNodeIds = new ArrayList<String>(10);
        this.findAllParentNodeIds(nodeMap, parentId, parentNodeIds);
        String nameSeparator = HaosOrgUnitServiceHelper.getFullNameSep();
        for (int index = parentNodeIds.size() - 1; index >= 0; --index) {
            longName.append(nodeMap.get(parentNodeIds.get(index)).getText()).append(nameSeparator);
        }
        return longName.length() == 0 ? "" : longName.substring(0, longName.length() - nameSeparator.length());
    }

    private boolean isShowBelongCompany() {
        if (this.showBelongCompany == null) {
            this.showBelongCompany = !"false".equals(this.treeView.getView().getFormShowParameter().getCustomParam("company_name_visible"));
        }
        return this.showBelongCompany;
    }

    public Map<String, Object> getStructProjectCustomInParam(String prop) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hr_dataperm_structprojectid_prop_" + prop, Collections.singletonList(this.structProjectVO.getStructProjectId()));
        return map;
    }

    protected String orgStructSelectFields() {
        return "structlongnumber,parentorg,adminorg.id id,adminorg.name name,adminorg.enable enable,adminorg.isvirtualorg isvirtualorg,adminorg.tobedisableflag tobedisableflag,adminorg.belongcompany.name belongcompany.name,adminorg.adminorgtype.adminorgtypestd adminorgtype.adminorgtypestd.id";
    }

    protected String structSimpleSelectFields() {
        return "adminorg.id id,parentorg";
    }

    protected DynamicObjectCollection queryColByOrgAndStructProject(String selectFields, Set<Long> orgIds, Long structProjectId) {
        return AdminOrgStructRepository.getInstance().queryColByOrgAndStructProject(selectFields, orgIds, structProjectId);
    }
}

