/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;

public class CloseCheckFormPlugin
extends AbstractFormPlugin {
    protected boolean closeConfirmStatus = false;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DataEntityState dataEntityState = this.getModel().getDataEntity().getDataEntityState();
        dataEntityState.setDirty(false);
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        if (this.closeConfirmStatus) {
            this.closeConfirmStatus = false;
            return;
        }
        DataEntityState dataEntityState = this.getModel().getDataEntity().getDataEntityState();
        boolean dataEntityDirty = dataEntityState.getDataEntityDirty();
        if (event.isCheckDataChange() && (dataEntityDirty || this.getModel().getDataChanged())) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("page_close", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"CloseCheckFormPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"CloseCheckFormPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f{0}\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"CloseCheckFormPlugin_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), System.lineSeparator());
            List<String> unCheckField = this.getUnCheckFields();
            String mainEntityNum = this.getModel().getDataEntityType().getName();
            Map allEntities = this.getModel().getDataEntityType().getAllEntities();
            String mainEntityMsg = ResManager.loadKDString((String)"\u5355\u636e\u5934\u5b57\u6bb5\u53d8\u52a8\uff1a%s\u3002", (String)"CloseCheckFormPlugin_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
            ArrayList mainEntityChangedFields = Lists.newArrayListWithCapacity((int)10);
            String entryMsg = ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u53d8\u52a8\u5b57\u6bb5\uff1a%3$s", (String)"CloseCheckFormPlugin_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
            ArrayList allEntryMsg = Lists.newArrayListWithCapacity((int)10);
            for (Map.Entry entityTypeEntry : allEntities.entrySet()) {
                if (HRStringUtils.equals((String)((String)entityTypeEntry.getKey()), (String)mainEntityNum)) {
                    for (IDataEntityProperty property : dataEntityState.GetDirtyProperties()) {
                        if (unCheckField.contains(property.getName())) continue;
                        mainEntityChangedFields.add(property.getDisplayName().getLocaleValue());
                    }
                    continue;
                }
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity((String)entityTypeEntry.getKey());
                String entryName = ((EntityType)entityTypeEntry.getValue()).getDisplayName().getLocaleValue();
                int rowIndex = 0;
                for (DynamicObject entryRow : entryEntity) {
                    ArrayList entryChangedFields = Lists.newArrayListWithCapacity((int)10);
                    Iterable bizChangedProperties = entryRow.getDataEntityState().getBizChangedProperties();
                    for (IDataEntityProperty bizChangedProperty : bizChangedProperties) {
                        if (unCheckField.contains(bizChangedProperty.getName())) continue;
                        entryChangedFields.add(bizChangedProperty.getDisplayName().getLocaleValue());
                    }
                    if (!entryChangedFields.isEmpty()) {
                        allEntryMsg.add(String.format(entryMsg, entryName, rowIndex + 1, String.join((CharSequence)",", entryChangedFields)));
                    }
                    ++rowIndex;
                }
            }
            if (mainEntityChangedFields.isEmpty() && allEntryMsg.isEmpty()) {
                return;
            }
            StringBuilder finalMsg = new StringBuilder();
            if (!mainEntityChangedFields.isEmpty()) {
                finalMsg.append(String.format(mainEntityMsg, String.join((CharSequence)",", mainEntityChangedFields)));
                finalMsg.append("\r\n");
            }
            for (String entryMsgStr : allEntryMsg) {
                finalMsg.append(entryMsgStr);
                finalMsg.append("\r\n");
            }
            this.getView().showConfirm(msg, finalMsg.substring(0, finalMsg.length() - 2), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            event.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (HRStringUtils.equals((String)"page_close", (String)event.getCallBackId()) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            this.closeConfirmStatus = true;
            this.getView().close();
        }
    }

    protected List<String> getUnCheckFields() {
        return Lists.newArrayListWithCapacity((int)10);
    }
}

