/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web;

import java.util.Collection;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.PermissionControlType;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import org.apache.commons.collections4.CollectionUtils;

public class ForbidUrlOpenPlugin
extends HRDynamicFormBasePlugin {
    public void preOpenForm(PreOpenFormEventArgs args) {
        BillShowParameter billShowParameter;
        super.preOpenForm(args);
        if (PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId())) {
            return;
        }
        FormShowParameter formParameter = args.getFormShowParameter();
        String entityNumber = this.getEntityNumber(formParameter);
        if (this.hasBindingFunctionPerm(entityNumber, formParameter.getPermissionItemId())) {
            return;
        }
        if (formParameter instanceof BillShowParameter && (billShowParameter = (BillShowParameter)formParameter).getPkId() != null) {
            return;
        }
        if (HRStringUtils.isEmpty((String)formParameter.getParentFormId()) && HRStringUtils.isEmpty((String)formParameter.getParentPageId())) {
            args.setCancelMessage(ResManager.loadKDString((String)"\u7981\u6b62\u6253\u5f00\u9875\u9762", (String)"ForbidUrlOpenPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private String getEntityNumber(FormShowParameter formParameter) {
        if (formParameter instanceof ListShowParameter) {
            return ((ListShowParameter)formParameter).getBillFormId();
        }
        return formParameter.getFormId();
    }

    private boolean hasBindingFunctionPerm(String formNum, String permItemID) {
        if (HRStringUtils.isEmpty((String)formNum) || HRStringUtils.isEmpty((String)permItemID)) {
            return false;
        }
        String entityNum = FormMetadataCache.getFormConfig((String)formNum).getEntityTypeId();
        PermissionControlType permControl = EntityMetadataCache.getPermissionControlType((String)entityNum);
        if (!permControl.isControlFunction()) {
            return false;
        }
        Set permItemIDs = EntityMetadataCache.getPermissionItems((String)entityNum);
        if (CollectionUtils.isEmpty((Collection)permItemIDs)) {
            return false;
        }
        return permItemIDs.contains(permItemID);
    }
}

