/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.model.AdminOrgQueryParamInfo;
import kd.hr.hbp.common.model.HRFilterFieldInfo;
import kd.hr.hbp.common.model.HRFilterFieldItemInfo;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRStandardTreeList;
import kd.hr.hbp.formplugin.web.imp.AdminOrgTreeHelper;

@Deprecated
public class HRAdminOrgQueryTreeList
extends HRStandardTreeList {
    public static final String CHK_INCLUDE_CHILD = "chkincludechild";
    public static final String CHK_SHOW_DEPT = "chkshowdept";
    public static final String CHK_SHOW_DISABLE = "chkshowdisable";
    public static final String ID_ORGTYPE_GROUP = "1010";
    public static final String ID_ORGTYPE_COMPANY = "1020";
    public static final String ID_ORGTYPE_REGION = "1030";
    public static final String ID_ORGTYPE_DEPARTMENT = "1040";

    public HRAdminOrgQueryTreeList() {
        super("haos_adminorgstruct", OrgServiceUtil.getAdminRootOrgId() + "", false);
    }

    @Override
    protected DynamicObject getRootDynamicObject() {
        String selectFields = "adminorg.id id, adminorg.name name,structlongnumber longnumber";
        QFilter filter = new QFilter("adminorg", "=", (Object)Long.valueOf(this.getRootId()));
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter[] filterArray = new QFilter[]{filter, currentFilter};
        DynamicObject rootDynamic = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryOriginalOne(selectFields, filterArray);
        return rootDynamic;
    }

    @Override
    protected DynamicObjectCollection getTreeViewCollection(String entityName, String parentId) {
        super.getTreeViewCollection(entityName, parentId);
        String selectFields = "adminorg.id id, adminorg.name name,parentorg,structlongnumber longnumber,isleaf";
        QFilter parentFilter = new QFilter("parentorg", "=", (Object)Long.valueOf(parentId));
        boolean isShowDepartment = this.isShowDepartment();
        boolean isShowDisable = this.isShowDisable();
        boolean isShowUnUsing = this.isShowUnUsing();
        QFilter[] filters = AdminOrgTreeHelper.getFilterArrayByFilterParams(parentFilter, isShowDepartment, isShowDisable, isShowUnUsing);
        DynamicObjectCollection dynObjColl = HRBaseDaoFactory.getInstance((String)entityName).queryColl(selectFields, filters, "structlongnumber");
        List<String> orgIdList = this.getOrgIdList(dynObjColl);
        AdminOrgQueryParamInfo queryParamInfo = new AdminOrgQueryParamInfo(isShowDepartment, isShowDisable, isShowUnUsing);
        List<String> allTreeOrgIds = this.getAllTreeOrgIds();
        this.resetIsLeafFieldOfSubTreeNode(dynObjColl, orgIdList, queryParamInfo, allTreeOrgIds);
        this.getPageCache().put(CHK_SHOW_DEPT, String.valueOf(isShowDepartment));
        this.getPageCache().put(CHK_SHOW_DISABLE, String.valueOf(isShowDisable));
        return this.getAllHasPermOrgs(dynObjColl);
    }

    @Override
    protected HRFilterFieldInfo getHRFilterFieldInfo() {
        ArrayList<HRFilterFieldItemInfo> hrFilterFieldItemInfos = new ArrayList<HRFilterFieldItemInfo>();
        HRFilterFieldItemInfo hrFilterFieldItemInfo = new HRFilterFieldItemInfo("adminorg", "adminorg");
        hrFilterFieldItemInfos.add(hrFilterFieldItemInfo);
        HRFilterFieldInfo hrFilterFieldInfo = new HRFilterFieldInfo(hrFilterFieldItemInfos);
        return hrFilterFieldInfo;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        switch (evt.getItemKey().toLowerCase(Locale.ROOT)) {
            case "tblrefresh": {
                this.getPageCache().put("treeOrgIds", null);
                this.getPageCache().put("permorgids", null);
                this.getPageCache().put("permfilter", null);
                break;
            }
        }
    }

    protected boolean isShowDisable() {
        String cacheStrShowDisable;
        boolean isShowDisable = false;
        Boolean isShowDisableParam = (Boolean)this.getView().getFormShowParameter().getCustomParam(CHK_SHOW_DISABLE);
        isShowDisable = isShowDisableParam == null ? ((cacheStrShowDisable = this.getPageCache().get(CHK_SHOW_DISABLE)) != null ? Boolean.parseBoolean(cacheStrShowDisable) : false) : isShowDisableParam;
        return isShowDisable;
    }

    protected boolean isShowDepartment() {
        String cacheStrShowDept;
        boolean isShowDepartment = true;
        Boolean isShowDepartmentParam = (Boolean)this.getView().getFormShowParameter().getCustomParam(CHK_SHOW_DEPT);
        isShowDepartment = isShowDepartmentParam == null ? ((cacheStrShowDept = this.getPageCache().get(CHK_SHOW_DEPT)) != null ? Boolean.parseBoolean(cacheStrShowDept) : true) : isShowDepartmentParam;
        return isShowDepartment;
    }

    protected boolean isShowUnUsing() {
        return true;
    }

    private List<String> getOrgIdList(DynamicObjectCollection dynamicObjectColl) {
        ArrayList<String> orgIdList = new ArrayList<String>(dynamicObjectColl.size());
        int size = dynamicObjectColl.size();
        for (int i = 0; i < size; ++i) {
            orgIdList.add(String.valueOf(((DynamicObject)dynamicObjectColl.get(i)).get("id")));
        }
        return orgIdList;
    }

    private List<String> getOrgIdList(DynamicObject[] dynObjColl) {
        ArrayList<String> orgIdList = new ArrayList<String>(dynObjColl.length);
        for (DynamicObject dynamicObject : dynObjColl) {
            orgIdList.add(String.valueOf(dynamicObject.get("adminorg.id")));
        }
        return orgIdList;
    }

    private void resetIsLeafFieldOfSubTreeNode(DynamicObjectCollection dynObjColl, List<String> orgIds, AdminOrgQueryParamInfo queryParamInfo, List<String> treeOrgIdList) {
        if (orgIds.size() > 0) {
            Map<String, Integer> subAdminOrgCountMap = HRAdminOrgQueryTreeList.getSubAdminOrgCountMap(queryParamInfo, orgIds, treeOrgIdList);
            DynamicObject dynamicObject = null;
            int size = dynObjColl.size();
            for (int i = 0; i < size; ++i) {
                dynamicObject = (DynamicObject)dynObjColl.get(i);
                long id = dynamicObject.getLong("id");
                if (subAdminOrgCountMap.get(String.valueOf(id)) != null && subAdminOrgCountMap.get(String.valueOf(id)) > 0) {
                    dynamicObject.set("isleaf", (Object)Boolean.FALSE);
                    continue;
                }
                dynamicObject.set("isleaf", (Object)Boolean.TRUE);
            }
        }
    }

    private DynamicObjectCollection getAllHasPermOrgs(DynamicObjectCollection dynamicObjectCollection) {
        List<String> treeOrgIds = this.getAllTreeOrgIds();
        DynamicObjectCollection hasPermTreeOrgDys = new DynamicObjectCollection();
        for (DynamicObject dy : dynamicObjectCollection) {
            String orgId = String.valueOf(dy.get("id"));
            if (!treeOrgIds.contains(orgId)) continue;
            hasPermTreeOrgDys.add((Object)dy);
        }
        return hasPermTreeOrgDys;
    }

    private List<String> getAllTreeOrgIds() {
        String pagecachedata = this.getPageCache().get("treeOrgIds");
        if (!HRStringUtils.isEmpty((String)pagecachedata)) {
            List result = SerializationUtils.fromJsonStringToList((String)pagecachedata, String.class);
            return result;
        }
        QFilter orgIdFilter = null;
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        boolean isSuper = PermissionServiceHelper.isSuperUser((long)userId);
        if (!isSuper) {
            orgIdFilter = new QFilter("adminorg.id", "in", this.getPermOrgs());
        }
        DynamicObject[] orgDys = HRBaseDaoFactory.getInstance((String)this.getEntityName()).query("structlongnumber", new QFilter[]{currentFilter, orgIdFilter});
        ArrayList<String> structLongNumbers = new ArrayList<String>();
        block0: for (DynamicObject orgDyc : orgDys) {
            String structLongNumber = orgDyc.getString("structlongnumber");
            while (!HRStringUtils.isEmpty((String)structLongNumber)) {
                structLongNumbers.add(structLongNumber);
                String tag = HRStringUtils.substringBeforeLast((String)structLongNumber, (String)"!");
                if (HRStringUtils.equals((String)structLongNumber, (String)tag)) continue block0;
                structLongNumber = tag;
            }
        }
        QFilter structLongNumberFilter = new QFilter("structlongnumber", "in", structLongNumbers);
        DynamicObject[] allTreeDys = HRBaseDaoFactory.getInstance((String)this.getEntityName()).query("adminorg.id", structLongNumberFilter.and(currentFilter));
        List<String> allTreeOrgIds = this.getOrgIdList(allTreeDys);
        this.getPageCache().put("treeOrgIds", SerializationUtils.toJsonString(allTreeOrgIds));
        return allTreeOrgIds;
    }

    public static Map<String, Integer> getSubAdminOrgCountMap(AdminOrgQueryParamInfo queryParamInfo, List<String> orgIdList, List<String> treeOrgIdList) {
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select orgstruct.fparentid as \"parentid\",count(orgstruct.fadminorgid) as \"suborgcount\"").append(" from t_haos_adminstruct orgstruct ").append(" inner join t_haos_adminorg adminOrg on adminOrg.fid=orgstruct.fadminorgid").append(" inner join t_haos_adminorgtype orgtype on orgtype.fid=adminOrg.fadminorgtypeid").append(" inner join t_haos_adminorgtypestd orgtypestd on orgtypestd.fid=TO_INTEGER(orgtype.fadminorgtypestdid)");
        selectSql.append(" where 1=1 and orgstruct.fiscurrentversion = '1'");
        HRAdminOrgQueryTreeList.appendSql(queryParamInfo, orgIdList, treeOrgIdList, selectSql);
        selectSql.append(" group by orgstruct.fparentid");
        HashMap<String, Integer> subOrgCountMap = new HashMap<String, Integer>();
        try (DataSet rs = null;){
            rs = HRDBUtil.queryDataSet((String)"hr_haos_getsuborgcount", (DBRoute)new DBRoute("hr"), (String)selectSql.toString(), null);
            Iterator iterator = rs.iterator();
            while (iterator != null && iterator.hasNext()) {
                Row data = (Row)iterator.next();
                subOrgCountMap.put(data.getString("parentid"), data.getInteger("suborgcount"));
            }
        }
        return subOrgCountMap;
    }

    private static void appendSql(AdminOrgQueryParamInfo queryParamInfo, List<String> orgIdList, List<String> treeOrgIdList, StringBuilder selectSql) {
        String idString;
        if (null != orgIdList && orgIdList.size() > 0) {
            idString = String.join((CharSequence)",", orgIdList);
            selectSql.append(" and orgstruct.FPARENTID in (").append(idString).append(')');
        }
        if (null != treeOrgIdList && treeOrgIdList.size() > 0) {
            idString = String.join((CharSequence)",", treeOrgIdList);
            selectSql.append(" and adminOrg.FID in (").append(idString).append(')');
        }
        if (!queryParamInfo.isShowDept()) {
            selectSql.append(" and orgtypestd.fid in (").append(ID_ORGTYPE_GROUP).append(',').append(ID_ORGTYPE_COMPANY).append(',').append(ID_ORGTYPE_REGION).append(')');
        }
        if (!queryParamInfo.isShowDisable()) {
            selectSql.append(" and adminOrg.fenable!='").append('0').append('\'');
        }
        if (!queryParamInfo.isShowUnUsing()) {
            selectSql.append(" and adminOrg.fenable!='").append('2').append('\'');
        }
    }
}

