/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.HRPermissionServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.HRFilterFieldInfo;
import kd.hr.hbp.common.model.HRFilterFieldItemInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.HRCommonFilterTool;

@ExcludeFromJacocoGeneratedReport
public class HRFilterList
extends AbstractListPlugin
implements BeforeFilterF7SelectListener {
    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        HRFilterFieldInfo hrFilterFieldInfo = this.getHRFilterFieldInfo();
        if (hrFilterFieldInfo == null) {
            hrFilterFieldInfo = this.getDefaultHRFilterFieldInfo();
        }
        if (hrFilterFieldInfo == null) {
            return;
        }
        QFilter filter = HRCommonFilterTool.assembleQFilterInfo(hrFilterFieldInfo);
        setFilterEvent.getQFilters().add(filter);
    }

    protected HRFilterFieldInfo getHRFilterFieldInfo() {
        return null;
    }

    private HRFilterFieldInfo getDefaultHRFilterFieldInfo() {
        HRFilterFieldItemInfo cutomItemInfo;
        HRFilterFieldItemInfo buFieldItemInfo;
        HRFilterFieldInfo hrFilterFieldInfo = null;
        ArrayList<HRFilterFieldItemInfo> hrFilterFieldItemInfos = new ArrayList<HRFilterFieldItemInfo>();
        HRFilterFieldItemInfo adminOrgFieldItemInfo = this.getAdminOrgFieldItemInfo();
        if (adminOrgFieldItemInfo != null) {
            hrFilterFieldItemInfos.add(adminOrgFieldItemInfo);
        }
        if ((buFieldItemInfo = this.getBUFieldItemInfo()) != null) {
            hrFilterFieldItemInfos.add(buFieldItemInfo);
        }
        if ((cutomItemInfo = this.getCustomFieldItemInfo()) != null) {
            hrFilterFieldItemInfos.add(cutomItemInfo);
        }
        if (hrFilterFieldItemInfos.size() > 0) {
            hrFilterFieldInfo = new HRFilterFieldInfo(hrFilterFieldItemInfos);
        }
        return hrFilterFieldInfo;
    }

    private HRFilterFieldItemInfo getAdminOrgFieldItemInfo() {
        HRFilterFieldItemInfo adminOrgFilterFieldItemInfo = null;
        String adminOrgField = this.getAdminOrgFilterField();
        if (!HRStringUtils.isEmpty((String)adminOrgField)) {
            adminOrgFilterFieldItemInfo = new HRFilterFieldItemInfo("adminorg", adminOrgField);
        }
        return adminOrgFilterFieldItemInfo;
    }

    private HRFilterFieldItemInfo getBUFieldItemInfo() {
        HRFilterFieldItemInfo buFilterFieldItemInfo = null;
        String buField = this.getBUFilterField();
        if (!HRStringUtils.isEmpty((String)buField)) {
            List<Long> permHROrgs = this.getPermHROrgs();
            QFilter buFilter = new QFilter(buField, "in", permHROrgs);
            buFilterFieldItemInfo = new HRFilterFieldItemInfo("hrbu", buFilter);
        }
        return buFilterFieldItemInfo;
    }

    private HRFilterFieldItemInfo getCustomFieldItemInfo() {
        HRFilterFieldItemInfo customFieldItemInfo = null;
        QFilter filter = this.getCustomFilter();
        if (filter != null) {
            customFieldItemInfo = new HRFilterFieldItemInfo("custom", filter);
        }
        return customFieldItemInfo;
    }

    protected QFilter getCustomFilter() {
        return null;
    }

    public void initialize() {
        super.initialize();
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        if (fc != null) {
            fc.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        this.setBURangeBeforeF7Select(event);
    }

    private void setBURangeBeforeF7Select(BeforeFilterF7SelectEvent evt) {
        String buField = this.getBUFilterField();
        if (HRStringUtils.isEmpty((String)buField)) {
            return;
        }
        String fieldNameStr = evt.getFieldName();
        if (!fieldNameStr.contains(buField) || !"bos_org".equals(evt.getRefEntityId())) {
            return;
        }
        List<Long> permHROrgs = this.getPermHROrgs();
        evt.getQfilters().add(new QFilter("id", "in", permHROrgs));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.setSchemefilterBUFiledRange(filterColumnList);
        this.setSchemefilterAdminOrgFiledRange(filterColumnList);
    }

    private void setSchemefilterAdminOrgFiledRange(List<FilterColumn> filterColumnList) {
        String adminOrgField = this.getAdminOrgFilterField();
        if (!HRStringUtils.isEmpty((String)adminOrgField)) {
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            List orgIds = (List)HRMServiceHelper.invokeHRMPService((String)"hbss", (String)"IHBSSService", (String)"getOrgListFromPermFiles", (Object[])new Object[]{userId});
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorghr");
            QFilter filter = new QFilter("id", "in", (Object)orgIds);
            DynamicObject[] orgs = serviceHelper.query("id,name,number", new QFilter[]{filter});
            HRCommonFilterTool.setSchemefilterF7FiledRange(filterColumnList, adminOrgField, orgs);
        }
    }

    private void setSchemefilterBUFiledRange(List<FilterColumn> filterColumnList) {
        String buField = this.getBUFilterField();
        if (!HRStringUtils.isEmpty((String)buField)) {
            List<Long> permHROrgs = this.getPermHROrgs();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_org");
            QFilter filter = new QFilter("id", "in", permHROrgs);
            DynamicObject[] bus = serviceHelper.query("id,name,number", new QFilter[]{filter});
            HRCommonFilterTool.setSchemefilterF7FiledRange(filterColumnList, buField, bus);
        }
    }

    protected String getAdminOrgFilterField() {
        return null;
    }

    protected String getBUFilterEntityName() {
        return null;
    }

    protected String getBUFilterField() {
        return null;
    }

    protected String getBUFilterAppId() {
        return null;
    }

    private List<Long> getPermHROrgs() {
        String appNumber;
        AppInfo appInfo;
        String appId;
        ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String entityName = this.getBUFilterEntityName();
        if (HRStringUtils.isEmpty((String)entityName)) {
            entityName = listParameter.getBillFormId();
        }
        if (HRStringUtils.isEmpty((String)(appId = this.getBUFilterAppId())) && (appInfo = AppMetadataCache.getAppInfo((String)(appNumber = listParameter.getAppId()))) != null) {
            appId = appInfo.getId();
        }
        return HRPermissionServiceHelper.getPermHROrgs((String)appId, (String)entityName);
    }
}

