/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.activity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowElement;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowNode;
import kd.bos.workflow.engine.dynprocess.freeflow.WFRejectNodesModel;
import kd.hr.hbp.business.servicehelper.ActivityServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

@ExcludeFromJacocoGeneratedReport
public class ActivityRejectPlugin
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(ActivityRejectPlugin.class);
    private static WorkflowServiceHelper workflowServiceHelper = new WorkflowServiceHelper();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"confirm"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"rejectbacktonode"});
        Long activityinsid = Long.valueOf(this.getView().getFormShowParameter().getCustomParam("activityinsid").toString());
        DynamicObject activityInsById = ActivityServiceHelper.getActivityInsById(null, (Long)activityinsid);
        if (activityInsById == null) {
            return;
        }
        List rejectNodes = WorkflowServiceHelper.getRejectNodes((Long)activityInsById.getLong("wfcurtaskid"), (String)"Reject");
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("rejectto");
        ArrayList comboItems = Lists.newArrayListWithCapacity((int)16);
        for (WFRejectNodesModel rejectNode : rejectNodes) {
            ComboItem comboItem = new ComboItem();
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue(rejectNode.getName());
            comboItem.setCaption(localeString);
            comboItem.setValue(rejectNode.getItemId());
            comboItems.add(comboItem);
        }
        comboEdit.setComboItems((List)comboItems);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("confirm".equals(operateKey)) {
            Long activityinsid = Long.valueOf(this.getView().getFormShowParameter().getCustomParam("activityinsid").toString());
            String rejectto = (String)this.getModelVal("rejectto");
            String reason = (String)this.getModelVal("reason");
            boolean rejectbacktonode = (Boolean)this.getModelVal("rejectbacktonode");
            if (HRStringUtils.isEmpty((String)rejectto) || HRStringUtils.isEmpty((String)reason)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u6570\u636e\u3002", (String)"ActivityTransferPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            OperationResult operationResult = (OperationResult)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSActivityService", (String)"rejectToNode", (Object[])new Object[]{activityinsid, RequestContext.get().getCurrUserId(), reason, rejectto, rejectbacktonode});
            ActivityServiceHelper.showErrorMessage((OperationResult)operationResult, (IFormView)this.getView(), (BeforeDoOperationEventArgs)args);
            Object billId = this.getView().getFormShowParameter().getCustomParam("billId");
            String billNumber = (String)this.getView().getFormShowParameter().getCustomParam("billNumber");
            ActivityServiceHelper.updateDealUser((Object)billId, (String)billNumber);
            this.getView().returnDataToParent((Object)"success");
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        if (HRStringUtils.equals((String)"rejectto", (String)fieldKey)) {
            Long activityinsid = Long.valueOf(this.getView().getFormShowParameter().getCustomParam("activityinsid").toString());
            DynamicObject activityInsById = ActivityServiceHelper.getActivityInsById(null, (Long)activityinsid);
            String propName = "allowRejectAndGoBack";
            boolean nodeProp = (Boolean)workflowServiceHelper.getNodeProp(Long.valueOf(activityInsById.getLong("wfprocessinsid")), activityInsById.getString("wfnode"), propName);
            if (!nodeProp) {
                return;
            }
            List wfprocessdefinitionid = WorkflowServiceHelper.getProcElementsByProcDefId((Long)activityInsById.getLong("wfprocessdefinitionid"));
            if (wfprocessdefinitionid == null) {
                return;
            }
            Object rejectto = this.getModelVal("rejectto");
            if (rejectto == null) {
                return;
            }
            for (WFFlowElement wfFlowElement : wfprocessdefinitionid) {
                if (!"StartSignalEvent".equals(wfFlowElement.getType())) continue;
                List nextNodes = wfFlowElement.getNextNodes();
                if (nextNodes == null) {
                    return;
                }
                for (WFFlowNode nextNode : nextNodes) {
                    String nextId = nextNode.getId();
                    if (HRStringUtils.isEmpty((String)nextId)) {
                        return;
                    }
                    if (!nextId.equals(rejectto)) continue;
                    this.getView().setVisible(Boolean.TRUE, new String[]{"rejectbacktonode"});
                    return;
                }
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"rejectbacktonode"});
        }
    }
}

